/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LayeredCauldronBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.TagValueOutput;
import net.minecraft.world.level.storage.ValueInput;
import net.minecraft.world.level.storage.ValueOutput;
import wily.legacy.init.LegacyRegistries;

public class WaterCauldronBlockEntity
extends BlockEntity {
    public Holder<Potion> potion = this.getDefaultPotion();
    public Holder<Item> lastPotionItemUsed = Items.POTION.builtInRegistryHolder();
    public Integer waterColor;

    public WaterCauldronBlockEntity(BlockPos blockPos, BlockState blockState) {
        super((BlockEntityType)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get(), blockPos, blockState);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        TagValueOutput output = TagValueOutput.createWithContext((ProblemReporter)ProblemReporter.DISCARDING, (HolderLookup.Provider)provider);
        this.saveAdditional((ValueOutput)output);
        return output.buildResult();
    }

    public void setChanged() {
        super.setChanged();
        if (this.level.isClientSide()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 2);
        } else {
            Level level = this.level;
            if (level instanceof ServerLevel) {
                ServerLevel l = (ServerLevel)level;
                l.getChunkSource().blockChanged(this.getBlockPos());
            }
        }
    }

    public void convertToColored() {
        this.convertTo((LayeredCauldronBlock)LegacyRegistries.COLORED_WATER_CAULDRON.get());
    }

    public void convertTo(LayeredCauldronBlock block) {
        if (this.getBlockState().is((Block)block)) {
            return;
        }
        BlockState coloredBlockState = (BlockState)block.defaultBlockState().setValue((Property)LayeredCauldronBlock.LEVEL, (Comparable)((Integer)this.getBlockState().getValue((Property)LayeredCauldronBlock.LEVEL)));
        this.level.setBlock(this.getBlockPos(), coloredBlockState, 3);
        this.setBlockState(coloredBlockState);
        this.level.setBlockEntity((BlockEntity)this);
    }

    public void setWaterColor(Integer waterColor) {
        if (waterColor == null) {
            this.convertTo((LayeredCauldronBlock)Blocks.WATER_CAULDRON);
        } else {
            this.convertToColored();
        }
        this.waterColor = waterColor;
    }

    public Holder<Potion> getDefaultPotion() {
        return Potions.WATER;
    }

    public boolean hasWater() {
        return ((Potion)this.potion.value()).equals(Potions.WATER.value());
    }

    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public void loadAdditional(ValueInput input) {
        super.loadAdditional(input);
        input.getInt("dyeColor").ifPresent(i -> {
            this.waterColor = i;
        });
        input.getString("potion").flatMap(id -> BuiltInRegistries.POTION.get(ResourceKey.create((ResourceKey)Registries.POTION, (ResourceLocation)ResourceLocation.tryParse((String)id)))).ifPresent(p -> {
            this.potion = p;
        });
        input.getString("lastPotionItemUsed").flatMap(id -> BuiltInRegistries.ITEM.get(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.tryParse((String)id)))).ifPresent(p -> {
            this.lastPotionItemUsed = p;
        });
    }

    protected void saveAdditional(ValueOutput output) {
        super.saveAdditional(output);
        if (this.waterColor != null) {
            output.putInt("dyeColor", this.waterColor.intValue());
            this.convertToColored();
        }
        this.potion.unwrapKey().ifPresent(r -> output.putString("potion", r.location().toString()));
        this.lastPotionItemUsed.unwrapKey().ifPresent(r -> output.putString("lastPotionItemUsed", r.location().toString()));
    }
}

