/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntSupplier;
import java.util.function.Supplier;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSliderButton;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.util.Mth;
import wily.legacy.Legacy4JClient;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacySoundUtil;

public class LegacySliderButton<T>
extends AbstractSliderButton {
    private final Function<LegacySliderButton<T>, Component> messageGetter;
    private final Function<LegacySliderButton<T>, T> valueGetter;
    private final Function<T, Double> valueSetter;
    private final Consumer<LegacySliderButton<T>> onChange;
    private final Function<LegacySliderButton<T>, Tooltip> tooltipSupplier;
    protected boolean dragging = false;
    protected boolean applyChangesOnRelease = false;
    protected T objectValue;
    private int slidingMul = 1;
    private int lastSliderInput = -1;
    private double rangeMul = 1.0;

    public LegacySliderButton(int i, int j, int k, int l, Function<LegacySliderButton<T>, Component> messageGetter, Function<LegacySliderButton<T>, Tooltip> tooltipSupplier, T initialValue, Function<LegacySliderButton<T>, T> valueGetter, Function<T, Double> valueSetter, Consumer<LegacySliderButton<T>> onChange) {
        super(i, j, k, l, (Component)Component.empty(), valueSetter.apply(initialValue).doubleValue());
        this.messageGetter = messageGetter;
        this.valueGetter = valueGetter;
        this.valueSetter = valueSetter;
        this.onChange = onChange;
        this.tooltipSupplier = tooltipSupplier;
        this.objectValue = initialValue;
        this.updateMessage();
    }

    public LegacySliderButton(int i, int j, int k, int l, Function<LegacySliderButton<T>, Component> messageGetter, Function<LegacySliderButton<T>, Tooltip> tooltipSupplier, T initialValue, Supplier<List<T>> values, Consumer<LegacySliderButton<T>> onChange) {
        this(i, j, k, l, messageGetter, tooltipSupplier, initialValue, b -> ((List)values.get()).get((int)Math.round(b.value * (double)(((List)values.get()).size() - 1))), t -> Math.max(0.0, (double)((List)values.get()).indexOf(t)) / (double)(((List)values.get()).size() - 1), onChange);
    }

    public LegacySliderButton(int i, int j, int k, int l, Function<LegacySliderButton<T>, Component> messageGetter, Function<LegacySliderButton<T>, Tooltip> tooltipSupplier, T initialValue, Function<LegacySliderButton<T>, T> valueGetter, Function<T, Double> valueSetter, Consumer<LegacySliderButton<T>> onChange, double rangeMultiplier) {
        this(i, j, k, l, messageGetter, tooltipSupplier, initialValue, valueGetter, valueSetter, onChange);
        this.rangeMul = rangeMultiplier;
    }

    public static <T> LegacySliderButton<T> createFromInt(int i, int j, int k, int l, Function<LegacySliderButton<T>, Component> messageGetter, Function<LegacySliderButton<T>, Tooltip> tooltipSupplier, T initialValue, Function<Integer, T> valueGetter, Function<T, Integer> valueSetter, Supplier<Integer> valuesSize, Consumer<LegacySliderButton<T>> onChange) {
        return new LegacySliderButton<Object>(i, j, k, l, messageGetter, tooltipSupplier, initialValue, b -> valueGetter.apply((int)Math.round(b.value * (double)((Integer)valuesSize.get() - 1))), t -> Math.max(0.0, (double)((Integer)valueSetter.apply(t)).intValue()) / (double)((Integer)valuesSize.get() - 1), onChange, -1.0);
    }

    public static LegacySliderButton<Integer> createFromIntRange(int i, int j, int k, int l, Function<LegacySliderButton<Integer>, Component> messageGetter, Function<LegacySliderButton<Integer>, Tooltip> tooltipSupplier, Integer initialValue, int min, IntSupplier max, Consumer<LegacySliderButton<Integer>> onChange) {
        return new LegacySliderButton<Integer>(i, j, k, l, messageGetter, tooltipSupplier, initialValue, b -> min + (int)Math.round(b.value * (double)(max.getAsInt() - min)), t -> Mth.clamp((double)((double)(t - min) / (double)(max.getAsInt() - min)), (double)0.0, (double)1.0), onChange, -1.0);
    }

    public static LegacySliderButton<Integer> createFromIntRange(int i, int j, int k, int l, Function<LegacySliderButton<Integer>, Component> messageGetter, Function<LegacySliderButton<Integer>, Tooltip> tooltipSupplier, Integer initialValue, int min, int max, Consumer<LegacySliderButton<Integer>> onChange) {
        return LegacySliderButton.createFromIntRange(i, j, k, l, messageGetter, tooltipSupplier, initialValue, min, () -> max, onChange);
    }

    public Component getDefaultMessage(Component caption, Component visibleValue) {
        return CommonComponents.optionNameValue((Component)caption, (Component)visibleValue);
    }

    public T getObjectValue() {
        return this.objectValue == null ? this.valueGetter.apply(this) : this.objectValue;
    }

    public void setObjectValue(T objectValue) {
        this.objectValue = objectValue;
        this.value = this.valueSetter.apply(objectValue);
    }

    public double getValue() {
        return this.value;
    }

    public void updateMessage() {
        this.setTooltip(this.tooltipSupplier.apply(this));
        this.setMessage(this.messageGetter.apply(this));
    }

    public void setFocused(boolean bl) {
        super.setFocused(bl);
        if (bl) {
            this.canChangeValue = Legacy4JClient.controllerManager.canChangeSlidersValue;
        }
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        boolean bl;
        if (!this.active) {
            return false;
        }
        if (keyEvent.isSelection()) {
            this.canChangeValue = !this.canChangeValue;
            Legacy4JClient.controllerManager.canChangeSlidersValue = this.canChangeValue;
            return true;
        }
        if (this.canChangeValue && ((bl = keyEvent.isLeft()) && this.value > 0.0 || keyEvent.isRight() && this.value < 1.0)) {
            if (this.slidingMul > 0 && keyEvent.key() != this.lastSliderInput) {
                this.slidingMul = 1;
            }
            this.lastSliderInput = keyEvent.key();
            double part = 1.0 / (double)(this.width - 8) * (double)this.slidingMul;
            double precision = 100.0 * this.rangeMul;
            T v = this.getObjectValue();
            while (v.equals(this.getObjectValue())) {
                double newValue = this.value + (bl ? -part : part);
                double flooredValue = this.rangeMul != -1.0 ? Math.floor(newValue * precision) / precision : newValue;
                this.setValue(flooredValue + ((double)((int)flooredValue) < flooredValue ? 0.0 : 0.0));
                if (part >= 1.0) break;
                part = Math.min(part * 2.0, 1.0);
            }
            ++this.slidingMul;
            return true;
        }
        return false;
    }

    protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
        LegacyFontUtil.applySDFont(b -> super.renderScrollingString(guiGraphics, font, i, j));
    }

    public boolean keyReleased(KeyEvent keyEvent) {
        if (this.canChangeValue && (keyEvent.isLeft() || keyEvent.isRight())) {
            this.slidingMul = 1;
        }
        return false;
    }

    public boolean mouseClicked(MouseButtonEvent mouseButtonEvent, boolean bl) {
        this.dragging = this.active;
        return super.mouseClicked(mouseButtonEvent, bl);
    }

    public void onRelease(MouseButtonEvent mouseButtonEvent) {
        this.dragging = false;
        if (this.applyChangesOnRelease) {
            this.onChange.accept(this);
            this.applyChangesOnRelease = false;
            this.updateMessage();
        }
        super.onRelease(mouseButtonEvent);
    }

    protected void applyValue() {
        T oldValue = this.objectValue;
        this.setObjectValue(this.valueGetter.apply(this));
        if (!oldValue.equals(this.objectValue)) {
            LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.SCROLL.get(), 1.0f);
            if (this.dragging) {
                this.applyChangesOnRelease = true;
            } else {
                this.onChange.accept(this);
            }
        }
    }
}

