/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.datafixers.util.Pair;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.server.IntegratedServer;
import net.minecraft.network.chat.Component;
import net.minecraft.server.commands.PublishCommand;
import net.minecraft.util.HttpUtil;
import net.minecraft.world.level.GameType;
import wily.factoryapi.FactoryAPI;
import wily.legacy.client.LegacyClientWorldSettings;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.LoadSaveScreen;

public class PublishScreen
extends ConfirmationScreen {
    public static final Component PORT_INFO_TEXT = Component.translatable((String)"lanServer.port");
    public static final Component LAN_SERVER = Component.translatable((String)"lanServer.title");
    public static final Component PUBLISH = Component.translatable((String)(PublishScreen.hasWorldHost() ? "legacy.menu.online" : "menu.shareToLan"));
    public static final Component PORT_UNAVAILABLE = Component.translatable((String)"lanServer.port.unavailable", (Object[])new Object[]{1024, 65535});
    public static final Component INVALID_PORT = Component.translatable((String)"lanServer.port.invalid", (Object[])new Object[]{1024, 65535});
    protected final LegacySliderButton<GameType> gameTypeSlider;
    public boolean publish = false;
    protected EditBox portEdit;
    private int port = HttpUtil.getAvailablePort();

    public PublishScreen(Screen parent, GameType gameType, Consumer<PublishScreen> okAction) {
        super(parent, ConfirmationScreen::getPanelWidth, () -> LegacyOptions.getUIMode().isSD() ? 108 : 145, LAN_SERVER, (Component)Component.translatable((String)"lanServer.port"), b -> {});
        this.okAction = s -> {
            this.publish = true;
            okAction.accept(this);
            s.onClose();
        };
        this.gameTypeSlider = new LegacySliderButton<GameType>(0, 0, 200, 16, b -> b.getDefaultMessage(LoadSaveScreen.GAME_MODEL_LABEL, ((GameType)b.getObjectValue()).getLongDisplayName()), b -> Tooltip.create((Component)Component.translatable((String)("selectWorld.gameMode." + ((GameType)b.getObjectValue()).getName() + ".info"))), gameType, () -> LoadSaveScreen.GAME_TYPES, b -> {});
    }

    public PublishScreen(Screen parent, GameType gameType) {
        this(parent, gameType, (PublishScreen s) -> {});
    }

    public static boolean hasWorldHost() {
        return FactoryAPI.isModLoaded((String)(FactoryAPI.getLoader().isForgeLike() ? "world_host" : "world-host"));
    }

    public static Pair<Integer, Component> tryParsePort(String string) {
        if (string.isBlank()) {
            return Pair.of((Object)HttpUtil.getAvailablePort(), null);
        }
        try {
            int port = Integer.parseInt(string);
            if (port < 1024 || port > 65535) {
                return Pair.of((Object)port, (Object)INVALID_PORT);
            }
            if (!HttpUtil.isPortAvailable((int)port)) {
                return Pair.of((Object)port, (Object)PORT_UNAVAILABLE);
            }
            return Pair.of((Object)port, null);
        }
        catch (NumberFormatException numberFormatException) {
            return Pair.of((Object)HttpUtil.getAvailablePort(), (Object)INVALID_PORT);
        }
    }

    public void repositionElements() {
        String string = this.portEdit.getValue();
        super.repositionElements();
        this.portEdit.setValue(string);
    }

    @Override
    protected void init() {
        super.init();
        boolean sd = LegacyOptions.getUIMode().isSD();
        int layoutX = this.panel.x + (this.panel.width - this.renderableVList.listWidth) / 2;
        this.portEdit = new EditBox(this.font, layoutX, this.panel.y + (sd ? 32 : 45), this.renderableVList.listWidth, sd ? 16 : 20, PORT_INFO_TEXT);
        this.portEdit.setHint((Component)Component.literal((String)("" + this.port)).withStyle(ChatFormatting.DARK_GRAY));
        this.portEdit.setMaxLength(128);
        this.portEdit.setResponder(string -> {
            Pair<Integer, Component> p = PublishScreen.tryParsePort(string);
            if (p.getFirst() != null) {
                this.port = (Integer)p.getFirst();
            }
            this.portEdit.setHint((Component)Component.literal((String)("" + this.port)).withStyle(ChatFormatting.DARK_GRAY));
            if (p.getSecond() == null) {
                this.portEdit.setTextColor(-2039584);
                this.portEdit.setTooltip(null);
                this.okButton.active = true;
            } else {
                this.portEdit.setTextColor(-43691);
                this.portEdit.setTooltip(Tooltip.create((Component)((Component)p.getSecond())));
                this.okButton.active = false;
            }
        });
        this.addRenderableWidget((GuiEventListener)this.portEdit);
        this.gameTypeSlider.setPosition(layoutX, this.panel.y + (sd ? 51 : 69));
        this.gameTypeSlider.setWidth(this.renderableVList.listWidth);
        this.addRenderableWidget((GuiEventListener)this.gameTypeSlider);
    }

    public void publish(IntegratedServer server) {
        if (!this.publish) {
            return;
        }
        FactoryAPI.SECURE_EXECUTOR.executeNowIfPossible(() -> this.minecraft.gui.getChat().addMessage((Component)(server.publishServer(this.gameTypeSlider.getObjectValue(), server.getWorldData().isAllowCommands() && LegacyClientWorldSettings.of(server.getWorldData()).trustPlayers(), this.port) ? PublishCommand.getSuccessMessage((int)this.port) : Component.translatable((String)"commands.publish.failed"))), () -> Minecraft.getInstance().player != null);
    }
}

