/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySpawnReason;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.util.LegacyComponents;

@Mixin(value={EntityType.class})
public abstract class EntityTypeMixin {
    @Unique
    boolean wasLastEnemySpawnFailed = false;

    @Inject(method={"create(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/entity/EntitySpawnReason;)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="RETURN")}, cancellable=true)
    public void create(Level level, EntitySpawnReason entitySpawnReason, CallbackInfoReturnable<Entity> cir) {
        Entity entity = (Entity)cir.getReturnValue();
        if (entity != null && level.getDifficulty() == Difficulty.PEACEFUL && !entity.getType().isAllowedInPeaceful()) {
            cir.setReturnValue(null);
            this.wasLastEnemySpawnFailed = true;
        } else {
            this.wasLastEnemySpawnFailed = false;
        }
    }

    @Inject(method={"spawn(Lnet/minecraft/server/level/ServerLevel;Lnet/minecraft/world/item/ItemStack;Lnet/minecraft/world/entity/LivingEntity;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/entity/EntitySpawnReason;ZZ)Lnet/minecraft/world/entity/Entity;"}, at={@At(value="RETURN")})
    public void spawn(ServerLevel arg, ItemStack arg2, LivingEntity arg3, BlockPos arg4, EntitySpawnReason arg5, boolean bl, boolean bl2, CallbackInfoReturnable<Entity> cir) {
        if (arg5 == EntitySpawnReason.SPAWN_ITEM_USE && this.wasLastEnemySpawnFailed && cir.getReturnValue() == null && arg3 instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)arg3;
            sp.displayClientMessage(LegacyComponents.PEACEFUL_SPAWN_TIP, true);
        }
    }
}

