/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.bosshealth;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.BossHealthOverlay;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.BossEvent;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.client.LegacyOptions;
import wily.legacy.util.client.LegacyFontUtil;

@Mixin(value={BossHealthOverlay.class})
public abstract class BossHealthOverlayMixin {
    @Shadow
    @Final
    private Minecraft minecraft;

    @Redirect(method={"render"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;III)V"))
    public void drawString(GuiGraphics graphics, Font font, Component component, int i, int j, int k) {
        LegacyFontUtil.applySmallerFont(LegacyFontUtil.MOJANGLES_11_FONT, b -> {
            LegacyFontUtil.forceVanillaFontShadowColor = true;
            graphics.pose().pushMatrix();
            graphics.pose().translate((float)graphics.guiWidth() / 2.0f, (float)j);
            if (!b.booleanValue()) {
                graphics.pose().scale(0.6666667f, 0.6666667f);
            }
            graphics.pose().translate((float)(-font.width((FormattedText)component)) / 2.0f, 0.0f);
            graphics.drawString(font, component, 0, 0, k);
            graphics.pose().popMatrix();
            LegacyFontUtil.forceVanillaFontShadowColor = false;
        });
    }

    @Shadow
    protected abstract void drawBar(GuiGraphics var1, int var2, int var3, BossEvent var4, int var5, ResourceLocation[] var6, ResourceLocation[] var7);

    @ModifyVariable(method={"render"}, at=@At(value="STORE", ordinal=0), ordinal=1)
    public int render(int i) {
        return (int)(12.0 + 16.0 * (Double)LegacyOptions.hudDistance.get());
    }

    @Inject(method={"drawBar(Lnet/minecraft/client/gui/GuiGraphics;IILnet/minecraft/world/BossEvent;)V"}, at={@At(value="HEAD")})
    private void drawBar(GuiGraphics guiGraphics, int i, int j, BossEvent bossEvent, CallbackInfo ci) {
        guiGraphics.pose().pushMatrix();
        FactoryScreenUtil.enableBlend();
        guiGraphics.pose().translate((float)(guiGraphics.guiWidth() - 203) / 2.0f, (float)j);
        guiGraphics.pose().scale(0.5f, 0.5f);
    }

    @Inject(method={"drawBar(Lnet/minecraft/client/gui/GuiGraphics;IILnet/minecraft/world/BossEvent;)V"}, at={@At(value="RETURN")})
    private void drawBarReturn(GuiGraphics guiGraphics, int i, int j, BossEvent bossEvent, CallbackInfo ci) {
        FactoryScreenUtil.disableBlend();
        guiGraphics.pose().popMatrix();
    }

    @Redirect(method={"drawBar(Lnet/minecraft/client/gui/GuiGraphics;IILnet/minecraft/world/BossEvent;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/BossHealthOverlay;drawBar(Lnet/minecraft/client/gui/GuiGraphics;IILnet/minecraft/world/BossEvent;I[Lnet/minecraft/resources/ResourceLocation;[Lnet/minecraft/resources/ResourceLocation;)V", ordinal=0))
    private void drawBar(BossHealthOverlay instance, GuiGraphics guiGraphics, int i, int j, BossEvent bossEvent, int k, ResourceLocation[] resourceLocations, ResourceLocation[] resourceLocations2) {
        this.drawBar(guiGraphics, 0, 0, bossEvent, 406, resourceLocations, resourceLocations2);
    }

    @Redirect(method={"drawBar(Lnet/minecraft/client/gui/GuiGraphics;IILnet/minecraft/world/BossEvent;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/BossHealthOverlay;drawBar(Lnet/minecraft/client/gui/GuiGraphics;IILnet/minecraft/world/BossEvent;I[Lnet/minecraft/resources/ResourceLocation;[Lnet/minecraft/resources/ResourceLocation;)V", ordinal=1))
    private void drawBarProgress(BossHealthOverlay instance, GuiGraphics guiGraphics, int i, int j, BossEvent bossEvent, int k, ResourceLocation[] resourceLocations, ResourceLocation[] resourceLocations2) {
        guiGraphics.pose().translate(3.0f, 0.0f);
        this.drawBar(guiGraphics, 0, 0, bossEvent, Mth.lerpDiscrete((float)bossEvent.getProgress(), (int)0, (int)400), resourceLocations, resourceLocations2);
    }

    @Redirect(method={"drawBar(Lnet/minecraft/client/gui/GuiGraphics;IILnet/minecraft/world/BossEvent;I[Lnet/minecraft/resources/ResourceLocation;[Lnet/minecraft/resources/ResourceLocation;)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;blitSprite(Lcom/mojang/blaze3d/pipeline/RenderPipeline;Lnet/minecraft/resources/ResourceLocation;IIIIIIII)V"))
    private void drawBar(GuiGraphics instance, RenderPipeline renderPipeline, ResourceLocation arg, int i, int j, int k, int l, int m, int n, int o, int p) {
        FactoryGuiGraphics.of((GuiGraphics)instance).blitSprite(arg, o <= 400 ? 400 : 406, j * 3, k, l, m, n, 0, o, p * 3);
    }
}

