/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.gson.JsonObject;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1799;
import net.minecraft.class_1826;
import net.minecraft.class_2477;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_368;
import net.minecraft.class_4013;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5819;
import net.minecraft.class_7417;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIClient;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTip;
import wily.legacy.client.LegacyTipOverride;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.util.LegacyTipBuilder;

public class LegacyTipManager
implements class_4013 {
    public static final int MOVEMENT_TIP_TICKS = 15;
    public static final int PAUSE_TIP_TICKS = 10;
    public static final int MAX_TIP_TICKS = 40;
    public static final List<Supplier<LegacyTip>> tips = new ArrayList<Supplier<LegacyTip>>();
    public static final List<Supplier<LegacyTip>> loadingTips = new ArrayList<Supplier<LegacyTip>>();
    private static final String TIPS = "texts/tips.json";
    private static final List<Supplier<LegacyTip>> usingLoadingTips = new ArrayList<Supplier<LegacyTip>>();
    public static int tipTicks;
    public static boolean startTipOffset;
    public static boolean returningTip;
    private static LegacyTip actualTip;
    private static Supplier<LegacyTip> actualTipSupplier;
    private static LegacyTip lastTip;
    private static LegacyTip actualLoadingTip;
    private static Supplier<LegacyTip> actualLoadingTipSupplier;
    private final class_5819 random = class_5819.method_43047();

    public static LegacyTip getLoadingTip(class_5819 random) {
        if (usingLoadingTips.isEmpty()) {
            if (loadingTips.isEmpty()) {
                return null;
            }
            usingLoadingTips.addAll(loadingTips);
        }
        if (actualLoadingTip == null) {
            int i = random.method_43048(usingLoadingTips.size());
            actualLoadingTip = usingLoadingTips.get(i).get();
            actualLoadingTipSupplier = usingLoadingTips.remove(i);
        } else if (LegacyTipManager.actualLoadingTip.visibility == class_368.class_369.field_2209) {
            actualLoadingTip = null;
            actualLoadingTipSupplier = null;
            return LegacyTipManager.getLoadingTip(random);
        }
        return actualLoadingTip;
    }

    public static LegacyTip getRebuiltLoadingTip() {
        return actualLoadingTipSupplier == null ? null : actualLoadingTipSupplier.get();
    }

    public static LegacyTip getActualTip() {
        return actualTip;
    }

    public static void setActualTip(LegacyTip tip) {
        lastTip = actualTip;
        actualTip = tip;
        actualTipSupplier = null;
        if (actualTip != null) {
            startTipOffset = true;
        } else {
            returningTip = true;
        }
    }

    public static LegacyTip getLastTip() {
        return lastTip;
    }

    public static void updateTipTicks() {
        if (startTipOffset) {
            if (tipTicks < 40) {
                if (tipTicks < 15 || returningTip) {
                    ++tipTicks;
                }
            } else {
                LegacyTipManager.resetTipOffset(actualTip == null);
            }
        }
    }

    public static void resetTipOffset(boolean resetStart) {
        if (resetStart) {
            startTipOffset = false;
        }
        returningTip = false;
        tipTicks = 0;
    }

    public static float getTipOffsetPercentage() {
        if (startTipOffset) {
            float ticks = (float)tipTicks + FactoryAPIClient.getGamePartialTick((boolean)false);
            return Math.clamp(returningTip ? 40.0f - ticks : ticks, 0.0f, 15.0f) / 15.0f;
        }
        return 0.0f;
    }

    public static float getTipXOffset() {
        LegacyMenuAccess a;
        class_437 class_4372;
        return (Boolean)LegacyOptions.hints.get() != false && (class_4372 = class_310.method_1551().field_1755) instanceof LegacyMenuAccess && (a = (LegacyMenuAccess)class_4372).getTipXOffset() != 0 ? Math.min(0.0f, (float)Math.max(a.getTipXOffset(), 50 - a.getMenuRectangle().method_49620()) * LegacyTipManager.getTipOffsetPercentage()) : 0.0f;
    }

    public static LegacyTip updateTip() {
        if (tips.isEmpty()) {
            LegacyTipManager.setActualTip(null);
        } else {
            LegacyTipManager.setActualTip(tips.get(0).get());
            tips.remove(0);
        }
        return actualTip;
    }

    public static boolean rebuildActual() {
        return LegacyTipManager.setTip(actualTipSupplier);
    }

    public static void rebuildActualLoading() {
        actualLoadingTip = LegacyTipManager.getRebuiltLoadingTip();
    }

    public static boolean setTip(Supplier<LegacyTip> tipSupplier) {
        if (tipSupplier != null) {
            LegacyTipManager.setActualTip(tipSupplier.get());
            actualTipSupplier = tipSupplier;
            return true;
        }
        return false;
    }

    public static void addTip(Supplier<LegacyTip> tipSupplier) {
        if (tipSupplier != null) {
            tips.add(tipSupplier);
        }
    }

    public static void addTip(class_1297 entity) {
        LegacyTipManager.addTip(LegacyTipManager.getTip(entity));
    }

    public static void addTip(class_1299<?> entityType) {
        LegacyTipManager.addTip(LegacyTipManager.getTip(entityType));
    }

    public static LegacyTip getTipFromBuilder(LegacyTipBuilder builder) {
        return LegacyTipManager.getTipFromBuilder(builder.getTitle(), builder.getTip(), builder.getItem(), (long)builder.getTime() * 1000L);
    }

    public static LegacyTip getTipFromBuilder(Optional<class_2561> title, Optional<class_2561> tip, class_1799 stack, long time) {
        return new LegacyTip(title.orElse(null), tip.orElse(class_5244.field_39003)).itemStack(stack).disappearTime(time);
    }

    public static LegacyTip getLoadingTipFromBuilder(LegacyTipBuilder builder) {
        return LegacyTipManager.getLoadingTipFromBuilder(builder.getTitle(), builder.getTip(), builder.getItem(), (long)builder.getTime() * 1000L);
    }

    public static LegacyTip getLoadingTipFromBuilder(Optional<class_2561> title, Optional<class_2561> tip, class_1799 stack, long time) {
        return new LegacyTip(tip.orElse(class_5244.field_39003), LegacyOptions.getUIMode().isSD() ? 325 : 400, 55, false).centered().title(title.orElse(null)).itemStack(stack).disappearTime(time);
    }

    public static Supplier<LegacyTip> getTip(class_1799 item, LegacyTipBuilder modifier) {
        LegacyTipBuilder builder = new LegacyTipBuilder().item(item).copyFrom(LegacyTipOverride.getOverride(item)).copyFrom(modifier, true);
        if (builder.getTip().isPresent() && !LegacyTipManager.hasTip(builder.getTip().get())) {
            return null;
        }
        return () -> LegacyTipManager.getTipFromBuilder(builder);
    }

    public static Supplier<LegacyTip> getTip(class_1799 item) {
        if (LegacyTipManager.hasTip(item)) {
            LegacyTipBuilder builder = new LegacyTipBuilder().item(item).copyFrom(LegacyTipOverride.getOverride(item));
            return () -> LegacyTipManager.getTipFromBuilder(builder);
        }
        return null;
    }

    public static Supplier<LegacyTip> getTip(class_1297 entity) {
        Supplier<LegacyTip> entityTypeTip = LegacyTipManager.getTip(entity.method_5864());
        if (entityTypeTip != null) {
            return entityTypeTip;
        }
        class_1799 pickResult = entity.method_31480();
        return pickResult != null && !pickResult.method_7960() && !(pickResult.method_7909() instanceof class_1826) ? LegacyTipManager.getTip(pickResult) : null;
    }

    public static Supplier<LegacyTip> getTip(class_1299<?> entity) {
        if (LegacyTipManager.hasTip(entity)) {
            LegacyTipBuilder builder = new LegacyTipBuilder().title(entity.method_5897()).tip((class_2561)class_2561.method_43471((String)LegacyTipBuilder.getTipId(entity)));
            builder.copyFrom(LegacyTipOverride.getOverride(entity));
            return () -> LegacyTipManager.getTipFromBuilder(builder);
        }
        return null;
    }

    public static class_2561 getTipComponent(class_1799 item) {
        return LegacyTipManager.hasValidTipOverride(item) ? LegacyTipOverride.getOverride(item).getTip().orElse((class_2561)class_2561.method_43473()) : LegacyTipBuilder.getTip(item);
    }

    public static class_2561 getTipComponent(class_1299<?> type) {
        return LegacyTipManager.hasValidTipOverride(type) ? LegacyTipOverride.getOverride(type).getTip().orElse((class_2561)class_2561.method_43473()) : class_2561.method_43471((String)LegacyTipBuilder.getTipId(type));
    }

    public static boolean hasTip(class_1799 item) {
        return LegacyTipManager.hasTip(LegacyTipBuilder.getTip(item)) || LegacyTipManager.hasValidTipOverride(item);
    }

    public static boolean hasValidTipOverride(class_1799 item) {
        return LegacyTipOverride.getOverride(item).getTip().isPresent() && (!LegacyTipOverride.getOverride(item).getItem().method_7960() || LegacyTipManager.hasTip(LegacyTipOverride.getOverride(item).getTip().get()));
    }

    public static boolean hasValidTipOverride(class_1299<?> type) {
        return LegacyTipOverride.getOverride(type).getTip().isPresent() && (!LegacyTipOverride.getOverride(type).getItem().method_7960() || LegacyTipManager.hasTip(LegacyTipOverride.getOverride(type).getTip().get()));
    }

    public static boolean hasTip(class_2561 c) {
        class_2588 t;
        class_7417 class_74172 = c.method_10851();
        return !(class_74172 instanceof class_2588) || LegacyTipManager.hasTip((t = (class_2588)class_74172).method_11022());
    }

    public static boolean hasTip(String s) {
        return class_2477.method_10517().method_4678(s);
    }

    public static boolean hasTip(class_1299<?> s) {
        return LegacyTipManager.hasTip(LegacyTipBuilder.getTipId(s)) || LegacyTipManager.hasValidTipOverride(s);
    }

    public static class_2561 getTipComponent(class_2960 location) {
        return class_2561.method_43471((String)(location.method_42094() + ".tip"));
    }

    public LegacyTip getLoadingTip() {
        return LegacyTipManager.getLoadingTip(this.random);
    }

    public void method_14491(class_3300 resourceManager) {
        loadingTips.clear();
        usingLoadingTips.clear();
        actualLoadingTip = null;
        resourceManager.method_14487().forEach(name -> resourceManager.method_14486(FactoryAPI.createLocation((String)name, (String)TIPS)).ifPresent(r -> {
            try (BufferedReader bufferedReader = r.method_43039();){
                JsonObject obj = class_3518.method_15255((Reader)bufferedReader);
                LegacyTipBuilder.LIST_CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)obj.get("loadingTips")).result().ifPresent(l -> l.forEach(b -> loadingTips.add(() -> LegacyTipManager.getLoadingTipFromBuilder(b))));
            }
            catch (IOException var8) {
                Legacy4J.LOGGER.warn(var8.getMessage());
            }
        }));
    }

    public String method_22322() {
        return "legacy:tip_manager";
    }

    static {
        startTipOffset = false;
        returningTip = false;
    }
}

