/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import net.minecraft.class_11907;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_34;
import net.minecraft.class_4068;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_525;
import net.minecraft.class_6382;
import net.minecraft.class_7919;
import org.apache.commons.io.FileUtils;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyClientWorldSettings;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacySaveCache;
import wily.legacy.client.LegacyWorldTemplate;
import wily.legacy.client.PackAlbum;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.LegacyLoadingScreen;
import wily.legacy.client.screen.LoadSaveScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class CreationList
extends RenderableVList {
    protected final class_310 minecraft;

    public CreationList(UIAccessor accessor) {
        super(accessor);
        this.layoutSpacing(l -> 0);
        this.minecraft = class_310.method_1551();
        CreationList.addIconButton(this, Legacy4J.createModLocation("creation_list/create_world"), (class_2561)class_2561.method_43471((String)"legacy.menu.create_world"), c -> class_525.method_31130((class_310)this.minecraft, () -> this.minecraft.method_1507(this.getScreen())));
        LegacyWorldTemplate.list.forEach(t -> CreationList.addIconButton(this, t.icon(), t.buttonMessage(), c -> {
            if (t.isGamePath() && !Files.exists(t.getPath(), new LinkOption[0])) {
                Path path = t.getValidPath();
                if (path == null || t.preDownload()) {
                    this.minecraft.method_1507((class_437)ConfirmationScreen.createInfoScreen(this.getScreen(), LegacyComponents.MISSING_WORLD_TEMPLATE, (class_2561)class_2561.method_43469((String)"legacy.menu.missing_world_template_message", (Object[])new Object[]{t.buttonMessage()})));
                } else {
                    final File file = path.toFile();
                    final Stocker fileSize = new Stocker((Object)1L);
                    final ExecutorService executor = Executors.newSingleThreadExecutor();
                    LegacyLoadingScreen screen = new LegacyLoadingScreen(LegacyComponents.DOWNLOADING_WORLD_TEMPLATE, class_5244.field_39003){

                        public void method_25393() {
                            this.setProgress(file.exists() ? Math.min(1.0f, (float)FileUtils.sizeOf((File)file) / (float)((Long)fileSize.get()).longValue()) : 0.0f);
                            super.method_25393();
                        }

                        public void method_25419() {
                            if (file.exists()) {
                                file.delete();
                            }
                            this.field_22787.method_1507(CreationList.this.getScreen());
                            LegacyLoadingScreen.closeExecutor(executor);
                        }

                        @Override
                        public boolean method_25422() {
                            return true;
                        }
                    };
                    this.minecraft.method_1507((class_437)screen);
                    CompletableFuture.runAsync(() -> {
                        try {
                            URL url = t.downloadURI().get().toURL();
                            fileSize.set((Object)url.openConnection().getContentLengthLong());
                            FileUtils.copyURLToFile((URL)url, (File)path.toFile());
                            this.minecraft.execute(() -> CreationList.loadTemplate(this.getScreen(), this.minecraft, t));
                        }
                        catch (IOException e) {
                            throw new RuntimeException(e);
                        }
                    }, executor);
                }
            } else {
                CreationList.loadTemplate(this.getScreen(), this.minecraft, t);
            }
        }));
    }

    public static void loadTemplate(class_437 parent, class_310 minecraft, LegacyWorldTemplate template) {
        try (class_32.class_5143 access = LegacySaveCache.getLevelStorageSource().method_27002(LegacySaveCache.importSaveFile(template.open(), arg_0 -> ((class_32)minecraft.method_1586()).method_230(arg_0), LegacySaveCache.getLevelStorageSource(), template.folderName()));){
            class_34 summary = access.method_29584(access.method_54545());
            Optional<PackAlbum> album = template.albumId().map(PackAlbum::resourceById);
            album.ifPresent(LegacyClientWorldSettings.of(summary.method_35505())::setSelectedResourceAlbum);
            access.close();
            if (template.directJoin()) {
                LoadSaveScreen.loadWorld(parent, minecraft, LegacySaveCache.getLevelStorageSource(), summary);
            } else {
                minecraft.method_1507((class_437)new LoadSaveScreen(parent, summary, access, (album.isPresent() || template.albumId().isEmpty()) && template.isLocked()){

                    @Override
                    public void method_25419() {
                        if (!((Boolean)LegacyOptions.saveCache.get()).booleanValue()) {
                            FileUtils.deleteQuietly((File)this.access.method_27424(class_1937.field_25179).toFile());
                        }
                        super.method_25419();
                    }
                });
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void addIconButton(RenderableVList list, class_2960 iconSprite, class_2561 message, Consumer<class_4264> onPress) {
        CreationList.addIconButton(list, iconSprite, message, onPress, null);
    }

    public static void addIconButton(RenderableVList list, final class_2960 iconSprite, class_2561 message, final Consumer<class_4264> onPress, class_7919 tooltip) {
        ContentButton button = new ContentButton(list, 0, 0, 270, 30, message){

            @Override
            public void renderIcon(class_332 guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
                FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(iconSprite, this.method_46426() + x, this.method_46427() + y, width, height);
            }

            public void method_25306(class_11907 input) {
                onPress.accept(this);
            }
        };
        list.addRenderable((class_4068)button);
        button.method_47400(tooltip);
    }

    public static abstract class ContentButton
    extends class_4264 {
        protected final RenderableVList list;

        public ContentButton(RenderableVList list, int x, int y, int width, int height, class_2561 component) {
            super(x, y, width, height, component);
            this.list = list;
        }

        protected void method_48579(class_332 guiGraphics, int i, int j, float f) {
            super.method_48579(guiGraphics, i, j, f);
            if (this.list.accessor.getBoolean(this.list.name + ".buttonIcon.isVisible", Boolean.valueOf(true)).booleanValue()) {
                this.renderIcon(guiGraphics, i, j, f);
            }
        }

        public void renderIcon(class_332 guiGraphics, int mouseX, int mouseY, float f) {
            int iconWidth = this.list.accessor.getInteger(this.list.name + ".buttonIcon.width", 20);
            int iconHeight = this.list.accessor.getInteger(this.list.name + ".buttonIcon.height", 20);
            int iconPos = (this.field_22759 - iconHeight) / 2;
            this.renderIcon(guiGraphics, mouseX, mouseY, iconPos, iconPos, iconWidth, iconHeight);
            if (((Boolean)class_310.method_1551().field_1690.method_42446().method_41753()).booleanValue() || this.field_22762) {
                this.renderIconHighlight(guiGraphics, mouseX, mouseY, iconPos, iconPos, iconWidth, iconHeight);
            }
        }

        public void renderIcon(class_332 guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
        }

        public void renderIconHighlight(class_332 guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
            guiGraphics.method_25294(this.method_46426() + x, this.method_46427() + y, this.method_46426() + x + width, this.method_46427() + y + height, -1601138544);
        }

        protected void method_49604(class_332 guiGraphics, class_327 font, int i, int j) {
            int x = this.method_46426() + this.list.accessor.getInteger(this.list.name + ".buttonMessage.xOffset", 35);
            LegacyFontUtil.applySDFont(b -> LegacyRenderUtil.renderScrollingString(guiGraphics, font, this.method_25369(), x, this.method_46427(), x + this.method_25368(), this.method_46427() + this.method_25364(), j, true));
        }

        protected void method_47399(class_6382 narrationElementOutput) {
            this.method_37021(narrationElementOutput);
        }
    }
}

