/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_437;
import net.minecraft.class_8028;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.client.LegacyGuiItemRenderer;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTip;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.RecipeInfo;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.network.ServerMenuCraftPayload;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

public abstract class RecipeIconHolder<R>
extends LegacyIconHolder
implements ControlTooltip.ActionHolder {
    public static final class_2561 NOT_ENOUGH_INGREDIENTS = class_2561.method_43471((String)"legacy.hint.not_enough_ingredients");
    protected final class_310 minecraft = class_310.method_1551();
    public boolean compactMode = false;
    protected int selectionOffset = 0;
    protected List<RecipeInfo<R>> focusedRecipes;
    protected boolean allowCraftableRecipesToggle = true;
    boolean isHoveredTop = false;
    boolean isHoveredBottom = false;

    public RecipeIconHolder(int x, int y) {
        super(x, y, 27, 27);
        this.allowItemDecorations = false;
    }

    public static class_1799 getActualItem(Optional<class_1856> ingredient) {
        return ingredient.isEmpty() || FactoryIngredient.of((class_1856)ingredient.get()).getStacks().length == 0 ? class_1799.field_8037 : FactoryIngredient.of((class_1856)ingredient.get()).getStacks()[(int)(class_156.method_658() / 800L % (long)FactoryIngredient.of((class_1856)ingredient.get()).getStacks().length)];
    }

    @Override
    public void method_25394(class_332 graphics, int i, int j, float f) {
        this.compactMode = LegacyOptions.getUIMode().isSD();
        this.isHoveredTop = this.method_25370() && !this.compactMode && this.getFocusedRecipes().size() > 2 && this.isMouseOver(i, j, -1);
        this.isHoveredBottom = this.method_25370() && !this.compactMode && this.getFocusedRecipes().size() >= 2 && this.isMouseOver(i, j, 1);
        this.itemIcon = this.isValidIndex() ? this.getFocusedRecipes().get(0).getResultItem() : class_1799.field_8037;
        super.method_25394(graphics, i, j, f);
    }

    @Override
    public void renderItem(class_332 graphics, int i, int j, float f) {
        if (!this.isValidIndex()) {
            return;
        }
        LegacyGuiItemRenderer.secureTranslucentRender(!this.canCraft(this.getFocusedRecipes().get(0)), 0.5f, u -> super.renderItem(graphics, i, j, f));
    }

    protected abstract boolean canCraft(RecipeInfo<R> var1);

    public boolean canCraft() {
        return this.canCraft(this.getFocusedRecipe());
    }

    protected abstract List<RecipeInfo<R>> getRecipes();

    public abstract LegacyScrollRenderer getScrollRenderer();

    List<RecipeInfo<R>> getFocusedRecipes() {
        if (!(this.method_25370() && this.isValidIndex() && this.canScroll())) {
            this.focusedRecipes = null;
        } else if (this.focusedRecipes == null) {
            this.focusedRecipes = new ArrayList<RecipeInfo<R>>(this.getRecipes());
        }
        return this.focusedRecipes == null ? this.getRecipes() : this.focusedRecipes;
    }

    public void invalidateFocused() {
        this.focusedRecipes = null;
    }

    @Override
    public void method_25365(boolean bl) {
        if (bl) {
            this.selectionOffset = 0;
            this.updateRecipeDisplay();
        }
        super.method_25365(bl);
    }

    @Override
    public void renderTooltip(class_310 minecraft, class_332 graphics, int i, int j) {
        super.renderTooltip(minecraft, graphics, i, j);
        if (!this.method_25370()) {
            return;
        }
        if (this.getFocusedRecipes().size() <= 1) {
            return;
        }
        if (this.isHoveredTop) {
            this.renderTooltip(minecraft, graphics, this.getFocusedRecipes().get(this.getFocusedRecipes().size() - 1).getResultItem(), i, j);
        }
        if (this.isHoveredBottom) {
            this.renderTooltip(minecraft, graphics, this.getFocusedRecipes().get(1).getResultItem(), i, j);
        }
    }

    protected RecipeInfo<R> getFocusedRecipe() {
        if (this.selectionOffset > 0 && this.getFocusedRecipes().size() < 2 || this.selectionOffset < 0 && this.getFocusedRecipes().size() <= 2) {
            this.selectionOffset = 0;
        }
        return this.isValidIndex() ? this.getFocusedRecipes().get(this.getSelectionIndex()) : null;
    }

    protected class_1799 getFocusedResult() {
        return this.getFocusedRecipe() == null ? class_1799.field_8037 : this.getFocusedRecipe().getResultItem();
    }

    public void updateRecipeDisplay() {
        this.updateRecipeDisplay(this.getFocusedRecipe());
    }

    protected abstract void toggleCraftableRecipes(class_11907 var1);

    public boolean controlCyclicNavigation(int i, int index, List<RecipeIconHolder<R>> craftingButtons, Stocker.Sizeable craftingOffset, LegacyScrollRenderer renderer, class_437 screen) {
        if (i == 263 && index == 0 || i == 262 && index == craftingButtons.size() - 1) {
            int oldOffset = (Integer)craftingOffset.get();
            craftingOffset.add(i == 263 ? -1 : 1, true);
            if (oldOffset == craftingOffset.max && i == 262 || oldOffset == 0 && i == 263) {
                screen.method_25395((class_364)craftingButtons.get(i == 263 ? craftingButtons.size() - 1 : 0));
            } else {
                renderer.updateScroll(i == 263 ? class_8028.field_41828 : class_8028.field_41829);
                this.focusedRecipes = null;
            }
            LegacySoundUtil.playSimpleUISound((class_3414)LegacyRegistries.FOCUS.get(), true);
            return true;
        }
        return false;
    }

    @Override
    public boolean method_25404(class_11908 keyEvent) {
        if (keyEvent.comp_4795() == 79 && this.allowCraftableRecipesToggle) {
            this.focusedRecipes = null;
            this.selectionOffset = 0;
            this.toggleCraftableRecipes((class_11907)keyEvent);
            this.updateRecipeDisplay();
            LegacySoundUtil.playSimpleUISound((class_3414)LegacyRegistries.FOCUS.get(), true);
            return true;
        }
        int oldSelection = this.selectionOffset;
        if ((keyEvent.method_74234() || keyEvent.method_74235()) && this.isValidIndex()) {
            if (!this.compactMode) {
                if (keyEvent.method_74234() && (this.getRecipes().size() > 2 || this.selectionOffset == 1)) {
                    this.selectionOffset = Math.max(this.selectionOffset - 1, -1);
                }
                if (keyEvent.method_74235() && this.getRecipes().size() >= 2) {
                    this.selectionOffset = Math.min(this.selectionOffset + 1, 1);
                }
            }
            if (oldSelection != this.selectionOffset || this.canScroll()) {
                LegacySoundUtil.playSimpleUISound((class_3414)LegacyRegistries.FOCUS.get(), true);
                if (oldSelection == this.selectionOffset && (this.compactMode || this.selectionOffset != 0)) {
                    Collections.rotate(this.getFocusedRecipes(), keyEvent.method_74234() ? 1 : -1);
                }
                this.updateRecipeDisplay();
                return true;
            }
        }
        return super.method_25404(keyEvent);
    }

    protected abstract void updateRecipeDisplay(RecipeInfo<R> var1);

    @Override
    public void renderSelection(class_332 graphics, int i, int j, float f) {
        if (this.isValidIndex()) {
            if (this.compactMode) {
                if (this.canScroll()) {
                    this.renderScroll(graphics, this.getScrollRenderer());
                }
            } else {
                graphics.method_51448().pushMatrix();
                graphics.method_51448().translate(this.getXCorner() - 4.5f, this.getYCorner());
                this.applyOffset(graphics);
                if (this.getFocusedRecipes().size() == 2) {
                    FactoryGuiGraphics.of((class_332)graphics).blitSprite(LegacySprites.CRAFTING_2_SLOTS_SELECTION, 0, -12, 36, 78);
                } else if (this.getFocusedRecipes().size() > 2) {
                    FactoryGuiGraphics.of((class_332)graphics).blitSprite(LegacySprites.CRAFTING_SELECTION, 0, -39, 36, 105);
                }
                graphics.method_51448().popMatrix();
                if (this.getFocusedRecipes().size() >= 2) {
                    LegacyGuiItemRenderer.secureTranslucentRender(!this.canCraft(this.getFocusedRecipes().get(1)), 0.5f, u -> this.renderItem(graphics, this.getFocusedRecipes().get(1).getResultItem(), this.method_46426(), this.method_46427() + 27, false));
                    if (this.getFocusedRecipes().size() >= 3) {
                        LegacyGuiItemRenderer.secureTranslucentRender(!this.canCraft(this.getFocusedRecipes().get(this.getFocusedRecipes().size() - 1)), 0.5f, u -> this.renderItem(graphics, this.getFocusedRecipes().get(this.getFocusedRecipes().size() - 1).getResultItem(), this.method_46426(), this.method_46427() - 27, false));
                    }
                }
            }
        }
        graphics.method_51448().pushMatrix();
        graphics.method_51448().translate(0.0f, (float)(this.selectionOffset * 27));
        super.renderSelection(graphics, i, j, f);
        graphics.method_51448().popMatrix();
    }

    protected boolean canScroll() {
        return this.getRecipes().size() >= (this.compactMode ? 2 : 3);
    }

    protected boolean isValidIndex() {
        return !this.getRecipes().isEmpty();
    }

    protected int getSelectionIndex() {
        return this.selectionOffset == -1 ? this.getFocusedRecipes().size() - 1 : (this.selectionOffset == 1 ? 1 : 0);
    }

    public boolean method_25401(double d, double e, double f, double g) {
        if (this.method_25370() && this.canScroll()) {
            Collections.rotate(this.getFocusedRecipes(), (int)Math.signum(g));
            this.updateRecipeDisplay();
            return true;
        }
        return false;
    }

    protected boolean isMouseOver(double d, double e, int selection) {
        return LegacyRenderUtil.isMouseOver(d, e, this.getXCorner(), this.getYCorner() + (float)(selection * 27), this.method_25368(), this.method_25364());
    }

    @Override
    public boolean method_25405(double d, double e) {
        return this.isHovered || this.isHoveredTop || this.isHoveredBottom;
    }

    @Override
    public void onClick(class_11909 event, boolean bl) {
        int oldSelection = this.selectionOffset;
        int n = this.isHoveredTop ? -1 : (this.selectionOffset = this.isHoveredBottom ? 1 : 0);
        if (oldSelection != this.selectionOffset) {
            this.updateRecipeDisplay();
        } else {
            super.onClick(event, bl);
        }
    }

    public void craft(class_11907 input) {
        CommonNetwork.sendToServer((CommonNetwork.Payload)new ServerMenuCraftPayload(this.getFocusedRecipe(), input.method_74239() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed));
    }

    @Override
    public void onPress(class_11907 input) {
        if (this.method_25370() && this.isValidIndex()) {
            if (this.canCraft()) {
                this.craft(input);
                this.updateRecipeDisplay();
            } else {
                class_1703 class_17032 = this.minecraft.field_1724.field_7512;
                if (class_17032 instanceof LegacyCraftingMenu) {
                    LegacyCraftingMenu m = (LegacyCraftingMenu)class_17032;
                    if (!m.showedNotEnoughIngredientsHint && ((Boolean)LegacyOptions.hints.get()).booleanValue()) {
                        m.showedNotEnoughIngredientsHint = true;
                        LegacyTipManager.setActualTip(new LegacyTip(null, NOT_ENOUGH_INGREDIENTS));
                    }
                }
                LegacySoundUtil.playSimpleUISound((class_3414)LegacyRegistries.CRAFT_FAIL.get(), 1.0f);
            }
        }
    }

    @Override
    @Nullable
    public class_2561 getAction(ControlTooltip.ActionHolder.Context context) {
        return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 257 && this.canCraft() && this.isValidIndex() && this.method_25370() ? LegacyComponents.CREATE : null);
    }
}

