/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_8028;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyScrollRenderer;

public abstract class RecipesScreen<T extends class_1703, H extends LegacyIconHolder>
extends class_465<T>
implements Controller.Event,
ControlTooltip.Event {
    protected final UIAccessor accessor = UIAccessor.of((class_437)this);
    protected final List<H> recipeButtons = new ArrayList<H>();
    protected final class_1661 inventory;
    protected int selectedRecipeButton;
    protected final Stocker.Sizeable recipeButtonsOffset = new Stocker.Sizeable(Integer.valueOf(0));
    protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    private int timesInventoryChanged;
    private int updateTimer = 0;

    public RecipesScreen(T menu, class_1661 inventory, class_2561 component) {
        super(menu, inventory, component);
        this.inventory = inventory;
        this.addRecipeButtons();
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultButtons(renderer, (class_437)this);
        ControlTooltip.Event.super.addControlTooltips(renderer);
    }

    @Override
    public boolean disableCursorOnInit() {
        return true;
    }

    @Override
    public boolean onceClickBindings(BindingState state) {
        return !state.is(ControllerBinding.DOWN_BUTTON) && Controller.Event.super.onceClickBindings(state);
    }

    protected abstract void updateRecipes();

    protected void updateRecipesAndResetTimer() {
        this.updateRecipes();
        this.updateTimer = 0;
    }

    protected void method_37432() {
        super.method_37432();
        ++this.updateTimer;
        if (this.timesInventoryChanged != this.inventory.method_7364()) {
            this.updateRecipesAndResetTimer();
            this.timesInventoryChanged = this.inventory.method_7364();
        }
        if (this.updateTimer >= 20) {
            this.updateRecipesAndResetTimer();
        }
    }

    public void renderRecipesScroll(class_332 guiGraphics, int x, int y) {
        if ((Integer)this.recipeButtonsOffset.get() > 0) {
            this.scrollRenderer.renderScroll(guiGraphics, class_8028.field_41828, this.field_2776 + this.accessor.getInteger("horizontalScroll.x", x), this.field_2800 + this.accessor.getInteger("horizontalScroll.y", y));
        }
        if (this.recipeButtonsOffset.max > 0 && (Integer)this.recipeButtonsOffset.get() < this.recipeButtonsOffset.max) {
            this.scrollRenderer.renderScroll(guiGraphics, class_8028.field_41829, this.field_2776 + this.field_2792 - 6 - this.accessor.getInteger("horizontalScroll.x", x), this.field_2800 + this.accessor.getInteger("horizontalScroll.y", y));
        }
    }

    protected abstract H createRecipeButton(int var1);

    protected void addRecipeButtons() {
        int max;
        int lastSize = this.recipeButtons.size();
        if (lastSize == (max = this.getMaxRecipeButtons())) {
            return;
        }
        if (max > lastSize) {
            for (int i = lastSize; i < max; ++i) {
                this.recipeButtons.add(this.createRecipeButton(i));
            }
        } else {
            while (this.recipeButtons.size() != max) {
                this.recipeButtons.remove(this.recipeButtons.size() - 1);
            }
            if (this.selectedRecipeButton >= this.recipeButtons.size()) {
                this.selectedRecipeButton = this.recipeButtons.size() - 1;
            }
        }
    }

    public abstract int getMaxRecipeButtons();

    public List<? extends LegacyIconHolder> getRecipeButtons() {
        return this.recipeButtons;
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        this.getRecipeButtons().forEach(h -> h.renderTooltip(this.field_22787, guiGraphics, i, j));
        this.method_2380(guiGraphics, i, j);
    }

    public void method_71085(class_332 guiGraphics, int i, int j, float f) {
        super.method_71085(guiGraphics, i, j, f);
        this.getRecipeButtons().forEach(b -> b.method_25394(guiGraphics, i, j, 0.0f));
        if (this.selectedRecipeButton < this.getRecipeButtons().size()) {
            this.getRecipeButtons().get(this.selectedRecipeButton).renderSelection(guiGraphics, i, j, 0.0f);
        }
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
        this.method_2389(guiGraphics, f, i, j);
    }

    public boolean method_25401(double d, double e, double f, double g) {
        if (this.method_19355(d, e).filter(guiEventListener -> guiEventListener.method_25401(d, e, f, g)).isPresent()) {
            return true;
        }
        if (super.method_25401(d, e, f, g)) {
            return true;
        }
        int scroll = (int)Math.signum(g);
        if (((Integer)this.recipeButtonsOffset.get() > 0 && scroll < 0 || scroll > 0 && this.recipeButtonsOffset.max > 0) && this.recipeButtonsOffset.add(scroll, false) != 0) {
            this.updateRecipesAndResetTimer();
            return true;
        }
        return false;
    }

    protected void method_25426() {
        super.method_25426();
        this.addRecipeButtons();
    }
}

