/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_364;
import net.minecraft.class_4068;
import net.minecraft.class_4069;
import net.minecraft.class_437;
import net.minecraft.class_8016;
import net.minecraft.class_8021;
import net.minecraft.class_8023;
import net.minecraft.class_8028;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.config.FactoryConfig;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.LegacyConfigWidgets;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.TickBox;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class RenderableVList {
    public final List<class_4068> renderables = new ArrayList<class_4068>();
    public final UIAccessor accessor;
    protected final Stocker<Integer> scrolledList = Stocker.of((Object)0);
    public boolean forceWidth = true;
    public boolean cyclic = true;
    protected boolean canScrollDown = false;
    protected String name;
    protected int leftPos;
    protected int topPos;
    public int listWidth;
    public int listHeight;
    protected int renderablesCount;
    protected LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    protected Function<class_8021, Integer> layoutSeparation = w -> LegacyOptions.getUIMode().isSD() ? 2 : 3;

    public RenderableVList(UIAccessor accessor) {
        this.accessor = accessor;
    }

    public RenderableVList(class_437 screen) {
        this(UIAccessor.of((class_437)screen));
    }

    public RenderableVList addRenderables(class_4068 ... renderables) {
        return this.addRenderables(this.renderables.size(), renderables);
    }

    public RenderableVList addRenderables(int indexOffset, class_4068 ... renderables) {
        this.renderables.addAll(indexOffset, List.of(renderables));
        return this;
    }

    public RenderableVList addRenderable(class_4068 renderable) {
        this.renderables.add(renderable);
        return this;
    }

    public class_437 getScreen() {
        return this.accessor.getScreen();
    }

    public <S> S getScreen(Class<S> screenClass) {
        return screenClass.cast(this.accessor.getScreen());
    }

    public <T> RenderableVList addLinkedOptions(int index, FactoryConfig<T> dependency, Predicate<FactoryConfig<T>> activeDependent, FactoryConfig<?> ... dependents) {
        ArrayList<class_339> dependentWidgets = new ArrayList<class_339>();
        for (FactoryConfig<?> dependent : dependents) {
            class_339 dependentWidget = LegacyConfigWidgets.createWidget(dependent);
            dependentWidget.field_22763 = activeDependent.test(dependency);
            dependentWidgets.add(dependentWidget);
        }
        this.renderables.addAll(index, (Collection<class_4068>)ImmutableList.builder().add((Object)LegacyConfigWidgets.createWidget(dependency, 0, 0, 0, b -> dependentWidgets.forEach(dependentWidget -> {
            dependentWidget.field_22763 = activeDependent.test(dependency);
        }))).addAll(dependentWidgets).build());
        return this;
    }

    public <T> RenderableVList addLinkedOptions(FactoryConfig<T> dependency, Predicate<FactoryConfig<T>> activeDependent, FactoryConfig<?> ... dependents) {
        return this.addLinkedOptions(this.renderables.size(), dependency, activeDependent, dependents);
    }

    public RenderableVList addDependentOptions(int index, boolean enabled, FactoryConfig<?> ... dependents) {
        if (enabled) {
            this.addOptions(index, dependents);
        } else {
            this.renderables.addAll(index, Arrays.stream(dependents).map(option -> {
                class_339 widget = LegacyConfigWidgets.createWidget(option);
                widget.field_22763 = false;
                return widget;
            }).toList());
        }
        return this;
    }

    public RenderableVList addDependentOptions(boolean enabled, FactoryConfig<?> ... dependents) {
        return this.addDependentOptions(this.renderables.size(), enabled, dependents);
    }

    public RenderableVList addOptions(FactoryConfig<?> ... optionInstances) {
        return this.addOptions(this.renderables.size(), optionInstances);
    }

    public RenderableVList addOptions(int indexOffset, FactoryConfig<?> ... optionInstances) {
        return this.addOptions(indexOffset, Arrays.stream(optionInstances));
    }

    public RenderableVList addOptions(Stream<FactoryConfig<?>> optionInstances) {
        return this.addOptions(this.renderables.size(), optionInstances);
    }

    public RenderableVList addOptions(int indexOffset, Stream<FactoryConfig<?>> optionInstances) {
        this.renderables.addAll(indexOffset, optionInstances.map(LegacyConfigWidgets::createWidget).toList());
        return this;
    }

    public RenderableVList addMultSliderOption(FactoryConfig<?> optionInstance, double rangeMultiplier) {
        return this.addRenderable((class_4068)LegacyConfigWidgets.createSliderWidget(optionInstance, rangeMultiplier));
    }

    public RenderableVList addOptionsCategory(class_2561 title, FactoryConfig<?> ... optionInstances) {
        this.addCategory(title);
        return this.addOptions(optionInstances);
    }

    public RenderableVList addCategory(final class_2561 title) {
        this.addRenderable((class_4068)new SimpleLayoutRenderable(this, this.listWidth, 13){

            public void method_25394(class_332 guiGraphics, int i, int j, float f) {
                LegacyFontUtil.applySDFont(b -> guiGraphics.method_51439(class_310.method_1551().field_1772, title, this.method_46426() + 1, this.method_46427() + 4, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
            }
        });
        return this;
    }

    public RenderableVList layoutSpacing(Function<class_8021, Integer> layoutSeparation) {
        this.layoutSeparation = layoutSeparation;
        return this;
    }

    public RenderableVList forceWidth(boolean forceWidth) {
        this.forceWidth = forceWidth;
        return this;
    }

    public RenderableVList cyclic(boolean cyclic) {
        this.cyclic = cyclic;
        return this;
    }

    public void focusRenderable(class_4068 renderable) {
        class_4068 class_40682;
        class_364 l;
        if (this.renderables.isEmpty()) {
            return;
        }
        if (renderable instanceof class_364) {
            l = (class_364)renderable;
            if (this.getScreen().method_25396().contains(l)) {
                this.getScreen().method_25395(l);
                return;
            }
        }
        if ((Integer)this.scrolledList.get() > 0) {
            this.scrolledList.set((Object)0);
            this.accessor.reloadUI();
        }
        if ((class_40682 = this.renderables.get(0)) instanceof class_364) {
            l = (class_364)class_40682;
            if (this.getScreen().method_25399() != l) {
                this.getScreen().method_25395(l);
            }
        }
        while (this.getScreen().method_25399() != renderable) {
            if (this.forceWidth) {
                class_8016 path = this.getDirectionalNextFocusPath(class_8028.field_41827);
                if (this.isInvalidFocus(path, true)) {
                    if (!this.canScrollDown) break;
                    while (this.canScrollDown && this.isInvalidFocus(this.getDirectionalNextFocusPath(class_8028.field_41827), true)) {
                        this.mouseScrolled(true);
                    }
                    continue;
                }
                this.getScreen().method_25395(path.comp_1188());
                continue;
            }
            class_364 listener = this.getNextHorizontalRenderable();
            if (listener == null) {
                class_8016 path = this.getDirectionalNextFocusPath(class_8028.field_41829);
                if (this.isInvalidFocus(path, true)) break;
                this.getScreen().method_25395(path.comp_1188());
                continue;
            }
            this.getScreen().method_25395(listener);
        }
    }

    public void init(int leftPos, int topPos, int listWidth, int listHeight) {
        this.init("renderableVList", leftPos, topPos, listWidth, listHeight);
    }

    public void init(String name, int leftPos, int topPos, int listWidth, int listHeight) {
        boolean allowScroll;
        this.name = name;
        this.leftPos = this.accessor.getInteger(name + ".x", leftPos);
        this.topPos = this.accessor.getInteger(name + ".y", topPos);
        this.listWidth = this.accessor.getInteger(name + ".width", listWidth);
        this.listHeight = this.accessor.getInteger(name + ".height", listHeight);
        boolean bl = allowScroll = this.listHeight > 0;
        if (allowScroll) {
            this.accessor.getChildrenRenderables().add((guiGraphics, i, j, f) -> {
                if ((Integer)this.scrolledList.get() > 0) {
                    this.scrollRenderer.renderScroll(guiGraphics, class_8028.field_41826, this.leftPos + this.listWidth - 29, this.topPos + this.listHeight - 8);
                }
                if (this.canScrollDown) {
                    this.scrollRenderer.renderScroll(guiGraphics, class_8028.field_41827, this.leftPos + this.listWidth - 13, this.topPos + this.listHeight - 8);
                }
            });
        }
        this.canScrollDown = false;
        int yDiff = 0;
        int xDiff = 0;
        this.renderablesCount = 0;
        for (int i2 = ((Integer)this.scrolledList.get()).intValue(); i2 < this.renderables.size(); ++i2) {
            class_8021 l;
            class_4068 r = this.renderables.get(i2);
            if (r instanceof TickBox) {
                TickBox tick = (TickBox)r;
                tick.updateHeight();
            }
            if (!allowScroll || !(r instanceof class_8021) || yDiff + (l = (class_8021)r).method_25364() + (i2 == this.renderables.size() - 1 && (Integer)this.scrolledList.get() == 0 ? 0 : 12) <= this.listHeight) {
                class_8021 l2;
                if (r instanceof class_8021) {
                    l2 = (class_8021)r;
                    boolean changeRow = this.forceWidth || xDiff + l2.method_25368() > this.listWidth;
                    l2.method_46421(this.leftPos + xDiff);
                    l2.method_46419(this.topPos + yDiff);
                    xDiff = changeRow ? 0 : xDiff + l2.method_25368() + this.layoutSeparation.apply(l2);
                    yDiff += changeRow ? l2.method_25364() + this.layoutSeparation.apply(l2) : 0;
                    if (changeRow && !this.forceWidth) {
                        --i2;
                        continue;
                    }
                }
                ++this.renderablesCount;
                if (r instanceof class_339) {
                    class_339 w = (class_339)r;
                    if (this.forceWidth) {
                        w.method_25358(this.listWidth);
                    }
                }
                if (r instanceof class_364) {
                    l2 = (class_364)r;
                    this.accessor.addChild(this.accessor.getChildren().size(), (class_364)l2, false, true);
                }
                this.accessor.addRenderable(this.accessor.getChildrenRenderables().size(), r);
                continue;
            }
            this.canScrollDown = true;
            break;
        }
    }

    public int getLineAmount(int scroll) {
        if (this.forceWidth) {
            return scroll;
        }
        int xDiff = 0;
        int rowAmount = 0;
        for (int i = ((Integer)this.scrolledList.get()).intValue(); i < (Integer)this.scrolledList.get() + this.renderablesCount; ++i) {
            class_4068 class_40682 = this.renderables.get(i);
            if (class_40682 instanceof class_8021) {
                class_8021 e = (class_8021)class_40682;
                xDiff += (xDiff == 0 ? 0 : this.layoutSeparation.apply(e)) + e.method_25368();
            }
            rowAmount += scroll;
            if (xDiff + 30 > this.listWidth) break;
        }
        return rowAmount;
    }

    public void mouseScrolled(double g) {
        this.mouseScrolled((int)(-Math.signum(g)) > 0);
    }

    public void mouseScrolled(boolean down) {
        int setScroll;
        if ((this.canScrollDown && down || (Integer)this.scrolledList.get() > 0 && !down) && (setScroll = Math.max(0, (Integer)this.scrolledList.get() + this.getLineAmount(down ? 1 : -1))) != (Integer)this.scrolledList.get()) {
            this.scrollRenderer.updateScroll(down ? class_8028.field_41827 : class_8028.field_41826);
            this.scrolledList.set((Object)setScroll);
            this.accessor.reloadUI();
        }
    }

    public boolean isHovered(double x, double y) {
        return LegacyRenderUtil.isMouseOver(x, y, this.leftPos, this.topPos, this.listWidth, this.listHeight == 0 ? this.getScreen().field_22790 : this.listHeight);
    }

    public boolean isInvalidFocus(class_8016 path, boolean allowExternalListener) {
        return path == null || allowExternalListener && !this.renderables.contains(path.comp_1188());
    }

    public boolean isDirectionFocused(class_8028 direction, boolean allowExternalListener) {
        return this.isInvalidFocus(this.getDirectionalNextFocusPath(direction), allowExternalListener);
    }

    public boolean isDirectionFocused(class_8028 direction) {
        return this.isDirectionFocused(direction, false);
    }

    public class_8016 getDirectionalNextFocusPath(class_8028 direction) {
        return this.getScreen().method_48217(this.getScreen().method_25399().method_48202(), direction, this.getScreen().method_25399(), (class_8023)new class_8023.class_8024(direction));
    }

    public void setLastFocusInDirection(class_8028 direction) {
        if (this.getScreen().method_25399() != null) {
            class_8016 path;
            while (!this.isInvalidFocus(path = this.getDirectionalNextFocusPath(direction), true)) {
                this.getScreen().method_25395(path.comp_1188());
            }
        }
    }

    public boolean keyPressed(int i) {
        return this.keyPressed(i, this.cyclic);
    }

    public boolean keyPressed(int i, boolean cyclic) {
        if (this.renderables.contains(this.getScreen().method_25399()) && this.renderablesCount > 1) {
            class_364 nextHorizontalRenderable;
            class_8016 path;
            if (i == 264 && this.isInvalidFocus(path = this.getDirectionalNextFocusPath(class_8028.field_41827), true)) {
                if (this.canScrollDown) {
                    while (this.canScrollDown && this.isDirectionFocused(class_8028.field_41827, true)) {
                        this.mouseScrolled(true);
                    }
                } else if (cyclic) {
                    if (path == null && (Integer)this.scrolledList.get() > 0) {
                        this.scrolledList.set((Object)0);
                        this.accessor.reloadUI();
                        this.setLastFocusInDirection(class_8028.field_41827);
                    }
                } else if (path == null) {
                    return true;
                }
            }
            if (i == 265 && this.isInvalidFocus(path = this.getDirectionalNextFocusPath(class_8028.field_41826), true)) {
                if ((Integer)this.scrolledList.get() > 0) {
                    while ((Integer)this.scrolledList.get() > 0 && this.isDirectionFocused(class_8028.field_41826, true)) {
                        this.mouseScrolled(false);
                    }
                } else if (cyclic) {
                    if (path == null) {
                        while (this.canScrollDown) {
                            this.mouseScrolled(true);
                        }
                    }
                } else if (path == null) {
                    return true;
                }
            }
            if (this.listHeight > 0) {
                class_364 lastFocus = this.getScreen().method_25399();
                if (i == 267) {
                    if (this.isDirectionFocused(class_8028.field_41827)) {
                        while (this.accessor.getChildren().contains(lastFocus) && this.canScrollDown) {
                            this.mouseScrolled(true);
                        }
                    }
                    this.setLastFocusInDirection(class_8028.field_41827);
                    return true;
                }
                if (i == 266) {
                    if (this.isDirectionFocused(class_8028.field_41826)) {
                        while (this.accessor.getChildren().contains(lastFocus) && (Integer)this.scrolledList.get() > 0) {
                            this.mouseScrolled(false);
                        }
                    }
                    this.setLastFocusInDirection(class_8028.field_41826);
                    return true;
                }
            }
            if (!this.forceWidth && (nextHorizontalRenderable = this.getNextHorizontalRenderable(i == 263, i == 262)) != null) {
                this.getScreen().method_48263(class_8016.method_48194((class_364)nextHorizontalRenderable, (class_4069[])new class_4069[]{this.getScreen()}));
                return true;
            }
        }
        return false;
    }

    public class_364 getNextHorizontalRenderable() {
        return this.getNextHorizontalRenderable(false, true);
    }

    public class_364 getNextHorizontalRenderable(boolean left, boolean right) {
        if (right && this.isDirectionFocused(class_8028.field_41829) || left && this.isDirectionFocused(class_8028.field_41828)) {
            class_4068 class_40682;
            int focused = this.renderables.indexOf(this.getScreen().method_25399()) + (right ? 1 : -1);
            if (left && this.isDirectionFocused(class_8028.field_41826) || right && this.isDirectionFocused(class_8028.field_41827)) {
                this.keyPressed(left ? 265 : 264, false);
            }
            if (focused >= 0 && focused < this.renderables.size() && (class_40682 = this.renderables.get(focused)) instanceof class_364) {
                class_364 newFocus = (class_364)class_40682;
                return newFocus;
            }
        }
        return null;
    }

    public static interface Access {
        public void renderableVListInit();

        default public RenderableVList getRenderableVList() {
            return this.getRenderableVLists().get(0);
        }

        default public void focusRenderable(Predicate<class_4068> renderablePredicate, IntConsumer changeSelectedRenderableVList) {
            for (int i = 0; i < this.getRenderableVLists().size(); ++i) {
                RenderableVList renderableVList = this.getRenderableVLists().get(i);
                for (class_4068 renderable : renderableVList.renderables) {
                    if (!renderablePredicate.test(renderable)) continue;
                    changeSelectedRenderableVList.accept(i);
                    renderableVList.focusRenderable(renderable);
                    return;
                }
            }
        }

        default public void initRenderableVListHeight(int height) {
            for (class_4068 renderable : this.getRenderableVList().renderables) {
                if (!(renderable instanceof class_339)) continue;
                class_339 widget = (class_339)renderable;
                widget.method_53533(this.getRenderableVList().accessor.getInteger("buttonsHeight", height));
            }
        }

        public List<RenderableVList> getRenderableVLists();

        default public RenderableVList getRenderableVListAt(double x, double y) {
            RenderableVList mainRenderableVList = this.getRenderableVList();
            if (mainRenderableVList.isHovered(x, y)) {
                return mainRenderableVList;
            }
            for (RenderableVList renderableVList : this.getRenderableVLists()) {
                if (renderableVList == mainRenderableVList || !renderableVList.isHovered(x, y)) continue;
                return renderableVList;
            }
            return null;
        }
    }
}

