/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.config;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1928;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.server.MinecraftServer;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.config.FactoryConfig;
import wily.factoryapi.util.DynamicUtil;
import wily.legacy.init.LegacyGameRules;
import wily.legacy.util.LegacyTipBuilder;

public class LegacyWorldOptions {
    public static final FactoryConfig.StorageHandler WORLD_STORAGE = new FactoryConfig.StorageHandler();
    public static final FactoryConfig<Map<String, LegacyTipBuilder>> customTips = WORLD_STORAGE.register(FactoryConfig.create((String)"customTips", null, () -> LegacyTipBuilder.MAP_CODEC, new HashMap(), v -> {}, (FactoryConfig.StorageAccess)WORLD_STORAGE));
    public static final FactoryConfig<List<InitialItem>> initialItems = WORLD_STORAGE.register(FactoryConfig.create((String)"initialItems", null, () -> InitialItem.LIST_CODEC, List.of(new InitialItem(class_1802.field_8895.method_7854(), LegacyGameRules.PLAYER_STARTING_MAP), new InitialItem(class_1802.field_27023.method_7854(), LegacyGameRules.PLAYER_STARTING_BUNDLE)), v -> {}, (FactoryConfig.StorageAccess)WORLD_STORAGE));
    public static final FactoryConfig<List<UsedEndPortalPos>> usedEndPortalPositions = WORLD_STORAGE.register(FactoryConfig.create((String)"usedEndPortalPositions", null, () -> UsedEndPortalPos.LIST_CODEC, new ArrayList(), v -> {}, (FactoryConfig.StorageAccess)WORLD_STORAGE));

    public record UsedEndPortalPos(class_2338 pos, UUID player, String identifier) {
        public static final Codec<UsedEndPortalPos> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2338.field_25064.fieldOf("pos").forGetter(UsedEndPortalPos::pos), (App)Codec.STRING.xmap(UUID::fromString, UUID::toString).fieldOf("player").forGetter(UsedEndPortalPos::player)).apply((Applicative)i, UsedEndPortalPos::new));
        public static final Codec<List<UsedEndPortalPos>> LIST_CODEC = CODEC.listOf().xmap(ArrayList::new, Function.identity());

        public UsedEndPortalPos(class_2338 pos, UUID player) {
            this(pos, player, "used_end_portal_pos:" + pos.toString());
        }

        public boolean inRange(class_2338 otherPos) {
            return Math.abs(this.pos.method_10263() - otherPos.method_10263()) <= 2 && Math.abs(this.pos.method_10260() - otherPos.method_10260()) <= 2;
        }

        public boolean isValid(MinecraftServer server) {
            class_3222 serverPlayer = server.method_3760().method_14602(this.player);
            return serverPlayer != null && serverPlayer.method_51469().method_27983() == class_1937.field_25181;
        }
    }

    public record InitialItem(class_1799 item, Optional<class_1928.class_4313<class_1928.class_4310>> dependentGamerule) {
        public static final Codec<class_1928.class_4313<class_1928.class_4310>> BOOLEAN_GAMERULE_CODEC = Codec.STRING.xmap(InitialItem::getGameruleFromId, class_1928.class_4313::method_20771);
        public static final Codec<InitialItem> CODEC = RecordCodecBuilder.create(i -> i.group((App)DynamicUtil.ITEM_CODEC.fieldOf("item").forGetter(InitialItem::item), (App)BOOLEAN_GAMERULE_CODEC.optionalFieldOf("gamerule").forGetter(InitialItem::dependentGamerule)).apply((Applicative)i, InitialItem::new));
        public static final Codec<List<InitialItem>> LIST_CODEC = CODEC.listOf();

        public InitialItem(class_1799 item, class_1928.class_4313<class_1928.class_4310> gamerule) {
            this(item, Optional.of(gamerule));
        }

        public InitialItem(class_1799 item) {
            this(item, Optional.empty());
        }

        public static class_1928.class_4313<class_1928.class_4310> getGameruleFromId(final String id) {
            final Bearer keyBearer = Bearer.of(null);
            final class_1928 gameRules = FactoryAPI.currentServer.method_3767();
            gameRules.method_20744(new class_1928.class_4311(){

                public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> key, class_1928.class_4314<T> type) {
                    if (gameRules.method_20746(key) instanceof class_1928.class_4310 && key.method_20771().equals(id)) {
                        keyBearer.set(key);
                    }
                }
            });
            return (class_1928.class_4313)keyBearer.get();
        }

        public boolean isEnabled(MinecraftServer server) {
            return this.dependentGamerule.isEmpty() || server.method_3767().method_8355(this.dependentGamerule.get());
        }
    }

    public record NamedArea(class_2338 firstPos, class_2338 secondPos, boolean checkHeight, boolean isBarrier, List<UUID> players) {
    }
}

