/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.util;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Decoder;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Encoder;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1792;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9326;
import org.apache.logging.log4j.Logger;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.util.DynamicUtil;
import wily.legacy.Legacy4J;

public class IOUtil {
    public static <T> Predicate<T> registryMatches(class_2378<T> registry, JsonObject o) {
        JsonPrimitive j;
        JsonElement jsonElement;
        String name = registry.method_46765().method_29177().method_12832();
        if (!o.has(name) && !o.has(name + "s")) {
            return t -> false;
        }
        ArrayList<Object> tip = new ArrayList<Object>();
        ArrayList tipExclusions = new ArrayList();
        ArrayList<class_6862> tipTags = new ArrayList<class_6862>();
        if (o.has(name) && (jsonElement = o.get(name)) instanceof JsonPrimitive && (j = (JsonPrimitive)jsonElement).isString()) {
            String s = j.getAsString();
            if (s.startsWith("#")) {
                tipTags.add(class_6862.method_40092((class_5321)registry.method_46765(), (class_2960)FactoryAPI.createLocation((String)s.replaceFirst("#", ""))));
            } else {
                tip.add(FactoryAPIPlatform.getRegistryValue((class_2960)FactoryAPI.createLocation((String)s), registry));
            }
        }
        if (o.has(name + "s") && (jsonElement = o.get(name + "s")) instanceof JsonArray) {
            JsonArray a = (JsonArray)jsonElement;
            a.forEach(ie -> {
                JsonPrimitive p;
                if (ie instanceof JsonPrimitive && (p = (JsonPrimitive)ie).isString()) {
                    String s = p.getAsString();
                    if (s.startsWith("#")) {
                        tipTags.add(class_6862.method_40092((class_5321)registry.method_46765(), (class_2960)FactoryAPI.createLocation((String)s.replaceFirst("#", ""))));
                    } else if (s.startsWith("!")) {
                        class_2960 l = FactoryAPI.createLocation((String)s.replaceFirst("!", ""));
                        registry.method_17966(l).ifPresent(tipExclusions::add);
                    } else {
                        tip.add(FactoryAPIPlatform.getRegistryValue((class_2960)FactoryAPI.createLocation((String)s), (class_2378)registry));
                    }
                }
            });
        }
        return t -> {
            if (tipExclusions.contains(t)) return false;
            if (tip.contains(t)) return true;
            if (!tipTags.stream().anyMatch(arg_0 -> ((class_6880.class_6883)registry.method_46747((class_5321)registry.method_29113(t).orElseThrow())).method_40220(arg_0))) return false;
            return true;
        };
    }

    public static BiPredicate<class_1792, class_9326> registryMatchesItem(JsonObject o) {
        class_9326 data = o.has("components") ? (class_9326)class_9326.field_49589.parse(DynamicUtil.getActualRegistryOps((DynamicOps)JsonOps.INSTANCE), (Object)o.getAsJsonObject("components")).getOrThrow() : null;
        Predicate p = IOUtil.registryMatches(class_7923.field_41178, o);
        return (item, d) -> p.test(item) && (data == null || Objects.equals(d, data));
    }

    public static <T> T getJsonStringOrNull(JsonObject object, String element, Function<String, T> constructor) {
        String s = class_3518.method_15253((JsonObject)object, (String)element, null);
        return s == null ? null : (T)constructor.apply(s);
    }

    public static <T> void ifJsonStringNotNull(JsonObject object, String element, Function<String, T> constructor, Consumer<T> consumer) {
        T obj = IOUtil.getJsonStringOrNull(object, element, constructor);
        if (obj != null) {
            consumer.accept(obj);
        }
    }

    public static Stream<String> getOrderedNamespaces(class_3300 manager) {
        return manager.method_14487().stream().sorted(Comparator.comparingInt(s -> s.equals("legacy") ? 0 : 1));
    }

    public static <T> FallbackCodec<T> createFallbackCodec(Codec<T> main, Codec<T> fallback) {
        return new FallbackCodec<T>(main, main, fallback);
    }

    public static <K, V> Codec<Map<K, V>> createIdMapCodec(final Codec<K> keyCodec, final Codec<V> codec, final String keyField) {
        return new Codec<Map<K, V>>(){

            public <T> DataResult<Pair<Map<K, V>, T>> decode(DynamicOps<T> ops, T input) {
                Dynamic dynamic = new Dynamic(ops, input);
                DataResult defaultMap = dynamic.asMapOpt().map(s -> s.collect(Collectors.toMap(p -> keyCodec.parse((Dynamic)p.getFirst()).result().orElseThrow(), p -> codec.parse(((Dynamic)p.getSecond()).set(keyField, (Dynamic)p.getFirst())).resultOrPartial(arg_0 -> ((Logger)Legacy4J.LOGGER).error(arg_0)).get(), (a, b) -> b, LinkedHashMap::new)));
                return defaultMap.map(m -> Pair.of((Object)m, (Object)input));
            }

            public <T> DataResult<T> encode(Map<K, V> input, DynamicOps<T> ops, T prefix) {
                return DataResult.success((Object)ops.createMap(input.entrySet().stream().map(e -> Pair.of((Object)keyCodec.encodeStart(ops, e.getKey()).getOrThrow(), codec.encodeStart(ops, e.getValue()).resultOrPartial(arg_0 -> ((Logger)Legacy4J.LOGGER).error(arg_0)).get()))));
            }
        };
    }

    public static <V> Codec<List<V>> createListIdMapCodec(final Codec<V> codec, final String keyField) {
        final Codec listCodec = codec.listOf();
        return IOUtil.createFallbackCodec(new Codec<List<V>>(){

            public <T> DataResult<Pair<List<V>, T>> decode(DynamicOps<T> ops, T input) {
                Dynamic dynamic = new Dynamic(ops, input);
                DataResult defaultMap = dynamic.asMapOpt().map(s -> s.map(p -> codec.parse(((Dynamic)p.getSecond()).set(keyField, (Dynamic)p.getFirst())).resultOrPartial(arg_0 -> ((Logger)Legacy4J.LOGGER).error(arg_0)).get()).toList());
                return defaultMap.map(m -> Pair.of((Object)m, (Object)input));
            }

            public <T> DataResult<T> encode(List<V> input, DynamicOps<T> ops, T prefix) {
                return listCodec.encode(input, ops, prefix);
            }
        }, listCodec);
    }

    public static <E> Codec<Map<String, E>> createListingCodec(final Codec<E> codec, final String keyField, final String valueField, final Function<E, String> fallBackKey) {
        return new Codec<Map<String, E>>(){

            public <T> DataResult<Pair<Map<String, E>, T>> decode(DynamicOps<T> ops, T input) {
                Dynamic dynamic = new Dynamic(ops, input);
                DataResult defaultMap = dynamic.asMapOpt().map(s -> s.collect(Collectors.toMap(p -> (String)((Dynamic)p.getFirst()).asString().result().orElseThrow(), p -> codec.parse((Dynamic)p.getSecond()).result().orElseThrow(), (a, b) -> b, LinkedHashMap::new)));
                return (defaultMap.result().isPresent() ? defaultMap : dynamic.asListOpt(d -> {
                    Object element = codec.parse(d).result().orElseGet(() -> d.get(valueField).flatMap(arg_0 -> ((Codec)codec).parse(arg_0)).resultOrPartial(arg_0 -> ((Logger)Legacy4J.LOGGER).error(arg_0)).get());
                    return Pair.of((Object)d.get(keyField).asString().result().orElseGet(() -> (String)fallBackKey.apply(element)), (Object)element);
                }).map(l -> l.stream().collect(Collectors.toMap(Pair::getFirst, Pair::getSecond, (a, b) -> b, LinkedHashMap::new)))).map(m -> Pair.of((Object)m, (Object)input));
            }

            public <T> DataResult<T> encode(Map<String, E> input, DynamicOps<T> ops, T prefix) {
                return DataResult.success((Object)ops.createList(input.entrySet().stream().map(e -> ops.createMap(Map.of(ops.createString(keyField), ops.createString((String)e.getKey()), ops.createString(valueField), codec.encodeStart(ops, e.getValue()).resultOrPartial(arg_0 -> ((Logger)Legacy4J.LOGGER).error(arg_0)).get())))));
            }
        };
    }

    public record FallbackCodec<T>(Encoder<T> encoder, Decoder<T> decoder, Codec<T> fallback) implements Codec<T>
    {
        public <T1> DataResult<Pair<T, T1>> decode(DynamicOps<T1> dynamicOps, T1 t1) {
            DataResult decoded = this.decoder.decode(dynamicOps, t1);
            return decoded.isError() ? this.fallback.decode(dynamicOps, t1) : decoded;
        }

        public <T1> DataResult<T1> encode(T t, DynamicOps<T1> dynamicOps, T1 t1) {
            DataResult encoded = this.encoder.encode(t, dynamicOps, t1);
            return encoded.isError() ? this.fallback.encode(t, dynamicOps, t1) : encoded;
        }
    }
}

