/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.client.sounds.SoundEngine;
import net.minecraft.client.sounds.SoundManager;
import wily.legacy.mixin.base.client.MusicManagerAccessor;
import wily.legacy.util.client.LegacySoundUtil;

public class LegacyMusicFader {
    private static final long FADE_TICKS = 70L;
    private static final Minecraft mc = Minecraft.getInstance();
    private static final SoundManager soundManager = mc.getSoundManager();
    private static final MusicManagerAccessor musicManagerAccessor = (MusicManagerAccessor)mc.getMusicManager();
    public static SoundInstance queuedSong = null;
    public static Map<SoundInstance, Long> fadingSongs = new HashMap<SoundInstance, Long>();
    public static boolean musicManagerShouldTick = true;
    private static long ticks = 0L;

    public static SoundEngine.PlayResult fadeInMusic(SoundInstance newSong, boolean stopMusicManager) {
        SoundEngine.PlayResult result = SoundEngine.PlayResult.STARTED;
        SoundInstance music = musicManagerAccessor.getCurrentMusic();
        if (music != null) {
            fadingSongs.putIfAbsent(music, ticks + 70L);
        }
        if (fadingSongs.isEmpty()) {
            result = soundManager.play(newSong);
        } else {
            queuedSong = newSong;
        }
        if (stopMusicManager) {
            musicManagerShouldTick = false;
        }
        return result;
    }

    public static void fadeOutMusic(SoundInstance fadeMusic, boolean startMusicManager, boolean delayMusicManager) {
        if (queuedSong == fadeMusic) {
            queuedSong = null;
        } else {
            fadingSongs.putIfAbsent(fadeMusic, ticks + 70L);
        }
        if (startMusicManager) {
            musicManagerShouldTick = true;
        }
        if (delayMusicManager) {
            musicManagerAccessor.setNextSongDelay(1200);
        }
    }

    public static void fadeOutBgMusic(boolean startMusicManager) {
        SoundInstance music = ((MusicManagerAccessor)mc.getMusicManager()).getCurrentMusic();
        if (music != null) {
            LegacyMusicFader.fadeOutMusic(music, startMusicManager, false);
        }
    }

    public static void tick() {
        ++ticks;
        Iterator<Map.Entry<SoundInstance, Long>> it = fadingSongs.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<SoundInstance, Long> entry = it.next();
            SoundInstance song = entry.getKey();
            long songTick = entry.getValue();
            if (ticks >= songTick) {
                soundManager.stop(song);
                it.remove();
                continue;
            }
            LegacySoundUtil.setSoundInstanceVolume(song, (float)(songTick - ticks) / 70.0f);
        }
        if (fadingSongs.isEmpty() && queuedSong != null) {
            soundManager.play(queuedSong);
            queuedSong = null;
        }
    }
}

