/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.network.chat.Component;
import wily.factoryapi.base.Bearer;
import wily.factoryapi.base.client.AdvancedTextWidget;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.CommonColor;
import wily.legacy.client.KnownListing;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.LegacyScreen;
import wily.legacy.client.screen.OverlayPanelScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class ConfirmationScreen
extends OverlayPanelScreen
implements RenderableVList.Access {
    protected final AdvancedTextWidget messageLabel;
    protected final RenderableVList renderableVList;
    private final List<RenderableVList> renderableVLists;
    private final Consumer<ConfirmationScreen> textWidgetConsumer;
    public Button okButton;
    protected Consumer<ConfirmationScreen> okAction;
    protected Bearer<Integer> messageYOffset;
    protected boolean initialized;

    public ConfirmationScreen(Screen parent, Function<ConfirmationScreen, Panel> panelConstructor, Component title, Consumer<ConfirmationScreen> textWidgetConsumer, Consumer<ConfirmationScreen> okAction) {
        super(parent, (OverlayPanelScreen s) -> (Panel)((Object)((Object)panelConstructor.apply((ConfirmationScreen)s))), title);
        this.renderableVList = new RenderableVList(this.accessor).layoutSpacing(l -> LegacyOptions.getUIMode().isSD() ? 1 : 2);
        this.renderableVLists = Collections.singletonList(this.renderableVList);
        this.messageYOffset = Bearer.of((Object)0);
        this.initialized = false;
        this.textWidgetConsumer = textWidgetConsumer;
        this.messageLabel = new AdvancedTextWidget(UIAccessor.of((Screen)this));
        this.okAction = okAction;
        this.parent = parent;
    }

    public ConfirmationScreen(Screen parent, Supplier<Integer> imageWidth, Supplier<Integer> baseHeight, Supplier<Integer> xOffset, Supplier<Integer> yOffset, Component title, Consumer<ConfirmationScreen> textWidgetConsumer, Consumer<ConfirmationScreen> okAction) {
        this(parent, (ConfirmationScreen s) -> Panel.createPanel(s, arg_0 -> ConfirmationScreen.lambda$new$2((Supplier)imageWidth, (Supplier)baseHeight, s, arg_0), arg_0 -> ConfirmationScreen.lambda$new$3(s, (Supplier)xOffset, (Supplier)yOffset, arg_0)), title, textWidgetConsumer, okAction);
    }

    public ConfirmationScreen(Screen parent, Supplier<Integer> imageWidth, Supplier<Integer> baseHeight, Supplier<Integer> xOffset, Supplier<Integer> yOffset, Component title, Component message, Consumer<ConfirmationScreen> okAction) {
        this(parent, imageWidth, baseHeight, xOffset, yOffset, title, (ConfirmationScreen w) -> w.messageLabel.lineSpacing(LegacyOptions.getUIMode().isSD() ? 8 : 12).withLines(message, (Integer)imageWidth.get() - (LegacyOptions.getUIMode().isSD() ? 12 : 30)), okAction);
    }

    public ConfirmationScreen(Screen parent, Supplier<Integer> imageWidth, Supplier<Integer> baseHeight, Component title, Component message, Consumer<ConfirmationScreen> okAction) {
        this(parent, imageWidth, baseHeight, () -> 0, () -> 0, title, message, okAction);
    }

    public ConfirmationScreen(Screen parent, Component title, Component message, Consumer<ConfirmationScreen> okAction) {
        this(parent, ConfirmationScreen::getPanelWidth, ConfirmationScreen::getBaseHeight, title, message, okAction);
    }

    public ConfirmationScreen(Screen parent, Supplier<Integer> imageWidth, Supplier<Integer> baseHeight, Component title, Component message) {
        this(parent, imageWidth, baseHeight, title, message, LegacyScreen::onClose);
    }

    public ConfirmationScreen(Screen parent, Component title, Component message) {
        this(parent, title, message, LegacyScreen::onClose);
    }

    public static ConfirmationScreen createInfoScreen(Screen parent, Component title, Component message) {
        return new ConfirmationScreen(parent, ConfirmationScreen::getPanelWidth, () -> LegacyOptions.getUIMode().isSD() ? 50 : 75, title, message){

            @Override
            protected void addButtons() {
                this.okButton = Button.builder((Component)Component.translatable((String)"gui.ok"), b -> this.okAction.accept(this)).build();
                this.renderableVList.addRenderable((Renderable)this.okButton);
            }
        };
    }

    public static ConfirmationScreen createLinkScreen(Screen parent, String link) {
        return ConfirmationScreen.createLinkScreen(parent, LegacyComponents.OPEN_LINK_TITLE, LegacyComponents.OPEN_LINK_MESSAGE, link);
    }

    public static ConfirmationScreen createLinkScreen(Screen parent, Component title, Component message, String link) {
        return new ConfirmationScreen(parent, ConfirmationScreen::getPanelWidth, ConfirmationScreen::getBaseHeight, title, message, s -> {
            Util.getPlatform().openUri(link);
            s.onClose();
        });
    }

    public static ConfirmationScreen createResetKnownListingScreen(Screen parent, Component title, Component message, KnownListing<?> knownListing) {
        return new ConfirmationScreen(parent, ConfirmationScreen::getPanelWidth, ConfirmationScreen::getBaseHeight, title, message, s -> {
            knownListing.list.clear();
            knownListing.save();
            s.onClose();
        });
    }

    public static ConfirmationScreen createSaveInfoScreen(Screen parent) {
        Supplier<Integer> imageWidth = () -> LegacyOptions.getUIMode().isSD() ? 200 : 275;
        return new ConfirmationScreen(parent, (Supplier)imageWidth, () -> LegacyOptions.getUIMode().isSD() ? 92 : 130, () -> 0, () -> LegacyOptions.getUIMode().isSD() ? 0 : 25, (Component)Component.empty(), w -> w.messageLabel.lineSpacing(LegacyOptions.getUIMode().isSD() ? 8 : 12).withLines(LegacyComponents.AUTOSAVE_MESSAGE, (Integer)imageWidth.get() - (LegacyOptions.getUIMode().isSD() ? 24 : 55)), LegacyScreen::onClose){

            @Override
            protected void addButtons() {
                this.darkBackground = false;
                this.okButton = Button.builder((Component)Component.translatable((String)"gui.ok"), b -> this.okAction.accept(this)).build();
                this.renderableVList.addRenderable((Renderable)this.okButton);
            }

            @Override
            public void renderableVListInit() {
                boolean sd = LegacyOptions.getUIMode().isSD();
                this.messageYOffset.set((Object)(sd ? 57 : 68));
                this.okButton.setWidth(sd ? 150 : 200);
                this.okButton.setHeight(sd ? 18 : 20);
                int listWidth = LegacyOptions.getUIMode().isSD() ? this.panel.width - 24 : this.panel.width - 55;
                this.renderableVList.init(this.panel.x + (this.panel.width - listWidth) / 2, this.panel.y + this.panel.height - (sd ? 28 : 40), listWidth, 0);
            }

            public boolean shouldCloseOnEsc() {
                return false;
            }

            @Override
            public void render(GuiGraphics guiGraphics, int i, int j, float f) {
                super.render(guiGraphics, i, j, f);
                LegacyRenderUtil.drawAutoSavingIcon(guiGraphics, this.panel.x + (this.panel.width - 24) / 2, this.panel.y + (LegacyOptions.getUIMode().isSD() ? 28 : 36));
            }
        };
    }

    public static int getPanelWidth() {
        return LegacyOptions.getUIMode().isSD() ? 144 : 230;
    }

    public static int getBaseHeight() {
        return LegacyOptions.getUIMode().isSD() ? 68 : 97;
    }

    @Override
    protected void init() {
        if (!this.initialized) {
            this.addButtons();
            this.initialized = true;
        }
        LegacyFontUtil.applySDFont(b -> this.textWidgetConsumer.accept(this));
        super.init();
        this.renderableVListInit();
        this.accessor.putIntegerBearer("messageYOffset", this.messageYOffset);
    }

    @Override
    public List<RenderableVList> getRenderableVLists() {
        return this.renderableVLists;
    }

    @Override
    public void renderableVListInit() {
        this.messageYOffset.set((Object)(this.title.getString().isEmpty() ? (LegacyOptions.getUIMode().isSD() ? 6 : 15) : (LegacyOptions.getUIMode().isSD() ? 18 : 35)));
        int listWidth = LegacyOptions.getUIMode().isSD() ? this.panel.width - 12 : this.panel.width - 30;
        this.initRenderableVListHeight(LegacyOptions.getUIMode().isSD() ? 18 : 20);
        this.renderableVList.init(this.panel.x + (this.panel.width - listWidth) / 2, this.panel.y + this.panel.height - this.renderableVList.renderables.size() * (LegacyOptions.getUIMode().isSD() ? 19 : 22) - (LegacyOptions.getUIMode().isSD() ? 6 : 8), listWidth, 0);
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.renderableVList.keyPressed(keyEvent.key())) {
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    protected void addButtons() {
        this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onClose()).build());
        this.okButton = Button.builder((Component)Component.translatable((String)"gui.ok"), b -> this.okAction.accept(this)).build();
        this.renderableVList.addRenderable((Renderable)this.okButton);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        int textX = this.panel.x + (this.panel.width - this.messageLabel.width) / 2;
        LegacyFontUtil.applySDFont(b -> {
            LegacyRenderUtil.renderScrollingString(guiGraphics, this.font, this.title, textX, this.panel.y + (b != false ? 6 : 15), textX + this.messageLabel.width, this.panel.y + (b != false ? 6 : 15) + 11, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false);
            this.messageLabel.withPos(textX, this.panel.y + (Integer)this.messageYOffset.get()).withColor(((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue()).withShadow(false).render(guiGraphics, i, j, f);
        });
    }

    private static /* synthetic */ void lambda$new$3(ConfirmationScreen s, Supplier xOffset, Supplier yOffset, Panel p) {
        p.pos(p.centeredLeftPos(s) + (Integer)xOffset.get(), p.centeredTopPos(s) + (Integer)yOffset.get());
    }

    private static /* synthetic */ void lambda$new$2(Supplier imageWidth, Supplier baseHeight, ConfirmationScreen s, Panel p) {
        p.appearance(LegacyOptions.getUIMode().isSD() ? LegacySprites.PANEL : LegacySprites.SMALL_PANEL, (Integer)imageWidth.get(), (Integer)baseHeight.get() + s.messageLabel.height);
    }
}

