/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.platform.Window;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.Object2ReferenceLinkedOpenHashMap;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceManagerReloadListener;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ItemSteerable;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.Cat;
import net.minecraft.world.entity.animal.IronGolem;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.SnowGolem;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Llama;
import net.minecraft.world.entity.animal.sheep.Sheep;
import net.minecraft.world.entity.animal.wolf.Wolf;
import net.minecraft.world.entity.decoration.ItemFrame;
import net.minecraft.world.entity.npc.AbstractVillager;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.npc.VillagerProfession;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.vehicle.AbstractMinecart;
import net.minecraft.world.entity.vehicle.Boat;
import net.minecraft.world.entity.vehicle.MinecartFurnace;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.BoneMealItem;
import net.minecraft.world.item.BrushItem;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.BundleItem;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.EggItem;
import net.minecraft.world.item.EmptyMapItem;
import net.minecraft.world.item.EnderEyeItem;
import net.minecraft.world.item.EnderpearlItem;
import net.minecraft.world.item.ExperienceBottleItem;
import net.minecraft.world.item.FireChargeItem;
import net.minecraft.world.item.FireworkRocketItem;
import net.minecraft.world.item.FishingRodItem;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.FoodOnAStickItem;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.LeadItem;
import net.minecraft.world.item.NameTagItem;
import net.minecraft.world.item.PotionItem;
import net.minecraft.world.item.ProjectileWeaponItem;
import net.minecraft.world.item.ShearsItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SnowballItem;
import net.minecraft.world.item.SpawnEggItem;
import net.minecraft.world.item.SpyglassItem;
import net.minecraft.world.item.ThrowablePotionItem;
import net.minecraft.world.item.TridentItem;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.item.crafting.RecipePropertySet;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.equipment.Equippable;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.AbstractCauldronBlock;
import net.minecraft.world.level.block.AbstractChestBlock;
import net.minecraft.world.level.block.BambooStalkBlock;
import net.minecraft.world.level.block.BarrelBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BrushableBlock;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.ButtonBlock;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.ComposterBlock;
import net.minecraft.world.level.block.DaylightDetectorBlock;
import net.minecraft.world.level.block.DiodeBlock;
import net.minecraft.world.level.block.DoorBlock;
import net.minecraft.world.level.block.DropperBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.FenceGateBlock;
import net.minecraft.world.level.block.FlowerPotBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.HopperBlock;
import net.minecraft.world.level.block.JukeboxBlock;
import net.minecraft.world.level.block.LeverBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.NoteBlock;
import net.minecraft.world.level.block.PumpkinBlock;
import net.minecraft.world.level.block.ShulkerBoxBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.entity.CampfireBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;
import org.lwjgl.glfw.GLFW;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.ItemContainerPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.MinecraftAccessor;
import wily.factoryapi.util.ColorUtil;
import wily.factoryapi.util.FactoryItemUtil;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.block.entity.WaterCauldronBlockEntity;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.screen.LegacyMenuAccess;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.mixin.base.FlowerPotBlockAccessor;
import wily.legacy.mixin.base.HangingEntityItemAccessor;
import wily.legacy.mixin.base.client.KeyboardHandlerAccessor;
import wily.legacy.util.IOUtil;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacyItemUtil;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public interface ControlTooltip {
    public static final String CONTROL_TOOLTIPS = "control_tooltips";
    public static final BiFunction<String, Style, ComponentIcon> CONTROL_ICON_FUNCTION = Util.memoize((s, style) -> ComponentIcon.of((Component)Component.literal((String)s).withStyle(style)));
    public static final Function<Icon[], Icon> COMPOUND_ICON_FUNCTION = Util.memoize(icons -> () -> icons);
    public static final Function<String, MutableComponent> CONTROL_ACTION_CACHE = Util.memoize(s -> Component.translatable((String)s));
    public static final String MOUSE_BASE_CHAR = "\uc002";
    public static final String MOUSE_BASE_FOCUSED_CHAR = "\uc003";
    public static final String KEY_CHAR = "\uc000";
    public static final String KEY_PRESSED_CHAR = "\uc001";
    public static final Component MORE = Component.literal((String)"...").withStyle(ChatFormatting.GRAY);
    public static final Component SPACE = Component.literal((String)"  ");
    public static final Component PLUS = Component.literal((String)"+");
    public static final ComponentIcon SPACE_ICON = ComponentIcon.of(SPACE);
    public static final ComponentIcon PLUS_ICON = ComponentIcon.of(PLUS);
    public static final Function<ComponentIcon[], ComponentIcon> COMPOUND_COMPONENT_ICON_FUNCTION = Util.memoize(CompoundComponentIcon::new);
    public static final Map<String, ArbitrarySupplier<ComponentIcon>> commonIcons = new HashMap<String, ArbitrarySupplier<ComponentIcon>>();
    public static final ArbitrarySupplier<ComponentIcon> PLAYER_MOVEMENT = ControlTooltip.registerCommonComponentIcon("player_movement", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? CompoundComponentIcon.of(ControlTooltip.getKeyIcon(87), ControlTooltip.getKeyIcon(65), ControlTooltip.getKeyIcon(83), ControlTooltip.getKeyIcon(68)) : ControllerBinding.LEFT_STICK.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> MENU_QUICK_ACTION = ControlTooltip.registerCommonComponentIcon("menu_quick_action", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? CompoundComponentIcon.of(ControlTooltip.getKeyIcon(0), PLUS_ICON, ControlTooltip.getKeyIcon(340)) : ControllerBinding.UP_BUTTON.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> NAVIGATION = ControlTooltip.registerCommonComponentIcon("navigation", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? CompoundComponentIcon.of(ControlTooltip.getKeyIcon(265), ControlTooltip.getKeyIcon(263), ControlTooltip.getKeyIcon(264), ControlTooltip.getKeyIcon(262)) : ControllerBinding.LEFT_STICK.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> HORIZONTAL_NAVIGATION = ControlTooltip.registerCommonComponentIcon("horizontal_navigation", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? CompoundComponentIcon.of(ControlTooltip.getKeyIcon(263), ControlTooltip.getKeyIcon(262)) : ControllerBinding.LEFT_STICK.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> VERTICAL_NAVIGATION = ControlTooltip.registerCommonComponentIcon("vertical_navigation", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? CompoundComponentIcon.of(ControlTooltip.getKeyIcon(265), ControlTooltip.getKeyIcon(264)) : ControllerBinding.LEFT_STICK.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> CONTROL_PAGE = ControlTooltip.registerCommonComponentIcon("control_page", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? CompoundComponentIcon.of(ControlTooltip.getKeyIcon(340), PLUS_ICON, CompoundComponentIcon.of(ControlTooltip.getKeyIcon(263), SPACE_ICON, ControlTooltip.getKeyIcon(262))) : ControllerBinding.RIGHT_STICK.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> CONTROL_TAB = ControlTooltip.registerCommonComponentIcon("control_tab", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? CompoundComponentIcon.of(ControlTooltip.getKeyIcon(91), SPACE_ICON, ControlTooltip.getKeyIcon(93)) : CompoundComponentIcon.of(ControllerBinding.LEFT_BUMPER.getIcon(), SPACE_ICON, ControllerBinding.RIGHT_BUMPER.getIcon())));
    public static final ArbitrarySupplier<ComponentIcon> CONTROL_TYPE = ControlTooltip.registerCommonComponentIcon("control_type", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? CompoundComponentIcon.of(ControlTooltip.getKeyIcon(340), PLUS_ICON, CompoundComponentIcon.of(ControlTooltip.getKeyIcon(91), SPACE_ICON, ControlTooltip.getKeyIcon(93))) : CompoundComponentIcon.of(ControllerBinding.LEFT_TRIGGER.getIcon(), SPACE_ICON, ControllerBinding.RIGHT_TRIGGER.getIcon())));
    public static final ArbitrarySupplier<ComponentIcon> LEFT_CRAFTING_TYPE = ControlTooltip.registerCommonComponentIcon("left_crafting_type", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? CompoundComponentIcon.of(ControlTooltip.getKeyIcon(340), PLUS_ICON, ControlTooltip.getKeyIcon(91)) : ControllerBinding.LEFT_TRIGGER.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> RIGHT_CRAFTING_TYPE = ControlTooltip.registerCommonComponentIcon("right_crafting_type", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? CompoundComponentIcon.of(ControlTooltip.getKeyIcon(340), PLUS_ICON, ControlTooltip.getKeyIcon(93)) : ControllerBinding.RIGHT_TRIGGER.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> PRESS = ControlTooltip.registerCommonComponentIcon("press", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(257) : ControllerBinding.DOWN_BUTTON.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> OPTION = ControlTooltip.registerCommonComponentIcon("option", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(79) : ControllerBinding.UP_BUTTON.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> EXTRA = ControlTooltip.registerCommonComponentIcon("extra", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(88) : ControllerBinding.LEFT_BUTTON.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> POINTER_MOVEMENT = ControlTooltip.registerCommonComponentIcon("pointer_movement", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKbmIcon(MOUSE_BASE_CHAR) : ControllerBinding.LEFT_STICK.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> CAMERA_MOVEMENT = ControlTooltip.registerCommonComponentIcon("camera_movement", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKbmIcon(MOUSE_BASE_CHAR) : ControllerBinding.LEFT_STICK.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> MENU_MAIN_ACTION = ControlTooltip.registerCommonComponentIcon("menu_main_action", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(0) : ControllerBinding.DOWN_BUTTON.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> MENU_OFF_ACTION = ControlTooltip.registerCommonComponentIcon("menu_off_action", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(1) : ControllerBinding.LEFT_BUTTON.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> LEFT_TAB = ControlTooltip.registerCommonComponentIcon("left_tab", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(91) : ControllerBinding.LEFT_BUMPER.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> RIGHT_TAB = ControlTooltip.registerCommonComponentIcon("right_tab", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(93) : ControllerBinding.RIGHT_BUMPER.getIcon()));
    public static final ArbitrarySupplier<ComponentIcon> CANCEL_BINDING = ControlTooltip.registerCommonComponentIcon("cancel_binding", (ArbitrarySupplier<ComponentIcon>)((ArbitrarySupplier)() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(256) : ControllerBinding.BACK.getIcon()));

    public static ComponentIcon getControlIcon(String s, ControlType type) {
        return CONTROL_ICON_FUNCTION.apply(s, type.styleOrEmpty());
    }

    public static MutableComponent getAction(String key) {
        return CONTROL_ACTION_CACHE.apply(key);
    }

    public static Component getSelectAction(GuiEventListener listener, ActionHolder.Context context) {
        ActionHolder.KeyContext c;
        return listener.isFocused() && context instanceof ActionHolder.KeyContext && (c = (ActionHolder.KeyContext)context).key() == 257 ? LegacyComponents.SELECT : null;
    }

    public static ArbitrarySupplier<ComponentIcon> registerCommonComponentIcon(String key, ArbitrarySupplier<ComponentIcon> supplier) {
        commonIcons.put(key, supplier);
        return supplier;
    }

    public static Component getKeyMessage(int key, Screen screen) {
        for (GuiEventListener child : screen.children()) {
            ActionHolder accessor;
            Component component;
            if (!(child instanceof ActionHolder) || (component = (accessor = (ActionHolder)child).getAction(new ActionHolder.KeyContext(new KeyEvent(key, 0, 0), screen))) == null) continue;
            return component;
        }
        return null;
    }

    public static Component getKeyboardAction(ActionHolder.KeyContext keyContext) {
        return keyContext.key() == 335 && ControlType.getActiveType().isKbm() || keyContext.key() == 257 && !ControlType.getActiveType().isKbm() ? LegacyComponents.SHOW_KEYBOARD : null;
    }

    public static Renderer setupDefaultButtons(Renderer renderer, Screen screen) {
        return renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(335) : ControllerBinding.DOWN_BUTTON.getIcon(), () -> ControlTooltip.getKeyMessage(335, screen)).add(() -> PRESS.get(), () -> ControlTooltip.getKeyMessage(257, screen));
    }

    public static Renderer setupDefaultScreen(Renderer renderer, Screen screen) {
        return ControlTooltip.setupDefaultButtons(renderer, screen).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(257) : ControllerBinding.DOWN_BUTTON.getIcon(), () -> ControlTooltip.getKeyMessage(257, screen)).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(256) : ControllerBinding.RIGHT_BUTTON.getIcon(), () -> screen.shouldCloseOnEsc() ? CommonComponents.GUI_BACK : null);
    }

    public static Renderer setupDefaultContainerScreen(Renderer renderer, LegacyMenuAccess<?> a) {
        return renderer.add(() -> MENU_MAIN_ACTION.get(), () -> ControlTooltip.getMenuMainAction(a)).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(256) : ControllerBinding.RIGHT_BUTTON.getIcon(), () -> LegacyComponents.EXIT).add(() -> MENU_OFF_ACTION.get(), () -> ControlTooltip.getMenuOffAction(a)).add(() -> MENU_QUICK_ACTION.get(), () -> ControlTooltip.getMenuQuickAction(a)).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(87) : ControllerBinding.RIGHT_TRIGGER.getIcon(), () -> a.getHoveredSlot() != null && a.getHoveredSlot().hasItem() && !a.isMouseDragging() && LegacyTipManager.hasTip(a.getHoveredSlot().getItem()) ? LegacyComponents.WHATS_THIS : null).add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(0) : ControllerBinding.LEFT_TRIGGER.getIcon(), () -> a.getMenu().getCarried().getCount() > 1 && !a.isOutsideClick(0) ? LegacyComponents.DISTRIBUTE : null);
    }

    public static Component getIconComponentFromKeyMapping(LegacyKeyMapping mapping) {
        ComponentIcon icon = ControlTooltip.getIconFromKeyMapping(mapping);
        return icon == null ? LegacyComponents.NONE : icon.getComponent();
    }

    public static ComponentIcon getIconFromKeyMapping(LegacyKeyMapping mapping) {
        return ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(mapping.getKey().getValue()) : (mapping.getBinding() == null ? null : mapping.getBinding().getIcon());
    }

    public static Component getMenuMainAction(LegacyMenuAccess<?> a) {
        if (a.isOutsideClick(0) && !a.getMenu().getCarried().isEmpty()) {
            return a.getMenu().getCarried().getCount() > 1 ? LegacyComponents.DROP_ALL : LegacyComponents.DROP;
        }
        if (!(a.getHoveredSlot() == null || a.isMouseDragging() || !a.getHoveredSlot().hasItem() && a.getMenu().getCarried().isEmpty())) {
            if (a.getHoveredSlot().hasItem() && !FactoryItemUtil.equalItems((ItemStack)a.getHoveredSlot().getItem(), (ItemStack)a.getMenu().getCarried()) && !ControlTooltip.isBundleAndAcceptItem(a.getHoveredSlot().getItem(), a.getMenu().getCarried())) {
                return a.getMenu().getCarried().isEmpty() ? LegacyComponents.TAKE : (ControlTooltip.isBundleAndAcceptItem(a.getMenu().getCarried(), a.getHoveredSlot().getItem()) ? LegacyComponents.PICK_UP : LegacyComponents.SWAP);
            }
            if (!a.getMenu().getCarried().isEmpty() && a.getHoveredSlot().mayPlace(a.getMenu().getCarried())) {
                return a.getHoveredSlot().getMaxStackSize() == 1 ? LegacyComponents.PLACE_ONE : (a.getMenu().getCarried().getCount() > 1 ? LegacyComponents.PLACE_ALL : LegacyComponents.PLACE);
            }
        }
        return null;
    }

    public static Component getMenuOffAction(LegacyMenuAccess<?> a) {
        if (a.isOutsideClick(1) && !a.getMenu().getCarried().isEmpty() && !a.isMouseDragging()) {
            return a.getMenu().getCarried().getCount() > 1 ? LegacyComponents.DROP_ONE : LegacyComponents.DROP;
        }
        if (a.getHoveredSlot() != null && !a.isMouseDragging()) {
            if (a.getMenu().getCarried().isEmpty()) {
                if (ControlTooltip.isBundle(a.getHoveredSlot().getItem()) && BundleItem.getFullnessDisplay((ItemStack)a.getHoveredSlot().getItem()) > 0.0f) {
                    return LegacyComponents.PICK_UP;
                }
                if (a.getHoveredSlot().getItem().getCount() > 1) {
                    return LegacyComponents.TAKE_HALF;
                }
            } else {
                if (a.getHoveredSlot().hasItem() && Legacy4JClient.hasModOnServer() && LegacyItemUtil.canRepair(a.getHoveredSlot().getItem(), a.getMenu().getCarried())) {
                    return LegacyComponents.REPAIR;
                }
                if (a.getHoveredSlot().hasItem() && Legacy4JClient.hasModOnServer() && LegacyItemUtil.isDyeableItem((Holder<Item>)a.getHoveredSlot().getItem().getItemHolder()) && a.getMenu().getCarried().getItem() instanceof DyeItem) {
                    return LegacyComponents.DYE;
                }
                if (ControlTooltip.isBundle(a.getMenu().getCarried()) && BundleItem.getFullnessDisplay((ItemStack)a.getMenu().getCarried()) > 0.0f && !a.getHoveredSlot().hasItem()) {
                    return LegacyComponents.RELEASE;
                }
                if (a.getHoveredSlot().hasItem() && !a.getMenu().getCarried().isEmpty() && !FactoryItemUtil.equalItems((ItemStack)a.getMenu().getCarried(), (ItemStack)a.getHoveredSlot().getItem()) && a.getHoveredSlot().mayPlace(a.getHoveredSlot().getItem())) {
                    return LegacyComponents.SWAP;
                }
                if (!a.getHoveredSlot().hasItem() && a.getHoveredSlot().mayPlace(a.getHoveredSlot().getItem())) {
                    return a.getMenu().getCarried().getCount() > 1 ? LegacyComponents.PLACE_ONE : LegacyComponents.PLACE;
                }
            }
        }
        return null;
    }

    public static Component getMenuQuickAction(LegacyMenuAccess<?> a) {
        if (a.getHoveredSlot() != null && a.getHoveredSlot().hasItem()) {
            AbstractContainerMenu abstractContainerMenu = a.getMenu();
            if (abstractContainerMenu instanceof InventoryMenu) {
                InventoryMenu menu = (InventoryMenu)abstractContainerMenu;
                for (int i = 5; i < 9 && i != a.getHoveredSlot().index; ++i) {
                    Slot slot = menu.getSlot(i);
                    if (!LegacySlotDisplay.isVisibleAndActive(slot) || !menu.getSlot(i).mayPlace(a.getHoveredSlot().getItem())) continue;
                    return LegacyComponents.EQUIP;
                }
            }
            return LegacyComponents.QUICK_MOVE;
        }
        return null;
    }

    public static boolean isBundle(ItemStack stack) {
        return stack.is(ItemTags.BUNDLES);
    }

    public static boolean isBundleAndAcceptItem(ItemStack stack, ItemStack itemToAccept) {
        return ControlTooltip.isBundle(stack) && BundleItem.getFullnessDisplay((ItemStack)stack) <= 1.0f - (float)itemToAccept.getCount() / (float)itemToAccept.getMaxStackSize() && !itemToAccept.isEmpty() && itemToAccept.getItem().canFitInsideContainerItems();
    }

    public static ControlTooltip create(final Supplier<Icon> icon, final Supplier<Component> action) {
        return new ControlTooltip(){

            @Override
            public Icon getIcon() {
                return (Icon)icon.get();
            }

            @Override
            public Component getAction() {
                return (Component)action.get();
            }
        };
    }

    public static ControlTooltip create(LegacyKeyMapping mapping, Supplier<Component> action) {
        return ControlTooltip.create(() -> ControlTooltip.getIconFromKeyMapping(mapping), action);
    }

    public static float getAlpha() {
        return Math.max(Minecraft.getInstance().screen == null ? 0.0f : 0.2f, LegacyRenderUtil.getHUDOpacity());
    }

    public static ComponentIcon getKbmIcon(String key) {
        return ControlTooltip.getControlIcon(key, ControlType.getKbmActiveType());
    }

    public static LegacyIcon getKeyIcon(int i) {
        InputConstants.Type type;
        InputConstants.Type type2 = i >= 0 ? (i <= 9 ? InputConstants.Type.MOUSE : InputConstants.Type.KEYSYM) : (type = null);
        if (type == null) {
            return null;
        }
        final InputConstants.Key key = type.getOrCreate(i);
        return ControlType.getKbmActiveType().icons().computeIfAbsent(key.getName(), i2 -> new KeyIcon(key){

            @Override
            public Component getComponent(boolean allowPressed) {
                return ControlTooltip.getControlIcon(key.getType() == InputConstants.Type.MOUSE ? (this.pressed() && allowPressed ? ControlTooltip.MOUSE_BASE_FOCUSED_CHAR : ControlTooltip.MOUSE_BASE_CHAR) : (this.pressed() && allowPressed ? ControlTooltip.KEY_PRESSED_CHAR : ControlTooltip.KEY_CHAR), ControlType.getKbmActiveType()).getComponent();
            }

            @Override
            public Component getOverlayComponent(boolean allowPressed) {
                return key.getDisplayName();
            }
        });
    }

    public static Component getPickAction(Minecraft minecraft) {
        BlockState b;
        BlockHitResult h;
        EntityHitResult r;
        ItemStack result;
        HitResult hitResult = minecraft.hitResult;
        if ((hitResult instanceof EntityHitResult && (result = (r = (EntityHitResult)hitResult).getEntity().getPickResult()) != null || (hitResult = minecraft.hitResult) instanceof BlockHitResult && (h = (BlockHitResult)hitResult).getType() != HitResult.Type.MISS && !(result = (b = minecraft.level.getBlockState(h.getBlockPos())).getCloneItemStack((LevelReader)minecraft.level, h.getBlockPos(), true)).isEmpty()) && (Legacy4JClient.playerHasInfiniteMaterials() || minecraft.player.getInventory().findSlotMatchingItem(result) != -1)) {
            return minecraft.hitResult instanceof EntityHitResult ? LegacyComponents.PICK_ENTITY : ((LegacyKeyMapping)minecraft.options.keyPickItem).getDisplayName();
        }
        return null;
    }

    public static Component getMainAction(Minecraft minecraft) {
        BlockHitResult r;
        if (minecraft.hitResult != null && minecraft.hitResult.getType() != HitResult.Type.MISS && !minecraft.level.getWorldBorder().isWithinBounds(minecraft.hitResult.getLocation().x(), minecraft.hitResult.getLocation().z())) {
            return null;
        }
        HitResult hitResult = minecraft.hitResult;
        if (hitResult instanceof BlockHitResult && (r = (BlockHitResult)hitResult).getType() != HitResult.Type.MISS) {
            BlockState state = minecraft.level.getBlockState(r.getBlockPos());
            if (state.getBlock() instanceof NoteBlock && !minecraft.player.getAbilities().instabuild) {
                return LegacyComponents.PLAY;
            }
            if (minecraft.player.getAbilities().instabuild || state.getBlock().defaultDestroyTime() >= 0.0f && !minecraft.player.blockActionRestricted((Level)minecraft.level, r.getBlockPos(), minecraft.gameMode.getPlayerMode())) {
                return LegacyComponents.MINE;
            }
        }
        return null;
    }

    public static Component getActualUse(Minecraft minecraft) {
        block77: {
            block78: {
                AbstractMinecart m;
                AbstractHorse h;
                InteractionHand[] itemFrame;
                Villager v;
                AbstractVillager m2;
                Entity entity;
                EntityHitResult r;
                BlockHitResult r2;
                if (minecraft.hitResult != null && minecraft.hitResult.getType() != HitResult.Type.MISS && !minecraft.level.getWorldBorder().isWithinBounds(minecraft.hitResult.getLocation().x(), minecraft.hitResult.getLocation().z())) {
                    return null;
                }
                HitResult hitResult = minecraft.hitResult;
                BlockHitResult blockHit = hitResult instanceof BlockHitResult && (r2 = (BlockHitResult)hitResult).getType() != HitResult.Type.MISS ? r2 : null;
                BlockState blockState = blockHit == null ? null : minecraft.level.getBlockState(blockHit.getBlockPos());
                HitResult hitResult2 = minecraft.hitResult;
                if (hitResult2 instanceof EntityHitResult) {
                    r = (EntityHitResult)hitResult2;
                    v0 = r.getEntity();
                } else {
                    v0 = entity = null;
                }
                if (minecraft.player.isSleeping()) {
                    return LegacyComponents.WAKE_UP;
                }
                if (blockState != null && (blockState.getBlock() instanceof ButtonBlock || blockState.getBlock() instanceof LeverBlock || blockState.getBlock() instanceof DoorBlock || blockState.getBlock() instanceof TrapDoorBlock || blockState.getBlock() instanceof SignBlock || blockState.getBlock() instanceof FenceGateBlock || blockState.getBlock() instanceof EnderChestBlock || blockState.getMenuProvider((Level)minecraft.level, blockHit.getBlockPos()) != null || minecraft.level.getBlockEntity(blockHit.getBlockPos()) instanceof MenuProvider)) {
                    return blockState.getBlock() instanceof AbstractChestBlock || blockState.getBlock() instanceof ShulkerBoxBlock || blockState.getBlock() instanceof BarrelBlock || blockState.getBlock() instanceof HopperBlock || blockState.getBlock() instanceof DropperBlock ? LegacyComponents.OPEN : LegacyComponents.USE;
                }
                HitResult hitResult3 = minecraft.hitResult;
                if (!(!(hitResult3 instanceof EntityHitResult) || !((hitResult3 = (r = (EntityHitResult)hitResult3).getEntity()) instanceof AbstractVillager) || (m2 = (AbstractVillager)hitResult3) instanceof Villager && (v = (Villager)m2).getVillagerData().profession().is(VillagerProfession.NONE) || m2.isTrading())) {
                    return LegacyComponents.TRADE;
                }
                if (entity instanceof ItemFrame && !(itemFrame = (InteractionHand[])entity).getItem().isEmpty()) {
                    return LegacyComponents.ROTATE;
                }
                if (blockState != null && blockState.getBlock() instanceof BedBlock) {
                    return LegacyComponents.SLEEP;
                }
                if (blockState != null && blockState.getBlock() instanceof NoteBlock) {
                    return LegacyComponents.CHANGE_PITCH;
                }
                if (blockState != null && blockState.getBlock() instanceof ComposterBlock && (Integer)blockState.getValue((Property)ComposterBlock.LEVEL) == 8) {
                    return LegacyComponents.COLLECT;
                }
                if (blockState != null && blockState.getBlock() instanceof JukeboxBlock && ((Boolean)blockState.getValue((Property)JukeboxBlock.HAS_RECORD)).booleanValue()) {
                    return LegacyComponents.EJECT;
                }
                if (blockState != null && blockState.getBlock() instanceof DaylightDetectorBlock) {
                    return LegacyComponents.INVERT;
                }
                for (InteractionHand hand : InteractionHand.values()) {
                    Mob s;
                    EntityHitResult r3;
                    HitResult hitResult4;
                    BucketItem i;
                    BlockHitResult bucketHitResult;
                    LivingEntity e;
                    Item snowGolem;
                    Mob m3;
                    EntityHitResult r4;
                    TamableAnimal a;
                    IronGolem g;
                    BlockItem b;
                    FlowerPotBlock pot;
                    Block block;
                    BlockItem b2;
                    AbstractCauldronBlock c;
                    Block block2;
                    ItemStack actualItem = minecraft.player.getItemInHand(hand);
                    if (actualItem.isEmpty()) continue;
                    if (blockHit != null && LegacyItemUtil.isDyeableItem((Holder<Item>)actualItem.getItemHolder()) && (block2 = minecraft.level.getBlockEntity(blockHit.getBlockPos())) instanceof WaterCauldronBlockEntity) {
                        WaterCauldronBlockEntity be = (WaterCauldronBlockEntity)block2;
                        if (be.waterColor == null && LegacyItemUtil.isDyedItem(actualItem)) {
                            return LegacyComponents.CLEAR;
                        }
                        if (be.waterColor != null && !LegacyItemUtil.isDyedItem(actualItem)) {
                            return LegacyComponents.DYE;
                        }
                    }
                    if (blockHit != null && actualItem.getItem() instanceof DyeItem && minecraft.level.getBlockEntity(blockHit.getBlockPos()) instanceof WaterCauldronBlockEntity) {
                        return LegacyComponents.MIX;
                    }
                    if (blockState != null && (block2 = blockState.getBlock()) instanceof AbstractCauldronBlock) {
                        c = (AbstractCauldronBlock)block2;
                        if (actualItem.is(Items.WATER_BUCKET) || actualItem.is(Items.LAVA_BUCKET) || (actualItem.is(Items.POTION) || actualItem.is(Items.SPLASH_POTION) || actualItem.is(Items.LINGERING_POTION)) && (blockState.is(Blocks.CAULDRON) || blockState.is(Blocks.WATER_CAULDRON) && !c.isFull(blockState)) && LegacyItemUtil.getPotionContent(actualItem) != null) {
                            return LegacyComponents.FILL;
                        }
                    }
                    if (blockState != null && (block2 = blockState.getBlock()) instanceof AbstractCauldronBlock) {
                        c = (AbstractCauldronBlock)block2;
                        if (actualItem.is(Items.BUCKET) && c.isFull(blockState) || actualItem.is(Items.POTION) && LegacyItemUtil.getPotionContent(actualItem) == null) {
                            return LegacyComponents.COLLECT;
                        }
                    }
                    if (ControlTooltip.canPlace(minecraft, actualItem, hand)) {
                        block2 = actualItem.getItem();
                        return block2 instanceof BlockItem && ControlTooltip.isPlant((b2 = (BlockItem)block2).getBlock()) ? LegacyComponents.PLANT : LegacyComponents.PLACE;
                    }
                    if (ControlTooltip.canHang(minecraft, blockHit, blockState, actualItem)) {
                        return LegacyComponents.HANG;
                    }
                    if (blockState != null && (block = blockState.getBlock()) instanceof FlowerPotBlock && (pot = (FlowerPotBlock)block).getPotted() == Blocks.AIR && (block = actualItem.getItem()) instanceof BlockItem) {
                        b = (BlockItem)block;
                        if (FlowerPotBlockAccessor.getPottedByContent().containsKey(b.getBlock())) {
                            return LegacyComponents.PLANT;
                        }
                    }
                    if (ControlTooltip.canFeed(minecraft, entity, actualItem)) {
                        return LegacyComponents.FEED;
                    }
                    if (ControlTooltip.canDyeEntity(minecraft, actualItem)) {
                        return LegacyComponents.DYE;
                    }
                    if (actualItem.is(Items.IRON_INGOT) && entity instanceof IronGolem && (g = (IronGolem)entity).getHealth() < g.getMaxHealth()) {
                        return LegacyComponents.REPAIR;
                    }
                    if (entity instanceof MinecartFurnace && actualItem.is(ItemTags.COALS)) {
                        return LegacyComponents.USE;
                    }
                    if (entity instanceof TamableAnimal && (a = (TamableAnimal)entity).isTame() && a.isFood(actualItem) && a.getHealth() < a.getMaxHealth()) {
                        return LegacyComponents.HEAL;
                    }
                    if (entity instanceof TamableAnimal && (a = (TamableAnimal)entity).isTame() && a.isOwnedBy((LivingEntity)minecraft.player)) {
                        return a.isInSittingPose() ? LegacyComponents.FOLLOW_ME : LegacyComponents.SIT;
                    }
                    if (ControlTooltip.canTame(minecraft, hand, actualItem)) {
                        return LegacyComponents.TAME;
                    }
                    if (ControlTooltip.canSetLoveMode(entity, actualItem)) {
                        return LegacyComponents.LOVE_MODE;
                    }
                    if (blockHit != null && actualItem.getItem() instanceof BoneMealItem && (b = blockState.getBlock()) instanceof BonemealableBlock && (b2 = (BonemealableBlock)b).isValidBonemealTarget((LevelReader)minecraft.level, blockHit.getBlockPos(), blockState)) {
                        return LegacyComponents.GROW;
                    }
                    if (blockState != null && blockState.getBlock() instanceof ComposterBlock && (Integer)blockState.getValue((Property)ComposterBlock.LEVEL) < 7 && ComposterBlock.COMPOSTABLES.containsKey((Object)actualItem.getItem())) {
                        return LegacyComponents.FILL;
                    }
                    if (blockHit != null && !actualItem.isEmpty() && (b = minecraft.level.getBlockEntity(blockHit.getBlockPos())) instanceof CampfireBlockEntity) {
                        CampfireBlockEntity e2 = (CampfireBlockEntity)b;
                        if (minecraft.level.recipeAccess().propertySet(RecipePropertySet.FURNACE_INPUT).test(actualItem)) {
                            return LegacyComponents.COOK;
                        }
                    }
                    if (blockState != null && actualItem.getItem() instanceof BrushItem && blockState.getBlock() instanceof BrushableBlock) {
                        return LegacyComponents.BRUSH;
                    }
                    if (actualItem.getUseAnimation().equals((Object)ItemUseAnimation.BLOCK)) {
                        return LegacyComponents.BLOCK;
                    }
                    if (actualItem.has(DataComponents.EQUIPPABLE) && (!((Equippable)actualItem.get(DataComponents.EQUIPPABLE)).slot().equals((Object)EquipmentSlot.BODY) || (block = minecraft.hitResult) instanceof EntityHitResult && (block = (r4 = (EntityHitResult)block).getEntity()) instanceof Mob && (m3 = (Mob)block).isEquippableInSlot(actualItem, EquipmentSlot.BODY))) {
                        return LegacyComponents.EQUIP;
                    }
                    if (actualItem.getItem() instanceof EmptyMapItem || actualItem.getItem() instanceof FishingRodItem) {
                        return LegacyComponents.USE;
                    }
                    if (actualItem.getItem() instanceof FireworkRocketItem && (minecraft.player.isFallFlying() || minecraft.hitResult instanceof BlockHitResult && minecraft.hitResult.getType() != HitResult.Type.MISS)) {
                        return LegacyComponents.LAUNCH;
                    }
                    if (actualItem.getItem() instanceof ShearsItem) {
                        Sheep s2;
                        if (entity instanceof Sheep && !(s2 = (Sheep)entity).isBaby() && !s2.isSheared() || entity instanceof SnowGolem && (snowGolem = (SnowGolem)entity).hasPumpkin() || entity instanceof MushroomCow) {
                            return LegacyComponents.SHEAR;
                        }
                        if (blockState != null && blockState.getBlock() instanceof PumpkinBlock) {
                            return LegacyComponents.CARVE;
                        }
                    }
                    if ((snowGolem = actualItem.getItem()) instanceof FoodOnAStickItem) {
                        FoodOnAStickItem i2 = (FoodOnAStickItem)snowGolem;
                        if (minecraft.player.getControlledVehicle() instanceof ItemSteerable && minecraft.player.getControlledVehicle().getType() == i2.canInteractWith) {
                            return LegacyComponents.BOOST;
                        }
                    }
                    if (actualItem.getItem() instanceof LeadItem) {
                        Mob m4;
                        if (entity instanceof Mob && (m4 = (Mob)entity).canBeLeashed()) {
                            return LegacyComponents.LEASH;
                        }
                        if (blockState != null && blockState.is(BlockTags.FENCES)) {
                            return LegacyComponents.ATTACH;
                        }
                    }
                    if (actualItem.getItem() instanceof NameTagItem && FactoryItemUtil.hasCustomName((ItemStack)actualItem) && (block = minecraft.hitResult) instanceof EntityHitResult && (block = (r4 = (EntityHitResult)block).getEntity()) instanceof LivingEntity && !((e = (LivingEntity)block) instanceof Player) && e.isAlive()) {
                        return LegacyComponents.NAME;
                    }
                    if (actualItem.getItem() instanceof EggItem || actualItem.getItem() instanceof SnowballItem || actualItem.getItem() instanceof EnderpearlItem || actualItem.getItem() instanceof EnderEyeItem || actualItem.getItem() instanceof ThrowablePotionItem || actualItem.getItem() instanceof ExperienceBottleItem) {
                        return LegacyComponents.THROW;
                    }
                    if ((actualItem.getItem() instanceof FlintAndSteelItem || actualItem.getItem() instanceof FireChargeItem) && (e = minecraft.hitResult) instanceof BlockHitResult) {
                        r4 = (BlockHitResult)e;
                        if (blockState != null && (BaseFireBlock.canBePlacedAt((Level)minecraft.level, (BlockPos)r4.getBlockPos().relative(r4.getDirection()), (Direction)minecraft.player.getDirection()) || CampfireBlock.canLight((BlockState)blockState) || CandleBlock.canLight((BlockState)blockState) || CandleCakeBlock.canLight((BlockState)blockState))) {
                            return LegacyComponents.IGNITE;
                        }
                    }
                    if (actualItem.getItem() instanceof ProjectileWeaponItem && !minecraft.player.getProjectile(actualItem).isEmpty()) {
                        if (minecraft.player.getUseItem() == actualItem) {
                            return LegacyComponents.RELEASE;
                        }
                        return LegacyComponents.DRAW;
                    }
                    if (actualItem.getItem() instanceof TridentItem) {
                        if (minecraft.player.getUseItem() == actualItem) {
                            return LegacyComponents.THROW;
                        }
                        if (EnchantmentHelper.getTridentSpinAttackStrength((ItemStack)actualItem, (LivingEntity)minecraft.player) <= 0.0f || minecraft.player.isInWaterOrRain()) {
                            return LegacyComponents.CHARGE;
                        }
                    }
                    if (ControlTooltip.isBundle(actualItem) && BundleItem.getFullnessDisplay((ItemStack)actualItem) > 0.0f) {
                        return LegacyComponents.RELEASE;
                    }
                    block = actualItem.getItem();
                    if (block instanceof BucketItem && (bucketHitResult = ControlTooltip.mayInteractItemAt(minecraft, actualItem, (HitResult)Item.getPlayerPOVHitResult((Level)minecraft.level, (Player)minecraft.player, (ClipContext.Fluid)(ItemContainerPlatform.getBucketFluid((BucketItem)(i = (BucketItem)block)) == Fluids.EMPTY ? ClipContext.Fluid.SOURCE_ONLY : ClipContext.Fluid.NONE)))) != null) {
                        BlockState state = minecraft.level.getBlockState(bucketHitResult.getBlockPos());
                        if (ItemContainerPlatform.getBucketFluid((BucketItem)i) != Fluids.EMPTY) {
                            LiquidBlockContainer container;
                            Block block3;
                            BlockState resultState;
                            BlockState blockState2 = resultState = state.getBlock() instanceof LiquidBlockContainer && ItemContainerPlatform.getBucketFluid((BucketItem)i) == Fluids.WATER ? state : minecraft.level.getBlockState(bucketHitResult.getBlockPos().relative(bucketHitResult.getDirection()));
                            if (resultState.canBeReplaced(ItemContainerPlatform.getBucketFluid((BucketItem)i)) || resultState.isAir() || (block3 = resultState.getBlock()) instanceof LiquidBlockContainer && (container = (LiquidBlockContainer)block3).canPlaceLiquid((LivingEntity)minecraft.player, (BlockGetter)minecraft.level, bucketHitResult.getBlockPos(), resultState, ItemContainerPlatform.getBucketFluid((BucketItem)i))) {
                                return LegacyComponents.EMPTY;
                            }
                        } else if (state.getBlock() instanceof BucketPickup) {
                            return LegacyComponents.COLLECT;
                        }
                    }
                    if ((hitResult4 = minecraft.hitResult) instanceof EntityHitResult && (hitResult4 = (r3 = (EntityHitResult)hitResult4).getEntity()) instanceof Mob && (s = (Mob)hitResult4).isEquippableInSlot(actualItem, EquipmentSlot.SADDLE) && !s.isSaddled()) {
                        return LegacyComponents.SADDLE;
                    }
                    if (ControlTooltip.isEdible(actualItem) && minecraft.player.canEat(false) || actualItem.getItem() instanceof PotionItem) {
                        return actualItem.getUseAnimation() == ItemUseAnimation.DRINK ? LegacyComponents.DRINK : LegacyComponents.EAT;
                    }
                    if (ControlTooltip.canTill(minecraft, hand, actualItem)) {
                        return LegacyComponents.TILL;
                    }
                    if (actualItem.getItem() instanceof AxeItem && blockState != null && AxeItem.STRIPPABLES.get(blockState.getBlock()) != null && (!hand.equals((Object)InteractionHand.MAIN_HAND) || !minecraft.player.getOffhandItem().is(Items.SHIELD) || minecraft.player.isSecondaryUseActive())) {
                        return LegacyComponents.PEEL_BARK;
                    }
                    if (actualItem.getItem() instanceof ShovelItem && blockState != null && minecraft.level.getBlockState(blockHit.getBlockPos().above()).isAir() && ShovelItem.FLATTENABLES.get(blockState.getBlock()) != null) {
                        return LegacyComponents.DIG_PATH;
                    }
                    if (!(actualItem.getItem() instanceof SpyglassItem)) continue;
                    return LegacyComponents.ZOOM;
                }
                if (entity instanceof AbstractHorse && (h = (AbstractHorse)entity).isTamed() && minecraft.player.isSecondaryUseActive()) {
                    return LegacyComponents.OPEN;
                }
                if (entity == null || !entity.canAddPassenger((Entity)minecraft.player) || !minecraft.player.canRide(entity)) break block77;
                if (entity instanceof Boat) {
                    return LegacyComponents.SAIL;
                }
                if (entity instanceof AbstractMinecart && (m = (AbstractMinecart)entity).isRideable()) {
                    return LegacyComponents.RIDE;
                }
                if (!(entity instanceof Mob)) break block77;
                Mob s = (Mob)entity;
                if (entity.isVehicle()) break block77;
                if (!(entity instanceof AbstractHorse) && s.isSaddled()) break block78;
                if (!(entity instanceof AbstractHorse)) break block77;
                AbstractHorse h2 = (AbstractHorse)entity;
                if (minecraft.player.isSecondaryUseActive() || (!h2.isTamed() || h2.isFood(minecraft.player.getMainHandItem())) && !minecraft.player.getMainHandItem().isEmpty()) break block77;
            }
            return LegacyComponents.MOUNT;
        }
        return null;
    }

    public static BlockHitResult mayInteractItemAt(Minecraft minecraft, ItemStack usedItem, HitResult result) {
        BlockHitResult r;
        if (result instanceof BlockHitResult && (r = (BlockHitResult)result).getType() != HitResult.Type.MISS && minecraft.level.mayInteract((Entity)minecraft.player, r.getBlockPos()) && minecraft.player.mayUseItemAt(r.getBlockPos().relative(r.getDirection()), r.getDirection(), usedItem)) {
            return r;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canFeed(Minecraft minecraft, Entity entity, ItemStack usedItem) {
        if (!(entity instanceof Animal)) return false;
        Animal a = (Animal)entity;
        if (!a.isFood(usedItem)) return false;
        if (!(a instanceof AbstractHorse)) {
            if (a.isBaby()) return true;
        }
        if (!(a instanceof AbstractHorse)) return false;
        AbstractHorse h = (AbstractHorse)a;
        if (!(a instanceof Llama) && !a.isBaby()) {
            if (usedItem.is(Items.HAY_BLOCK)) return false;
        }
        if (!h.isTamed()) return true;
        if (ControlTooltip.isLoveFood(a, usedItem)) return false;
        if (!(a.getHealth() < a.getMaxHealth())) return false;
        if (minecraft.player.isSecondaryUseActive()) return false;
        return true;
    }

    public static boolean canSetLoveMode(Entity entity, ItemStack usedItem) {
        Animal a;
        return entity instanceof Animal && !(a = (Animal)entity).isBaby() && a.isFood(usedItem) && a.canFallInLove() && !a.isInLove() && (!(a instanceof AbstractHorse) || ControlTooltip.isLoveFood(a, usedItem));
    }

    public static boolean isLoveFood(Animal a, ItemStack stack) {
        return a instanceof Llama && stack.is(Items.HAY_BLOCK) || a instanceof Horse && (stack.is(Items.GOLDEN_CARROT) || stack.is(Items.GOLDEN_APPLE) || stack.is(Items.ENCHANTED_GOLDEN_APPLE));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean canPlace(Minecraft minecraft, ItemStack usedItem, InteractionHand hand) {
        if (minecraft.hitResult == null) return false;
        if (minecraft.hitResult.getType() == HitResult.Type.MISS) return false;
        if (usedItem.isEmpty()) return false;
        Item item = usedItem.getItem();
        if (item instanceof SpawnEggItem) {
            SpawnEggItem e = (SpawnEggItem)item;
            item = minecraft.hitResult;
            if (!(item instanceof EntityHitResult)) return true;
            EntityHitResult r = (EntityHitResult)item;
            if (r.getEntity().getType() == e.getType(usedItem)) return true;
        }
        if (!((item = minecraft.hitResult) instanceof BlockHitResult)) return false;
        BlockHitResult r = (BlockHitResult)item;
        item = usedItem.getItem();
        if (!(item instanceof BlockItem)) return false;
        BlockItem b = (BlockItem)item;
        BlockPlaceContext c = new BlockPlaceContext((Player)minecraft.player, hand, usedItem, r);
        if (!c.canPlace()) return false;
        if (b.getPlacementState(c) == null) return false;
        return true;
    }

    public static boolean canHang(Minecraft minecraft, BlockHitResult hitResult, BlockState blockState, ItemStack usedItem) {
        HangingEntityItemAccessor hanging;
        block5: {
            block4: {
                Item item;
                if (hitResult == null || !((item = usedItem.getItem()) instanceof HangingEntityItemAccessor)) break block4;
                hanging = (HangingEntityItemAccessor)item;
                if (Block.canSupportCenter((LevelReader)minecraft.level, (BlockPos)hitResult.getBlockPos(), (Direction)hitResult.getDirection()) || blockState.isSolid() || DiodeBlock.isDiode((BlockState)blockState)) break block5;
            }
            return false;
        }
        if (hanging.getType() == EntityType.PAINTING) {
            return Direction.Plane.HORIZONTAL.test(hitResult.getDirection());
        }
        return hanging.getType() == EntityType.ITEM_FRAME || hanging.getType() == EntityType.GLOW_ITEM_FRAME;
    }

    public static boolean canTill(Minecraft minecraft, InteractionHand hand, ItemStack usedItem) {
        HitResult hitResult;
        if (!(usedItem.getItem() instanceof HoeItem) || !((hitResult = minecraft.hitResult) instanceof BlockHitResult)) {
            return false;
        }
        BlockHitResult r = (BlockHitResult)hitResult;
        Pair use = (Pair)HoeItem.TILLABLES.get(minecraft.level.getBlockState(r.getBlockPos()).getBlock());
        return use != null && ((Predicate)use.getFirst()).test(new UseOnContext((Player)minecraft.player, hand, r));
    }

    public static boolean canTame(Minecraft minecraft, InteractionHand hand, ItemStack usedItem) {
        AbstractHorse h;
        TamableAnimal t;
        EntityHitResult e;
        HitResult hitResult = minecraft.hitResult;
        return hitResult instanceof EntityHitResult && ((hitResult = (e = (EntityHitResult)hitResult).getEntity()) instanceof TamableAnimal && !(t = (TamableAnimal)hitResult).isTame() && (t instanceof Wolf && usedItem.is(Items.BONE) || !(t instanceof Wolf) && t.isFood(usedItem)) || hand == InteractionHand.MAIN_HAND && (hitResult = e.getEntity()) instanceof AbstractHorse && !(h = (AbstractHorse)hitResult).isTamed() && !minecraft.player.isSecondaryUseActive() && usedItem.isEmpty());
    }

    public static boolean isPlant(Block block) {
        return block instanceof BushBlock || block instanceof SugarCaneBlock || block instanceof GrowingPlantBlock || block instanceof BambooStalkBlock || block instanceof CactusBlock;
    }

    public static boolean isEdible(ItemStack stack) {
        return stack.has(DataComponents.FOOD);
    }

    public static boolean canDyeEntity(Minecraft minecraft, ItemStack usedItem) {
        Cat c;
        Wolf w;
        EntityHitResult result;
        HitResult hitResult;
        return usedItem.getItem() instanceof DyeItem && (hitResult = minecraft.hitResult) instanceof EntityHitResult && ((hitResult = (result = (EntityHitResult)hitResult).getEntity()) instanceof Wolf && (w = (Wolf)hitResult).isTame() || result.getEntity() instanceof Sheep || (hitResult = result.getEntity()) instanceof Cat && (c = (Cat)hitResult).isTame());
    }

    public Icon getIcon();

    @Nullable
    public Component getAction();

    public static interface ComponentIcon
    extends Icon {
        public static ComponentIcon of(final Component component) {
            return new ComponentIcon(){

                @Override
                public Component getComponent() {
                    return component;
                }

                @Override
                public int render(GuiGraphics graphics, int x, int y, boolean allowPressed, int color, boolean simulate) {
                    Font font = Minecraft.getInstance().font;
                    if (!simulate) {
                        graphics.drawString(font, this.getComponent(), x, y, color, false);
                    }
                    return font.width((FormattedText)this.getComponent());
                }
            };
        }

        public Component getComponent();
    }

    public static interface ActionHolder {
        @Nullable
        public Component getAction(Context var1);

        @Nullable
        default public Component getAction(Screen screen) {
            return this.getAction(() -> screen);
        }

        public static interface ScreenContext
        extends Context {
            public Screen screen();
        }

        public static interface Context {
            default public <C extends Context> Component actionOfContext(Class<C> contextClass, Function<C, Component> toAction) {
                if (contextClass.isInstance(this)) {
                    return toAction.apply((Context)contextClass.cast(this));
                }
                return null;
            }
        }

        public record KeyContext(KeyEvent keyEvent, Screen screen) implements ScreenContext
        {
            public int key() {
                return this.keyEvent.key();
            }
        }
    }

    public static class Renderer
    implements Renderable {
        public static final FactoryEvent<BiConsumer<Screen, Renderer>> SCREEN_EVENT = new FactoryEvent(e -> (screen, event) -> e.invokeAll(c -> c.accept(screen, event)));
        public static final FactoryEvent<BiConsumer<Gui, Renderer>> GUI_EVENT = new FactoryEvent(e -> (screen, event) -> e.invokeAll(c -> c.accept(screen, event)));
        static final Renderer INSTANCE = new Renderer();
        public final List<ControlTooltip> tooltips = new ArrayList<ControlTooltip>();
        protected final Map<Component, Icon> renderTooltips = new Object2ReferenceLinkedOpenHashMap();
        private final Minecraft minecraft = Minecraft.getInstance();

        public static Renderer getInstance() {
            return INSTANCE;
        }

        public static Renderer of(Object o) {
            Renderer renderer;
            if (o instanceof Event) {
                Event e = (Event)o;
                renderer = e.getControlTooltips();
            } else {
                renderer = Renderer.getInstance();
            }
            return renderer;
        }

        public Renderer clear() {
            this.tooltips.clear();
            return this;
        }

        public Renderer set(int ordinal, Supplier<Icon> control, Supplier<Component> action) {
            return this.set(ordinal, ControlTooltip.create(control, action));
        }

        public Renderer set(int ordinal, ControlTooltip tooltip) {
            this.tooltips.set(ordinal, tooltip);
            return this;
        }

        public Renderer replace(int ordinal, Function<Icon, Icon> control, Function<Component, Component> action) {
            ControlTooltip old = this.tooltips.get(ordinal);
            return this.set(ordinal, ControlTooltip.create(() -> (Icon)control.apply(old.getIcon()), () -> (Component)action.apply(old.getAction())));
        }

        public Renderer add(KeyMapping mapping) {
            return this.add(LegacyKeyMapping.of(mapping));
        }

        public Renderer add(KeyMapping mapping, Supplier<Component> action) {
            return this.add(ControlTooltip.create(LegacyKeyMapping.of(mapping), action));
        }

        public Renderer add(KeyMapping mapping, BooleanSupplier extraCondition) {
            return this.add(ControlTooltip.create(LegacyKeyMapping.of(mapping), () -> extraCondition.getAsBoolean() ? LegacyKeyMapping.of(mapping).getDisplayName() : null));
        }

        public Renderer add(LegacyKeyMapping mapping) {
            return this.add(mapping, mapping::getDisplayName);
        }

        public Renderer add(LegacyKeyMapping mapping, Supplier<Component> action) {
            return this.add(ControlTooltip.create(mapping, action));
        }

        public Renderer add(LegacyKeyMapping mapping, BooleanSupplier extraCondition) {
            return this.add(ControlTooltip.create(mapping, () -> extraCondition.getAsBoolean() ? mapping.getDisplayName() : null));
        }

        public Renderer addCompound(Supplier<Icon[]> control, Supplier<Component> action) {
            return this.add(ControlTooltip.create(() -> COMPOUND_ICON_FUNCTION.apply((Icon[])control.get()), action));
        }

        public Renderer add(Supplier<Icon> control, Supplier<Component> action) {
            return this.add(ControlTooltip.create(control, action));
        }

        public Renderer add(ControlTooltip tooltip) {
            this.tooltips.add(tooltip);
            return this;
        }

        public boolean allowPressed() {
            return this.minecraft.screen != null;
        }

        public void render(GuiGraphics guiGraphics, int i, int j, float f) {
            if (!((Boolean)LegacyOptions.inGameTooltips.get()).booleanValue() && this.minecraft.screen == null || !((Boolean)LegacyOptions.displayControlTooltips.get()).booleanValue()) {
                return;
            }
            this.renderTooltips.clear();
            for (ControlTooltip tooltip : this.tooltips) {
                Icon icon2;
                Component action2 = tooltip.getAction();
                if (action2 == null || (icon2 = tooltip.getIcon()) == null) continue;
                if (LegacyOptions.getUIMode().isSD()) {
                    action2 = action2.copy().withStyle(action2.getStyle().withFont(LegacyFontUtil.MOJANGLES_11_FONT));
                }
                this.renderTooltips.compute(action2, (k, existingIcon) -> existingIcon == null ? icon2 : (existingIcon.equals(icon2) || (Boolean)LegacyOptions.displayMultipleControlsFromAction.get() == false ? existingIcon : CompoundIcon.of(existingIcon, SPACE_ICON, icon2)));
            }
            guiGraphics.pose().pushMatrix();
            boolean left = ((LegacyOptions.ControlTooltipDisplay)((Object)LegacyOptions.controlTooltipDisplay.get())).isLeft();
            float hudDistance = Math.max(0.0f, ((Double)LegacyOptions.hudDistance.get()).floatValue() - 0.5f) * 2.0f;
            float hudDiff = 1.0f - hudDistance;
            float xDiff = 32.0f - 30.0f * hudDiff;
            guiGraphics.pose().translate(left ? xDiff : (float)guiGraphics.guiWidth() - xDiff, (float)guiGraphics.guiHeight() - ((float)(29 - (15 - ControlType.getActiveType().iconHeight()) / 2) - 16.0f * hudDiff));
            this.renderTooltips.forEach((action, icon) -> {
                if (left) {
                    int controlWidth = icon.render(guiGraphics, 0, 0, this.allowPressed(), ColorUtil.withAlpha((int)0xFFFFFF, (float)ControlTooltip.getAlpha()), false);
                    if (controlWidth > 0) {
                        guiGraphics.pose().translate(LegacyOptions.getUIMode().isSD() ? 0.0f : 2.0f, 0.0f);
                        guiGraphics.drawString(this.minecraft.font, action, controlWidth, 0, ColorUtil.withAlpha((int)((Integer)CommonColor.ACTION_TEXT.get()), (float)ControlTooltip.getAlpha()));
                        guiGraphics.pose().translate((float)(controlWidth + this.minecraft.font.width((FormattedText)action) + 10), 0.0f);
                    }
                } else {
                    int controlWidth = icon.getWidth();
                    if (controlWidth > 0) {
                        guiGraphics.pose().translate((float)(-controlWidth - this.minecraft.font.width((FormattedText)action)), 0.0f);
                        icon.render(guiGraphics, 0, 0, this.allowPressed(), ColorUtil.withAlpha((int)0xFFFFFF, (float)ControlTooltip.getAlpha()), false);
                        guiGraphics.pose().translate(LegacyOptions.getUIMode().isSD() ? 0.0f : 2.0f, 0.0f);
                        guiGraphics.drawString(this.minecraft.font, action, controlWidth, 0, ColorUtil.withAlpha((int)((Integer)CommonColor.ACTION_TEXT.get()), (float)ControlTooltip.getAlpha()));
                        guiGraphics.pose().translate(-12.0f, 0.0f);
                    }
                }
            });
            guiGraphics.pose().popMatrix();
        }

        public void press(MouseButtonEvent event, boolean clicked) {
            if (!MinecraftAccessor.getInstance().hasGameLoaded()) {
                return;
            }
            boolean left = ((LegacyOptions.ControlTooltipDisplay)((Object)LegacyOptions.controlTooltipDisplay.get())).isLeft();
            float hudDistance = Math.max(0.0f, ((Double)LegacyOptions.hudDistance.get()).floatValue() - 0.5f) * 2.0f;
            float hudDiff = 1.0f - hudDistance;
            float xDiff = 32.0f - 30.0f * hudDiff;
            float tooltipX = left ? xDiff : (float)this.minecraft.getWindow().getGuiScaledWidth() - xDiff;
            float tooltipY = (float)this.minecraft.getWindow().getGuiScaledHeight() - ((float)(29 - (15 - ControlType.getActiveType().iconHeight()) / 2) - 16.0f * hudDiff);
            for (Map.Entry<Component, Icon> e : this.renderTooltips.entrySet()) {
                int tooltipWidth = e.getValue().getWidth() + this.minecraft.font.width((FormattedText)e.getKey());
                if (!left) {
                    tooltipX -= (float)tooltipWidth;
                }
                if (LegacyRenderUtil.isMouseOver(event.x(), event.y(), tooltipX, tooltipY - 1.0f, tooltipWidth, 9)) {
                    if (clicked) {
                        e.getValue().clickIfInside(tooltipX, event);
                    } else {
                        e.getValue().release(event);
                    }
                    return;
                }
                tooltipX += left ? (float)(tooltipWidth + 12) : -12.0f;
            }
        }
    }

    public static abstract class LegacyIcon
    implements ComponentIcon {
        boolean lastPressed = false;
        long startPressTime = 0L;

        public abstract Component getComponent(boolean var1);

        public abstract Component getOverlayComponent(boolean var1);

        @Override
        public Component getComponent() {
            return this.getComponent(false);
        }

        public abstract boolean pressed();

        public abstract boolean canLoop();

        public float getPressInterval() {
            return (float)(Util.getMillis() - this.startPressTime) / 280.0f;
        }

        @Override
        public void click(MouseButtonEvent event) {
            this.startPressTime = Util.getMillis();
        }

        public Component getActualIcon(char[] chars, boolean allowPressed, ControlType type) {
            return chars == null ? null : ControlTooltip.getControlIcon(String.valueOf(chars[chars.length > 1 && allowPressed && this.startPressTime != 0L && (this.canLoop() || this.getPressInterval() <= 1.0f) ? 1 + Math.round((this.getPressInterval() / 2.0f <= 1.4f ? this.getPressInterval() / 2.0f % 1.0f : 0.4f) * (float)(chars.length - 2)) : 0]), type).getComponent();
        }

        @Override
        public int render(GuiGraphics graphics, int x, int y, boolean allowPressed, int color, boolean simulate) {
            int cow;
            Component c = this.getComponent(allowPressed);
            Component co = this.getOverlayComponent(allowPressed);
            Font font = Minecraft.getInstance().font;
            int cw = c == null ? 0 : font.width((FormattedText)c);
            int n = cow = co == null ? 0 : font.width((FormattedText)co);
            if (!simulate) {
                if (!this.pressed() && (double)(this.getPressInterval() % 1.0f) < 0.1 && this.getPressInterval() >= 1.0f) {
                    this.startPressTime = 0L;
                }
                if (allowPressed && this.pressed() && !this.lastPressed && this.startPressTime == 0L) {
                    this.startPressTime = Util.getMillis();
                }
                this.lastPressed = this.pressed();
                if (c != null) {
                    graphics.drawString(font, c, x + (co == null || cw > cow ? 0 : (cow - cw) / 2), y, color, false);
                }
                if (co != null) {
                    float rel = this.startPressTime == 0L ? 0.0f : (this.canLoop() ? this.getPressInterval() % 1.0f : Math.min(this.getPressInterval(), 1.0f));
                    float d = 1.0f - Math.max(0.0f, (rel >= 0.5f ? 1.0f - rel : rel) * 2.0f / 5.0f);
                    graphics.pose().pushMatrix();
                    graphics.pose().translate((float)x + (c == null || cow > cw ? ((float)cow - (float)cow * d) / 2.0f : ((float)cw - (float)cow * d) / 2.0f), (float)y + (9.0f - 9.0f * d) / 2.0f);
                    graphics.pose().scale(d, d);
                    graphics.drawString(font, co, 0, 0, ColorUtil.withAlpha((int)color, (float)(ColorUtil.getAlpha((int)color) * (0.8f + (rel >= 0.5f ? 0.2f : 0.0f)))), false);
                    graphics.pose().popMatrix();
                }
            }
            return Math.max(cw, cow);
        }
    }

    public static class CompoundComponentIcon
    implements ComponentIcon,
    CompoundIcon {
        private final ComponentIcon[] componentIcons;
        private final MutableComponent component = Component.empty();
        private boolean isAdditive = false;

        public CompoundComponentIcon(ComponentIcon[] componentIcons) {
            this.componentIcons = componentIcons;
            for (ComponentIcon componentIcon : componentIcons) {
                this.component.append(componentIcon.getComponent());
                if (componentIcon != PLUS_ICON) continue;
                this.isAdditive = true;
            }
        }

        public static ComponentIcon of(ComponentIcon ... componentIcons) {
            return COMPOUND_COMPONENT_ICON_FUNCTION.apply(componentIcons);
        }

        @Override
        public Component getComponent() {
            return this.component;
        }

        @Override
        public Icon[] getIcons() {
            return this.componentIcons;
        }

        @Override
        public boolean isAdditive() {
            return this.isAdditive;
        }
    }

    public static interface Icon {
        public int render(GuiGraphics var1, int var2, int var3, boolean var4, int var5, boolean var6);

        default public void clickIfInside(double tooltipX, MouseButtonEvent event) {
            this.click(event);
        }

        default public void click(MouseButtonEvent event) {
        }

        default public void release(MouseButtonEvent event) {
        }

        default public int render(GuiGraphics graphics, int x, int y, boolean allowPressed, int color) {
            return this.render(graphics, x, y, allowPressed, color, false);
        }

        default public int render(GuiGraphics graphics, int x, int y, boolean allowPressed) {
            return this.render(graphics, x, y, allowPressed, -1);
        }

        default public int getWidth() {
            return this.render(null, 0, 0, false, -1, true);
        }
    }

    public static interface CompoundIcon
    extends Icon {
        public static Icon of(Icon ... icons) {
            return COMPOUND_ICON_FUNCTION.apply(icons);
        }

        public Icon[] getIcons();

        @Override
        default public void clickIfInside(double tooltipX, MouseButtonEvent event) {
            Icon[] icons = this.getIcons();
            for (int i = 0; i < icons.length; ++i) {
                Icon icon = icons[i];
                double diffX = event.x() - tooltipX;
                if (this.isAdditive() || diffX >= 0.0 && diffX < (double)icon.getWidth() || i == icons.length - 1) {
                    icon.clickIfInside(tooltipX, event);
                    if (!this.isAdditive()) break;
                }
                tooltipX += (double)icon.getWidth();
            }
            if (Legacy4JClient.controllerManager.simulateShift) {
                Legacy4JClient.controllerManager.simulateShift = false;
            }
        }

        default public boolean isAdditive() {
            return false;
        }

        @Override
        default public void release(MouseButtonEvent event) {
            for (Icon icon : this.getIcons()) {
                icon.release(event);
            }
        }

        @Override
        default public int render(GuiGraphics graphics, int x, int y, boolean allowPressed, int color, boolean simulate) {
            int totalWidth = 0;
            for (Icon icon : this.getIcons()) {
                totalWidth += icon.render(graphics, x + totalWidth, y, allowPressed, color, simulate);
            }
            return totalWidth;
        }
    }

    public static class GuiManager
    implements ResourceManagerReloadListener {
        public static final List<ControlTooltip> controlTooltips = new ArrayList<ControlTooltip>();

        public static void applyGUIControlTooltips(Renderer renderer, Minecraft minecraft) {
            renderer.add(minecraft.options.keyJump, () -> minecraft.player.isUnderWater() ? LegacyComponents.SWIM_UP : null).add(minecraft.options.keyInventory, () -> {
                AbstractHorse h;
                Entity patt0$temp;
                return !minecraft.gameMode.isServerControlledInventory() || !((patt0$temp = minecraft.player.getVehicle()) instanceof AbstractHorse) || (h = (AbstractHorse)patt0$temp).isTamed();
            }).add(Legacy4JClient.keyCrafting).add(minecraft.options.keyUse, () -> ControlTooltip.getActualUse(minecraft)).add(minecraft.options.keyAttack, () -> ControlTooltip.getMainAction(minecraft));
            renderer.tooltips.addAll(controlTooltips);
            renderer.add(minecraft.options.keyShift, () -> minecraft.player.isPassenger() ? (minecraft.player.getVehicle() instanceof LivingEntity ? LegacyComponents.DISMOUNT : LegacyComponents.EXIT) : (minecraft.player.getInBlockState().is(Blocks.SCAFFOLDING) ? LegacyComponents.HOLD_TO_DESCEND : null)).add(minecraft.options.keyPickItem, () -> ControlTooltip.getPickAction(minecraft));
        }

        public static <T> Predicate<T> staticPredicate(boolean b) {
            return o -> b;
        }

        protected ControlTooltip guiControlTooltipFromJson(JsonObject o) {
            Component component;
            Predicate<Object> predicate;
            Predicate<Block> blockPredicate;
            BiPredicate<Item, DataComponentPatch> itemPredicate;
            LegacyKeyMapping mapping = LegacyKeyMapping.of((KeyMapping)KeyMapping.ALL.get(GsonHelper.getAsString((JsonObject)o, (String)"keyMapping")));
            if (o.has("heldItem")) {
                JsonElement jsonElement = o.get("heldItem");
                if (jsonElement instanceof JsonObject) {
                    JsonObject obj = (JsonObject)jsonElement;
                    v0 = IOUtil.registryMatchesItem(obj);
                } else {
                    v0 = o.get("heldItem").getAsBoolean() ? (i, t) -> i != null && i != Items.AIR : (i, t) -> false;
                }
            } else {
                v0 = itemPredicate = (i, t) -> true;
            }
            if (o.has("hitBlock")) {
                JsonElement jsonElement = o.get("hitBlock");
                if (jsonElement instanceof JsonObject) {
                    JsonObject obj = (JsonObject)jsonElement;
                    v1 = IOUtil.registryMatches(BuiltInRegistries.BLOCK, obj);
                } else {
                    v1 = o.get("hitBlock").getAsBoolean() ? b -> !b.defaultBlockState().isAir() : b -> false;
                }
            } else {
                v1 = blockPredicate = b -> true;
            }
            if (o.has("hitEntity")) {
                JsonElement jsonElement = o.get("hitEntity");
                if (jsonElement instanceof JsonObject) {
                    JsonObject obj = (JsonObject)jsonElement;
                    predicate = IOUtil.registryMatches(BuiltInRegistries.ENTITY_TYPE, obj);
                } else {
                    predicate = GuiManager.staticPredicate(o.get("hitEntity").getAsBoolean());
                }
            } else {
                predicate = e -> true;
            }
            Predicate<EntityType> entityPredicate = predicate;
            Minecraft minecraft = Minecraft.getInstance();
            JsonElement jsonElement = o.get("action");
            if (jsonElement instanceof JsonPrimitive) {
                JsonPrimitive p = (JsonPrimitive)jsonElement;
                component = Component.translatable((String)p.getAsString());
            } else {
                component = mapping.getDisplayName();
            }
            Component c = component;
            return ControlTooltip.create(mapping, () -> {
                EntityHitResult er;
                HitResult patt1$temp;
                BlockHitResult r;
                HitResult patt0$temp;
                return minecraft.player != null && itemPredicate.test(minecraft.player.getMainHandItem().getItem(), minecraft.player.getMainHandItem().getComponentsPatch()) && ((patt0$temp = minecraft.hitResult) instanceof BlockHitResult && blockPredicate.test(minecraft.level.getBlockState((r = (BlockHitResult)patt0$temp).getBlockPos()).getBlock()) || (patt1$temp = minecraft.hitResult) instanceof EntityHitResult && entityPredicate.test((er = (EntityHitResult)patt1$temp).getEntity().getType())) ? c : null;
            });
        }

        public void onResourceManagerReload(ResourceManager manager) {
            controlTooltips.clear();
            manager.listResources("control_tooltips/gui", string -> string.getPath().endsWith(".json")).forEach((location, resource) -> {
                try {
                    BufferedReader bufferedReader = resource.openAsReader();
                    JsonObject obj = GsonHelper.parse((Reader)bufferedReader);
                    JsonElement ioElement = obj.get("tooltips");
                    if (ioElement instanceof JsonArray) {
                        JsonArray array = (JsonArray)ioElement;
                        array.forEach(e -> {
                            if (e instanceof JsonObject) {
                                JsonObject o = (JsonObject)e;
                                controlTooltips.add(this.guiControlTooltipFromJson(o));
                            }
                        });
                    } else if (ioElement instanceof JsonObject) {
                        JsonObject o = (JsonObject)ioElement;
                        controlTooltips.add(this.guiControlTooltipFromJson(o));
                    }
                    bufferedReader.close();
                }
                catch (IOException exception) {
                    Legacy4J.LOGGER.warn(exception.getMessage());
                }
            });
        }

        public String getName() {
            return "legacy:control_tooltip_gui";
        }
    }

    public static class KeyIcon
    extends CharsIcon {
        public static final Codec<KeyIcon> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.STRING.xmap(InputConstants::getKey, InputConstants.Key::getName).fieldOf("key").forGetter(KeyIcon::key), (App)CharsIcon.CHARS_CODEC.optionalFieldOf("icon").forGetter(CharsIcon::iconChars), (App)CharsIcon.CHARS_CODEC.optionalFieldOf("iconOverlay").forGetter(CharsIcon::iconOverlayChars), (App)Codec.STRING.optionalFieldOf("tipIcon").forGetter(CharsIcon::tipIcon)).apply((Applicative)i, KeyIcon::new));
        public static final Codec<List<KeyIcon>> LIST_CODEC = IOUtil.createListIdMapCodec(CODEC, "key");
        private final InputConstants.Key key;

        public KeyIcon(InputConstants.Key key, Optional<char[]> iconChars, Optional<char[]> iconOverlayChars, Optional<String> tipIcon) {
            super(iconChars, iconOverlayChars, tipIcon);
            this.key = key;
        }

        public KeyIcon(InputConstants.Key key) {
            this(key, Optional.empty(), Optional.empty(), Optional.empty());
        }

        @Override
        public ControlType getControlType() {
            return ControlType.getKbmActiveType();
        }

        @Override
        public String name() {
            return this.key.getName();
        }

        @Override
        public void click(MouseButtonEvent event) {
            super.click(event);
            if (this.key.getValue() == 340 || this.key.getValue() == 344) {
                Legacy4JClient.controllerManager.simulateShift = true;
            }
            if (this.key.getType() == InputConstants.Type.KEYSYM) {
                ((KeyboardHandlerAccessor)Minecraft.getInstance().keyboardHandler).invokeKeyPress(Minecraft.getInstance().getWindow().handle(), 1, new KeyEvent(this.key.getValue(), 0, 0));
            }
        }

        @Override
        public void release(MouseButtonEvent event) {
            if (this.key.getType() == InputConstants.Type.KEYSYM) {
                ((KeyboardHandlerAccessor)Minecraft.getInstance().keyboardHandler).invokeKeyPress(Minecraft.getInstance().getWindow().handle(), 0, new KeyEvent(this.key.getValue(), 0, 0));
            }
        }

        @Override
        public boolean pressed() {
            Window window = Minecraft.getInstance().getWindow();
            return this.key.getType() == InputConstants.Type.KEYSYM ? InputConstants.isKeyDown((Window)window, (int)this.key.getValue()) : GLFW.glfwGetMouseButton((long)window.handle(), (int)this.key.getValue()) == 1;
        }

        @Override
        public boolean canLoop() {
            return this.key.getType() != InputConstants.Type.MOUSE;
        }

        public InputConstants.Key key() {
            return this.key;
        }
    }

    public static class ControllerIcon
    extends CharsIcon {
        public static final Codec<ControllerIcon> CODEC = RecordCodecBuilder.create(i -> i.group((App)ControllerBinding.CODEC.fieldOf("binding").forGetter(ControllerIcon::binding), (App)CharsIcon.CHARS_CODEC.optionalFieldOf("icon").forGetter(CharsIcon::iconChars), (App)CharsIcon.CHARS_CODEC.optionalFieldOf("iconOverlay").forGetter(CharsIcon::iconOverlayChars), (App)Codec.STRING.optionalFieldOf("tipIcon").forGetter(CharsIcon::tipIcon)).apply((Applicative)i, ControllerIcon::new));
        public static final Codec<List<ControllerIcon>> LIST_CODEC = IOUtil.createListIdMapCodec(CODEC, "binding");
        private final ControllerBinding<?> binding;

        public ControllerIcon(ControllerBinding<?> binding, Optional<char[]> iconChars, Optional<char[]> iconOverlayChars, Optional<String> tipIcon) {
            super(iconChars, iconOverlayChars, tipIcon);
            this.binding = binding;
        }

        @Override
        public boolean pressed() {
            return this.state().pressed;
        }

        @Override
        public boolean canLoop() {
            return !this.state().isBlocked();
        }

        @Override
        public void click(MouseButtonEvent event) {
            super.click(event);
            this.state().nextUpdatePress();
        }

        @Override
        public ControlType getControlType() {
            return ControlType.getActiveControllerType();
        }

        public ControllerBinding<?> binding() {
            return this.binding;
        }

        public BindingState state() {
            return this.binding().getMapped().state();
        }

        @Override
        public String name() {
            return this.binding().getKey();
        }
    }

    public static abstract class CharsIcon
    extends LegacyIcon {
        public static final Codec<char[]> CHARS_CODEC = Codec.STRING.xmap(String::toCharArray, String::new);
        private final Optional<char[]> iconChars;
        private final Optional<char[]> iconOverlayChars;
        private final Optional<String> tipIcon;

        protected CharsIcon(Optional<char[]> iconChars, Optional<char[]> iconOverlayChars, Optional<String> tipIcon) {
            this.iconChars = iconChars;
            this.iconOverlayChars = iconOverlayChars;
            this.tipIcon = tipIcon;
        }

        @Override
        public Component getComponent(boolean allowPressed) {
            return this.iconChars.isPresent() ? this.getActualIcon(this.iconChars.get(), allowPressed, this.getControlType()) : null;
        }

        @Override
        public Component getOverlayComponent(boolean allowPressed) {
            return this.iconOverlayChars.isPresent() ? this.getActualIcon(this.iconOverlayChars.get(), allowPressed, this.getControlType()) : null;
        }

        @Override
        public Component getComponent() {
            return this.tipIcon.isEmpty() ? (super.getComponent() == null ? this.getOverlayComponent(false) : super.getComponent()) : ControlTooltip.getControlIcon(this.tipIcon.get(), ControlType.getActiveControllerType()).getComponent();
        }

        public abstract ControlType getControlType();

        public Optional<char[]> iconChars() {
            return this.iconChars;
        }

        public Optional<char[]> iconOverlayChars() {
            return this.iconOverlayChars;
        }

        public Optional<String> tipIcon() {
            return this.tipIcon;
        }

        public abstract String name();
    }

    public static interface Event {
        public static final Event EMPTY = new Event(){};

        public static Event of(Object o) {
            Event e;
            return o instanceof Event ? (e = (Event)o) : EMPTY;
        }

        default public Renderer getControlTooltips() {
            return Renderer.getInstance();
        }

        default public void setupControlTooltips() {
            this.addControlTooltips(this.getControlTooltips().clear());
        }

        default public void addControlTooltips(Renderer renderer) {
            Event event;
            if (this instanceof Gui) {
                GuiManager.applyGUIControlTooltips(renderer, Minecraft.getInstance());
            }
            if ((event = this) instanceof Screen) {
                Screen s = (Screen)event;
                Event event2 = this;
                if (event2 instanceof LegacyMenuAccess) {
                    LegacyMenuAccess a = (LegacyMenuAccess)((Object)event2);
                    ControlTooltip.setupDefaultContainerScreen(renderer, a);
                } else {
                    ControlTooltip.setupDefaultScreen(renderer, s);
                }
            }
        }
    }
}

