/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.stream.StreamSupport;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.advancements.AdvancementProgress;
import net.minecraft.advancements.AdvancementTree;
import net.minecraft.advancements.DisplayInfo;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.Tooltip;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.advancements.AdvancementsScreen;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.multiplayer.ClientAdvancements;
import net.minecraft.core.ClientAsset;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.factoryapi.util.PagedList;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.MultilineTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.TabList;
import wily.legacy.mixin.base.client.AbstractWidgetAccessor;
import wily.legacy.network.ClientAdvancementsPayload;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class LegacyAdvancementsScreen
extends PanelVListScreen
implements TabList.Access {
    public static final Component TITLE = Component.translatable((String)"gui.advancements");
    public static final List<ResourceLocation> vanillaOrder = List.of(FactoryAPI.createVanillaLocation((String)"story/root"), FactoryAPI.createVanillaLocation((String)"adventure/root"), FactoryAPI.createVanillaLocation((String)"husbandry/root"), FactoryAPI.createVanillaLocation((String)"nether/root"), FactoryAPI.createVanillaLocation((String)"end/root"));
    protected final Stocker.Sizeable page = new Stocker.Sizeable(Integer.valueOf(0));
    protected final TabList tabList = new TabList(this.accessor, (List<LegacyTabButton>)new PagedList(this.page, this::getMaxTabCount));
    protected final List<DisplayInfo> displayInfos = new ArrayList<DisplayInfo>();
    protected final Panel panelRecess;
    protected boolean showDescription = false;
    protected boolean oldLegacyTooltipsValue;

    public LegacyAdvancementsScreen(Screen parent) {
        super(parent, (PanelVListScreen s) -> Panel.createPanel(s, p -> p.centeredLeftPos(s), p -> p.centeredTopPos(s) + (((LegacyAdvancementsScreen)s).displayInfos.isEmpty() ? 0 : ((LegacyAdvancementsScreen)s).getTabYOffset()), 450, 252), TITLE);
        this.renderableVLists.clear();
        StreamSupport.stream(LegacyAdvancementsScreen.getActualAdvancements().roots().spliterator(), false).sorted(Comparator.comparingInt(n -> vanillaOrder.contains(n.holder().id()) ? vanillaOrder.indexOf(n.holder().id()) : Integer.MAX_VALUE)).forEach(a -> {
            DisplayInfo displayInfo = a.advancement().display().orElse(null);
            if (displayInfo == null) {
                return;
            }
            this.tabList.add(LegacyTabButton.Type.MIDDLE, LegacyTabButton.iconOf(displayInfo.getIcon()), displayInfo.getTitle(), b -> this.repositionElements());
            RenderableVList renderableVList = new RenderableVList(this).layoutSpacing(l -> 4).forceWidth(false).cyclic(false);
            this.renderableVLists.add(renderableVList);
            this.displayInfos.add(displayInfo);
            LegacyAdvancementsScreen.getActualAdvancements().nodes().stream().filter(n1 -> !n1.equals(a) && n1.root().equals(a)).sorted(Comparator.comparingInt(LegacyAdvancementsScreen::getRootDistance)).forEach(node -> this.addAdvancementButton(renderableVList, (AdvancementNode)node));
        });
        this.panelRecess = Panel.createPanel(this, p -> p.appearance(LegacySprites.PANEL_RECESS, this.panel.getWidth() - 24, this.panel.getHeight() - 66), p -> p.pos(this.panel.getX() + 12, this.panel.getY() + 50));
    }

    public static int getRootDistance(AdvancementNode advancement) {
        AdvancementNode advancement3;
        AdvancementNode advancement2 = advancement;
        int i = 0;
        while ((advancement3 = advancement2.parent()) != null) {
            advancement2 = advancement3;
            ++i;
        }
        return i;
    }

    public static Screen getActualAdvancementsScreenInstance(Screen parent) {
        return (Boolean)LegacyOptions.legacyAdvancements.get() != false ? new LegacyAdvancementsScreen(parent) : new AdvancementsScreen(LegacyAdvancementsScreen.getAdvancements(), parent);
    }

    public static AdvancementTree getActualAdvancements() {
        return Legacy4JClient.hasModOnServer() ? ClientAdvancementsPayload.advancements : LegacyAdvancementsScreen.getAdvancements().getTree();
    }

    public static ClientAdvancements getAdvancements() {
        return Minecraft.getInstance().getConnection().getAdvancements();
    }

    protected void addAdvancementButton(RenderableVList renderableVList, AdvancementNode advancementNode) {
        advancementNode.advancement().display().ifPresent(info -> renderableVList.addRenderable((Renderable)new AdvancementButton(0, 0, 38, 38, advancementNode, (DisplayInfo)info)));
    }

    @Override
    public TabList getTabList() {
        return this.tabList;
    }

    @Override
    public int getTabYOffset() {
        return 18;
    }

    @Override
    public RenderableVList getRenderableVList() {
        return this.getRenderableVLists().get((Integer)this.page.get() * this.getMaxTabCount() + this.tabList.getIndex());
    }

    protected int getMaxTabCount() {
        return this.accessor.getInteger("maxTabCount", 10);
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (state.is(ControllerBinding.RIGHT_STICK) && state instanceof BindingState.Axis) {
            BindingState.Axis s = (BindingState.Axis)state;
            if (s.pressed && s.canClick()) {
                this.tabList.controlPage(this.page, s.x < 0.0f && -s.x > Math.abs(s.y), s.x > 0.0f && s.x > Math.abs(s.y));
            }
        }
    }

    @Override
    protected void panelInit() {
        this.addRenderableWidget(this.tabList);
        super.panelInit();
        this.panelRecess.init("panelRecess");
        this.addRenderableOnly(this.tabList::renderSelected);
        this.addRenderableOnly((guiGraphics, i, j, f) -> {
            ResourceLocation background;
            LegacyFontUtil.applySDFont(b -> guiGraphics.drawString(this.font, this.showDescription && !this.tabList.tabButtons.isEmpty() ? this.tabList.tabButtons.get(this.tabList.getIndex()).getMessage() : this.getTitle(), this.panel.x + (this.panel.width - this.font.width((FormattedText)(this.showDescription && !this.tabList.tabButtons.isEmpty() ? this.tabList.tabButtons.get(this.tabList.getIndex()).getMessage() : this.getTitle()))) / 2, this.panel.y + 10, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
            if (!this.displayInfos.isEmpty() && (background = ((ClientAsset.ResourceTexture)this.displayInfos.get(this.tabList.getIndex()).getBackground().orElse(null)).texturePath()) != null) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blit(background, this.panel.x + 14, this.panel.y + 24, 0.0f, 0.0f, this.panelRecess.width - 4, 23, 16, 16);
            }
            LegacyRenderUtil.renderPanelTranslucentRecess(guiGraphics, this.panel.x + 12, this.panel.y + 22, this.panelRecess.width, 27);
            GuiEventListener patt0$temp = this.getFocused();
            if (patt0$temp instanceof AdvancementButton) {
                AdvancementButton a = (AdvancementButton)patt0$temp;
                guiGraphics.drawString(this.font, a.info.getTitle(), this.panel.x + (this.panel.width - this.font.width((FormattedText)a.info.getTitle())) / 2, this.panel.y + 32, -1);
            }
        });
        this.addRenderableOnly((Renderable)this.panelRecess);
        this.tabList.init(this.panel.x, this.panel.y - 37, this.panel.width, 43, (b, i) -> {
            int index = this.tabList.tabButtons.indexOf(b);
            b.type = LegacyTabButton.Type.bySize(index, this.getMaxTabCount());
            b.setWidth(this.accessor.getInteger("tabList.buttonWidth", 45));
            b.offset = t1 -> new Vec2(0.0f, t1.selected ? 0.0f : 4.4f);
        });
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 17, this.panel.y + 55, this.panelRecess.width - 10, this.panelRecess.height - 10);
    }

    @Override
    public boolean keyPressed(KeyEvent keyEvent) {
        if (keyEvent.key() == 88) {
            this.showDescription = !this.showDescription;
            return true;
        }
        if (this.tabList.controlTab(keyEvent.key())) {
            return true;
        }
        if (keyEvent.hasShiftDown()) {
            this.tabList.controlPage(this.page, keyEvent.isLeft(), keyEvent.isRight());
        }
        return super.keyPressed(keyEvent);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.tooltips.remove(0);
        renderer.add(() -> ControlTooltip.EXTRA.get(), () -> LegacyComponents.SHOW_DESCRIPTION).add(() -> ControlTooltip.CONTROL_PAGE.get(), () -> this.page.max > 0 ? LegacyComponents.PAGE : null);
    }

    public void tick() {
        super.tick();
        if (!this.getRenderableVLists().isEmpty()) {
            this.getRenderableVList().renderables.forEach(r -> {
                if (r instanceof AdvancementButton) {
                    AdvancementButton b = (AdvancementButton)((Object)r);
                    b.update();
                }
            });
        }
    }

    public void added() {
        super.added();
        this.oldLegacyTooltipsValue = (Boolean)LegacyOptions.legacyItemTooltips.get();
        LegacyOptions.legacyItemTooltipScaling.set((Object)false);
    }

    public void removed() {
        super.removed();
        LegacyOptions.legacyItemTooltipScaling.set((Object)this.oldLegacyTooltipsValue);
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        LegacyRenderUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        if (!this.showDescription) {
            guiGraphics.deferredTooltip = null;
        }
    }

    public static class AdvancementButton
    extends AbstractWidget {
        public final ResourceLocation id;
        public final Advancement advancement;
        public final DisplayInfo info;
        protected boolean lastUnlocked;
        protected boolean unlocked;

        public AdvancementButton(int x, int y, int width, int height, AdvancementNode advancement, DisplayInfo info) {
            super(x, y, width, height, info.getTitle());
            this.info = info;
            this.id = advancement.holder().id();
            this.advancement = advancement.advancement();
            this.update();
        }

        public void update() {
            AdvancementProgress p = null;
            this.lastUnlocked = this.unlocked;
            AdvancementHolder a = LegacyAdvancementsScreen.getAdvancements().get(this.id);
            boolean bl = this.unlocked = a != null && (p = (AdvancementProgress)LegacyAdvancementsScreen.getAdvancements().progress.getOrDefault(a, null)) != null && p.isDone();
            if (this.lastUnlocked == this.unlocked && ((AbstractWidgetAccessor)((Object)this)).getTooltip().get() != null) {
                return;
            }
            Component progressText = p == null || p.getProgressText() == null ? null : p.getProgressText();
            this.setTooltip((Tooltip)(progressText == null ? Tooltip.create((Component)this.info.getDescription()) : new MultilineTooltip(List.of(this.info.getDescription().getVisualOrderText(), progressText.getVisualOrderText()))));
        }

        public boolean isUnlocked() {
            return this.unlocked;
        }

        protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
            if (this.isFocused()) {
                guiGraphics.pose().pushMatrix();
                guiGraphics.pose().translate(-1.5f, -1.4f);
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL_HIGHLIGHT, this.getX(), this.getY(), 41, 41);
                guiGraphics.pose().popMatrix();
            }
            FactoryScreenUtil.enableBlend();
            if (!this.isUnlocked()) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, 0.5f);
            }
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PANEL, this.getX(), this.getY(), this.getWidth(), this.getHeight());
            FactoryScreenUtil.disableDepthTest();
            if (!this.isUnlocked()) {
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.PADLOCK, this.getX() + (this.getWidth() - 32) / 2, this.getY() + (this.getHeight() - 32) / 2, 32, 32);
            }
            FactoryScreenUtil.enableDepthTest();
            FactoryScreenUtil.disableBlend();
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, 1.0f);
            if (!this.isUnlocked()) {
                return;
            }
            guiGraphics.pose().pushMatrix();
            guiGraphics.pose().translate((float)this.getX() + (float)(this.getWidth() - 32) / 2.0f, (float)this.getY() + (float)(this.getHeight() - 32) / 2.0f);
            guiGraphics.pose().scale(2.0f, 2.0f);
            guiGraphics.renderFakeItem(this.info.getIcon(), 0, 0);
            guiGraphics.pose().popMatrix();
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }
    }
}

