/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.blaze3d.platform.InputConstants;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.AdvancedTextWidget;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.PanelVListScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyRenderUtil;

public class LegacyKeyMappingScreen
extends PanelVListScreen {
    protected AdvancedTextWidget mappingTooltipLines;
    protected LegacyKeyMapping selectedMapping;
    protected ArbitrarySupplier<Component> mappingTooltip;

    public LegacyKeyMappingScreen(Screen parent) {
        this(parent, (Component)Component.translatable((String)"controls.keybinds.title"));
    }

    public LegacyKeyMappingScreen(Screen parent, Component title) {
        this(parent, (LegacyKeyMappingScreen s) -> Panel.centered(s, LegacySprites.PANEL, 255, 293), title);
    }

    public LegacyKeyMappingScreen(Screen parent, Panel.Constructor<LegacyKeyMappingScreen> panelFunction, Component title) {
        super(parent, panelFunction.cast(), title);
        this.mappingTooltipLines = new AdvancedTextWidget(this.accessor).withShadow(false);
        this.selectedMapping = null;
        this.mappingTooltip = ArbitrarySupplier.empty();
        this.renderableVList.layoutSpacing(l -> 1);
        this.addButtons();
    }

    public static void setAndUpdateKey(KeyMapping key, InputConstants.Key input) {
        key.setKey(input);
        Minecraft.getInstance().options.save();
        KeyMapping.resetMapping();
    }

    public void addButtons() {
        Object[] keyMappings = (KeyMapping[])ArrayUtils.clone((Object[])Minecraft.getInstance().options.keyMappings);
        Arrays.sort(keyMappings);
        KeyMapping.Category lastCategory = null;
        this.renderableVList.addRenderable((Renderable)Button.builder((Component)Component.translatable((String)"legacy.menu.reset_defaults"), arg_0 -> this.lambda$addButtons$3((KeyMapping[])keyMappings, arg_0)).size(240, 20).build());
        this.renderableVList.addOptions(LegacyOptions.unbindConflictingKeys, LegacyOptions.of(Minecraft.getInstance().options.toggleCrouch()), LegacyOptions.of(Minecraft.getInstance().options.toggleSprint()), LegacyOptions.of(Minecraft.getInstance().options.toggleUse()), LegacyOptions.of(Minecraft.getInstance().options.toggleAttack()));
        for (Object keyMapping : keyMappings) {
            KeyMapping.Category category = keyMapping.getCategory();
            if (!Objects.equals(lastCategory, category)) {
                this.renderableVList.addCategory(category.label());
            }
            lastCategory = keyMapping.getCategory();
            this.renderableVList.addRenderable((Renderable)new MappingButton(0, 0, 240, 20, LegacyKeyMapping.of((KeyMapping)keyMapping), (KeyMapping)keyMapping){
                final /* synthetic */ KeyMapping val$keyMapping;
                {
                    this.val$keyMapping = keyMapping;
                    super(i, j, k, l, mapping);
                }

                @Override
                public ControlTooltip.ComponentIcon getIcon() {
                    return ControlTooltip.getKeyIcon(this.mapping.getKey().getValue());
                }

                @Override
                public boolean isNone() {
                    return this.mapping.getKey() == InputConstants.UNKNOWN;
                }

                public void onPress(InputWithModifiers input) {
                    if (input.hasShiftDown() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed) {
                        LegacyKeyMappingScreen.setAndUpdateKey(this.val$keyMapping, this.val$keyMapping.getDefaultKey());
                        LegacyKeyMappingScreen.this.setAndUpdateMappingTooltip((ArbitrarySupplier<Component>)ArbitrarySupplier.empty());
                    } else {
                        LegacyKeyMappingScreen.this.setSelectedMapping(this.mapping);
                        LegacyKeyMappingScreen.this.setAndUpdateMappingTooltip((ArbitrarySupplier<Component>)((ArbitrarySupplier)LegacyKeyMappingScreen.this::getCancelTooltip));
                    }
                }
            });
        }
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean bl) {
        if (this.selectedMapping != null && this.allowsKey()) {
            LegacyKeyMappingScreen.setAndUpdateKey(this.selectedMapping.self(), InputConstants.Type.MOUSE.getOrCreate(event.button()));
            this.setAndUpdateMappingTooltip((ArbitrarySupplier<Component>)ArbitrarySupplier.empty());
            this.resolveConflictingMappings();
            this.setSelectedMapping(null);
            return true;
        }
        return super.mouseClicked(event, bl);
    }

    @Override
    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.selectedMapping != null && this.allowsKey()) {
            LegacyKeyMappingScreen.setAndUpdateKey(this.selectedMapping.self(), keyEvent.isEscape() ? InputConstants.UNKNOWN : InputConstants.getKey((KeyEvent)keyEvent));
            this.setAndUpdateMappingTooltip((ArbitrarySupplier<Component>)ArbitrarySupplier.empty());
            this.resolveConflictingMappings();
            this.setSelectedMapping(null);
            return true;
        }
        return super.keyPressed(keyEvent);
    }

    public boolean allowsKey() {
        return true;
    }

    public void setFocused(@Nullable GuiEventListener guiEventListener) {
        super.setFocused(guiEventListener);
        this.setAndUpdateMappingTooltip((ArbitrarySupplier<Component>)ArbitrarySupplier.empty());
    }

    @Override
    public void renderDefaultBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        LegacyRenderUtil.renderDefaultBackground(this.accessor, guiGraphics, false);
    }

    public Component getCancelTooltip() {
        return Component.translatable((String)"legacy.options.keyMappingTooltip", (Object[])new Object[]{((ControlTooltip.ComponentIcon)ControlTooltip.CANCEL_BINDING.get()).getComponent()});
    }

    public Component getConflictingTooltip() {
        return LegacyComponents.CONFLICTING_KEYS;
    }

    protected void setSelectedMapping(LegacyKeyMapping keyMapping) {
        this.selectedMapping = keyMapping;
    }

    protected boolean areConflicting(LegacyKeyMapping keyMapping, LegacyKeyMapping comparison) {
        return keyMapping.getKey() == comparison.getKey();
    }

    public boolean unbindConflictingBindings() {
        return (Boolean)LegacyOptions.unbindConflictingKeys.get();
    }

    protected void setNone(LegacyKeyMapping keyMapping) {
        LegacyKeyMappingScreen.setAndUpdateKey(keyMapping.self(), InputConstants.UNKNOWN);
    }

    protected void resolveConflictingMappings() {
        for (Renderable renderable : this.getRenderableVList().renderables) {
            if (!(renderable instanceof MappingButton)) continue;
            MappingButton b = (MappingButton)renderable;
            if (this.selectedMapping == b.mapping || b.isNone() || !this.areConflicting(this.selectedMapping, b.mapping)) continue;
            this.getRenderableVList().focusRenderable((Renderable)b);
            if (this.unbindConflictingBindings()) {
                this.setNone(b.mapping);
            }
            this.setAndUpdateMappingTooltip((ArbitrarySupplier<Component>)((ArbitrarySupplier)this::getConflictingTooltip));
            break;
        }
    }

    protected void setAndUpdateMappingTooltip(ArbitrarySupplier<Component> tooltip) {
        this.mappingTooltip = tooltip;
        this.updateMappingTooltip();
    }

    protected void updateMappingTooltip() {
        this.mappingTooltipLines.withLines(Collections.emptyList());
        this.mappingTooltip.ifPresent(c -> this.mappingTooltipLines.withLines(c, 120));
    }

    @Override
    protected void init() {
        this.updateMappingTooltip();
        this.addRenderableOnly((guiGraphics, i, j, f) -> {
            GuiEventListener patt0$temp = this.getFocused();
            if (patt0$temp instanceof MappingButton) {
                MappingButton b = (MappingButton)patt0$temp;
                if (!this.mappingTooltipLines.getLines().isEmpty()) {
                    int tooltipHeight = this.mappingTooltipLines.getHeight() + 18;
                    int tooltipX = this.panel.getX() + this.panel.getWidth() - 2;
                    int tooltipY = Math.max(this.panel.getY() + 2, Math.min(b.getY() + (b.getHeight() - tooltipHeight) / 2, this.panel.getY() + this.panel.getHeight() - tooltipHeight - 2));
                    LegacyRenderUtil.renderPointerPanel(guiGraphics, tooltipX, tooltipY, 129, tooltipHeight);
                    this.mappingTooltipLines.setPosition(tooltipX + 4, tooltipY + 9);
                    this.mappingTooltipLines.render(guiGraphics, i, j, f);
                }
            }
        });
        super.init();
        this.addRenderableOnly((guiGraphics, i, j, f) -> guiGraphics.drawString(this.font, FactoryAPIPlatform.getModInfo((String)"minecraft").getVersion() + " " + Legacy4J.VERSION.get(), this.panel.getX() + this.panel.getWidth() + 81, this.panel.getY() + this.panel.getHeight() - 7, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
    }

    @Override
    public void renderableVListInit() {
        this.getRenderableVList().init(this.panel.x + 7, this.panel.y + 6, this.panel.width - 14, this.panel.height - 20);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.replace(0, i -> i, c -> this.selectedMapping == null ? c : null);
        renderer.replace(1, i -> i, c -> this.selectedMapping == null ? c : null);
        renderer.replace(2, i -> i, c -> this.selectedMapping == null ? c : null);
        renderer.replace(3, i -> i, c -> this.selectedMapping == null ? c : null);
        renderer.add(() -> ControlTooltip.CANCEL_BINDING.get(), () -> this.selectedMapping == null ? null : LegacyComponents.CANCEL);
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if (this.selectedMapping != null) {
            state.block();
            if (state.is(ControllerBinding.BACK) && state.pressed) {
                LegacyKeyMappingScreen.setAndUpdateKey(this.selectedMapping.self(), InputConstants.UNKNOWN);
                this.setAndUpdateMappingTooltip((ArbitrarySupplier<Component>)ArbitrarySupplier.empty());
                this.setSelectedMapping(null);
            }
        }
    }

    private /* synthetic */ void lambda$addButtons$3(KeyMapping[] keyMappings, Button button) {
        this.minecraft.setScreen((Screen)new ConfirmationScreen((Screen)this, (Component)Component.translatable((String)"legacy.menu.reset_keyBinds"), (Component)Component.translatable((String)"legacy.menu.reset_keyBinds_message"), b -> {
            for (KeyMapping keyMapping : keyMappings) {
                keyMapping.setKey(keyMapping.getDefaultKey());
            }
            KeyMapping.resetMapping();
            Minecraft.getInstance().options.save();
            this.minecraft.setScreen((Screen)this);
        }));
    }

    public abstract class MappingButton
    extends AbstractButton {
        public final LegacyKeyMapping mapping;

        public MappingButton(int i, int j, int k, int l, LegacyKeyMapping mapping) {
            super(i, j, k, l, mapping.getDisplayName());
            this.mapping = mapping;
        }

        public abstract ControlTooltip.ComponentIcon getIcon();

        public abstract boolean isNone();

        protected void renderWidget(GuiGraphics guiGraphics, int i, int j, float f) {
            Component c;
            if (!this.isFocused() && this.isPressed()) {
                LegacyKeyMappingScreen.this.setSelectedMapping(null);
            }
            super.renderWidget(guiGraphics, i, j, f);
            Object object = this.isPressed() ? LegacyComponents.SELECTION : (c = this.isNone() ? LegacyComponents.NONE : null);
            if (c != null) {
                Font font = LegacyKeyMappingScreen.this.font;
                int n = this.getX() + this.width - 20 - Minecraft.getInstance().font.width((FormattedText)c) / 2;
                int n2 = this.getY();
                Objects.requireNonNull(LegacyKeyMappingScreen.this.font);
                guiGraphics.drawString(font, c, n, n2 + (this.height - 9) / 2 + 1, LegacyRenderUtil.getDefaultTextColor(!this.isHoveredOrFocused()));
                return;
            }
            ControlTooltip.ComponentIcon icon = this.getIcon();
            FactoryScreenUtil.enableBlend();
            int n = this.getX() + this.width - 20 - icon.getWidth() / 2;
            int n3 = this.getY();
            Objects.requireNonNull(LegacyKeyMappingScreen.this.font);
            icon.render(guiGraphics, n, n3 + (this.height - 9) / 2 + 1, false);
            FactoryScreenUtil.disableBlend();
        }

        private boolean isPressed() {
            return LegacyKeyMappingScreen.this.selectedMapping != null && this.mapping == LegacyKeyMappingScreen.this.selectedMapping;
        }

        protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
            LegacyRenderUtil.renderScrollingString(guiGraphics, font, this.getMessage(), this.getX() + 8, this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), j, true);
        }

        protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
            this.defaultButtonNarrationText(narrationElementOutput);
        }
    }
}

