/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.gui.screens.recipebook.SearchRecipeBookCategory;
import net.minecraft.client.input.InputWithModifiers;
import net.minecraft.client.input.KeyEvent;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.recipebook.PlaceRecipeHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractCraftingMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ExtendedRecipeBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIDefinition;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTabDisplay;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.RecipeInfo;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.RecipeIconHolder;
import wily.legacy.client.screen.RecipesScreen;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.client.screen.TabList;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

public class MixedCraftingScreen<T extends AbstractCraftingMenu>
extends RecipesScreen<T, RecipeIconHolder<VanillaCrafting>>
implements TabList.Access {
    public static final ResourceLocation STRUCTURES_TAB = Legacy4J.createModLocation("structures");
    public static final ResourceLocation MECHANISMS_TAB = Legacy4J.createModLocation("mechanisms");
    public static final ResourceLocation TOOLS_TAB = Legacy4J.createModLocation("tools");
    public static final ResourceLocation MISC_TAB = Legacy4J.createModLocation("misc");
    public static final ResourceLocation SEARCH_TAB = Legacy4J.createModLocation("search");
    public static final ExtendedRecipeBookCategory[] VANILLA_CATEGORIES = new ExtendedRecipeBookCategory[]{RecipeBookCategories.CRAFTING_BUILDING_BLOCKS, RecipeBookCategories.CRAFTING_REDSTONE, RecipeBookCategories.CRAFTING_EQUIPMENT, RecipeBookCategories.CRAFTING_MISC, SearchRecipeBookCategory.CRAFTING};
    protected final List<ItemStack> compactItemStackList = new ArrayList<ItemStack>();
    protected final StackedItemContents stackedContents = new StackedItemContents();
    protected final ScrollableRenderer scrollableRenderer = new ScrollableRenderer();
    protected final EditBox searchBox;
    private final boolean is2x2;
    protected Stocker.Sizeable infoType;
    protected List<List<RecipeInfo<VanillaCrafting>>> recipesByGroup;
    protected boolean allowRecipeDisplay;
    protected boolean searchMode;
    private boolean onlyCraftableRecipes;
    protected final TabList craftingTabList;

    public MixedCraftingScreen(T abstractContainerMenu, Inventory inventory, Component component, boolean is2x2) {
        super(abstractContainerMenu, inventory, component);
        this.searchBox = new EditBox(Minecraft.getInstance().font, 0, 0, 200, 20, LegacyComponents.SEARCH_ITEMS);
        this.infoType = new Stocker.Sizeable(Integer.valueOf(0), 2);
        this.recipesByGroup = new ArrayList<List<RecipeInfo<VanillaCrafting>>>();
        this.allowRecipeDisplay = false;
        this.searchMode = false;
        this.onlyCraftableRecipes = (Boolean)LegacyOptions.defaultShowCraftableRecipes.get();
        this.craftingTabList = new TabList(this.accessor);
        this.is2x2 = is2x2;
        this.searchBox.setResponder(s -> this.updateRecipesAndResetTimer());
        this.searchBox.setMaxLength(50);
        for (LegacyTabDisplay tab : Legacy4JClient.mixedCraftingTabs.map().values()) {
            boolean searchTab = tab.is(SEARCH_TAB);
            this.craftingTabList.add(LegacyTabButton.Type.LEFT, tab.icon(), tab.nameOrEmpty(), t -> {
                if (searchTab) {
                    this.enableSearchMode(true);
                } else {
                    this.resetElements();
                }
            });
        }
        this.resetElements(false, false);
        this.accessor.addStatic(UIDefinition.createBeforeInit(a -> this.accessor.putStaticElement("is2x2", (Object)is2x2)));
    }

    public static MixedCraftingScreen<CraftingMenu> craftingScreen(CraftingMenu abstractContainerMenu, Inventory inventory, Component component) {
        return new MixedCraftingScreen<CraftingMenu>(abstractContainerMenu, inventory, component, false);
    }

    public static MixedCraftingScreen<InventoryMenu> playerCraftingScreen(Player player) {
        return new MixedCraftingScreen<InventoryMenu>(player.inventoryMenu, player.getInventory(), LegacyCraftingMenu.CRAFTING_TITLE, true);
    }

    public static boolean isValidTab(LegacyTabDisplay display) {
        return display.is(STRUCTURES_TAB) || display.is(MECHANISMS_TAB) || display.is(TOOLS_TAB) || display.is(MISC_TAB) || display.is(SEARCH_TAB);
    }

    public void enableSearchMode(boolean clearSearch) {
        this.searchMode = true;
        this.resetElements(true, clearSearch);
        this.setFocused((GuiEventListener)this.searchBox);
    }

    public void disableSearchMode() {
        this.searchMode = false;
        this.resetElements(true, false);
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlTooltip.EXTRA.get(), () -> LegacyComponents.INFO).add(() -> ControlTooltip.OPTION.get(), () -> this.onlyCraftableRecipes ? LegacyComponents.ALL_RECIPES : LegacyComponents.SHOW_CRAFTABLE_RECIPES).add(() -> this.searchMode ? (ControlTooltip.Icon)ControlTooltip.VERTICAL_NAVIGATION.get() : ControlTooltip.CompoundComponentIcon.of(ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(340) : ControllerBinding.LEFT_STICK_BUTTON.getIcon(), ControlTooltip.PLUS_ICON, (ControlTooltip.ComponentIcon)ControlTooltip.OPTION.get()), () -> this.searchMode ? LegacyComponents.EXIT_SEARCH_MODE : LegacyComponents.SEARCH_MODE).add(() -> ControlTooltip.CONTROL_TAB.get(), () -> LegacyComponents.GROUP);
    }

    public void resetElements() {
        this.searchMode = false;
        this.resetElements(true, true);
    }

    public void resetElements(boolean reposition, boolean resetCrafting) {
        if (!resetCrafting || this.searchBox.getValue().isEmpty()) {
            this.updateRecipesAndResetTimer();
        } else {
            this.searchBox.setValue("");
        }
        this.selectedRecipeButton = 0;
        if (resetCrafting) {
            this.infoType.set(Integer.valueOf(0));
            this.recipeButtonsOffset.set(Integer.valueOf(0));
        }
        if (reposition) {
            this.repositionElements();
        }
    }

    public void setFocused(@Nullable GuiEventListener guiEventListener) {
        if (guiEventListener instanceof TabList) {
            return;
        }
        super.setFocused(guiEventListener);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        if (!this.searchMode) {
            Component title = this.getTabList() == this.craftingTabList ? this.getTabList().tabButtons.get(this.getTabList().getIndex()).getMessage() : CommonComponents.EMPTY;
            LegacyFontUtil.applySDFont(b -> guiGraphics.drawString(this.font, title, (this.imageWidth - this.font.width((FormattedText)title)) / 2, this.accessor.getInteger("title.y", 17), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
        }
        int inventoryPanelX = this.accessor.getInteger("inventoryPanel.x", 176);
        int bottomPanelY = this.accessor.getInteger("bottomPanel.y", 103);
        int inventoryPanelWidth = this.accessor.getInteger("inventoryPanel.width", 163);
        int bottomPanelHeight = this.accessor.getInteger("bottomPanel.height", 105);
        if ((Integer)this.infoType.get() <= 0) {
            LegacyFontUtil.applySDFont(b -> guiGraphics.drawString(this.font, this.playerInventoryTitle, inventoryPanelX + (inventoryPanelWidth - this.font.width((FormattedText)this.playerInventoryTitle)) / 2, bottomPanelY + this.accessor.getInteger("inventoryTitle.y", 11), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
        } else if (this.selectedRecipeButton < this.getRecipeButtons().size()) {
            RecipeIconHolder h = (RecipeIconHolder)this.recipeButtons.get(this.selectedRecipeButton);
            if ((Integer)this.infoType.get() == 1 && LegacyTipManager.hasTip(h.getFocusedResult())) {
                LegacyFontUtil.applySDFont(b -> {
                    List l = this.font.split((FormattedText)LegacyTipManager.getTipComponent(h.getFocusedResult()), inventoryPanelWidth - 11);
                    int lineSpacing = b != false ? 8 : 12;
                    this.scrollableRenderer.lineHeight = lineSpacing;
                    int lineAmount = (bottomPanelHeight - 21) / lineSpacing;
                    this.scrollableRenderer.scrolled.max = Math.max(0, l.size() - lineAmount);
                    this.scrollableRenderer.render(guiGraphics, inventoryPanelX + 5, bottomPanelY + 2, inventoryPanelWidth - 11, lineAmount * lineSpacing + 2, () -> {
                        for (int i1 = 0; i1 < l.size(); ++i1) {
                            guiGraphics.drawString(this.font, (FormattedCharSequence)l.get(i1), inventoryPanelX + 5, bottomPanelY + 5 + i1 * (b != false ? 8 : 12), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                        }
                    });
                });
            } else if ((Integer)this.infoType.get() == 2) {
                LegacyFontUtil.applySDFont(b -> guiGraphics.drawString(this.font, LegacyComponents.INGREDIENTS, inventoryPanelX + (inventoryPanelWidth - this.font.width((FormattedText)LegacyComponents.INGREDIENTS)) / 2, bottomPanelY + this.accessor.getInteger("ingredientsTitle.y", 5), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
                if (h.getFocusedRecipe() != null) {
                    int ingredientSize = this.accessor.getInteger("ingredientSlot.size", 14);
                    int ingredientX = inventoryPanelX + this.accessor.getInteger("ingredientSlot.x", 4);
                    int ingredientY = bottomPanelY + this.accessor.getInteger("ingredientSlot.y", 21);
                    float textScale = LegacyOptions.getUIMode().isFHD() ? 0.6666667f : (LegacyOptions.getUIMode().isSD() ? 0.5f : 1.0f);
                    this.compactItemStackList.clear();
                    RecipeMenu.handleCompactItemStackList(this.compactItemStackList, () -> h.getFocusedRecipe().getOptionalIngredients().stream().map(RecipeIconHolder::getActualItem).iterator());
                    this.scrollableRenderer.scrolled.max = Math.max(0, this.compactItemStackList.size() - 4);
                    this.scrollableRenderer.lineHeight = ingredientSize + 1;
                    this.scrollableRenderer.render(guiGraphics, inventoryPanelX + 2, ingredientY - 2, inventoryPanelWidth - 11, (ingredientSize + 1) * 4 + 1, () -> {
                        for (int i1 = 0; i1 < this.compactItemStackList.size(); ++i1) {
                            ItemStack ing = this.compactItemStackList.get(i1);
                            LegacyRenderUtil.iconHolderRenderer.itemHolder(ingredientX, ingredientY + (ingredientSize + 1) * i1, ingredientSize, ingredientSize, ing, false, Vec2.ZERO).render(guiGraphics, i, j, 0.0f);
                            guiGraphics.pose().pushMatrix();
                            guiGraphics.pose().translate((float)(ingredientX + ingredientSize + this.accessor.getInteger("ingredientText.x", 4)), (float)(ingredientY + ingredientSize / 2 + (ingredientSize + 1) * i1));
                            LegacyFontUtil.applyFontOverrideIf(LegacyOptions.getUIMode().isHD(), LegacyFontUtil.MOJANGLES_11_FONT, b -> {
                                guiGraphics.pose().scale(textScale);
                                guiGraphics.pose().translate(0.0f, -3.0f);
                                LegacyRenderUtil.renderScrollingString(guiGraphics, this.font, ing.getHoverName(), 0, -2, Math.round((float)(inventoryPanelWidth - 22 - 2) / textScale), 7, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false);
                            });
                            guiGraphics.pose().popMatrix();
                        }
                    });
                }
            }
        }
    }

    protected void slotClicked(Slot slot, int i, int j, ClickType clickType) {
        this.allowRecipeDisplay = false;
        super.slotClicked(slot, i, j, clickType);
        this.updateRecipesAndResetTimer();
    }

    @Override
    protected void updateRecipes() {
        ClientPacketListener clientPacketListener;
        this.minecraft = Minecraft.getInstance();
        this.stackedContents.clear();
        this.inventory.fillStackedContents(this.stackedContents);
        ((AbstractCraftingMenu)this.menu).fillCraftSlotsStackedContents(this.stackedContents);
        List collections = Minecraft.getInstance().player.getRecipeBook().getCollection(VANILLA_CATEGORIES[this.getTabList().getIndex()]);
        this.allowRecipeDisplay = false;
        ContextMap context = SlotDisplayContext.fromLevel((Level)this.minecraft.level);
        this.allowRecipeDisplay = ((AbstractCraftingMenu)this.menu).getInputGridSlots().stream().noneMatch(Slot::hasItem);
        collections.forEach(collection -> collection.selectRecipes(this.stackedContents, d -> {
            RecipeDisplay recipeDisplay = d;
            Objects.requireNonNull(recipeDisplay);
            RecipeDisplay selector0$temp = recipeDisplay;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedCraftingRecipeDisplay.class, ShapelessCraftingRecipeDisplay.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    ShapedCraftingRecipeDisplay shapedCraftingRecipeDisplay = (ShapedCraftingRecipeDisplay)selector0$temp;
                    if (((AbstractCraftingMenu)this.menu).getGridWidth() >= shapedCraftingRecipeDisplay.width() && ((AbstractCraftingMenu)this.menu).getGridWidth() >= shapedCraftingRecipeDisplay.height()) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    ShapelessCraftingRecipeDisplay shapelessCraftingRecipeDisplay = (ShapelessCraftingRecipeDisplay)selector0$temp;
                    if (((AbstractCraftingMenu)this.menu).getGridWidth() * ((AbstractCraftingMenu)this.menu).getGridHeight() >= shapelessCraftingRecipeDisplay.ingredients().size()) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }));
        this.recipesByGroup.clear();
        List searchCollections = null;
        if (!this.searchBox.getValue().isBlank() && (clientPacketListener = this.minecraft.getConnection()) != null) {
            searchCollections = clientPacketListener.searchTrees().recipes().search(this.searchBox.getValue().toLowerCase(Locale.ROOT));
        }
        for (final RecipeCollection collection2 : collections) {
            List selectedRecipes;
            if (!collection2.hasAnySelected() || searchCollections != null && !searchCollections.contains(collection2) || (selectedRecipes = collection2.getSelectedRecipes(this.onlyCraftableRecipes ? RecipeCollection.CraftableStatus.CRAFTABLE : RecipeCollection.CraftableStatus.ANY)).isEmpty()) continue;
            this.recipesByGroup.add(selectedRecipes.stream().map(e -> {
                final ArrayList ings = new ArrayList(Collections.nCopies(((AbstractCraftingMenu)this.menu).getGridWidth() * ((AbstractCraftingMenu)this.menu).getGridHeight(), Optional.empty()));
                boolean[] warningSlots = new boolean[((AbstractCraftingMenu)this.menu).getGridWidth() * ((AbstractCraftingMenu)this.menu).getGridHeight()];
                final ArrayList<List<ItemStack>> displays = new ArrayList<List<ItemStack>>(Collections.nCopies(((AbstractCraftingMenu)this.menu).getGridWidth() * ((AbstractCraftingMenu)this.menu).getGridHeight(), Collections.singletonList(ItemStack.EMPTY)));
                RecipeDisplay recipeDisplay = e.display();
                Objects.requireNonNull(recipeDisplay);
                RecipeDisplay selector0$temp = recipeDisplay;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedCraftingRecipeDisplay.class, ShapelessCraftingRecipeDisplay.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        ShapedCraftingRecipeDisplay shapedCraftingRecipeDisplay = (ShapedCraftingRecipeDisplay)selector0$temp;
                        PlaceRecipeHelper.placeRecipe((int)((AbstractCraftingMenu)this.menu).getGridWidth(), (int)((AbstractCraftingMenu)this.menu).getGridHeight(), (int)shapedCraftingRecipeDisplay.width(), (int)shapedCraftingRecipeDisplay.height(), (Iterable)shapedCraftingRecipeDisplay.ingredients(), (slotDisplay, ix, jx, k) -> displays.set(ix, slotDisplay.resolveForStacks(context)));
                        break;
                    }
                    case 1: {
                        ShapelessCraftingRecipeDisplay shapelessCraftingRecipeDisplay = (ShapelessCraftingRecipeDisplay)selector0$temp;
                        for (int index = 0; index < shapelessCraftingRecipeDisplay.ingredients().size(); ++index) {
                            displays.set(index, ((SlotDisplay)shapelessCraftingRecipeDisplay.ingredients().get(index)).resolveForStacks(context));
                        }
                        break;
                    }
                }
                e.craftingRequirements().ifPresent(ingredients -> {
                    for (int index = 0; index < ingredients.size(); ++index) {
                        ings.set(index, Optional.of((Ingredient)ingredients.get(index)));
                    }
                });
                if (this.allowRecipeDisplay) {
                    this.compactItemStackList.clear();
                    RecipeMenu.handleCompactInventoryList(this.compactItemStackList, this.inventory, ItemStack.EMPTY);
                    block5: for (int i = 0; i < displays.size(); ++i) {
                        List stacks = (List)displays.get(i);
                        if (stacks.isEmpty() || ((ItemStack)stacks.get(0)).isEmpty()) {
                            warningSlots[i] = false;
                            continue;
                        }
                        for (ItemStack itemStack : this.compactItemStackList) {
                            if (!stacks.stream().anyMatch(item -> item.is(itemStack.getItem()))) continue;
                            warningSlots[i] = false;
                            itemStack.shrink(1);
                            continue block5;
                        }
                        warningSlots[i] = true;
                    }
                }
                final VanillaCrafting crafting = new VanillaCrafting(){
                    final /* synthetic */ RecipeDisplayEntry val$e;
                    final /* synthetic */ boolean[] val$warningSlots;
                    {
                        this.val$e = recipeDisplayEntry;
                        this.val$warningSlots = blArray;
                    }

                    @Override
                    public ItemStack getItemFromGrid(int index) {
                        List items = (List)displays.get(index);
                        if (items.isEmpty()) {
                            return ItemStack.EMPTY;
                        }
                        return (ItemStack)items.get((int)(Util.getMillis() / 800L % (long)items.size()));
                    }

                    @Override
                    public boolean canCraft() {
                        return collection2.isCraftable(this.val$e.id());
                    }

                    @Override
                    public void craft(InputWithModifiers input) {
                        ((MixedCraftingScreen)MixedCraftingScreen.this).minecraft.gameMode.handlePlaceRecipe(((MixedCraftingScreen)MixedCraftingScreen.this).minecraft.player.containerMenu.containerId, this.val$e.id(), input.hasShiftDown());
                    }

                    @Override
                    public boolean isWarning(int index) {
                        return this.val$warningSlots[index];
                    }
                };
                final List resultDisplay = e.resultItems(context);
                RecipeInfo<VanillaCrafting> info = new RecipeInfo<VanillaCrafting>(this){

                    public VanillaCrafting get() {
                        return crafting;
                    }

                    public ResourceLocation getId() {
                        return null;
                    }

                    @Override
                    public List<Optional<Ingredient>> getOptionalIngredients() {
                        return ings;
                    }

                    @Override
                    public ItemStack getResultItem() {
                        return resultDisplay.size() == 1 ? (ItemStack)resultDisplay.get(0) : (ItemStack)resultDisplay.get((int)(Util.getMillis() / 800L % (long)resultDisplay.size()));
                    }

                    @Override
                    public Component getName() {
                        return this.getResultItem().getHoverName();
                    }

                    @Override
                    public Component getDescription() {
                        return null;
                    }
                };
                return info;
            }).toList());
        }
        this.recipeButtonsOffset.max = Math.max(0, this.recipesByGroup.size() - 12);
    }

    protected boolean isInventoryActive() {
        return (Integer)this.infoType.get() <= 0;
    }

    @Override
    public int getTabYOffset() {
        return 18;
    }

    @Override
    protected void init() {
        this.imageWidth = 349;
        this.imageHeight = 215;
        super.init();
        this.topPos += this.getTabYOffset();
        final int invSlotSize = this.accessor.getInteger("inventorySlot.size", 16);
        int invSlotX = this.accessor.getInteger("inventory.x", 186);
        int invSlotY = this.accessor.getInteger("inventory.y", 133);
        int quickSelectY = this.accessor.getInteger("quickSelect.y", 186);
        final int slotSize = this.accessor.getInteger("craftingGridSlot.size", 23);
        int craftingGridPanelX = this.accessor.getInteger("craftingGridPanel.x", 9);
        int bottomPanelY = this.accessor.getInteger("bottomPanel.y", 103);
        int craftingGridSlotX = this.accessor.getInteger("craftingGridSlot.x", this.is2x2 ? 24 : 12);
        int craftingGridSlotY = this.accessor.getInteger("craftingGridSlot.y", 30);
        final int resultSlotSize = this.accessor.getInteger("craftingResultSlot.size", 36);
        for (int i2 = 0; i2 < ((AbstractCraftingMenu)this.menu).slots.size(); ++i2) {
            final Slot s = (Slot)((AbstractCraftingMenu)this.menu).slots.get(i2);
            if (i2 == 0) {
                LegacySlotDisplay.override(s, craftingGridPanelX + this.accessor.getInteger("resultSlot.x", 104) + (this.is2x2 ? 0 : slotSize / 2), bottomPanelY + this.accessor.getInteger("resultSlot.y", 48), new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return resultSlotSize;
                    }

                    @Override
                    public ItemStack getItemOverride() {
                        RecipeIconHolder recipeIconHolder;
                        if (MixedCraftingScreen.this.allowRecipeDisplay && (recipeIconHolder = (RecipeIconHolder)MixedCraftingScreen.this.recipeButtons.get(MixedCraftingScreen.this.selectedRecipeButton)).isValidIndex()) {
                            return recipeIconHolder.getFocusedResult();
                        }
                        return LegacySlotDisplay.super.getItemOverride();
                    }

                    @Override
                    public boolean isWarning() {
                        RecipeIconHolder recipeIconHolder;
                        if (MixedCraftingScreen.this.allowRecipeDisplay && (recipeIconHolder = (RecipeIconHolder)MixedCraftingScreen.this.recipeButtons.get(MixedCraftingScreen.this.selectedRecipeButton)).isValidIndex()) {
                            return !recipeIconHolder.canCraft();
                        }
                        return LegacySlotDisplay.super.isWarning();
                    }
                });
                continue;
            }
            if (i2 < (this.is2x2 ? 5 : 10)) {
                LegacySlotDisplay.override(s, craftingGridPanelX + craftingGridSlotX + s.getContainerSlot() % ((AbstractCraftingMenu)this.menu).getGridWidth() * slotSize, bottomPanelY + craftingGridSlotY + (this.is2x2 ? slotSize / 2 : 0) + s.getContainerSlot() / ((AbstractCraftingMenu)this.menu).getGridHeight() * slotSize, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return slotSize;
                    }

                    @Override
                    public ItemStack getItemOverride() {
                        RecipeIconHolder recipeIconHolder;
                        if (MixedCraftingScreen.this.allowRecipeDisplay && (recipeIconHolder = (RecipeIconHolder)MixedCraftingScreen.this.recipeButtons.get(MixedCraftingScreen.this.selectedRecipeButton)).isValidIndex()) {
                            return ((VanillaCrafting)recipeIconHolder.getFocusedRecipe().get()).getItemFromGrid(s.getContainerSlot());
                        }
                        return LegacySlotDisplay.super.getItemOverride();
                    }

                    @Override
                    public boolean isWarning() {
                        RecipeIconHolder recipeIconHolder;
                        if (MixedCraftingScreen.this.allowRecipeDisplay && (recipeIconHolder = (RecipeIconHolder)MixedCraftingScreen.this.recipeButtons.get(MixedCraftingScreen.this.selectedRecipeButton)).isValidIndex()) {
                            return ((VanillaCrafting)recipeIconHolder.getFocusedRecipe().get()).isWarning(s.getContainerSlot());
                        }
                        return LegacySlotDisplay.super.isWarning();
                    }
                });
                continue;
            }
            if (this.is2x2 && (i2 < 9 || i2 == ((AbstractCraftingMenu)this.menu).slots.size() - 1)) {
                LegacySlotDisplay.override(s, new LegacySlotDisplay(this){

                    @Override
                    public boolean isVisible() {
                        return false;
                    }
                });
                continue;
            }
            if (i2 < ((AbstractCraftingMenu)this.menu).slots.size() - (this.is2x2 ? 10 : 9)) {
                LegacySlotDisplay.override(s, invSlotX + (s.getContainerSlot() - 9) % 9 * invSlotSize, invSlotY + (s.getContainerSlot() - 9) / 9 * invSlotSize, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return invSlotSize;
                    }

                    @Override
                    public boolean isVisible() {
                        return MixedCraftingScreen.this.isInventoryActive();
                    }
                });
                continue;
            }
            if (i2 >= ((AbstractCraftingMenu)this.menu).slots.size() - (this.is2x2 ? 1 : 0)) continue;
            LegacySlotDisplay.override(s, invSlotX + s.getContainerSlot() * invSlotSize, quickSelectY, new LegacySlotDisplay(){

                @Override
                public int getWidth() {
                    return invSlotSize;
                }

                @Override
                public boolean isVisible() {
                    return MixedCraftingScreen.this.isInventoryActive();
                }
            });
        }
        if (this.searchMode) {
            this.searchBox.setWidth(200);
            this.searchBox.setHeight(20);
            this.searchBox.setPosition(this.leftPos + (this.imageWidth - this.searchBox.getWidth()) / 2, this.topPos + 11);
            this.addRenderableWidget((GuiEventListener)((EditBox)this.accessor.putWidget("searchBox", (AbstractWidget)this.searchBox)));
        }
        if (this.selectedRecipeButton < this.getRecipeButtons().size() && !this.searchMode) {
            this.setFocused(this.getRecipeButtons().get(this.selectedRecipeButton));
        }
        int craftingButtonsX = this.accessor.getInteger("craftingButtons.x", 13);
        int craftingButtonsY = this.accessor.getInteger("craftingButtons.y", 38);
        int craftingButtonsSize = this.accessor.getInteger("craftingButtons.size", 27);
        this.getRecipeButtons().forEach(b -> {
            b.width = b.height = craftingButtonsSize;
            b.setPos(this.leftPos + craftingButtonsX + this.recipeButtons.indexOf(b) * b.width, this.topPos + craftingButtonsY);
            this.addWidget((GuiEventListener)b);
        });
        this.addWidget(this.getTabList());
        this.getTabList().init(this.leftPos, this.topPos - 37, this.imageWidth, 43, (t, i) -> {
            int index = this.getTabList().tabButtons.indexOf(t);
            t.type = LegacyTabButton.Type.bySize(index, this.getMaxTabCount());
            t.setWidth(this.accessor.getInteger("tabList.buttonWidth", 71));
            t.offset = t1 -> new Vec2((LegacyRenderUtil.hasHorizontalArtifacts() && index % 2 != 0 ? 0.0125f : 0.0f) + this.accessor.getFloat("tabList.buttonOffset.x", -1.5f) * (float)this.getTabList().tabButtons.indexOf(t), t1.selected ? 0.0f : this.accessor.getFloat("tabList.selectedOffset.y", 4.4f));
        });
    }

    @Override
    public TabList getTabList() {
        return this.craftingTabList;
    }

    protected int getMaxTabCount() {
        return this.accessor.getInteger("maxTabCount", 5);
    }

    @Override
    protected RecipeIconHolder<VanillaCrafting> createRecipeButton(final int index) {
        RecipeIconHolder<VanillaCrafting> h = new RecipeIconHolder<VanillaCrafting>(this.leftPos + 13 + index * 27, this.topPos + 38){

            @Override
            public void render(GuiGraphics graphics, int i, int j, float f) {
                if (this.isFocused()) {
                    MixedCraftingScreen.this.selectedRecipeButton = index;
                }
                super.render(graphics, i, j, f);
            }

            @Override
            protected boolean canCraft(RecipeInfo<VanillaCrafting> rcp) {
                return rcp == null || ((VanillaCrafting)rcp.get()).canCraft();
            }

            @Override
            protected List<RecipeInfo<VanillaCrafting>> getRecipes() {
                return MixedCraftingScreen.this.recipesByGroup.size() <= (Integer)MixedCraftingScreen.this.recipeButtonsOffset.get() + index ? Collections.emptyList() : MixedCraftingScreen.this.recipesByGroup.get((Integer)MixedCraftingScreen.this.recipeButtonsOffset.get() + index);
            }

            @Override
            public LegacyScrollRenderer getScrollRenderer() {
                return MixedCraftingScreen.this.scrollRenderer;
            }

            @Override
            protected void toggleCraftableRecipes(InputWithModifiers input) {
                if (input.hasShiftDown() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed) {
                    return;
                }
                MixedCraftingScreen.this.onlyCraftableRecipes = !MixedCraftingScreen.this.onlyCraftableRecipes;
                MixedCraftingScreen.this.updateRecipes();
            }

            @Override
            public boolean keyPressed(KeyEvent keyEvent) {
                if (this.controlCyclicNavigation(keyEvent.key(), index, MixedCraftingScreen.this.recipeButtons, MixedCraftingScreen.this.recipeButtonsOffset, MixedCraftingScreen.this.scrollRenderer, (Screen)MixedCraftingScreen.this)) {
                    return true;
                }
                if (keyEvent.key() == 88) {
                    MixedCraftingScreen.this.infoType.add(1, true);
                    LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
                    return true;
                }
                return super.keyPressed(keyEvent);
            }

            @Override
            protected void updateRecipeDisplay(RecipeInfo<VanillaCrafting> rcp) {
                MixedCraftingScreen.this.scrollableRenderer.resetScrolled();
            }

            @Override
            public void craft(InputWithModifiers input) {
                LegacySoundUtil.playSimpleUISound(SoundEvents.ITEM_PICKUP, 1.0f);
                ((VanillaCrafting)this.getFocusedRecipe().get()).craft(input);
                MixedCraftingScreen.this.slotClicked(((AbstractCraftingMenu)MixedCraftingScreen.this.menu).getResultSlot(), ((AbstractCraftingMenu)((MixedCraftingScreen)MixedCraftingScreen.this).menu).getResultSlot().index, 0, ClickType.QUICK_MOVE);
            }
        };
        h.offset = LegacyCraftingMenu.DEFAULT_INVENTORY_OFFSET;
        return h;
    }

    @Override
    public int getMaxRecipeButtons() {
        return this.accessor.getInteger("maxCraftingButtonsCount", 12);
    }

    @Override
    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (super.mouseScrolled(d, e, f, g)) {
            return true;
        }
        return this.scrollableRenderer.mouseScrolled(g);
    }

    public boolean mouseClicked(MouseButtonEvent event, boolean bl) {
        if (this.searchBox.isFocused() && this.searchMode && !this.searchBox.isMouseOver(event.x(), event.y())) {
            this.disableSearchMode();
        }
        return super.mouseClicked(event, bl);
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        this.getTabList().render(guiGraphics, i, j, f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(this.accessor.getResourceLocation("imageSprite", LegacySprites.SMALL_PANEL), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        this.getTabList().renderSelected(guiGraphics, i, j, f);
        int bottomPanelHeight = this.accessor.getInteger("bottomPanel.height", 105);
        int panelWidth = this.accessor.getInteger("craftingGridPanel.width", 163);
        int bottomPanelY = this.accessor.getInteger("bottomPanel.y", 103);
        int craftingGridPanelX = this.accessor.getInteger("craftingGridPanel.x", 9);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + craftingGridPanelX, this.topPos + bottomPanelY, panelWidth, bottomPanelHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + this.accessor.getInteger("inventoryPanel.x", 176), this.topPos + bottomPanelY, this.accessor.getInteger("inventoryPanel.width", 163), bottomPanelHeight);
        int slotSize = this.accessor.getInteger("craftingGridSlot.size", 23);
        int xDiff = this.leftPos + craftingGridPanelX;
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SMALL_ARROW, xDiff + this.accessor.getInteger("craftingArrow.x", 77) + (this.is2x2 ? 0 : slotSize / 2), this.topPos + bottomPanelY + this.accessor.getInteger("craftingArrow.y", 57), 16, 14);
        this.renderRecipesScroll(guiGraphics, 5, 45);
        ItemStack resultStack = ((RecipeIconHolder)this.recipeButtons.get(this.selectedRecipeButton)).getFocusedResult();
        if (!resultStack.isEmpty() && this.allowRecipeDisplay) {
            Component resultName = ((RecipeIconHolder)this.recipeButtons.get(this.selectedRecipeButton)).getFocusedRecipe().getName();
            Component description = ((RecipeIconHolder)this.recipeButtons.get(this.selectedRecipeButton)).getFocusedRecipe().getDescription();
            int titleY = bottomPanelY + this.accessor.getInteger("craftingTitle.y", 11) - (description == null ? 0 : 6);
            LegacyFontUtil.applySDFont(b -> LegacyRenderUtil.renderScrollingString(guiGraphics, this.font, resultName, xDiff + 2 + Math.max(panelWidth - this.font.width((FormattedText)resultName), 0) / 2, this.topPos + titleY, xDiff + panelWidth - 2, this.topPos + titleY + 11, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false));
            if (description != null) {
                LegacyFontUtil.applySDFont(b -> LegacyRenderUtil.renderScrollingString(guiGraphics, this.font, (Component)description.copy().setStyle(Style.EMPTY), xDiff + 2 + Math.max(panelWidth - this.font.width((FormattedText)description), 0) / 2, this.topPos + titleY + 12, xDiff + panelWidth - 2, this.topPos + titleY + 23, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false));
            }
        }
    }

    public boolean keyPressed(KeyEvent keyEvent) {
        if (this.searchMode && (keyEvent.key() == 265 || keyEvent.key() == 264)) {
            this.disableSearchMode();
            return true;
        }
        if (this.getTabList().controlTab(keyEvent.key())) {
            return true;
        }
        if (keyEvent.key() != 256 && this.searchBox.isFocused()) {
            return this.searchBox.keyPressed(keyEvent);
        }
        return super.keyPressed(keyEvent);
    }

    public boolean keyReleased(KeyEvent keyEvent) {
        if (!this.searchBox.isFocused() && !this.searchMode && keyEvent.key() == 79 && (keyEvent.hasShiftDown() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed)) {
            this.enableSearchMode(false);
            return true;
        }
        return super.keyReleased(keyEvent);
    }

    public static interface VanillaCrafting {
        public ItemStack getItemFromGrid(int var1);

        public boolean canCraft();

        public void craft(InputWithModifiers var1);

        public boolean isWarning(int var1);
    }
}

