/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.init;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.TallGrassBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.MapColor;
import net.minecraft.world.level.material.PushReaction;
import wily.factoryapi.FactoryAPIPlatform;
import wily.factoryapi.base.RegisterListing;
import wily.legacy.Legacy4J;
import wily.legacy.block.ColoredWaterCauldronBlock;
import wily.legacy.block.entity.WaterCauldronBlockEntity;
import wily.legacy.config.LegacyMixinToggles;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.inventory.LegacyMerchantMenu;
import wily.legacy.util.LegacyTags;

public class LegacyRegistries {
    private static final RegisterListing<BlockEntityType<?>> BLOCK_ENTITIES_REGISTER = FactoryAPIPlatform.createRegister((String)"legacy", (Registry)BuiltInRegistries.BLOCK_ENTITY_TYPE);
    private static final RegisterListing<Block> BLOCK_ITEMS_REGISTER = FactoryAPIPlatform.createRegister((String)"legacy", (Registry)BuiltInRegistries.BLOCK);
    private static final RegisterListing<Block> BLOCK_REGISTER = FactoryAPIPlatform.createRegister((String)"legacy", (Registry)BuiltInRegistries.BLOCK);
    private static final RegisterListing<Item> ITEM_REGISTER = FactoryAPIPlatform.createRegister((String)"legacy", (Registry)BuiltInRegistries.ITEM);
    private static final RegisterListing<MenuType<?>> MENU_REGISTER = FactoryAPIPlatform.createRegister((String)"legacy", (Registry)BuiltInRegistries.MENU);
    private static final RegisterListing<SoundEvent> SOUND_EVENT_REGISTER = FactoryAPIPlatform.createRegister((String)"legacy", (Registry)BuiltInRegistries.SOUND_EVENT);
    public static final RegisterListing.Holder<MenuType<LegacyMerchantMenu>> MERCHANT_MENU = MENU_REGISTER.add("merchant_menu", () -> new MenuType(LegacyMerchantMenu::new, FeatureFlags.VANILLA_SET));
    public static final RegisterListing.Holder<MenuType<LegacyCraftingMenu>> STONECUTTER_PANEL_MENU = MENU_REGISTER.add("stonecutter_panel_menu", () -> new MenuType(LegacyCraftingMenu::stoneCutterMenu, FeatureFlags.VANILLA_SET));
    public static final RegisterListing.Holder<MenuType<LegacyCraftingMenu>> LOOM_PANEL_MENU = MENU_REGISTER.add("loom_panel_menu", () -> new MenuType(LegacyCraftingMenu::loomMenu, FeatureFlags.VANILLA_SET));
    public static final RegisterListing.Holder<MenuType<LegacyCraftingMenu>> PLAYER_CRAFTING_PANEL_MENU = MENU_REGISTER.add("player_crafting_panel_menu", () -> new MenuType(LegacyCraftingMenu::playerCraftingMenu, FeatureFlags.VANILLA_SET));
    public static final RegisterListing.Holder<MenuType<LegacyCraftingMenu>> CRAFTING_PANEL_MENU = MENU_REGISTER.add("crafting_panel_menu", () -> new MenuType(LegacyCraftingMenu::craftingMenu, FeatureFlags.VANILLA_SET));
    public static final RegisterListing.Holder<Item> WATER = ITEM_REGISTER.add("water", id -> new BlockItem(Blocks.WATER, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id)).overrideDescription(Blocks.WATER.getDescriptionId())));
    public static final RegisterListing.Holder<Item> LAVA = ITEM_REGISTER.add("lava", id -> new BlockItem(Blocks.LAVA, new Item.Properties().setId(ResourceKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)id)).overrideDescription(Blocks.LAVA.getDescriptionId())));
    public static final RegisterListing.Holder<ColoredWaterCauldronBlock> COLORED_WATER_CAULDRON = BLOCK_REGISTER.add("colored_water_cauldron", id -> new ColoredWaterCauldronBlock(FactoryAPIPlatform.setupBlockProperties((BlockBehaviour.Properties)BlockBehaviour.Properties.ofLegacyCopy((BlockBehaviour)Blocks.CAULDRON), (ResourceLocation)id)));
    public static final RegisterListing.Holder<Block> SHRUB = BLOCK_ITEMS_REGISTER.add("shrub", id -> new TallGrassBlock(FactoryAPIPlatform.setupBlockProperties((BlockBehaviour.Properties)BlockBehaviour.Properties.of().mapColor(MapColor.PLANT).replaceable().noCollision().instabreak().sound(SoundType.GRASS).offsetType(BlockBehaviour.OffsetType.XYZ).ignitedByLava().pushReaction(PushReaction.DESTROY), (ResourceLocation)id)));
    public static final RegisterListing.Holder<BlockEntityType<WaterCauldronBlockEntity>> WATER_CAULDRON_BLOCK_ENTITY = BLOCK_ENTITIES_REGISTER.add("water_cauldron", () -> FactoryAPIPlatform.createBlockEntityType(WaterCauldronBlockEntity::new, (Block[])new Block[]{Blocks.WATER_CAULDRON, (Block)COLORED_WATER_CAULDRON.get()}));
    public static final RegisterListing.Holder<SoundEvent> SCROLL = SOUND_EVENT_REGISTER.add("random.scroll", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Legacy4J.createModLocation("random.scroll")));
    public static final RegisterListing.Holder<SoundEvent> CRAFT_FAIL = SOUND_EVENT_REGISTER.add("random.craft_fail", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Legacy4J.createModLocation("random.craft_fail")));
    public static final RegisterListing.Holder<SoundEvent> BACK = SOUND_EVENT_REGISTER.add("random.back", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Legacy4J.createModLocation("random.back")));
    public static final RegisterListing.Holder<SoundEvent> FOCUS = SOUND_EVENT_REGISTER.add("random.focus", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Legacy4J.createModLocation("random.focus")));
    public static final RegisterListing.Holder<SoundEvent> ACTION = SOUND_EVENT_REGISTER.add("random.action", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Legacy4J.createModLocation("random.action")));
    public static final RegisterListing.Holder<SoundEvent> SHIFT_LOCK = SOUND_EVENT_REGISTER.add("random.shift_lock", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Legacy4J.createModLocation("random.shift_lock")));
    public static final RegisterListing.Holder<SoundEvent> SHIFT_UNLOCK = SOUND_EVENT_REGISTER.add("random.shift_unlock", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Legacy4J.createModLocation("random.shift_unlock")));
    public static final RegisterListing.Holder<SoundEvent> SPACE = SOUND_EVENT_REGISTER.add("random.space", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Legacy4J.createModLocation("random.space")));
    public static final RegisterListing.Holder<SoundEvent> BACKSPACE = SOUND_EVENT_REGISTER.add("random.backspace", () -> SoundEvent.createVariableRangeEvent((ResourceLocation)Legacy4J.createModLocation("random.backspace")));

    public static boolean isInvalidCauldron(BlockState blockState, Level level, BlockPos blockPos) {
        WaterCauldronBlockEntity be;
        BlockEntity blockEntity;
        return blockState.is(LegacyTags.WATER_CAULDRONS) && (blockEntity = level.getBlockEntity(blockPos)) instanceof WaterCauldronBlockEntity && (!(be = (WaterCauldronBlockEntity)blockEntity).hasWater() || be.waterColor != null);
    }

    public static void register() {
        BLOCK_REGISTER.register();
        if (((Boolean)LegacyMixinToggles.legacyCauldrons.get()).booleanValue()) {
            BLOCK_ENTITIES_REGISTER.register();
        }
        BLOCK_ITEMS_REGISTER.register();
        BLOCK_ITEMS_REGISTER.forEach(b -> ITEM_REGISTER.add(b.getId().getPath(), () -> new BlockItem((Block)b.get(), FactoryAPIPlatform.setupBlockItemProperties((Item.Properties)new Item.Properties(), (RegisterListing.Holder)b))));
        ITEM_REGISTER.register();
        MENU_REGISTER.register();
        SOUND_EVENT_REGISTER.register();
    }
}

