/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.network;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.crafting.Ingredient;
import wily.factoryapi.base.FactoryIngredient;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.Legacy4J;
import wily.legacy.client.RecipeInfo;
import wily.legacy.inventory.RecipeMenu;

public record ServerMenuCraftPayload(Optional<ResourceLocation> craftId, List<Optional<Ingredient>> customIngredients, int button, boolean max) implements CommonNetwork.Payload
{
    public static final CommonNetwork.Identifier<ServerMenuCraftPayload> ID = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("server_menu_craft"), ServerMenuCraftPayload::new);

    public ServerMenuCraftPayload(CommonNetwork.PlayBuf buf) {
        this(((RegistryFriendlyByteBuf)buf.get()).readOptional(FriendlyByteBuf::readResourceLocation), ((RegistryFriendlyByteBuf)buf.get()).readList(b -> ((RegistryFriendlyByteBuf)buf.get()).readOptional(b1 -> FactoryIngredient.decode((CommonNetwork.PlayBuf)buf).toIngredient())), ((RegistryFriendlyByteBuf)buf.get()).readVarInt(), ((RegistryFriendlyByteBuf)buf.get()).readBoolean());
    }

    public ServerMenuCraftPayload(List<Optional<Ingredient>> ingredients, int button, boolean max) {
        this(Optional.empty(), ingredients, button, max);
    }

    public ServerMenuCraftPayload(RecipeInfo<?> rcp, int button, boolean max) {
        this(Optional.of(rcp.getId()), rcp.isOverride() ? rcp.getOptionalIngredients() : Collections.emptyList(), button, max);
    }

    public ServerMenuCraftPayload(RecipeInfo<?> rcp, boolean max) {
        this(rcp, -1, max);
    }

    public void encode(CommonNetwork.PlayBuf buf) {
        ((RegistryFriendlyByteBuf)buf.get()).writeOptional(this.craftId, FriendlyByteBuf::writeResourceLocation);
        ((RegistryFriendlyByteBuf)buf.get()).writeCollection(this.customIngredients, (r, o) -> r.writeOptional(o, (b, i) -> FactoryIngredient.encode((CommonNetwork.PlayBuf)buf, (FactoryIngredient)FactoryIngredient.of((Ingredient)i))));
        ((RegistryFriendlyByteBuf)buf.get()).writeVarInt(this.button);
        ((RegistryFriendlyByteBuf)buf.get()).writeBoolean(this.max);
    }

    public void apply(CommonNetwork.Payload.Context context) {
        Player player = context.player();
        if (player instanceof ServerPlayer) {
            ServerPlayer sp = (ServerPlayer)player;
            player = sp.containerMenu;
            if (player instanceof RecipeMenu) {
                RecipeMenu m = (RecipeMenu)player;
                context.executor().execute(() -> m.tryCraft((Player)sp, this));
            }
        }
    }

    public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
        return ID;
    }
}

