/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.util.client;

import net.minecraft.Util;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.GuiAccessor;
import wily.factoryapi.base.client.SpectatorGuiAccessor;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.client.UIDefinition;
import wily.factoryapi.util.ColorUtil;
import wily.factoryapi.util.FactoryGuiElement;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.AnimatedCharacterRenderer;
import wily.legacy.client.CommonColor;
import wily.legacy.client.CommonValue;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyMixinOptions;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.controller.LegacyKeyMapping;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.network.TopMessage;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

public class LegacyGuiElements {
    public static long lastHotbarSelectionChange = -1L;
    public static int lastHotbarSelection = -1;
    public static long lastGui = -1L;

    public static void setup(Minecraft minecraft) {
        FactoryGuiElement[] nonScaledElements = new FactoryGuiElement[]{FactoryGuiElement.SELECTED_ITEM_NAME, FactoryGuiElement.OVERLAY_MESSAGE, FactoryGuiElement.SPECTATOR_TOOLTIP};
        ArbitrarySupplier hudScale = LegacyRenderUtil::getHUDScale;
        UIAccessor accessor = FactoryScreenUtil.getGuiAccessor();
        FactoryGuiElement.HOTBAR.pre().register(guiGraphics -> {
            int newSelection;
            AnimatedCharacterRenderer.render(guiGraphics);
            int n = newSelection = minecraft.player != null ? minecraft.player.getInventory().getSelectedSlot() : -1;
            if (lastHotbarSelection >= 0 && lastHotbarSelection != newSelection) {
                lastHotbarSelectionChange = Util.getMillis();
            }
            lastHotbarSelection = newSelection;
        });
        FactoryGuiElement.HOTBAR.post().register(guiGraphics -> {
            if (minecraft.player != null) {
                ControlTooltip.Renderer.of(minecraft.gui).render(guiGraphics, 0, 0, FactoryAPIClient.getPartialTick());
            }
            LegacyRenderUtil.renderTopText(guiGraphics, TopMessage.small, 21, 1.0f, TopMessage.smallTicks);
            LegacyRenderUtil.renderTopText(guiGraphics, TopMessage.medium, 37, 1.5f, TopMessage.mediumTicks);
        });
        FactoryGuiElement.SPECTATOR_HOTBAR.pre().register(guiGraphics -> {
            LegacyFontUtil.legacyFont = false;
            AnimatedCharacterRenderer.render(guiGraphics);
        });
        FactoryGuiElement.SPECTATOR_HOTBAR.post().register(guiGraphics -> {
            LegacyFontUtil.legacyFont = true;
        });
        accessor.addStatic(UIDefinition.createBeforeInit(a -> {
            if (!((Boolean)LegacyMixinOptions.legacyGui.get()).booleanValue()) {
                return;
            }
            a.getElements().put((Object)(FactoryGuiElement.VIGNETTE.name() + ".isVisible"), () -> false);
            a.getElements().put((Object)"isGuiVisible", LegacyRenderUtil::canDisplayHUD);
            a.getElements().put((Object)"hud.scaleX", (Object)hudScale);
            a.getElements().put((Object)"hud.scaleY", (Object)hudScale);
            a.getElements().put((Object)"hud.scaleZ", (Object)hudScale);
            a.getElements().put((Object)"hud.translateX", () -> minecraft.getWindow().getGuiScaledWidth() / 2);
            a.getElements().put((Object)"hud.scaledTranslateX", () -> -minecraft.getWindow().getGuiScaledWidth() / 2);
            a.getElements().put((Object)"hud.translateY", () -> Float.valueOf((float)minecraft.getWindow().getGuiScaledHeight() + LegacyRenderUtil.getHUDDistance()));
            a.getElements().put((Object)"hud.scaledTranslateY", () -> -minecraft.getWindow().getGuiScaledHeight());
            a.getElements().put((Object)"hud.renderColor", () -> ColorUtil.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)LegacyRenderUtil.getHUDOpacity()));
            a.getElements().put((Object)(FactoryGuiElement.BOSSHEALTH.name() + ".renderColor"), () -> ColorUtil.colorFromFloat((float)1.0f, (float)1.0f, (float)1.0f, (float)LegacyRenderUtil.getInterfaceOpacity()));
            a.putStaticElement(FactoryGuiElement.CROSSHAIR.name() + ".hud.translateY", (Object)false);
            a.putStaticElement(FactoryGuiElement.CROSSHAIR.name() + ".hud.scaledTranslateY", (Object)false);
            a.getElements().put((Object)(FactoryGuiElement.SPECTATOR_HOTBAR.name() + ".translateY"), () -> Float.valueOf((22.0f - LegacyRenderUtil.getHUDDistance()) * (1.0f - SpectatorGuiAccessor.getInstance().getVisibility())));
            a.getElements().put((Object)(FactoryGuiElement.SPECTATOR_TOOLTIP.name() + ".translateY"), () -> Float.valueOf((22.0f - LegacyRenderUtil.getHUDDistance()) * (1.0f - SpectatorGuiAccessor.getInstance().getVisibility()) + 35.0f - LegacyRenderUtil.getHUDSize() + LegacyRenderUtil.getHUDDistance()));
            for (FactoryGuiElement element : nonScaledElements) {
                a.putStaticElement(element.name() + ".hud.translateX", (Object)false);
                a.putStaticElement(element.name() + ".hud.translateY", (Object)false);
                a.putStaticElement(element.name() + ".hud.scaledTranslateX", (Object)false);
                a.putStaticElement(element.name() + ".hud.scaledTranslateY", (Object)false);
                a.putStaticElement(element.name() + ".hud.scale", (Object)false);
            }
            a.getElements().put((Object)(FactoryGuiElement.OVERLAY_MESSAGE.name() + ".translateY"), () -> Float.valueOf(LegacyRenderUtil.getHUDDistance() + 72.0f - (float)((Integer)LegacyOptions.selectedItemTooltipSpacing.get()).intValue() - LegacyRenderUtil.getHUDSize() - (float)(GuiAccessor.getInstance().getLastToolHighlight().isEmpty() || GuiAccessor.getInstance().getToolHighlightTimer() <= 0 || LegacyRenderUtil.getSelectedItemTooltipLines() == 0 ? 0 : (Math.min(LegacyRenderUtil.getSelectedItemTooltipLines() + 1, LegacyRenderUtil.getTooltip(GuiAccessor.getInstance().getLastToolHighlight()).stream().filter(c -> !c.getString().isEmpty()).mapToInt(c -> 1).sum()) - 1) * (Integer)LegacyOptions.selectedItemTooltipSpacing.get())));
            a.getElements().put((Object)(FactoryGuiElement.CROSSHAIR.name() + ".translateY"), () -> minecraft.getWindow().getGuiScaledHeight() / 2);
            a.getElements().put((Object)(FactoryGuiElement.CROSSHAIR.name() + ".scaledTranslateY"), () -> -minecraft.getWindow().getGuiScaledHeight() / 2);
        }));
        FactoryAPIClient.uiDefinitionManager.staticList.add(UIDefinition.createBeforeInit(a -> {
            CommonValue.COMMON_VALUES.forEach((s, c) -> a.getElements().put((Object)("commonValue." + (String)(s.getNamespace().equals("minecraft") ? "" : s.getNamespace() + ".") + s.getPath()), (Object)c));
            CommonColor.COMMON_COLORS.forEach((s, c) -> a.getElements().put((Object)("commonColor." + (String)(s.getNamespace().equals("minecraft") ? "" : s.getNamespace() + ".") + s.getPath()), (Object)c));
            ControlTooltip.commonIcons.forEach((s, i) -> a.getElements().put((Object)("controlIcon." + s), (Object)i.map(ControlTooltip.ComponentIcon::getComponent)));
            for (KeyMapping keyMapping : minecraft.options.keyMappings) {
                a.getElements().put((Object)("controlIcon." + keyMapping.getName()), () -> ControlTooltip.getIconComponentFromKeyMapping(LegacyKeyMapping.of(keyMapping)));
            }
            Legacy4JClient.controlTypesManager.map().forEach((s, c) -> a.getElements().put((Object)("activeControlType." + String.valueOf(s)), () -> ControlType.getActiveType().equals(c)));
            for (int i2 = 1; i2 < LegacyOptions.UIMode.values().length; ++i2) {
                LegacyOptions.UIMode uiMode = LegacyOptions.UIMode.values()[i2];
                a.getElements().put((Object)("uiMode." + uiMode.getSerializedName()), () -> LegacyOptions.getUIMode() == uiMode);
            }
        }));
    }
}

