/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.controller;

import java.util.Arrays;
import java.util.Comparator;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.class_156;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;

public class CompoundControllerBinding
extends ControllerBinding<BindingState> {
    private static final Function<ControllerBinding<?>[], CompoundControllerBinding> CACHE = class_156.method_34866(CompoundControllerBinding::new);
    private final ControllerBinding<?>[] bindings;

    public CompoundControllerBinding(final ControllerBinding<?>[] bindings) {
        super(Arrays.stream(bindings).map(ControllerBinding::getKey).sorted().collect(Collectors.joining(",")), binding -> new BindingState((ControllerBinding)binding){

            @Override
            public void update(Controller controller) {
                boolean press = true;
                for (ControllerBinding controllerBinding : bindings) {
                    if (((BindingState)controllerBinding.state()).pressed) continue;
                    press = false;
                    break;
                }
                this.update(press);
            }

            @Override
            public void nextUpdatePress() {
                for (ControllerBinding controllerBinding : bindings) {
                    ((BindingState)controllerBinding.state()).nextUpdatePress();
                }
            }

            @Override
            public void block() {
                super.block();
                for (ControllerBinding controllerBinding : bindings) {
                    ((BindingState)controllerBinding.state()).block();
                    ((BindingState)controllerBinding.state()).released = true;
                }
            }
        });
        Arrays.sort(bindings, Comparator.comparing(ControllerBinding::getKey));
        this.bindings = bindings;
    }

    public static CompoundControllerBinding getOrCreate(ControllerBinding<?> ... bindings) {
        return CACHE.apply(bindings);
    }

    public static ControllerBinding<?> getOrCreateAndUpdate(Controller controller, ControllerBinding<?> ... bindings) {
        if (bindings.length == 1) {
            return bindings[0];
        }
        CompoundControllerBinding compoundControllerBinding = CompoundControllerBinding.getOrCreate(bindings);
        if (!ControllerBinding.map.containsKey(compoundControllerBinding.getKey())) {
            ControllerBinding.register(compoundControllerBinding);
            ((BindingState)compoundControllerBinding.state()).update(controller);
        }
        return compoundControllerBinding;
    }

    public ControllerBinding<?>[] bindings() {
        return this.bindings;
    }

    @Override
    public ControlTooltip.ComponentIcon getIcon() {
        ControlTooltip.ComponentIcon[] icons = new ControlTooltip.ComponentIcon[this.bindings.length * 2 - 1];
        for (int i = 0; i < icons.length; ++i) {
            boolean isDelimiter = i % 2 != 0 && i < icons.length - 1;
            icons[i] = isDelimiter ? ControlTooltip.PLUS_ICON : this.bindings[i / 2].getIcon();
        }
        return ControlTooltip.CompoundComponentIcon.of(icons);
    }

    @Override
    public boolean isSpecial() {
        return true;
    }
}

