/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import net.minecraft.core.Holder;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.saveddata.maps.MapDecorationType;
import net.minecraft.world.level.saveddata.maps.MapDecorationTypes;
import wily.legacy.client.CommonColor;
import wily.legacy.util.LegacySprites;

public record PlayerIdentifier(int index, ResourceLocation optionsMapSprite, int color, ResourceLocation mapDecorationSprite, ResourceLocation offMapDecorationSprite, ResourceLocation offLimitsMapDecorationSprite) {
    public static final Codec<PlayerIdentifier> CODEC = RecordCodecBuilder.create(i -> i.group((App)Codec.INT.fieldOf("index").forGetter(PlayerIdentifier::index), (App)ResourceLocation.CODEC.fieldOf("optionsMapSprite").orElse((Object)LegacySprites.MAP_PLAYER).forGetter(PlayerIdentifier::optionsMapSprite), (App)CommonColor.INT_COLOR_CODEC.fieldOf("color").orElse((Object)0xFFFFFF).forGetter(PlayerIdentifier::color), (App)ResourceLocation.CODEC.fieldOf("mapDecorationSprite").orElse((Object)((MapDecorationType)MapDecorationTypes.PLAYER.value()).assetId()).forGetter(PlayerIdentifier::mapDecorationSprite), (App)ResourceLocation.CODEC.fieldOf("offMapDecorationSprite").orElse((Object)((MapDecorationType)MapDecorationTypes.PLAYER_OFF_MAP.value()).assetId()).forGetter(PlayerIdentifier::offMapDecorationSprite), (App)ResourceLocation.CODEC.fieldOf("offLimitsMapDecorationSprite").orElse((Object)((MapDecorationType)MapDecorationTypes.PLAYER_OFF_LIMITS.value()).assetId()).forGetter(PlayerIdentifier::offLimitsMapDecorationSprite)).apply((Applicative)i, PlayerIdentifier::new));
    public static final PlayerIdentifier DEFAULT = new PlayerIdentifier(0, LegacySprites.MAP_PLAYER, 0xFFFFFF, ((MapDecorationType)MapDecorationTypes.PLAYER.value()).assetId(), ((MapDecorationType)MapDecorationTypes.PLAYER_OFF_MAP.value()).assetId(), ((MapDecorationType)MapDecorationTypes.PLAYER_OFF_LIMITS.value()).assetId());
    public static final Int2ObjectMap<PlayerIdentifier> list = new Int2ObjectArrayMap();

    public ResourceLocation spriteByMapDecorationType(Holder<MapDecorationType> type) {
        if (((MapDecorationType)MapDecorationTypes.PLAYER.value()).equals(type.value())) {
            return this.mapDecorationSprite();
        }
        if (((MapDecorationType)MapDecorationTypes.PLAYER_OFF_MAP.value()).equals(type.value())) {
            return this.offMapDecorationSprite();
        }
        if (((MapDecorationType)MapDecorationTypes.PLAYER_OFF_LIMITS.value()).equals(type.value())) {
            return this.offLimitsMapDecorationSprite();
        }
        return ((MapDecorationType)type.value()).assetId();
    }

    public static PlayerIdentifier of(int index) {
        return (PlayerIdentifier)list.getOrDefault(index % list.size(), (Object)DEFAULT);
    }
}

