/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.navigation.CommonInputs;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.client.gui.navigation.ScreenRectangle;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.SimpleLayoutRenderable;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.ScreenUtil;

public class LegacyIconHolder
extends SimpleLayoutRenderable
implements GuiEventListener,
NarratableEntry,
ControlTooltip.ActionHolder {
    public static final ResourceLocation ICON_HOLDER = Legacy4J.createModLocation("container/icon_holder");
    public static final ResourceLocation SIZEABLE_ICON_HOLDER = Legacy4J.createModLocation("container/sizeable_icon_holder");
    public static final ResourceLocation SELECT_ICON_HIGHLIGHT = Legacy4J.createModLocation("container/select_icon_highlight");
    public static final ResourceLocation RED_ICON_HOLDER = Legacy4J.createModLocation("container/red_icon_holder");
    public static final ResourceLocation GRAY_ICON_HOLDER = Legacy4J.createModLocation("container/gray_icon_holder");
    public static final ResourceLocation WARNING_ICON = Legacy4J.createModLocation("container/icon_warning");
    public static final ResourceLocation SLOT_HIGHLIGHT = Legacy4J.createModLocation("container/slot_highlight");
    public static final ResourceLocation MOJANGLES_11_FONT = Legacy4J.createModLocation("default_11");
    public Vec3 offset = Vec3.ZERO;
    public ResourceLocation iconSprite = null;
    public ArbitrarySupplier<ResourceLocation> iconHolderOverride = null;
    @NotNull
    public ItemStack itemIcon = ItemStack.EMPTY;
    public boolean allowItemDecorations = true;
    public boolean allowFocusedItemTooltip = false;
    private boolean isWarning = false;
    public boolean isHovered;
    private boolean focused = false;

    public LegacyIconHolder() {
    }

    public static LegacyIconHolder fromSlot(final Slot slot) {
        return new LegacyIconHolder(){

            @Override
            public void render(GuiGraphics graphics, int i, int j, float f) {
                this.slotBoundsWithItem(0, 0, slot);
                super.render(graphics, i, j, f);
            }
        };
    }

    public LegacyIconHolder(int leftPos, int topPos, Slot slot) {
        this.slotBounds(leftPos, topPos, slot);
    }

    public LegacyIconHolder(int x, int y, int width, int height) {
        this(width, height);
        this.setPos(x, y);
    }

    public LegacyIconHolder(int width, int height) {
        this.setBounds(width, height);
    }

    public void setBounds(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setPos(int x, int y) {
        this.setX(x);
        this.setY(y);
    }

    public boolean isHovered(double mouseX, double mouseY) {
        return this.isHovered;
    }

    public LegacyIconHolder slotBoundsWithItem(int leftPos, int topPos, Slot slot) {
        return this.slotBounds(leftPos, topPos, slot, slot.getItem());
    }

    public LegacyIconHolder slotBounds(Slot slot) {
        return this.slotBounds(0, 0, slot);
    }

    public LegacyIconHolder slotBounds(int leftPos, int topPos, Slot slot) {
        return this.slotBounds(leftPos, topPos, slot, ItemStack.EMPTY);
    }

    public LegacyIconHolder slotBounds(int leftPos, int topPos, Slot slot, ItemStack stack) {
        return this.itemHolder(leftPos + slot.x, topPos + slot.y, LegacySlotDisplay.of(slot).getWidth(), LegacySlotDisplay.of(slot).getHeight(), stack, LegacySlotDisplay.of(slot).isWarning(), LegacySlotDisplay.of(slot).getIconSprite(), LegacySlotDisplay.of(slot).getOffset(), LegacySlotDisplay.of(slot).getIconHolderOverride());
    }

    public LegacyIconHolder itemHolder(ItemStack itemIcon, boolean isWarning) {
        return this.itemHolder(itemIcon, isWarning, Vec3.ZERO);
    }

    public LegacyIconHolder itemHolder(ItemStack itemIcon, boolean isWarning, Vec3 offset) {
        return this.itemHolder(0, 0, 21, 21, itemIcon, isWarning, offset);
    }

    public LegacyIconHolder itemHolder(int x, int y, int width, int height, ItemStack itemIcon, boolean isWarning, Vec3 offset) {
        return this.itemHolder(x, y, width, height, itemIcon, isWarning, null, offset, null);
    }

    public LegacyIconHolder itemHolder(int x, int y, int width, int height, ItemStack itemIcon, boolean isWarning, ResourceLocation iconSprite, Vec3 offset, ArbitrarySupplier<ResourceLocation> override) {
        this.setPos(x, y);
        this.setBounds(width, height);
        this.iconSprite = iconSprite;
        this.iconHolderOverride = override;
        this.itemIcon = itemIcon;
        this.isWarning = isWarning;
        this.allowItemDecorations = true;
        this.offset = offset;
        return this;
    }

    public static LegacyIconHolder entityHolder(int x, int y, int width, int height, final EntityType<?> entityType) {
        return new LegacyIconHolder(x, y, width, height){
            Entity entity;

            @Override
            public void render(GuiGraphics graphics, int i, int j, float f) {
                super.render(graphics, i, j, f);
                if (this.entity == null && Minecraft.getInstance().level != null) {
                    this.entity = entityType.create((Level)Minecraft.getInstance().level, null);
                }
                if (this.entity != null) {
                    this.renderEntity(graphics, this.entity, i, j, f);
                }
            }
        };
    }

    public double getMiddleX() {
        return (double)this.getXCorner() + this.offset.x() + (double)((float)this.getWidth() / 2.0f);
    }

    public double getMiddleY() {
        return (double)this.getYCorner() + this.offset.y() + (double)((float)this.getHeight() / 2.0f);
    }

    public float getXCorner() {
        return (float)this.getX() - (this.isSizeable() ? 1.0f : (float)this.getWidth() / 20.0f);
    }

    public float getYCorner() {
        return (float)this.getY() - (this.isSizeable() ? 1.0f : (float)this.getHeight() / 20.0f);
    }

    public float getSelectableWidth() {
        return (float)this.getWidth() - 2.0f * (this.isSizeable() ? 1.0f : (float)this.getWidth() / 20.0f);
    }

    public float getSelectableHeight() {
        return (float)this.getHeight() - 2.0f * (this.isSizeable() ? 1.0f : (float)this.getHeight() / 20.0f);
    }

    public boolean isSizeable() {
        return Math.min(this.getWidth(), this.getHeight()) < 18 && ScreenUtil.is720p();
    }

    public boolean canSizeIcon() {
        return Math.min(this.getWidth(), this.getHeight()) > 21;
    }

    public void applyOffset(GuiGraphics graphics) {
        if (!this.offset.equals((Object)Vec3.ZERO)) {
            graphics.pose().translate(this.offset.x, this.offset.y, this.offset.z);
        }
    }

    public boolean isWarning() {
        return this.isWarning;
    }

    public void setWarning(boolean warning) {
        this.isWarning = warning;
    }

    public ResourceLocation getIconHolderSprite() {
        return this.iconHolderOverride == null ? (this.isWarning() ? RED_ICON_HOLDER : (this.isSizeable() ? SIZEABLE_ICON_HOLDER : ICON_HOLDER)) : (ResourceLocation)this.iconHolderOverride.get();
    }

    public void render(GuiGraphics graphics, int i, int j, float f) {
        this.isHovered = ScreenUtil.isMouseOver(i, j, this.getXCorner(), this.getYCorner(), this.width, this.height);
        ResourceLocation sprite = this.getIconHolderSprite();
        if (sprite != null) {
            this.renderChild(graphics, this.getXCorner(), this.getYCorner(), () -> FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(sprite, 0, 0, this.getWidth(), this.getHeight()));
        }
        if (this.iconSprite != null) {
            this.renderIcon(this.iconSprite, graphics, this.canSizeIcon(), 16, 16);
        }
        this.renderItem(graphics, i, j, f);
    }

    public void renderIcon(ResourceLocation location, GuiGraphics graphics, boolean scaled, int width, int height) {
        this.renderChild(graphics, this.getX(), this.getY(), () -> {
            FactoryGuiGraphics.of((GuiGraphics)graphics).disableDepthTest();
            if (scaled) {
                graphics.pose().scale(this.getSelectableWidth() / (float)width, this.getSelectableHeight() / (float)height, this.getSelectableHeight() / 16.0f);
            } else {
                graphics.pose().translate((this.getSelectableWidth() - (float)width) / 2.0f, (this.getSelectableHeight() - (float)height) / 2.0f, 0.0f);
            }
            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(location, 0, 0, width, height);
            FactoryGuiGraphics.of((GuiGraphics)graphics).enableDepthTest();
        });
    }

    public void renderItem(GuiGraphics graphics, int i, int j, float f) {
        this.renderItem(graphics, this.itemIcon, this.getX(), this.getY(), this.isWarning());
    }

    public void renderItem(GuiGraphics graphics, ItemStack item, int x, int y, boolean isWarning) {
        if (!item.isEmpty()) {
            this.renderItem(graphics, () -> {
                graphics.renderFakeItem(item, 0, 0);
                if (this.allowItemDecorations) {
                    graphics.renderItemDecorations(Minecraft.getInstance().font, item, 0, 0);
                }
            }, x, y, isWarning);
        }
    }

    public void renderItem(GuiGraphics graphics, Runnable itemRender, int x, int y, boolean isWarning) {
        this.renderScaled(graphics, x, y, itemRender);
        if (isWarning) {
            this.renderWarning(graphics);
        }
    }

    public void renderWarning(GuiGraphics graphics, float z) {
        this.renderChild(graphics, this.x, this.y, () -> {
            FactoryGuiGraphics.of((GuiGraphics)graphics).disableDepthTest();
            graphics.pose().translate(0.0f, 0.0f, z);
            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(WARNING_ICON, 0, 0, 8, 8);
            FactoryGuiGraphics.of((GuiGraphics)graphics).enableDepthTest();
        });
    }

    public void renderWarning(GuiGraphics graphics) {
        this.renderWarning(graphics, 332.0f);
    }

    public void renderEntity(GuiGraphics graphics, Entity entity, int i, int j, float f) {
        entity.setYRot(180.0f);
        entity.yRotO = entity.getYRot();
        entity.xRotO = 0.0f;
        entity.setXRot(0.0f);
        if (entity instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)entity;
            e.yBodyRot = 180.0f;
            e.yBodyRotO = 180.0f;
            e.yHeadRotO = e.yHeadRot = 180.0f;
        }
        graphics.enableScissor(this.getX(), this.getY(), this.getX() + Math.round(this.getSelectableWidth()), this.getY() + Math.round(this.getSelectableHeight()));
        ScreenUtil.renderEntity(graphics, (float)this.getX() + (float)this.getWidth() / 2.0f, this.getYCorner() + Math.min(this.getSelectableWidth(), this.getSelectableHeight()), (int)Math.min(this.getSelectableWidth(), this.getSelectableHeight()), f, new Vector3f(), new Quaternionf().rotationXYZ(0.0f, 0.7853982f, (float)Math.PI), null, entity, true);
        graphics.disableScissor();
    }

    public void renderSelection(GuiGraphics graphics, int i, int j, float f) {
        this.renderChild(graphics, this.getXCorner() - 4.5f, this.getYCorner() - 4.5f, () -> {
            graphics.pose().translate(0.0f, 0.0f, 332.0f);
            FactoryGuiGraphics.of((GuiGraphics)graphics).disableDepthTest();
            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(SELECT_ICON_HIGHLIGHT, 0, 0, 36, 36);
            FactoryGuiGraphics.of((GuiGraphics)graphics).enableDepthTest();
        });
    }

    public void renderScaled(GuiGraphics graphics, float x, float y, Runnable render) {
        this.renderChild(graphics, x, y, () -> {
            graphics.pose().scale(this.getSelectableWidth() / 16.0f, this.getSelectableHeight() / 16.0f, this.getSelectableHeight() / 16.0f);
            render.run();
        });
    }

    public void renderChild(GuiGraphics graphics, float x, float y, Runnable render) {
        graphics.pose().pushPose();
        graphics.pose().translate(x, y, 0.0f);
        this.applyOffset(graphics);
        render.run();
        graphics.pose().popPose();
    }

    public void renderHighlight(GuiGraphics graphics) {
        this.renderScaled(graphics, this.getX(), this.getY(), () -> {
            RenderSystem.enableBlend();
            FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(SLOT_HIGHLIGHT, 0, 0, 16, 16);
            RenderSystem.disableBlend();
        });
    }

    public void renderTooltip(Minecraft minecraft, GuiGraphics graphics, int i, int j) {
        if (this.isHovered || this.allowFocusedItemTooltip && this.isFocused()) {
            this.renderTooltip(minecraft, graphics, this.itemIcon, !this.isHovered ? (int)this.getMiddleX() : i, !this.isHovered ? (int)this.getMiddleY() : j);
        }
    }

    public void renderTooltip(Minecraft minecraft, GuiGraphics graphics, ItemStack stack, int i, int j) {
        if (!stack.isEmpty()) {
            Legacy4JClient.applyFontOverrideIf(ScreenUtil.is720p(), MOJANGLES_11_FONT, b -> graphics.renderTooltip(minecraft.font, stack, i, j));
        }
    }

    public boolean isHoveredOrFocused() {
        return this.isHovered || this.isFocused();
    }

    public void setFocused(boolean bl) {
        this.focused = bl;
    }

    public boolean keyPressed(int i, int j, int k) {
        if (CommonInputs.selected((int)i)) {
            this.onPress();
        }
        return false;
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (this.isMouseOver(d, e) && i == 0) {
            this.onClick(d, e);
            return !this.isFocused();
        }
        return false;
    }

    public void playClickSound() {
        if (!this.isFocused()) {
            ScreenUtil.playSimpleUISound((SoundEvent)SoundEvents.UI_BUTTON_CLICK.value(), 1.0f);
        }
    }

    public void onClick(double d, double e) {
        this.playClickSound();
        this.onPress();
    }

    public void onPress() {
    }

    public boolean isFocused() {
        return this.focused;
    }

    public NarratableEntry.NarrationPriority narrationPriority() {
        if (this.isFocused()) {
            return NarratableEntry.NarrationPriority.FOCUSED;
        }
        if (this.isHovered) {
            return NarratableEntry.NarrationPriority.HOVERED;
        }
        return NarratableEntry.NarrationPriority.NONE;
    }

    public boolean isMouseOver(double d, double e) {
        return this.isHovered;
    }

    public void updateNarration(NarrationElementOutput narrationElementOutput) {
    }

    public ComponentPath nextFocusPath(FocusNavigationEvent focusNavigationEvent) {
        return !this.isFocused() ? ComponentPath.leaf((GuiEventListener)this) : null;
    }

    public ScreenRectangle getRectangle() {
        return new ScreenRectangle((int)this.getXCorner(), (int)this.getYCorner(), this.getWidth(), this.getHeight());
    }

    public int getMinSize() {
        return Math.min(this.getWidth(), this.getHeight());
    }

    @Override
    @Nullable
    public Component getAction(ControlTooltip.ActionHolder.Context context) {
        return ControlTooltip.getSelectAction(this, context);
    }
}

