/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.navigation.ScreenDirection;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.recipebook.RecipeCollection;
import net.minecraft.client.gui.screens.recipebook.SearchRecipeBookCategory;
import net.minecraft.client.multiplayer.ClientPacketListener;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.recipebook.PlaceRecipeHelper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.context.ContextMap;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedItemContents;
import net.minecraft.world.inventory.AbstractCraftingMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.CraftingMenu;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ExtendedRecipeBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeBookCategories;
import net.minecraft.world.item.crafting.display.RecipeDisplay;
import net.minecraft.world.item.crafting.display.RecipeDisplayEntry;
import net.minecraft.world.item.crafting.display.ShapedCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.ShapelessCraftingRecipeDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplay;
import net.minecraft.world.item.crafting.display.SlotDisplayContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.base.client.UIDefinition;
import wily.factoryapi.util.PagedList;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyTipManager;
import wily.legacy.client.RecipeInfo;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyIconHolder;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.LegacyTabButton;
import wily.legacy.client.screen.RecipeIconHolder;
import wily.legacy.client.screen.ScrollableRenderer;
import wily.legacy.client.screen.TabList;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.inventory.RecipeMenu;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class MixedCraftingScreen<T extends AbstractCraftingMenu>
extends AbstractContainerScreen<T>
implements Controller.Event,
ControlTooltip.Event,
TabList.Access {
    private final Inventory inventory;
    protected final List<ItemStack> compactItemStackList = new ArrayList<ItemStack>();
    protected final StackedItemContents stackedContents = new StackedItemContents();
    private int timesInventoryChanged;
    private final boolean is2x2;
    private boolean onlyCraftableRecipes = false;
    protected Stocker.Sizeable infoType = new Stocker.Sizeable(Integer.valueOf(0), 2);
    protected final UIAccessor accessor = UIAccessor.of((Screen)this);
    protected final List<RecipeIconHolder<VanillaCrafting>> craftingButtons = new PagedList(new Stocker.Sizeable(Integer.valueOf(0), 0), () -> this.accessor.getInteger("maxCraftingButtonsCount", 12));
    protected List<List<RecipeInfo<VanillaCrafting>>> recipesByGroup = new ArrayList<List<RecipeInfo<VanillaCrafting>>>();
    protected final Stocker.Sizeable craftingButtonsOffset = new Stocker.Sizeable(Integer.valueOf(0));
    protected final TabList craftingTabList = new TabList().add(43, 0, LegacyTabButton.iconOf(LegacySprites.STRUCTURES), LegacyComponents.STRUCTURES, t -> this.resetElements()).add(43, 0, LegacyTabButton.iconOf(LegacySprites.MECHANISMS), LegacyComponents.MECHANISMS, t -> this.resetElements()).add(43, 0, LegacyTabButton.iconOf(LegacySprites.TOOLS), LegacyComponents.TOOLS_AND_ARMOUR, t -> this.resetElements()).add(43, 0, LegacyTabButton.iconOf(LegacySprites.MISC), LegacyComponents.MISC, t -> this.resetElements()).add(43, 0, LegacyTabButton.iconOf(LegacySprites.SEARCH), LegacyComponents.SEARCH_ITEMS, t -> this.enableSearchMode(true));
    protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    protected final ScrollableRenderer scrollableRenderer = new ScrollableRenderer();
    protected boolean allowRecipeDisplay = false;
    protected final EditBox searchBox;
    protected boolean searchMode;
    public static final ExtendedRecipeBookCategory[] VANILLA_CATEGORIES = new ExtendedRecipeBookCategory[]{RecipeBookCategories.CRAFTING_BUILDING_BLOCKS, RecipeBookCategories.CRAFTING_REDSTONE, RecipeBookCategories.CRAFTING_EQUIPMENT, RecipeBookCategories.CRAFTING_MISC, SearchRecipeBookCategory.CRAFTING};
    protected int selectedCraftingButton;

    public static MixedCraftingScreen<CraftingMenu> craftingScreen(CraftingMenu abstractContainerMenu, Inventory inventory, Component component) {
        return new MixedCraftingScreen<CraftingMenu>(abstractContainerMenu, inventory, component, false);
    }

    public static MixedCraftingScreen<InventoryMenu> playerCraftingScreen(Player player) {
        return new MixedCraftingScreen<InventoryMenu>(player.inventoryMenu, player.getInventory(), LegacyCraftingMenu.CRAFTING_TITLE, true);
    }

    public void enableSearchMode(boolean clearSearch) {
        this.searchMode = true;
        this.resetElements(true, clearSearch);
        this.setFocused((GuiEventListener)this.searchBox);
    }

    public void disableSearchMode() {
        this.searchMode = false;
        this.resetElements(true, false);
    }

    public MixedCraftingScreen(T abstractContainerMenu, Inventory inventory, Component component, boolean is2x2) {
        super(abstractContainerMenu, inventory, component);
        this.searchBox = new EditBox(Minecraft.getInstance().font, 0, 0, 200, 20, LegacyComponents.SEARCH_ITEMS);
        this.searchMode = false;
        this.inventory = inventory;
        this.is2x2 = is2x2;
        this.searchBox.setResponder(s -> this.updateStackedContents());
        this.searchBox.setMaxLength(50);
        this.resetElements(false, false);
        this.addCraftingButtons();
        this.accessor.getStaticDefinitions().add(UIDefinition.createBeforeInit(a -> this.accessor.putStaticElement("is2x2", (Object)is2x2)));
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        ControlTooltip.setupDefaultButtons(renderer, (Screen)this);
        ControlTooltip.Event.super.addControlTooltips(renderer);
        renderer.add(() -> ControlTooltip.EXTRA.get(), () -> LegacyComponents.INFO).add(() -> ControlTooltip.OPTION.get(), () -> this.onlyCraftableRecipes ? LegacyComponents.ALL_RECIPES : LegacyComponents.SHOW_CRAFTABLE_RECIPES).add(() -> this.searchMode ? (ControlTooltip.Icon)ControlTooltip.VERTICAL_NAVIGATION.get() : ControlTooltip.ComponentIcon.compoundOf(ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(340) : ControllerBinding.LEFT_STICK_BUTTON.getIcon(), ControlTooltip.PLUS_ICON, (ControlTooltip.ComponentIcon)ControlTooltip.OPTION.get()), () -> this.searchMode ? LegacyComponents.EXIT_SEARCH_MODE : LegacyComponents.SEARCH_MODE).addCompound(() -> new ControlTooltip.Icon[]{ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(91) : ControllerBinding.LEFT_BUMPER.getIcon(), ControlTooltip.SPACE_ICON, ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(93) : ControllerBinding.RIGHT_BUMPER.getIcon()}, () -> LegacyComponents.GROUP);
    }

    public void resetElements() {
        this.searchMode = false;
        this.resetElements(true, true);
    }

    public void resetElements(boolean reposition, boolean resetCrafting) {
        if (!resetCrafting || this.searchBox.getValue().isEmpty()) {
            this.updateStackedContents();
        } else {
            this.searchBox.setValue("");
        }
        this.selectedCraftingButton = 0;
        if (resetCrafting) {
            this.infoType.set(Integer.valueOf(0));
            this.craftingButtonsOffset.set(Integer.valueOf(0));
        }
        if (reposition) {
            this.repositionElements();
        }
    }

    public void setFocused(@Nullable GuiEventListener guiEventListener) {
        if (guiEventListener instanceof TabList) {
            return;
        }
        super.setFocused(guiEventListener);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        if (!this.searchMode) {
            Component title = this.getTabList() == this.craftingTabList ? this.getTabList().tabButtons.get(this.getTabList().selectedTab).getMessage() : CommonComponents.EMPTY;
            guiGraphics.drawString(this.font, title, (this.imageWidth - this.font.width((FormattedText)title)) / 2, 17, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        }
        int inventoryPanelX = this.accessor.getInteger("inventoryPanelX", 176);
        int inventoryPanelWidth = this.accessor.getInteger("inventoryPanelWidth", 163);
        if ((Integer)this.infoType.get() <= 0) {
            guiGraphics.drawString(this.font, this.playerInventoryTitle, inventoryPanelX + (inventoryPanelWidth - this.font.width((FormattedText)this.playerInventoryTitle)) / 2, this.accessor.getInteger("bottomPanelTitleY", 114), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        } else if (this.selectedCraftingButton < this.getCraftingButtons().size()) {
            RecipeIconHolder<VanillaCrafting> h = this.craftingButtons.get(this.selectedCraftingButton);
            if ((Integer)this.infoType.get() == 1 && LegacyTipManager.hasTip(h.getFocusedResult())) {
                List l = this.font.split((FormattedText)LegacyTipManager.getTipComponent(h.getFocusedResult()), inventoryPanelWidth - 11);
                this.scrollableRenderer.scrolled.max = Math.max(0, l.size() - 7);
                this.scrollableRenderer.render(guiGraphics, inventoryPanelX + 5, 105, inventoryPanelWidth - 11, 84, () -> {
                    for (int i1 = 0; i1 < l.size(); ++i1) {
                        guiGraphics.drawString(this.font, (FormattedCharSequence)l.get(i1), inventoryPanelX + 5, 108 + i1 * 12, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                    }
                });
            } else if ((Integer)this.infoType.get() == 2) {
                guiGraphics.drawString(this.font, LegacyComponents.INGREDIENTS, inventoryPanelX + (inventoryPanelWidth - this.font.width((FormattedText)LegacyComponents.INGREDIENTS)) / 2, 108, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                if (h.getFocusedRecipe() != null) {
                    this.compactItemStackList.clear();
                    RecipeMenu.handleCompactItemStackList(this.compactItemStackList, () -> h.getFocusedRecipe().getOptionalIngredients().stream().map(RecipeIconHolder::getActualItem).iterator());
                    this.scrollableRenderer.scrolled.max = Math.max(0, this.compactItemStackList.size() - 4);
                    this.scrollableRenderer.render(guiGraphics, inventoryPanelX + 2, 122, 152, 60, () -> {
                        for (int i1 = 0; i1 < this.compactItemStackList.size(); ++i1) {
                            ItemStack ing = this.compactItemStackList.get(i1);
                            ScreenUtil.iconHolderRenderer.itemHolder(inventoryPanelX + 4, 124 + 15 * i1, 14, 14, ing, false, Vec3.ZERO).render(guiGraphics, i, j, 0.0f);
                            guiGraphics.pose().pushPose();
                            guiGraphics.pose().translate((float)(inventoryPanelX + 22), (float)(128 + 15 * i1), 0.0f);
                            Legacy4JClient.applyFontOverrideIf(ScreenUtil.is720p(), LegacyIconHolder.MOJANGLES_11_FONT, b -> {
                                if (!b.booleanValue()) {
                                    guiGraphics.pose().scale(0.6666667f, 0.6666667f, 0.6666667f);
                                }
                                guiGraphics.drawString(this.font, ing.getHoverName(), 0, 0, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
                            });
                            guiGraphics.pose().popPose();
                        }
                    });
                }
            }
        }
        guiGraphics.pose().translate((float)(-this.leftPos), (float)(-this.topPos), 0.0f);
        this.getCraftingButtons().forEach(b -> b.render(guiGraphics, i, j, 0.0f));
        if (this.selectedCraftingButton < this.getCraftingButtons().size()) {
            this.getCraftingButtons().get(this.selectedCraftingButton).renderSelection(guiGraphics, i, j, 0.0f);
        }
        guiGraphics.pose().translate((float)this.leftPos, (float)this.topPos, 0.0f);
    }

    protected void containerTick() {
        super.containerTick();
        if (this.timesInventoryChanged != this.minecraft.player.getInventory().getTimesChanged()) {
            this.updateStackedContents();
            this.timesInventoryChanged = this.minecraft.player.getInventory().getTimesChanged();
        }
    }

    protected void slotClicked(Slot slot, int i, int j, ClickType clickType) {
        this.allowRecipeDisplay = false;
        super.slotClicked(slot, i, j, clickType);
        this.updateStackedContents();
    }

    private void updateStackedContents() {
        ClientPacketListener clientPacketListener;
        this.minecraft = Minecraft.getInstance();
        this.stackedContents.clear();
        this.inventory.fillStackedContents(this.stackedContents);
        ((AbstractCraftingMenu)this.menu).fillCraftSlotsStackedContents(this.stackedContents);
        List collections = Minecraft.getInstance().player.getRecipeBook().getCollection(VANILLA_CATEGORIES[this.getTabList().selectedTab]);
        this.allowRecipeDisplay = false;
        ContextMap context = SlotDisplayContext.fromLevel((Level)this.minecraft.level);
        this.allowRecipeDisplay = ((AbstractCraftingMenu)this.menu).getInputGridSlots().stream().noneMatch(Slot::hasItem);
        collections.forEach(collection -> collection.selectRecipes(this.stackedContents, d -> {
            RecipeDisplay recipeDisplay = d;
            Objects.requireNonNull(recipeDisplay);
            RecipeDisplay selector0$temp = recipeDisplay;
            int index$1 = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedCraftingRecipeDisplay.class, ShapelessCraftingRecipeDisplay.class}, (Object)selector0$temp, index$1)) {
                case 0 -> {
                    ShapedCraftingRecipeDisplay shapedCraftingRecipeDisplay = (ShapedCraftingRecipeDisplay)selector0$temp;
                    if (((AbstractCraftingMenu)this.menu).getGridWidth() >= shapedCraftingRecipeDisplay.width() && ((AbstractCraftingMenu)this.menu).getGridWidth() >= shapedCraftingRecipeDisplay.height()) {
                        yield true;
                    }
                    yield false;
                }
                case 1 -> {
                    ShapelessCraftingRecipeDisplay shapelessCraftingRecipeDisplay = (ShapelessCraftingRecipeDisplay)selector0$temp;
                    if (((AbstractCraftingMenu)this.menu).getGridWidth() * ((AbstractCraftingMenu)this.menu).getGridHeight() >= shapelessCraftingRecipeDisplay.ingredients().size()) {
                        yield true;
                    }
                    yield false;
                }
                default -> false;
            };
        }));
        this.recipesByGroup.clear();
        List searchCollections = null;
        if (!this.searchBox.getValue().isBlank() && (clientPacketListener = this.minecraft.getConnection()) != null) {
            searchCollections = clientPacketListener.searchTrees().recipes().search(this.searchBox.getValue().toLowerCase(Locale.ROOT));
        }
        for (final RecipeCollection collection2 : collections) {
            List selectedRecipes;
            if (!collection2.hasAnySelected() || searchCollections != null && !searchCollections.contains(collection2) || (selectedRecipes = collection2.getSelectedRecipes(this.onlyCraftableRecipes ? RecipeCollection.CraftableStatus.CRAFTABLE : RecipeCollection.CraftableStatus.ANY)).isEmpty()) continue;
            this.recipesByGroup.add(selectedRecipes.stream().map(e -> {
                final ArrayList ings = new ArrayList(Collections.nCopies(((AbstractCraftingMenu)this.menu).getGridWidth() * ((AbstractCraftingMenu)this.menu).getGridHeight(), Optional.empty()));
                boolean[] warningSlots = new boolean[((AbstractCraftingMenu)this.menu).getGridWidth() * ((AbstractCraftingMenu)this.menu).getGridHeight()];
                final ArrayList<List<ItemStack>> displays = new ArrayList<List<ItemStack>>(Collections.nCopies(((AbstractCraftingMenu)this.menu).getGridWidth() * ((AbstractCraftingMenu)this.menu).getGridHeight(), Collections.singletonList(ItemStack.EMPTY)));
                RecipeDisplay recipeDisplay = e.display();
                Objects.requireNonNull(recipeDisplay);
                RecipeDisplay selector0$temp = recipeDisplay;
                int index$1 = 0;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ShapedCraftingRecipeDisplay.class, ShapelessCraftingRecipeDisplay.class}, (Object)selector0$temp, index$1)) {
                    case 0: {
                        ShapedCraftingRecipeDisplay shapedCraftingRecipeDisplay = (ShapedCraftingRecipeDisplay)selector0$temp;
                        PlaceRecipeHelper.placeRecipe((int)((AbstractCraftingMenu)this.menu).getGridWidth(), (int)((AbstractCraftingMenu)this.menu).getGridHeight(), (int)shapedCraftingRecipeDisplay.width(), (int)shapedCraftingRecipeDisplay.height(), (Iterable)shapedCraftingRecipeDisplay.ingredients(), (slotDisplay, ix, jx, k) -> displays.set(ix, slotDisplay.resolveForStacks(context)));
                        break;
                    }
                    case 1: {
                        ShapelessCraftingRecipeDisplay shapelessCraftingRecipeDisplay = (ShapelessCraftingRecipeDisplay)selector0$temp;
                        for (int index = 0; index < shapelessCraftingRecipeDisplay.ingredients().size(); ++index) {
                            displays.set(index, ((SlotDisplay)shapelessCraftingRecipeDisplay.ingredients().get(index)).resolveForStacks(context));
                        }
                        break;
                    }
                }
                e.craftingRequirements().ifPresent(ingredients -> {
                    for (int index = 0; index < ingredients.size(); ++index) {
                        ings.set(index, Optional.of((Ingredient)ingredients.get(index)));
                    }
                });
                if (this.allowRecipeDisplay) {
                    this.compactItemStackList.clear();
                    RecipeMenu.handleCompactInventoryList(this.compactItemStackList, this.inventory, ItemStack.EMPTY);
                    block5: for (int i = 0; i < displays.size(); ++i) {
                        List stacks = (List)displays.get(i);
                        if (stacks.isEmpty() || ((ItemStack)stacks.get(0)).isEmpty()) {
                            warningSlots[i] = false;
                            continue;
                        }
                        for (ItemStack itemStack : this.compactItemStackList) {
                            if (!stacks.stream().anyMatch(item -> item.is(itemStack.getItem()))) continue;
                            warningSlots[i] = false;
                            itemStack.shrink(1);
                            continue block5;
                        }
                        warningSlots[i] = true;
                    }
                }
                final VanillaCrafting crafting = new VanillaCrafting(){
                    final /* synthetic */ RecipeDisplayEntry val$e;
                    final /* synthetic */ boolean[] val$warningSlots;
                    {
                        this.val$e = recipeDisplayEntry;
                        this.val$warningSlots = blArray;
                    }

                    @Override
                    public ItemStack getItemFromGrid(int index) {
                        List items = (List)displays.get(index);
                        if (items.isEmpty()) {
                            return ItemStack.EMPTY;
                        }
                        return (ItemStack)items.get((int)(Util.getMillis() / 800L % (long)items.size()));
                    }

                    @Override
                    public boolean canCraft() {
                        return collection2.isCraftable(this.val$e.id());
                    }

                    @Override
                    public void craft() {
                        ((MixedCraftingScreen)MixedCraftingScreen.this).minecraft.gameMode.handlePlaceRecipe(((MixedCraftingScreen)MixedCraftingScreen.this).minecraft.player.containerMenu.containerId, this.val$e.id(), Screen.hasShiftDown());
                    }

                    @Override
                    public boolean isWarning(int index) {
                        return this.val$warningSlots[index];
                    }
                };
                final List resultDisplay = e.resultItems(context);
                RecipeInfo<VanillaCrafting> info = new RecipeInfo<VanillaCrafting>(this){

                    public VanillaCrafting get() {
                        return crafting;
                    }

                    public ResourceLocation getId() {
                        return null;
                    }

                    @Override
                    public List<Optional<Ingredient>> getOptionalIngredients() {
                        return ings;
                    }

                    @Override
                    public ItemStack getResultItem() {
                        return resultDisplay.size() == 1 ? (ItemStack)resultDisplay.get(0) : (ItemStack)resultDisplay.get((int)(Util.getMillis() / 800L % (long)resultDisplay.size()));
                    }

                    @Override
                    public Component getName() {
                        return this.getResultItem().getHoverName();
                    }

                    @Override
                    public Component getDescription() {
                        return null;
                    }
                };
                return info;
            }).toList());
        }
        this.craftingButtonsOffset.max = Math.max(0, this.recipesByGroup.size() - 12);
    }

    protected boolean isInventoryActive() {
        return (Integer)this.infoType.get() <= 0;
    }

    protected void init() {
        this.imageWidth = 349;
        this.imageHeight = 215;
        super.init();
        this.topPos += 18;
        for (int i2 = 0; i2 < ((AbstractCraftingMenu)this.menu).slots.size(); ++i2) {
            final Slot s = (Slot)((AbstractCraftingMenu)this.menu).slots.get(i2);
            if (i2 == 0) {
                LegacySlotDisplay.override(s, 123, 151, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return 36;
                    }

                    @Override
                    public ItemStack getItemOverride() {
                        RecipeIconHolder<VanillaCrafting> recipeIconHolder;
                        if (MixedCraftingScreen.this.allowRecipeDisplay && (recipeIconHolder = MixedCraftingScreen.this.craftingButtons.get(MixedCraftingScreen.this.selectedCraftingButton)).isValidIndex()) {
                            return recipeIconHolder.getFocusedResult();
                        }
                        return LegacySlotDisplay.super.getItemOverride();
                    }

                    @Override
                    public boolean isWarning() {
                        RecipeIconHolder<VanillaCrafting> recipeIconHolder;
                        if (MixedCraftingScreen.this.allowRecipeDisplay && (recipeIconHolder = MixedCraftingScreen.this.craftingButtons.get(MixedCraftingScreen.this.selectedCraftingButton)).isValidIndex()) {
                            return !recipeIconHolder.canCraft();
                        }
                        return LegacySlotDisplay.super.isWarning();
                    }
                });
                continue;
            }
            if (i2 < (this.is2x2 ? 5 : 10)) {
                LegacySlotDisplay.override(s, 21 + s.getContainerSlot() % ((AbstractCraftingMenu)this.menu).getGridWidth() * 23, (this.is2x2 ? 145 : 133) + s.getContainerSlot() / ((AbstractCraftingMenu)this.menu).getGridHeight() * 23, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return 23;
                    }

                    @Override
                    public ItemStack getItemOverride() {
                        RecipeIconHolder<VanillaCrafting> recipeIconHolder;
                        if (MixedCraftingScreen.this.allowRecipeDisplay && (recipeIconHolder = MixedCraftingScreen.this.craftingButtons.get(MixedCraftingScreen.this.selectedCraftingButton)).isValidIndex()) {
                            return ((VanillaCrafting)recipeIconHolder.getFocusedRecipe().get()).getItemFromGrid(s.getContainerSlot());
                        }
                        return LegacySlotDisplay.super.getItemOverride();
                    }

                    @Override
                    public boolean isWarning() {
                        RecipeIconHolder<VanillaCrafting> recipeIconHolder;
                        if (MixedCraftingScreen.this.allowRecipeDisplay && (recipeIconHolder = MixedCraftingScreen.this.craftingButtons.get(MixedCraftingScreen.this.selectedCraftingButton)).isValidIndex()) {
                            return ((VanillaCrafting)recipeIconHolder.getFocusedRecipe().get()).isWarning(s.getContainerSlot());
                        }
                        return LegacySlotDisplay.super.isWarning();
                    }
                });
                continue;
            }
            if (this.is2x2 && (i2 < 9 || i2 == ((AbstractCraftingMenu)this.menu).slots.size() - 1)) {
                LegacySlotDisplay.override(s, new LegacySlotDisplay(this){

                    @Override
                    public boolean isVisible() {
                        return false;
                    }
                });
                continue;
            }
            if (i2 < ((AbstractCraftingMenu)this.menu).slots.size() - (this.is2x2 ? 10 : 9)) {
                LegacySlotDisplay.override(s, 186 + (s.getContainerSlot() - 9) % 9 * 16, 133 + (s.getContainerSlot() - 9) / 9 * 16, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return 16;
                    }

                    @Override
                    public boolean isVisible() {
                        return MixedCraftingScreen.this.isInventoryActive();
                    }
                });
                continue;
            }
            if (i2 >= ((AbstractCraftingMenu)this.menu).slots.size() - (this.is2x2 ? 1 : 0)) continue;
            LegacySlotDisplay.override(s, 186 + s.getContainerSlot() * 16, 186, new LegacySlotDisplay(){

                @Override
                public int getWidth() {
                    return 16;
                }

                @Override
                public boolean isVisible() {
                    return MixedCraftingScreen.this.isInventoryActive();
                }
            });
        }
        if (this.searchMode) {
            this.searchBox.setPosition(this.leftPos + (this.imageWidth - this.searchBox.getWidth()) / 2, this.topPos + 11);
            this.addRenderableWidget((GuiEventListener)this.searchBox);
        }
        if (this.selectedCraftingButton < this.getCraftingButtons().size() && !this.searchMode) {
            this.setFocused(this.getCraftingButtons().get(this.selectedCraftingButton));
        }
        this.getCraftingButtons().forEach(b -> {
            b.setPos(this.leftPos + this.accessor.getInteger("craftingButtonsX", 13) + this.getCraftingButtons().indexOf(b) * 27, this.topPos + 38);
            this.addWidget((GuiEventListener)b);
        });
        this.addWidget(this.getTabList());
        this.getTabList().init(this.leftPos, this.topPos - 37, this.imageWidth, (t, i) -> {
            int index = this.getTabList().tabButtons.indexOf(t);
            t.type = index == 0 ? 0 : (index >= this.getMaxTabCount() ? 2 : 1);
            t.setWidth(this.accessor.getInteger("tabListButtonWidth", 71));
            t.offset = t1 -> new Vec3(this.accessor.getDouble("tabListXOffset", -1.5) * (double)this.getTabList().tabButtons.indexOf(t), t1.selected ? 0.0 : this.accessor.getDouble("tabListSelectedYOffset", 4.5), 0.0);
        });
    }

    @Override
    public TabList getTabList() {
        return this.craftingTabList;
    }

    protected int getMaxTabCount() {
        return this.accessor.getInteger("maxTabCount", 4);
    }

    protected void addCraftingButtons() {
        for (int i = 0; i < 12; ++i) {
            final int index = i;
            RecipeIconHolder<VanillaCrafting> h = new RecipeIconHolder<VanillaCrafting>(this.leftPos + 13 + i * 27, this.topPos + 38){

                @Override
                public void render(GuiGraphics graphics, int i, int j, float f) {
                    if (this.isFocused()) {
                        MixedCraftingScreen.this.selectedCraftingButton = index;
                    }
                    super.render(graphics, i, j, f);
                }

                @Override
                protected boolean canCraft(RecipeInfo<VanillaCrafting> rcp) {
                    return rcp == null || ((VanillaCrafting)rcp.get()).canCraft();
                }

                @Override
                protected List<RecipeInfo<VanillaCrafting>> getRecipes() {
                    return MixedCraftingScreen.this.recipesByGroup.size() <= (Integer)MixedCraftingScreen.this.craftingButtonsOffset.get() + index ? Collections.emptyList() : MixedCraftingScreen.this.recipesByGroup.get((Integer)MixedCraftingScreen.this.craftingButtonsOffset.get() + index);
                }

                @Override
                protected void toggleCraftableRecipes() {
                    if (Screen.hasShiftDown() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed) {
                        return;
                    }
                    MixedCraftingScreen.this.onlyCraftableRecipes = !MixedCraftingScreen.this.onlyCraftableRecipes;
                    MixedCraftingScreen.this.updateStackedContents();
                }

                @Override
                public boolean keyPressed(int i, int j, int k) {
                    if (this.controlCyclicNavigation(i, index, MixedCraftingScreen.this.craftingButtons, MixedCraftingScreen.this.craftingButtonsOffset, MixedCraftingScreen.this.scrollRenderer, (Screen)MixedCraftingScreen.this)) {
                        return true;
                    }
                    if (i == 88) {
                        MixedCraftingScreen.this.infoType.add(1, true);
                        ScreenUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), true);
                        return true;
                    }
                    return super.keyPressed(i, j, k);
                }

                @Override
                protected void updateRecipeDisplay(RecipeInfo<VanillaCrafting> rcp) {
                    MixedCraftingScreen.this.scrollableRenderer.scrolled.set(Integer.valueOf(0));
                }

                @Override
                public void craft() {
                    ScreenUtil.playSimpleUISound(SoundEvents.ITEM_PICKUP, 1.0f);
                    ((VanillaCrafting)this.getFocusedRecipe().get()).craft();
                    MixedCraftingScreen.this.slotClicked(((AbstractCraftingMenu)MixedCraftingScreen.this.menu).getResultSlot(), ((AbstractCraftingMenu)((MixedCraftingScreen)MixedCraftingScreen.this).menu).getResultSlot().index, 0, ClickType.QUICK_MOVE);
                }
            };
            this.getCraftingButtons().add(h);
            h.offset = LegacyCraftingMenu.DEFAULT_INVENTORY_OFFSET;
        }
    }

    public boolean mouseScrolled(double d, double e, double f, double g) {
        if (this.getChildAt(d, e).filter(guiEventListener -> guiEventListener.mouseScrolled(d, e, f, g)).isPresent()) {
            return true;
        }
        if (super.mouseScrolled(d, e, f, g)) {
            return true;
        }
        if (this.scrollableRenderer.mouseScrolled(g)) {
            return true;
        }
        int scroll = (int)Math.signum(g);
        if (((Integer)this.craftingButtonsOffset.get() > 0 && scroll < 0 || scroll > 0 && this.craftingButtonsOffset.max > 0) && this.craftingButtonsOffset.add(scroll, false) != 0) {
            this.repositionElements();
            return true;
        }
        return false;
    }

    public boolean mouseClicked(double d, double e, int i) {
        if (this.searchBox.isFocused() && this.searchMode && !this.searchBox.isMouseOver(d, e)) {
            this.disableSearchMode();
        }
        return super.mouseClicked(d, e, i);
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    protected void renderBg(GuiGraphics guiGraphics, float f, int i, int j) {
        this.getTabList().render(guiGraphics, i, j, f);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite((ResourceLocation)this.accessor.getElementValue("imageSprite", (Object)LegacySprites.SMALL_PANEL, ResourceLocation.class), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        int panelWidth = this.accessor.getInteger("craftingGridPanelWidth", 163);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + 9, this.topPos + 103, panelWidth, 105);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + this.accessor.getInteger("inventoryPanelX", 176), this.topPos + this.accessor.getInteger("inventoryPanelY", 103), this.accessor.getInteger("inventoryPanelWidth", 163), 105);
        int contentsWidth = (this.is2x2 ? 2 : 3) * 23 + 69;
        int xDiff = this.leftPos + 9 + (panelWidth - contentsWidth) / 2;
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SMALL_ARROW, xDiff + (this.is2x2 ? 2 : 3) * 23 + 8, this.topPos + 161, 16, 13);
        if ((Integer)this.craftingButtonsOffset.get() > 0) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.LEFT, this.leftPos + 5, this.topPos + 45);
        }
        if (this.craftingButtonsOffset.max > 0 && (Integer)this.craftingButtonsOffset.get() < this.craftingButtonsOffset.max) {
            this.scrollRenderer.renderScroll(guiGraphics, ScreenDirection.RIGHT, this.leftPos + this.imageWidth - 11, this.topPos + 45);
        }
    }

    @Override
    public boolean disableCursorOnInit() {
        return true;
    }

    @Override
    public boolean onceClickBindings() {
        return false;
    }

    public boolean keyPressed(int i, int j, int k) {
        if (this.searchMode && (i == 265 || i == 264)) {
            this.disableSearchMode();
            return true;
        }
        if (this.getTabList().controlTab(i)) {
            return true;
        }
        if (i != 256 && this.searchBox.isFocused()) {
            return this.searchBox.keyPressed(i, j, k);
        }
        return super.keyPressed(i, j, k);
    }

    public boolean keyReleased(int i, int j, int k) {
        if (!this.searchBox.isFocused() && !this.searchMode && i == 79 && (MixedCraftingScreen.hasShiftDown() || ControllerBinding.LEFT_STICK_BUTTON.state().pressed)) {
            this.enableSearchMode(false);
            return true;
        }
        return super.keyReleased(i, j, k);
    }

    public List<RecipeIconHolder<VanillaCrafting>> getCraftingButtons() {
        return this.craftingButtons;
    }

    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBackground(guiGraphics, i, j, f);
        super.render(guiGraphics, i, j, f);
        int panelWidth = this.accessor.getInteger("craftingGridPanelWidth", 163);
        ItemStack resultStack = this.craftingButtons.get(this.selectedCraftingButton).getFocusedResult();
        if (!resultStack.isEmpty() && this.allowRecipeDisplay) {
            Component resultName = this.getCraftingButtons().get(this.selectedCraftingButton).getFocusedRecipe().getName();
            Component description = this.getCraftingButtons().get(this.selectedCraftingButton).getFocusedRecipe().getDescription();
            int titleY = this.accessor.getInteger("bottomPanelTitleY", 114) - (description == null ? 0 : 6);
            ScreenUtil.renderScrollingString(guiGraphics, this.font, resultName, this.leftPos + 11 + Math.max(panelWidth - this.font.width((FormattedText)resultName), 0) / 2, this.topPos + titleY, this.leftPos + 7 + panelWidth, this.topPos + titleY + 11, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false);
            if (description != null) {
                ScreenUtil.renderScrollingString(guiGraphics, this.font, (Component)description.copy().setStyle(Style.EMPTY), this.leftPos + 11 + Math.max(panelWidth - this.font.width((FormattedText)description), 0) / 2, this.topPos + titleY + 12, this.leftPos + 7 + panelWidth, this.topPos + titleY + 23, (int)((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()), false);
            }
        }
        this.getCraftingButtons().forEach(h -> h.renderTooltip(this.minecraft, guiGraphics, i, j));
        this.renderTooltip(guiGraphics, i, j);
    }

    public static interface VanillaCrafting {
        public ItemStack getItemFromGrid(int var1);

        public boolean canCraft();

        public void craft();

        public boolean isWarning(int var1);
    }
}

