/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen.compat;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import com.mojang.blaze3d.platform.NativeImage;
import io.github.gaming32.worldhost.FriendsListUpdate;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.plugin.OnlineFriend;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractButton;
import net.minecraft.client.gui.components.PlayerFaceRenderer;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.FaviconTexture;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.resources.PlayerSkin;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.status.ServerStatus;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.screen.JoinGameScreen;
import wily.legacy.client.screen.ServerRenderableList;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

public class FriendsServerRenderableList
extends ServerRenderableList {
    boolean ping = false;
    protected final FriendsListUpdate friendsListUpdate = friends -> this.updateServers();

    public FriendsServerRenderableList(UIAccessor accessor) {
        super(accessor);
    }

    @Override
    public void added() {
        WorldHost.ONLINE_FRIEND_UPDATES.add(this.friendsListUpdate);
    }

    @Override
    public void removed() {
        super.removed();
        WorldHost.ONLINE_FRIEND_UPDATES.remove(this.friendsListUpdate);
    }

    @Override
    public boolean hasOnlineFriends() {
        return !WorldHost.ONLINE_FRIENDS.isEmpty();
    }

    @Override
    public void updateLANServers() {
        if (!this.ping) {
            WorldHost.pingFriends();
            this.ping = true;
        }
        super.updateLANServers();
        Util.backgroundExecutor().execute(() -> {
            WorldHost.ONLINE_FRIENDS.forEach((uuid, id) -> {
                final GameProfile profile = WorldHost.fetchProfile((MinecraftSessionService)this.minecraft.getMinecraftSessionService(), (UUID)uuid);
                AbstractButton onlineButton = new AbstractButton(0, 0, 270, 30, (Component)Component.literal((String)profile.getName()), (OnlineFriend)id){
                    final ServerData serverData;
                    final FaviconTexture icon;
                    private byte @Nullable [] lastIconBytes;
                    final /* synthetic */ OnlineFriend val$id;
                    {
                        this.val$id = onlineFriend;
                        super(i, j, k, l, arg);
                        this.serverData = new ServerData("", "", ServerData.Type.OTHER);
                        this.icon = FaviconTexture.forServer((TextureManager)FriendsServerRenderableList.this.minecraft.getTextureManager(), (String)this.serverData.ip);
                    }

                    private boolean uploadServerIcon(@Nullable byte[] bs) {
                        if (bs == null) {
                            this.icon.clear();
                        } else {
                            try {
                                this.icon.upload(NativeImage.read((byte[])bs));
                            }
                            catch (Throwable throwable) {
                                LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.name, this.serverData.ip, throwable});
                                return false;
                            }
                        }
                        return true;
                    }

                    protected void renderScrollingString(GuiGraphics guiGraphics, Font font, int i, int j) {
                        ScreenUtil.renderScrollingString(guiGraphics, font, this.getMessage(), this.getX() + 35, this.getY(), this.getX() + this.getWidth(), this.getY() + this.getHeight(), j, true);
                    }

                    protected void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float f) {
                        super.renderWidget(guiGraphics, mouseX, mouseY, f);
                        this.updateServerInfo();
                        byte[] bs = this.serverData.getIconBytes();
                        if (!Arrays.equals(bs, this.lastIconBytes)) {
                            if (this.uploadServerIcon(bs)) {
                                this.lastIconBytes = bs;
                            } else {
                                this.serverData.setIconBytes(null);
                            }
                        }
                        if (this.serverData.getIconBytes() == null) {
                            PlayerFaceRenderer.draw((GuiGraphics)guiGraphics, (PlayerSkin)FriendsServerRenderableList.this.minecraft.getSkinManager().getInsecureSkin(profile), (int)(this.getX() + 5), (int)(this.getY() + 5), (int)20);
                        } else {
                            ServerRenderableList.drawIcon(guiGraphics, this.getX(), this.getY(), this.icon.textureLocation());
                        }
                        if (((Boolean)((FriendsServerRenderableList)FriendsServerRenderableList.this).minecraft.options.touchscreen().get()).booleanValue() || this.isHovered) {
                            guiGraphics.fill(this.getX() + 5, this.getY() + 5, this.getX() + 25, this.getY() + 25, -1601138544);
                            int u = mouseX - this.getX();
                            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(u < 30 && u > 5 ? LegacySprites.JOIN_HIGHLIGHTED : LegacySprites.JOIN, this.getX(), this.getY(), 32, 32);
                        }
                    }

                    public void onPress() {
                        if (this.isFocused()) {
                            FriendsServerRenderableList.this.minecraft.setScreen((Screen)new JoinGameScreen(FriendsServerRenderableList.this.getScreen(), this.serverData, b -> {
                                WorldHost.LOGGER.info("Requesting to join {}", (Object)profile.getId());
                                if (WorldHost.protoClient != null) {
                                    this.val$id.joinWorld(FriendsServerRenderableList.this.getScreen());
                                }
                            }));
                        }
                    }

                    private void updateServerInfo() {
                        this.serverData.name = profile.getName();
                        ServerStatus metadata = (ServerStatus)WorldHost.ONLINE_FRIEND_PINGS.get(profile.getId());
                        if (metadata == null) {
                            this.serverData.status = Component.empty();
                            this.serverData.motd = Component.empty();
                            return;
                        }
                        this.serverData.motd = metadata.description();
                        metadata.version().ifPresentOrElse(version -> {
                            this.serverData.version = Component.literal((String)version.name());
                            this.serverData.protocol = version.protocol();
                        }, () -> {
                            this.serverData.version = Component.translatable((String)"multiplayer.status.old");
                            this.serverData.protocol = 0;
                        });
                        metadata.players().ifPresentOrElse(players -> {
                            this.serverData.status = Component.translatable((String)"multiplayer.status.player_count", (Object[])new Object[]{Component.literal((String)("" + players.online())).withStyle(ChatFormatting.GRAY), Component.literal((String)("" + players.max())).withStyle(ChatFormatting.GRAY)}).withStyle(ChatFormatting.DARK_GRAY);
                            this.serverData.players = players;
                            if (!players.sample().isEmpty()) {
                                ArrayList<MutableComponent> playerList = new ArrayList<MutableComponent>(players.sample().size());
                                for (GameProfile gameProfile : players.sample()) {
                                    playerList.add(Component.literal((String)gameProfile.getName()));
                                }
                                if (players.sample().size() < players.online()) {
                                    playerList.add(Component.translatable((String)"multiplayer.status.and_more", (Object[])new Object[]{players.online() - players.sample().size()}));
                                }
                                this.serverData.playerList = playerList;
                            } else {
                                this.serverData.playerList = List.of();
                            }
                        }, () -> {
                            this.serverData.status = Component.translatable((String)"multiplayer.status.unknown").withStyle(ChatFormatting.DARK_GRAY);
                        });
                        metadata.favicon().ifPresent(favicon -> {
                            if (!Arrays.equals(favicon.iconBytes(), this.serverData.getIconBytes())) {
                                this.serverData.setIconBytes(favicon.iconBytes());
                            }
                        });
                    }

                    protected void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
                        this.defaultButtonNarrationText(narrationElementOutput);
                    }
                };
                this.addRenderable((Renderable)onlineButton);
                if (this.accessor.getChildren().contains(onlineButton)) {
                    this.minecraft.getNarrator().say((Component)Component.translatable((String)"multiplayer.lan.server_found", (Object[])new Object[]{onlineButton.getMessage()}));
                }
            });
            if (!WorldHost.ONLINE_FRIENDS.isEmpty()) {
                this.accessor.reloadUI();
            }
        });
    }
}

