/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.inventory;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.stats.Stats;
import net.minecraft.world.Container;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.npc.ClientSideMerchant;
import net.minecraft.world.entity.npc.Villager;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.trading.Merchant;
import net.minecraft.world.item.trading.MerchantOffer;
import net.minecraft.world.item.trading.MerchantOffers;
import wily.factoryapi.base.StackIngredient;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.inventory.LegacyCraftingMenu;
import wily.legacy.network.ServerMenuCraftPayload;

public class LegacyMerchantMenu
extends LegacyCraftingMenu {
    public final Merchant merchant;
    public int merchantLevel;
    public boolean showProgressBar;

    public LegacyMerchantMenu(int i, Inventory inventory) {
        this(i, inventory, (Merchant)new ClientSideMerchant(inventory.player));
    }

    public LegacyMerchantMenu(int i, Inventory inventory, Merchant merchant) {
        super((MenuType)LegacyRegistries.MERCHANT_MENU.get(), i, (Player p) -> merchant.getTradingPlayer() == p);
        this.addInventorySlotGrid((Container)inventory, 9, 133, 98, 3);
        this.addInventorySlotGrid((Container)inventory, 0, 133, 154, 1);
        this.merchant = merchant;
    }

    public static List<Optional<Ingredient>> ingredientsFromStacks(ItemStack ... s) {
        return Arrays.stream(s).map(i -> i.isEmpty() ? Optional.empty() : Optional.of(StackIngredient.of((boolean)true, (ItemStack)i))).toList();
    }

    @Override
    public boolean canCraft(List<Optional<Ingredient>> ingredients, Player player, ServerMenuCraftPayload packet) {
        return packet.button() >= 0 && packet.button() < this.merchant.getOffers().size() && !this.merchant.getOffers().isEmpty() && !((MerchantOffer)this.merchant.getOffers().get(packet.button())).isOutOfStock() && super.canCraft(ingredients, player, packet);
    }

    @Override
    public void onCraft(Player player, ServerMenuCraftPayload packet, ItemStack result) {
        int n;
        super.onCraft(player, packet, result);
        MerchantOffer offer = (MerchantOffer)this.merchant.getOffers().get(packet.button());
        offer.getResult().onCraftedBy(player.level(), player, offer.getResult().getCount());
        Merchant merchant = this.merchant;
        if (merchant instanceof LivingEntity) {
            LivingEntity e = (LivingEntity)merchant;
            e.playSound(this.merchant.getNotifyTradeSound(), 1.0f, e.getVoicePitch());
        }
        this.merchant.notifyTrade(offer);
        player.awardStat(Stats.TRADED_WITH_VILLAGER);
        this.merchant.overrideXp(this.merchant.getVillagerXp() + offer.getXp());
        MerchantOffers merchantOffers = this.merchant.getOffers();
        merchant = this.merchant;
        if (merchant instanceof Villager) {
            Villager v = (Villager)merchant;
            n = v.getVillagerData().getLevel();
        } else {
            n = 0;
        }
        player.sendMerchantOffers(this.containerId, merchantOffers, n, this.merchant.getVillagerXp(), this.merchant.showProgressBar(), this.merchant.canRestock());
    }

    public void removed(Player player) {
        super.removed(player);
        this.merchant.setTradingPlayer(null);
    }

    @Override
    public ItemStack getResult(Player player, ServerMenuCraftPayload packet) {
        if (player instanceof ServerPlayer && packet.button() >= 0 && packet.button() < this.merchant.getOffers().size() && !this.merchant.getOffers().isEmpty()) {
            return ((MerchantOffer)this.merchant.getOffers().get(packet.button())).getResult();
        }
        return ItemStack.EMPTY;
    }

    @Override
    public List<Optional<Ingredient>> getIngredients(Player player, ServerMenuCraftPayload packet) {
        if (player instanceof ServerPlayer && packet.button() >= 0 && packet.button() < this.merchant.getOffers().size() && !this.merchant.getOffers().isEmpty()) {
            return LegacyMerchantMenu.ingredientsFromStacks(((MerchantOffer)this.merchant.getOffers().get(packet.button())).getCostA(), ((MerchantOffer)this.merchant.getOffers().get(packet.button())).getCostB());
        }
        return super.getIngredients(player, packet);
    }
}

