/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import com.mojang.blaze3d.font.GlyphProvider;
import com.mojang.blaze3d.platform.NativeImage;
import java.io.IOException;
import java.io.InputStream;
import net.minecraft.client.gui.font.CodepointMap;
import net.minecraft.client.gui.font.providers.BitmapProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.Legacy4J;

@Mixin(value={BitmapProvider.Definition.class})
public abstract class BitmapProviderMixin {
    @Shadow
    @Final
    private int[][] codepointGrid;
    @Shadow
    @Final
    private int ascent;
    @Shadow
    @Final
    private int height;
    @Shadow
    @Final
    private ResourceLocation file;

    @Shadow
    protected abstract int getActualGlyphWidth(NativeImage var1, int var2, int var3, int var4, int var5);

    @Inject(method={"load"}, at={@At(value="HEAD")}, cancellable=true)
    private void load(ResourceManager resourceManager, CallbackInfoReturnable<GlyphProvider> cir) throws IOException {
        BitmapProvider var22;
        ResourceLocation resourceLocation = this.file.withPrefix("textures/");
        InputStream inputStream = resourceManager.open(resourceLocation);
        try {
            NativeImage nativeImage = NativeImage.read((NativeImage.Format)NativeImage.Format.RGBA, (InputStream)inputStream);
            int i = nativeImage.getWidth();
            int j = nativeImage.getHeight();
            int k = i / this.codepointGrid[0].length;
            int l = j / this.codepointGrid.length;
            final float f = (float)this.height / (float)l;
            CodepointMap codepointMap = new CodepointMap(BitmapProvider.Glyph[]::new, x$0 -> new BitmapProvider.Glyph[x$0][]);
            int m = 0;
            while (true) {
                int[] var13;
                if (m >= this.codepointGrid.length) {
                    var22 = new BitmapProvider(nativeImage, codepointMap);
                    break;
                }
                int n = 0;
                for (int o : var13 = this.codepointGrid[m]) {
                    int q;
                    BitmapProvider.Glyph glyph;
                    int p = n++;
                    if (o == 0 || (glyph = (BitmapProvider.Glyph)codepointMap.put(o, (Object)new BitmapProvider.Glyph(this, f, nativeImage, p * k, m * l, k, l, (int)(0.5 + (double)((float)(q = this.getActualGlyphWidth(nativeImage, k, l, p, m)) * f)) + 1, this.ascent){

                        public float getAdvance() {
                            return (float)(q + 1) * f;
                        }
                    })) == null) continue;
                    Legacy4J.LOGGER.warn("Codepoint '{}' declared multiple times in {}", (Object)Integer.toHexString(o), (Object)resourceLocation);
                }
                ++m;
            }
        }
        catch (Throwable var21) {
            try {
                inputStream.close();
            }
            catch (Throwable var20) {
                var21.addSuppressed(var20);
            }
            cir.setReturnValue(null);
            throw var21;
        }
        inputStream.close();
        cir.setReturnValue((Object)var22);
    }
}

