/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import java.util.List;
import net.minecraft.Util;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Renderable;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.DeathScreen;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.util.Mth;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.legacy.client.CommonColor;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.ExitConfirmationScreen;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.ScreenUtil;

@Mixin(value={DeathScreen.class})
public abstract class DeathScreenMixin
extends Screen
implements ControlTooltip.Event {
    @Shadow
    @Final
    public boolean hardcore;
    @Shadow
    @Final
    public Component causeOfDeath;
    @Shadow
    @Nullable
    private Button exitToTitleButton;
    @Shadow
    @Final
    private List<Button> exitButtons;
    @Shadow
    private int delayTicker;
    private long screenInit = Util.getMillis();

    @Shadow
    @Nullable
    protected abstract Style getClickedComponentStyleAt(int var1);

    @Shadow
    protected abstract void handleExitToTitleScreen();

    @Shadow
    protected abstract void setButtonsActive(boolean var1);

    protected DeathScreenMixin(Component component) {
        super(component);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    protected void init(CallbackInfo ci) {
        ci.cancel();
        this.delayTicker = 0;
        this.exitButtons.clear();
        MutableComponent component = this.hardcore ? Component.translatable((String)"deathScreen.spectate") : Component.translatable((String)"deathScreen.respawn");
        this.exitButtons.add((Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)component, button -> {
            this.minecraft.player.respawn();
            button.active = false;
        }).bounds(this.width / 2 - 100, this.height / 2 + 20, 200, 20).build()));
        this.exitToTitleButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"menu.quit"), button -> this.minecraft.getReportingContext().draftReportHandled(this.minecraft, (Screen)this, this::handleExitToTitleScreen, true)).bounds(this.width / 2 - 100, this.height / 2 + 45, 200, 20).build());
        this.exitButtons.add(this.exitToTitleButton);
        this.setButtonsActive(false);
    }

    @Inject(method={"handleExitToTitleScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleExitToTitleScreen(CallbackInfo ci) {
        ci.cancel();
        if (this.hardcore) {
            ExitConfirmationScreen.exit(this.minecraft, true);
        } else {
            this.minecraft.setScreen((Screen)new ExitConfirmationScreen(this));
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        ci.cancel();
        float alpha = Math.min((float)(Util.getMillis() - this.screenInit) / 1200.0f, 1.0f);
        guiGraphics.fill(0, 0, guiGraphics.guiWidth(), guiGraphics.guiHeight(), 0x38080C | Mth.ceil((float)(alpha * 160.0f)) << 24);
        guiGraphics.pose().pushPose();
        guiGraphics.pose().translate((float)(this.width - this.font.width((FormattedText)this.title) * 2) / 2.0f, (float)this.height / 4.0f + 20.0f, 0.0f);
        guiGraphics.pose().scale(2.0f, 2.0f, 2.0f);
        ScreenUtil.drawOutlinedString(guiGraphics, this.font, this.title, 0, 0, (int)((Integer)CommonColor.TITLE_TEXT.get()), (int)((Integer)CommonColor.TITLE_TEXT_OUTLINE.get()), 0.5f);
        guiGraphics.pose().popPose();
        if (this.causeOfDeath != null) {
            guiGraphics.drawCenteredString(this.font, this.causeOfDeath, this.width / 2, this.height / 2 - 24, 0xFFFFFF);
            if (j > this.height / 2 - 24 && j < this.height / 2 - 15) {
                guiGraphics.renderComponentHoverEffect(this.font, this.getClickedComponentStyleAt(i), i, j);
            }
        }
        if (this.exitToTitleButton != null && this.minecraft.getReportingContext().hasDraftReport()) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.DRAFT_REPORT, this.exitToTitleButton.getX() + this.exitToTitleButton.getWidth() - 17, this.exitToTitleButton.getY() + 3, 15, 15);
        }
        for (Renderable renderable : this.renderables) {
            renderable.render(guiGraphics, i, j, f);
        }
    }
}

