/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base;

import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.ItemUseAnimation;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.level.Level;
import org.spongepowered.asm.mixin.Mixin;
import wily.factoryapi.base.config.FactoryConfig;
import wily.legacy.config.LegacyCommonOptions;

@Mixin(value={SwordItem.class})
public class SwordItemMixin
extends Item {
    public SwordItemMixin(Item.Properties properties) {
        super(properties);
    }

    public int getUseDuration(ItemStack itemStack, LivingEntity livingEntity) {
        if (FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacySwordBlocking)) {
            return 7200;
        }
        return super.getUseDuration(itemStack, livingEntity);
    }

    public InteractionResult use(Level level, Player player, InteractionHand interactionHand) {
        if (FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacySwordBlocking) && (interactionHand == InteractionHand.OFF_HAND || !player.getOffhandItem().getUseAnimation().equals((Object)ItemUseAnimation.BLOCK))) {
            player.startUsingItem(interactionHand);
            return InteractionResult.CONSUME;
        }
        return super.use(level, player, interactionHand);
    }

    public ItemUseAnimation getUseAnimation(ItemStack itemStack) {
        if (FactoryConfig.hasCommonConfigEnabled(LegacyCommonOptions.legacySwordBlocking)) {
            return ItemUseAnimation.BLOCK;
        }
        return super.getUseAnimation(itemStack);
    }
}

