/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.book;

import java.lang.invoke.LambdaMetafactory;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.font.TextFieldHelper;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.BookEditScreen;
import net.minecraft.client.gui.screens.inventory.PageButton;
import net.minecraft.client.renderer.Rect2i;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.Style;
import net.minecraft.util.FormattedCharSequence;
import net.minecraft.util.StringUtil;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.legacy.client.ControlType;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.Controller;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.BookPanel;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.KeyboardScreen;
import wily.legacy.util.LegacyComponents;

@Mixin(value={BookEditScreen.class})
public abstract class BookEditScreenMixin
extends Screen
implements Controller.Event,
ControlTooltip.Event {
    @Shadow
    private Button signButton;
    @Shadow
    private boolean isSigning;
    @Shadow
    private Button doneButton;
    @Shadow
    private Button finalizeButton;
    @Shadow
    private Button cancelButton;
    @Shadow
    private PageButton forwardButton;
    @Shadow
    private PageButton backButton;
    @Shadow
    private int frameTick;
    @Shadow
    @Final
    private static Component EDIT_TITLE_LABEL;
    @Shadow
    @Final
    private Component ownerText;
    @Shadow
    @Final
    private static Component FINALIZE_WARNING_LABEL;
    @Shadow
    private Component pageMsg;
    private static final Component EXIT_BOOK;
    private static final Component EXIT_BOOK_MESSAGE;
    @Shadow
    @Final
    private static FormattedCharSequence BLACK_CURSOR;
    @Shadow
    @Final
    private static FormattedCharSequence GRAY_CURSOR;
    @Shadow
    private String title;
    @Shadow
    private int currentPage;
    @Shadow
    private boolean isModified;
    @Shadow
    @Final
    private TextFieldHelper pageEdit;
    @Shadow
    @Final
    private TextFieldHelper titleEdit;
    private BookPanel panel = new BookPanel(this){

        public boolean charTyped(char c, int i) {
            if (super.charTyped(c, i)) {
                return true;
            }
            if (BookEditScreenMixin.this.isSigning) {
                boolean bl = BookEditScreenMixin.this.titleEdit.charTyped(c);
                if (bl) {
                    BookEditScreenMixin.this.updateButtonVisibility();
                    BookEditScreenMixin.this.isModified = true;
                    return true;
                }
                return false;
            }
            if (StringUtil.isAllowedChatCharacter((char)c)) {
                BookEditScreenMixin.this.pageEdit.insertText(Character.toString(c));
                BookEditScreenMixin.this.clearDisplayCache();
                return true;
            }
            return false;
        }

        /*
         * Unable to fully structure code
         */
        @Override
        public boolean keyPressed(int i, int j, int k) {
            block7: {
                if (KeyboardScreen.isOpenKey(i)) {
                    BookEditScreenMixin.access$000(BookEditScreenMixin.this).setScreen((Screen)new KeyboardScreen((Supplier<GuiEventListener>)LambdaMetafactory.metafactory(null, null, null, ()Ljava/lang/Object;, lambda$keyPressed$0(), ()Lnet/minecraft/client/gui/components/events/GuiEventListener;)(this), BookEditScreenMixin.this));
                    return true;
                }
                if (BookEditScreenMixin.this.isSigning) {
                    return BookEditScreenMixin.this.titleKeyPressed(i, j, k);
                }
                if (i != 264) break block7;
                if (!ControlType.getActiveType().isKbm() && BookEditScreenMixin.access$100((BookEditScreenMixin)BookEditScreenMixin.this).screen == BookEditScreenMixin.this) {
                    return false;
                }
                newLine = BookEditScreenMixin.this.getDisplayCache().changeLine(BookEditScreenMixin.this.pageEdit.getCursorPos(), 1);
                if (newLine != BookEditScreenMixin.this.pageEdit.getCursorPos()) break block7;
                BookEditScreenMixin.this.pageEdit.insertText("\n");
                v0 = BookEditScreenMixin.this.pageEdit;
                v1 = BookEditScreenMixin.this.getDisplayCache().changeLine(BookEditScreenMixin.this.pageEdit.getCursorPos(), 1);
                if (Screen.hasShiftDown()) ** GOTO lbl-1000
                var6_5 = BookEditScreenMixin.access$200((BookEditScreenMixin)BookEditScreenMixin.this).screen;
                if (var6_5 instanceof KeyboardScreen) {
                    s = (KeyboardScreen)var6_5;
                    ** if (!s.shift) goto lbl-1000
                }
                ** GOTO lbl-1000
lbl-1000:
                // 2 sources

                {
                    v2 = true;
                    ** GOTO lbl23
                }
lbl-1000:
                // 2 sources

                {
                    v2 = false;
                }
lbl23:
                // 2 sources

                v0.setCursorPos(v1, v2);
                return true;
            }
            if (BookEditScreenMixin.this.bookKeyPressed(i, j, k)) {
                BookEditScreenMixin.this.clearDisplayCache();
                return true;
            }
            return super.keyPressed(i, j, k);
        }

        @Override
        @Nullable
        public Component getAction(ControlTooltip.ActionHolder.Context context) {
            return this.isFocused() ? context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, ControlTooltip::getKeyboardAction) : null;
        }

        private /* synthetic */ GuiEventListener lambda$keyPressed$0() {
            return this;
        }
    };

    @Shadow
    protected abstract void clearDisplayCache();

    @Shadow
    protected abstract void updateButtonVisibility();

    @Shadow
    protected abstract void saveChanges(boolean var1);

    @Shadow
    protected abstract void pageBack();

    @Shadow
    protected abstract void pageForward();

    @Shadow
    protected abstract BookEditScreen.DisplayCache getDisplayCache();

    @Shadow
    protected abstract void renderHighlight(GuiGraphics var1, Rect2i[] var2);

    @Shadow
    protected abstract void renderCursor(GuiGraphics var1, BookEditScreen.Pos2i var2, boolean var3);

    @Shadow
    protected abstract boolean titleKeyPressed(int var1, int var2, int var3);

    @Shadow
    protected abstract boolean bookKeyPressed(int var1, int var2, int var3);

    @Shadow
    protected abstract int getNumPages();

    public void added() {
        super.added();
        ControlTooltip.Renderer.of(this).add(() -> ControlType.getActiveType().isKbm() ? (this.getFocused() == this.panel ? null : ControlTooltip.COMPOUND_ICON_FUNCTION.apply(new ControlTooltip.Icon[]{ControlTooltip.getKeyIcon(340), ControlTooltip.PLUS_ICON, ControlTooltip.getKeyIcon(263)})) : ControllerBinding.LEFT_BUMPER.getIcon(), () -> this.currentPage != 0 ? LegacyComponents.PREVIOUS_PAGE : null).add(() -> ControlType.getActiveType().isKbm() ? (this.getFocused() == this.panel ? null : ControlTooltip.COMPOUND_ICON_FUNCTION.apply(new ControlTooltip.Icon[]{ControlTooltip.getKeyIcon(340), ControlTooltip.PLUS_ICON, ControlTooltip.getKeyIcon(262)})) : ControllerBinding.RIGHT_BUMPER.getIcon(), () -> this.currentPage < this.getNumPages() - 1 ? LegacyComponents.NEXT_PAGE : LegacyComponents.ADD_PAGE);
    }

    protected BookEditScreenMixin(Component component) {
        super(component);
    }

    @ModifyArg(method={"<init>"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/font/TextFieldHelper;<init>(Ljava/util/function/Supplier;Ljava/util/function/Consumer;Ljava/util/function/Supplier;Ljava/util/function/Consumer;Ljava/util/function/Predicate;)V", ordinal=0), index=4)
    private Predicate<String> changeTextFieldHelperWidth(Predicate<String> predicate) {
        return string -> string.length() < 2304 && this.font.wordWrapHeight(string, 159) <= 176;
    }

    @ModifyArg(method={"rebuildDisplayCache"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/StringSplitter;splitLines(Ljava/lang/String;ILnet/minecraft/network/chat/Style;ZLnet/minecraft/client/StringSplitter$LinePosConsumer;)V"), index=1)
    private int rebuildDisplayCache(int i) {
        return 159;
    }

    @Inject(method={"convertScreenToLocal"}, at={@At(value="HEAD")}, cancellable=true)
    private void convertScreenToLocal(BookEditScreen.Pos2i pos2i, CallbackInfoReturnable<BookEditScreen.Pos2i> cir) {
        cir.setReturnValue((Object)new BookEditScreen.Pos2i(pos2i.x - this.panel.x - 20, pos2i.y - this.panel.y - 37));
    }

    @Inject(method={"convertLocalToScreen"}, at={@At(value="HEAD")}, cancellable=true)
    private void convertLocalToScreen(BookEditScreen.Pos2i pos2i, CallbackInfoReturnable<BookEditScreen.Pos2i> cir) {
        cir.setReturnValue((Object)new BookEditScreen.Pos2i(pos2i.x + this.panel.x + 20, pos2i.y + this.panel.y + 37));
    }

    public void onClose() {
        if (this.isModified) {
            this.minecraft.setScreen((Screen)new ConfirmationScreen((Screen)this, EXIT_BOOK, EXIT_BOOK_MESSAGE, b -> this.minecraft.setScreen(null)));
        } else {
            super.onClose();
        }
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        ci.cancel();
        this.clearDisplayCache();
        this.panel.init();
        this.addRenderableWidget(this.panel);
        this.signButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"book.signButton"), button -> {
            this.isSigning = true;
            this.updateButtonVisibility();
            this.setFocused(this.panel);
        }).bounds(this.width / 2 - 108, this.panel.y + this.panel.height + 5, 100, 20).build());
        this.doneButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_DONE, button -> {
            this.minecraft.setScreen(null);
            this.saveChanges(false);
        }).bounds(this.width / 2 + 8, this.panel.y + this.panel.height + 5, 100, 20).build());
        this.finalizeButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"book.finalizeButton"), button -> {
            if (this.isSigning) {
                this.saveChanges(true);
                this.minecraft.setScreen(null);
            }
        }).bounds(this.width / 2 - 108, this.panel.y + this.panel.height + 5, 100, 20).build());
        this.cancelButton = (Button)this.addRenderableWidget((GuiEventListener)Button.builder((Component)CommonComponents.GUI_CANCEL, button -> {
            if (this.isSigning) {
                this.isSigning = false;
            }
            this.updateButtonVisibility();
        }).bounds(this.width / 2 + 8, this.panel.y + this.panel.height + 5, 100, 20).build());
        this.forwardButton = (PageButton)this.addRenderableWidget((GuiEventListener)this.panel.createLegacyPageButton(this.panel.x + this.panel.width - 62, this.panel.y + this.panel.height - 34, true, button -> this.pageForward(), true));
        this.backButton = (PageButton)this.addRenderableWidget((GuiEventListener)this.panel.createLegacyPageButton(this.panel.x + 26, this.panel.y + this.panel.height - 34, false, button -> this.pageBack(), true));
        this.setFocused(this.panel);
        this.updateButtonVisibility();
    }

    @Inject(method={"renderBackground"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBackground(CallbackInfo ci) {
        ci.cancel();
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void tick(CallbackInfo ci) {
        super.tick();
        if (this.getFocused() == null || this.getFocused() instanceof PageButton) {
            this.setFocused(this.panel);
        }
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        ci.cancel();
        super.render(guiGraphics, i, j, f);
        if (this.isSigning) {
            boolean bl = this.frameTick / 6 % 2 == 0;
            FormattedCharSequence formattedCharSequence = FormattedCharSequence.composite((FormattedCharSequence)FormattedCharSequence.forward((String)this.title, (Style)Style.EMPTY), (FormattedCharSequence)(bl ? BLACK_CURSOR : GRAY_CURSOR));
            guiGraphics.drawString(this.font, EDIT_TITLE_LABEL, this.panel.x + 20, this.panel.y + 37, 0, false);
            guiGraphics.drawString(this.font, formattedCharSequence, this.panel.x + 20, this.panel.y + 50, 0, false);
            guiGraphics.drawString(this.font, this.ownerText, this.panel.x + 20, this.panel.y + 61, 0, false);
            guiGraphics.drawWordWrap(this.font, (FormattedText)FINALIZE_WARNING_LABEL, this.panel.x + 20, this.panel.y + 85, 159, 0);
        } else {
            guiGraphics.drawString(this.font, this.pageMsg, this.panel.x + this.panel.width - 24 - this.font.width((FormattedText)this.pageMsg), this.panel.y + 22, 0, false);
            BookEditScreen.DisplayCache displayCache = this.getDisplayCache();
            for (BookEditScreen.LineInfo lineInfo : displayCache.lines) {
                guiGraphics.drawString(this.font, lineInfo.asComponent, lineInfo.x, lineInfo.y, -16777216, false);
            }
            if (this.panel.isFocused()) {
                this.renderHighlight(guiGraphics, displayCache.selection);
                this.renderCursor(guiGraphics, displayCache.cursor, displayCache.cursorAtEnd);
            }
        }
    }

    @Override
    public void bindingStateTick(BindingState state) {
        if ((state.is(ControllerBinding.RIGHT_BUMPER) || state.is(ControllerBinding.LEFT_BUMPER)) && state.canClick()) {
            (state.is(ControllerBinding.RIGHT_BUMPER) ? this.forwardButton : this.backButton).keyPressed(257, 0, 0);
        }
    }

    @Inject(method={"keyPressed"}, at={@At(value="HEAD")}, cancellable=true)
    public void keyPressed(int i, int j, int k, CallbackInfoReturnable<Boolean> cir) {
        if (BookEditScreenMixin.hasShiftDown() && (i == 262 || i == 263) && this.getFocused() != this.panel) {
            (i == 262 ? this.forwardButton : this.backButton).keyPressed(257, 0, 0);
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)super.keyPressed(i, j, k));
    }

    @Inject(method={"charTyped"}, at={@At(value="HEAD")}, cancellable=true)
    public void charTyped(char c, int i, CallbackInfoReturnable<Boolean> cir) {
        cir.setReturnValue((Object)super.charTyped(c, i));
    }

    public boolean isPauseScreen() {
        return false;
    }

    static /* synthetic */ Minecraft access$000(BookEditScreenMixin x0) {
        return x0.minecraft;
    }

    static /* synthetic */ Minecraft access$100(BookEditScreenMixin x0) {
        return x0.minecraft;
    }

    static /* synthetic */ Minecraft access$200(BookEditScreenMixin x0) {
        return x0.minecraft;
    }

    static {
        EXIT_BOOK = Component.translatable((String)"legacy.menu.exit_book");
        EXIT_BOOK_MESSAGE = Component.translatable((String)"legacy.menu.exit_book_message");
    }
}

