/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.network;

import java.util.function.Supplier;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import wily.factoryapi.base.network.CommonNetwork;
import wily.legacy.Legacy4J;

public record TopMessage(Component message, int baseColor, int ticksOnScreen, boolean shadow, boolean fade, boolean pulse) {
    public static TopMessage small;
    public static TopMessage medium;
    public static int smallTicks;
    public static int mediumTicks;

    public TopMessage(Component message, int baseColor, boolean shadow, boolean fade, boolean pulse) {
        this(message, baseColor, 40, shadow, fade, pulse);
    }

    public TopMessage(Component message, int baseColor, boolean shadow, boolean fade) {
        this(message, baseColor, shadow, fade, false);
    }

    public TopMessage(Component message, int baseColor, boolean shadow) {
        this(message, baseColor, shadow, false);
    }

    public TopMessage(Component message, int baseColor) {
        this(message, baseColor, true);
    }

    public static void tick() {
        if (small != null) {
            if (smallTicks < small.ticksOnScreen()) {
                ++smallTicks;
            } else {
                TopMessage.setSmall(null);
            }
        }
        if (medium != null) {
            if (mediumTicks < medium.ticksOnScreen()) {
                ++mediumTicks;
            } else {
                TopMessage.setMedium(null);
            }
        }
    }

    public static void setMedium(TopMessage topMessage) {
        medium = topMessage;
        mediumTicks = 0;
    }

    public static void setSmall(TopMessage topMessage) {
        small = topMessage;
        smallTicks = 0;
    }

    public record Payload(SendType sendType, TopMessage topMessage) implements CommonNetwork.Payload
    {
        public static final CommonNetwork.Identifier<Payload> ID = CommonNetwork.Identifier.create((ResourceLocation)Legacy4J.createModLocation("send_top_message"), Payload::decode);

        public static Payload decode(CommonNetwork.PlayBuf buf) {
            SendType type;
            return new Payload(type, (type = (SendType)((RegistryFriendlyByteBuf)buf.get()).readEnum(SendType.class)).clear() ? null : new TopMessage(CommonNetwork.decodeComponent((CommonNetwork.PlayBuf)buf), ((RegistryFriendlyByteBuf)buf.get()).readVarInt(), ((RegistryFriendlyByteBuf)buf.get()).readVarInt(), ((RegistryFriendlyByteBuf)buf.get()).readBoolean(), ((RegistryFriendlyByteBuf)buf.get()).readBoolean(), ((RegistryFriendlyByteBuf)buf.get()).readBoolean()));
        }

        public void encode(CommonNetwork.PlayBuf buf) {
            ((RegistryFriendlyByteBuf)buf.get()).writeEnum((Enum)this.sendType);
            if (this.sendType().clear()) {
                return;
            }
            CommonNetwork.encodeComponent((CommonNetwork.PlayBuf)buf, (Component)this.topMessage.message);
            ((RegistryFriendlyByteBuf)buf.get()).writeVarInt(this.topMessage.baseColor);
            ((RegistryFriendlyByteBuf)buf.get()).writeVarInt(this.topMessage.ticksOnScreen);
            ((RegistryFriendlyByteBuf)buf.get()).writeBoolean(this.topMessage.shadow);
            ((RegistryFriendlyByteBuf)buf.get()).writeBoolean(this.topMessage.fade);
            ((RegistryFriendlyByteBuf)buf.get()).writeBoolean(this.topMessage.pulse);
        }

        public void apply(CommonNetwork.SecureExecutor executor, Supplier<Player> player) {
            if (this.sendType().isSmall()) {
                TopMessage.setSmall(this.topMessage);
            }
            if (this.sendType().isMedium()) {
                TopMessage.setMedium(this.topMessage);
            }
        }

        public CommonNetwork.Identifier<? extends CommonNetwork.Payload> identifier() {
            return ID;
        }
    }

    public static enum SendType {
        SMALL,
        MEDIUM,
        CLEAR_SMALL,
        CLEAR_MEDIUM,
        CLEAR_ALL;


        public boolean isSmall() {
            return this == SMALL || this == CLEAR_SMALL || this == CLEAR_ALL;
        }

        public boolean isMedium() {
            return this == MEDIUM || this == CLEAR_MEDIUM || this == CLEAR_ALL;
        }

        public boolean clear() {
            return this.ordinal() > 1;
        }
    }
}

