/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.Arrays;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.multiplayer.ServerData;
import net.minecraft.client.multiplayer.resolver.ServerAddress;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.LegacySliderButton;
import wily.legacy.client.screen.PlayGameScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.client.LegacyFontUtil;

public class ServerEditScreen
extends ConfirmationScreen {
    private final ServerData serverData;
    protected EditBox nameBox;
    protected EditBox ipBox;

    public ServerEditScreen(PlayGameScreen parent, ServerData serverData, boolean add) {
        super(parent, ConfirmationScreen::getPanelWidth, () -> LegacyOptions.getUIMode().isSD() ? 140 : 187, add ? LegacyComponents.ADD_SERVER : LegacyComponents.EDIT_SERVER, LegacyComponents.ENTER_NAME, b -> {});
        this.serverData = serverData;
        this.okAction = s -> {
            serverData.name = this.nameBox.getValue();
            serverData.ip = this.ipBox.getValue();
            if (add) {
                ServerData data = parent.getServers().unhide(serverData.ip);
                if (data != null) {
                    data.copyNameIconFrom(serverData);
                } else {
                    parent.getServers().add(serverData, false);
                }
            }
            parent.getServers().save();
            parent.serverRenderableList.updateServers();
            this.onClose();
        };
    }

    public void repositionElements() {
        String string = this.ipBox.getValue();
        String string2 = this.nameBox.getValue();
        super.repositionElements();
        this.ipBox.setValue(string);
        this.nameBox.setValue(string2);
    }

    @Override
    protected void init() {
        super.init();
        boolean sd = LegacyOptions.getUIMode().isSD();
        int editBoxesHeight = LegacyOptions.getUIMode().isSD() ? 16 : 20;
        int layoutX = this.panel.x + (this.panel.width - this.messageLabel.width) / 2;
        this.nameBox = new EditBox(this.font, layoutX, this.panel.y + (sd ? 32 : 47), this.renderableVList.listWidth, editBoxesHeight, CommonComponents.EMPTY);
        this.ipBox = new EditBox(this.font, layoutX, this.panel.y + (sd ? 67 : 87), this.renderableVList.listWidth, editBoxesHeight, LegacyComponents.ENTER_IP);
        this.nameBox.setValue(this.serverData.name);
        this.ipBox.setValue(this.serverData.ip);
        this.ipBox.setMaxLength(128);
        this.nameBox.setResponder(s -> this.updateAddButtonStatus());
        this.ipBox.setResponder(s -> this.updateAddButtonStatus());
        this.addRenderableWidget((GuiEventListener)this.nameBox);
        this.addRenderableWidget((GuiEventListener)this.ipBox);
        this.addRenderableWidget((GuiEventListener)new LegacySliderButton<ServerData.ServerPackStatus>(layoutX, this.panel.y + (sd ? 86 : 112), this.renderableVList.listWidth, 16, b -> b.getDefaultMessage((Component)Component.translatable((String)"manageServer.resourcePack"), ((ServerData.ServerPackStatus)b.getObjectValue()).getName()), b -> null, this.serverData.getResourcePackStatus(), () -> Arrays.stream(ServerData.ServerPackStatus.values()).toList(), b -> this.serverData.setResourcePackStatus((ServerData.ServerPackStatus)b.objectValue)));
        this.setInitialFocus((GuiEventListener)this.nameBox);
        this.updateAddButtonStatus();
    }

    @Override
    public void render(GuiGraphics guiGraphics, int i, int j, float f) {
        super.render(guiGraphics, i, j, f);
        int textX = this.panel.x + (this.panel.width - this.messageLabel.width) / 2;
        LegacyFontUtil.applySDFont(b -> guiGraphics.drawString(this.font, LegacyComponents.ENTER_IP, textX, this.panel.y + (b != false ? 53 : 73), ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false));
    }

    private void updateAddButtonStatus() {
        this.okButton.active = ServerAddress.isValidAddress((String)this.ipBox.getValue()) && !this.nameBox.getValue().isEmpty();
    }
}

