/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client;

import net.minecraft.Util;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.sounds.SoundEvent;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.legacy.client.CommonValue;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.client.LegacySoundUtil;

@Mixin(value={AbstractWidget.class})
public abstract class AbstractWidgetMixin
implements ControlTooltip.ActionHolder {
    @Shadow
    protected boolean isHovered;
    @Unique
    private long lastHovered = -1L;
    @Unique
    private boolean playedFocusSound = false;

    @Redirect(method={"renderScrollingString(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIIII)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;III)V"))
    private static void renderScrollingString(GuiGraphics instance, Font arg, Component arg2, int i, int j, int k) {
        instance.drawString(arg, arg2, i, j, k, ((Boolean)CommonValue.WIDGET_TEXT_SHADOW.get()).booleanValue());
    }

    @Redirect(method={"renderScrollingString(Lnet/minecraft/client/gui/GuiGraphics;Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;IIIIII)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;drawCenteredString(Lnet/minecraft/client/gui/Font;Lnet/minecraft/network/chat/Component;III)V"))
    private static void renderCenteredScrollingString(GuiGraphics instance, Font arg, Component arg2, int i, int j, int k) {
        instance.drawString(arg, arg2, i - arg.width((FormattedText)arg2) / 2, j, k, ((Boolean)CommonValue.WIDGET_TEXT_SHADOW.get()).booleanValue());
    }

    @Shadow
    public abstract boolean isFocused();

    @Inject(method={"render"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/AbstractWidget;renderWidget(Lnet/minecraft/client/gui/GuiGraphics;IIF)V")})
    private void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        if (this.isHovered) {
            if (this.lastHovered == -1L) {
                this.lastHovered = Util.getMillis();
            }
            if (!this.playedFocusSound && Util.getMillis() - this.lastHovered >= 10L && ((Boolean)LegacyOptions.hoverFocusSound.get()).booleanValue()) {
                LegacySoundUtil.playSimpleUISound((SoundEvent)LegacyRegistries.FOCUS.get(), 1.0f);
                this.playedFocusSound = true;
            }
        } else {
            this.lastHovered = -1L;
            this.playedFocusSound = false;
        }
    }

    @Redirect(method={"nextFocusPath"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/components/AbstractWidget;isActive()Z"))
    public boolean nextFocusPath(AbstractWidget instance) {
        return instance.visible;
    }

    @Override
    @Nullable
    public Component getAction(ControlTooltip.ActionHolder.Context context) {
        return ControlTooltip.getSelectAction((GuiEventListener)this, context);
    }
}

