/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.beacon;

import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.BeaconScreen;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.BeaconMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.entity.BeaconBlockEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;

@Mixin(value={BeaconScreen.class})
public abstract class BeaconScreenMixin
extends AbstractContainerScreen<BeaconMenu> {
    private static final ItemStack[] DISPLAY_ITEMS = new ItemStack[]{Items.NETHERITE_INGOT.getDefaultInstance(), Items.EMERALD.getDefaultInstance(), Items.DIAMOND.getDefaultInstance(), Items.GOLD_INGOT.getDefaultInstance(), Items.IRON_INGOT.getDefaultInstance()};
    @Shadow
    @Final
    private static Component PRIMARY_EFFECT_LABEL;
    @Shadow
    @Final
    private static Component SECONDARY_EFFECT_LABEL;
    @Shadow
    @Final
    private List<BeaconScreen.BeaconButton> beaconButtons;

    public BeaconScreenMixin(BeaconMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    private BeaconScreen self() {
        return (BeaconScreen)this;
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"init"}, at={@At(value="HEAD")}, cancellable=true)
    public void init(CallbackInfo ci) {
        BeaconScreen.BeaconPowerButton beaconPowerButton;
        Holder mobEffect;
        int l;
        ci.cancel();
        boolean sd = LegacyOptions.getUIMode().isSD();
        this.imageWidth = sd ? 160 : 260;
        this.imageHeight = sd ? 160 : 255;
        final int slotsSize = sd ? 13 : 21;
        LegacySlotDisplay defaultDisplay = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return slotsSize;
            }
        };
        super.init();
        for (int i = 0; i < ((BeaconMenu)this.menu).slots.size(); ++i) {
            Slot s = (Slot)((BeaconMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, sd ? 87 : 141, sd ? 82 : 129, defaultDisplay);
                continue;
            }
            if (i < ((BeaconMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, (sd ? 22 : 36) + (s.getContainerSlot() - 9) % 9 * slotsSize, (sd ? 98 : 155) + (s.getContainerSlot() - 9) / 9 * slotsSize, defaultDisplay);
                continue;
            }
            LegacySlotDisplay.override(s, (sd ? 22 : 36) + s.getContainerSlot() * slotsSize, sd ? 140 : 223, defaultDisplay);
        }
        this.beaconButtons.clear();
        BeaconScreen beaconScreen = this.self();
        Objects.requireNonNull(beaconScreen);
        BeaconScreen.BeaconConfirmButton confirmButton = new BeaconScreen.BeaconConfirmButton(this, beaconScreen, this.leftPos + (sd ? 112 : 202), this.topPos + (sd ? 80 : 127)){
            {
                BeaconScreen beaconScreen = x0;
                Objects.requireNonNull(beaconScreen);
                super(beaconScreen, i, j);
            }

            protected void renderIcon(GuiGraphics guiGraphics) {
                FactoryScreenUtil.enableBlend();
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.BEACON_CONFIRM, this.getX() + (this.getWidth() - 14) / 2, this.getY() + (this.getHeight() - 14) / 2, 14, 14);
                FactoryScreenUtil.disableBlend();
            }
        };
        confirmButton.setSize(sd ? 16 : 22, sd ? 16 : 22);
        this.addRenderableWidget((GuiEventListener)confirmButton);
        this.beaconButtons.add((BeaconScreen.BeaconButton)confirmButton);
        for (int i = 0; i <= 2; ++i) {
            int j = ((List)this.getFrom(BeaconBlockEntity.BEACON_EFFECTS, i)).size();
            for (l = 0; l < j; ++l) {
                mobEffect = (Holder)this.getFrom((List)this.getFrom(BeaconBlockEntity.BEACON_EFFECTS, i), l);
                BeaconScreen beaconScreen2 = this.self();
                Objects.requireNonNull(beaconScreen2);
                beaconPowerButton = new BeaconScreen.BeaconPowerButton(beaconScreen2, this.leftPos + (sd ? 29 : 59) + (j > 1 ? l * (sd ? 20 : 27) : (sd ? 10 : 13)), this.topPos + (sd ? 19 : 38) + i * (sd ? 18 : 30), mobEffect, true, i){
                    {
                        BeaconScreen beaconScreen = x0;
                        Objects.requireNonNull(beaconScreen);
                        super(beaconScreen, i, j, arg, bl, k);
                    }

                    protected void renderIcon(GuiGraphics arg) {
                        BeaconScreenMixin.this.renderBeaconIcon(arg, (AbstractWidget)this, x$0 -> super.renderIcon(x$0));
                    }
                };
                beaconPowerButton.active = false;
                ((BeaconScreen.BeaconPowerButton)this.addRenderableWidget((GuiEventListener)beaconPowerButton)).setSize(sd ? 16 : 22, sd ? 16 : 22);
                this.beaconButtons.add((BeaconScreen.BeaconButton)beaconPowerButton);
            }
        }
        int j = ((List)this.getFrom(BeaconBlockEntity.BEACON_EFFECTS, 3)).size() + 1;
        int k = j > 1 ? 0 : (sd ? 10 : 13);
        for (l = 0; l < j - 1; ++l) {
            mobEffect = (Holder)this.getFrom((List)this.getFrom(BeaconBlockEntity.BEACON_EFFECTS, 3), l);
            BeaconScreen beaconScreen3 = this.self();
            Objects.requireNonNull(beaconScreen3);
            beaconPowerButton = new BeaconScreen.BeaconPowerButton(beaconScreen3, this.leftPos + (sd ? 98 : 164) + l * (sd ? 20 : 27) + k, this.topPos + (sd ? 37 : 68), mobEffect, false, 3){
                {
                    BeaconScreen beaconScreen = x0;
                    Objects.requireNonNull(beaconScreen);
                    super(beaconScreen, i, j, arg, bl, k);
                }

                protected void renderIcon(GuiGraphics arg) {
                    BeaconScreenMixin.this.renderBeaconIcon(arg, (AbstractWidget)this, x$0 -> super.renderIcon(x$0));
                }
            };
            beaconPowerButton.active = false;
            ((BeaconScreen.BeaconPowerButton)this.addRenderableWidget((GuiEventListener)beaconPowerButton)).setSize(sd ? 16 : 22, sd ? 16 : 22);
            this.beaconButtons.add((BeaconScreen.BeaconButton)beaconPowerButton);
        }
        BeaconScreen beaconScreen4 = this.self();
        Objects.requireNonNull(beaconScreen4);
        BeaconScreen.BeaconUpgradePowerButton beaconPowerButton2 = new BeaconScreen.BeaconUpgradePowerButton(beaconScreen4, this.leftPos + (sd ? 98 : 165) + (j - 1) * 24 - k / 2, this.topPos + (sd ? 37 : 68), (Holder)this.getFrom((List)this.getFrom(BeaconBlockEntity.BEACON_EFFECTS, 0), 0)){
            {
                BeaconScreen beaconScreen = x0;
                Objects.requireNonNull(beaconScreen);
                super(beaconScreen, i, j, arg);
            }

            protected void renderIcon(GuiGraphics arg) {
                BeaconScreenMixin.this.renderBeaconIcon(arg, (AbstractWidget)this, x$0 -> super.renderIcon(x$0));
            }
        };
        beaconPowerButton2.visible = false;
        ((BeaconScreen.BeaconPowerButton)this.addRenderableWidget((GuiEventListener)beaconPowerButton2)).setSize(sd ? 16 : 22, sd ? 16 : 22);
        this.beaconButtons.add((BeaconScreen.BeaconButton)beaconPowerButton2);
    }

    @Unique
    private <T> T getFrom(List<T> list, int i) {
        return list.get(i);
    }

    @Inject(method={"renderLabels"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderLabels(GuiGraphics guiGraphics, int i, int j, CallbackInfo ci) {
        ci.cancel();
        LegacyFontUtil.applySDFont(b -> {
            int panelWidth = b != false ? 75 : 120;
            guiGraphics.drawString(this.font, PRIMARY_EFFECT_LABEL, (b != false ? 4 : 8) + (panelWidth - this.font.width((FormattedText)PRIMARY_EFFECT_LABEL)) / 2, b != false ? 7 : 13, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
            guiGraphics.drawString(this.font, SECONDARY_EFFECT_LABEL, (b != false ? 80 : 132) + (panelWidth - this.font.width((FormattedText)SECONDARY_EFFECT_LABEL)) / 2, b != false ? 7 : 13, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        });
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        boolean sd = LegacyOptions.getUIMode().isSD();
        int panelWidth = sd ? 75 : 120;
        int panelHeight = sd ? 75 : 115;
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(UIAccessor.of((Screen)this).getResourceLocation("imageSprite", sd ? LegacySprites.PANEL : LegacySprites.SMALL_PANEL), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + (sd ? 4 : 8), this.topPos + (sd ? 4 : 9), panelWidth, panelHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + (sd ? 80 : 132), this.topPos + (sd ? 4 : 9), panelWidth, panelHeight);
        this.renderBeaconSprite(guiGraphics, LegacySprites.BEACON_1, this.leftPos + (sd ? 12 : 32), this.topPos + (sd ? 22 : 39));
        this.renderBeaconSprite(guiGraphics, LegacySprites.BEACON_2, this.leftPos + (sd ? 12 : 32), this.topPos + (sd ? 40 : 69));
        this.renderBeaconSprite(guiGraphics, LegacySprites.BEACON_3, this.leftPos + (sd ? 12 : 32), this.topPos + (sd ? 58 : 97));
        this.renderBeaconSprite(guiGraphics, LegacySprites.BEACON_4, this.leftPos + (sd ? 112 : 180), this.topPos + (sd ? 22 : 42));
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)(this.leftPos + (sd ? 9 : 15)), (float)(this.topPos + (sd ? 81 : 129)));
        guiGraphics.pose().scale(sd ? 0.7222222f : 1.125f, sd ? 0.7222222f : 1.125f);
        for (ItemStack displayItem : DISPLAY_ITEMS) {
            guiGraphics.renderItem(displayItem, 0, 0);
            guiGraphics.pose().translate(18.0f, 0.0f);
        }
        guiGraphics.pose().popMatrix();
    }

    @Unique
    private void renderBeaconSprite(GuiGraphics graphics, ResourceLocation sprite, int x, int y) {
        graphics.pose().pushMatrix();
        graphics.pose().translate((float)x, (float)y);
        if (LegacyOptions.getUIMode().isSD()) {
            graphics.pose().scale(0.5f);
        }
        FactoryGuiGraphics.of((GuiGraphics)graphics).blitSprite(sprite, 0, 0, 20, 19);
        graphics.pose().popMatrix();
    }

    @Unique
    private void renderBeaconIcon(GuiGraphics arg, AbstractWidget widget, Consumer<GuiGraphics> render) {
        if (LegacyOptions.getUIMode().isSD()) {
            arg.pose().pushMatrix();
            arg.pose().translate((float)(widget.getX() + widget.getWidth() / 2), (float)(widget.getY() + widget.getHeight() / 2));
            arg.pose().scale(0.5f);
            arg.pose().translate((float)(-widget.getX() - 11), (float)(-widget.getY() - 11));
            render.accept(arg);
            arg.pose().popMatrix();
        } else {
            render.accept(arg);
        }
    }
}

