/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.enchantment;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.EnchantmentNames;
import net.minecraft.client.gui.screens.inventory.EnchantmentScreen;
import net.minecraft.client.input.MouseButtonEvent;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.EnchantmentMenu;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.enchantment.Enchantment;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;

@Mixin(value={EnchantmentScreen.class})
public abstract class EnchantmentScreenMixin
extends AbstractContainerScreen<EnchantmentMenu> {
    public EnchantmentScreenMixin(EnchantmentMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    @Shadow
    protected abstract void renderBook(GuiGraphics var1, int var2, int var3);

    @Inject(method={"init"}, at={@At(value="HEAD")})
    public void init(CallbackInfo ci) {
        final boolean sd = LegacyOptions.getUIMode().isSD();
        this.imageWidth = sd ? 130 : 215;
        this.imageHeight = sd ? 140 : 217;
        this.inventoryLabelX = sd ? 7 : 14;
        this.inventoryLabelY = sd ? 67 : 104;
        this.titleLabelX = sd ? 7 : 14;
        this.titleLabelY = sd ? 5 : 10;
        final int slotsSize = sd ? 13 : 21;
        LegacySlotDisplay defaultSlotsDisplay = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return slotsSize;
            }
        };
        for (int i = 0; i < ((EnchantmentMenu)this.menu).slots.size(); ++i) {
            final Slot s = (Slot)((EnchantmentMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, sd ? 10 : 19, sd ? 49 : 66, new LegacySlotDisplay(){

                    @Override
                    public ResourceLocation getIconSprite() {
                        return s.hasItem() ? null : LegacySprites.ENCHANTING_SLOT;
                    }

                    @Override
                    public int getWidth() {
                        return sd ? 16 : 21;
                    }
                });
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s, sd ? 31 : 50, sd ? 49 : 66, new LegacySlotDisplay(){

                    @Override
                    public int getWidth() {
                        return sd ? 16 : 21;
                    }
                });
                continue;
            }
            if (i < ((EnchantmentMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, this.inventoryLabelX + (s.getContainerSlot() - 9) % 9 * slotsSize, (sd ? 77 : 115) + (s.getContainerSlot() - 9) / 9 * slotsSize, defaultSlotsDisplay);
                continue;
            }
            LegacySlotDisplay.override(s, this.inventoryLabelX + s.getContainerSlot() * slotsSize, sd ? 122 : 185, defaultSlotsDisplay);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    @Inject(method={"mouseClicked"}, at={@At(value="HEAD")}, cancellable=true)
    public void mouseClicked(MouseButtonEvent event, boolean bl, CallbackInfoReturnable<Boolean> cir) {
        boolean sd = LegacyOptions.getUIMode().isSD();
        int buttonHeight = sd ? 15 : 21;
        for (int l = 0; l < 3; ++l) {
            double f = event.x() - ((double)this.leftPos + (sd ? 52.5 : 80.5));
            double g = event.y() - ((double)this.topPos + (sd ? 17.5 : 23.5) + (double)(buttonHeight * l));
            if (!(f >= 0.0 && g >= 0.0 && f < (double)(sd ? 70 : 120) && g < (double)buttonHeight && ((EnchantmentMenu)this.menu).clickMenuButton((Player)this.minecraft.player, l))) continue;
            this.minecraft.gameMode.handleInventoryButtonClick(((EnchantmentMenu)this.menu).containerId, l);
            cir.setReturnValue((Object)true);
            return;
        }
        cir.setReturnValue((Object)super.mouseClicked(event, bl));
    }

    @ModifyArg(method={"renderBook"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;submitBookModelRenderState(Lnet/minecraft/client/model/BookModel;Lnet/minecraft/resources/ResourceLocation;FFFIIII)V"), index=2)
    public float changeBookScale(float original) {
        return LegacyOptions.getUIMode().isSD() ? original : original * 1.25f;
    }

    @ModifyArg(method={"renderBook"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;submitBookModelRenderState(Lnet/minecraft/client/model/BookModel;Lnet/minecraft/resources/ResourceLocation;FFFIIII)V"), index=7)
    public int changeBookX1(int original) {
        return original + (LegacyOptions.getUIMode().isSD() ? 0 : 6);
    }

    @ModifyArg(method={"renderBook"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/gui/GuiGraphics;submitBookModelRenderState(Lnet/minecraft/client/model/BookModel;Lnet/minecraft/resources/ResourceLocation;FFFIIII)V"), index=8)
    public int changeBookY1(int original) {
        return original + (LegacyOptions.getUIMode().isSD() ? 0 : 9);
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        boolean sd = LegacyOptions.getUIMode().isSD();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(UIAccessor.of((Screen)this).getResourceLocation("imageSprite", sd ? LegacySprites.PANEL : LegacySprites.SMALL_PANEL), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.leftPos + (sd ? 51 : 79), this.topPos + (sd ? 16 : 22), sd ? 73 : 123, sd ? 48 : 66);
        this.renderBook(guiGraphics, this.leftPos + (sd ? -5 : 8), this.topPos + (sd ? 0 : 12));
        EnchantmentNames.getInstance().initSeed((long)((EnchantmentMenu)this.menu).getEnchantmentSeed());
        int m = ((EnchantmentMenu)this.menu).getGoldCount();
        int buttonWidth = sd ? 70 : 120;
        int buttonHeight = sd ? 15 : 21;
        int levelSize = sd ? 16 : 24;
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)this.leftPos + (LegacyRenderUtil.hasHorizontalArtifacts() ? (sd ? 52.4f : 80.4f) : (sd ? 52.5f : 80.5f)), (float)this.topPos + (sd ? 17.4f : 23.4f) - (float)buttonHeight);
        for (int n = 0; n < 3; ++n) {
            guiGraphics.pose().translate(0.0f, (float)buttonHeight);
            int enchantCost = ((EnchantmentMenu)this.menu).costs[n];
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(sd ? LegacySprites.SMALL_ENCHANTMENT_BUTTON_EMPTY : LegacySprites.ENCHANTMENT_BUTTON_EMPTY, 0, 0, buttonWidth, buttonHeight);
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.DISABLED_LEVEL_SPRITES[n], sd ? 0 : -1, sd ? 0 : -1, levelSize, levelSize);
            if (enchantCost == 0) continue;
            String string = "" + enchantCost;
            int r = (sd ? 58 : 86) - this.font.width(string);
            FormattedText formattedText = EnchantmentNames.getInstance().getRandomName(this.font, r);
            int s = (Integer)CommonColor.ENCHANTMENT_TEXT.get();
            if (!(m >= n + 1 && this.minecraft.player.experienceLevel >= enchantCost || this.minecraft.player.getAbilities().instabuild)) {
                guiGraphics.drawWordWrap(this.font, formattedText, sd ? 16 : 24, sd ? 2 : 3, r, (s & 0xFEFEFE) >> 1, false);
                s = (Integer)CommonColor.INSUFFICIENT_EXPERIENCE_TEXT.get();
            } else {
                double t = (double)i - ((double)this.leftPos + (sd ? 52.5 : 80.5));
                double u = (double)j - ((double)this.topPos + (sd ? 17.5 : 23.5) + (double)(buttonHeight * n));
                if (t >= 0.0 && u >= 0.0 && t < (double)buttonWidth && u < (double)buttonHeight) {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(sd ? LegacySprites.SMALL_ENCHANTMENT_BUTTON_SELECTED : LegacySprites.ENCHANTMENT_BUTTON_SELECTED, 0, 0, buttonWidth, buttonHeight);
                    s = (Integer)CommonColor.HIGHLIGHTED_ENCHANTMENT_TEXT.get();
                } else {
                    FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(sd ? LegacySprites.SMALL_ENCHANTMENT_BUTTON_ACTIVE : LegacySprites.ENCHANTMENT_BUTTON_ACTIVE, 0, 0, buttonWidth, buttonHeight);
                }
                FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ENABLED_LEVEL_SPRITES[n], sd ? 0 : -1, sd ? 0 : -1, levelSize, levelSize);
                guiGraphics.drawWordWrap(this.font, formattedText, sd ? 16 : 24, sd ? 2 : 3, r, s, false);
                s = (Integer)CommonColor.EXPERIENCE_TEXT.get();
            }
            int color = s;
            LegacyFontUtil.applySDFont(b -> guiGraphics.drawString(this.font, string, buttonWidth - this.font.width(string) - (sd ? 2 : 0), sd ? 8 : 12, color));
        }
        guiGraphics.pose().popMatrix();
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        LegacyFontUtil.applySDFont(b -> super.renderLabels(guiGraphics, i, j));
    }

    @Inject(method={"render"}, at={@At(value="HEAD")}, cancellable=true)
    public void render(GuiGraphics guiGraphics, int i, int j, float f, CallbackInfo ci) {
        ci.cancel();
        boolean sd = LegacyOptions.getUIMode().isSD();
        super.render(guiGraphics, i, j, f);
        this.renderTooltip(guiGraphics, i, j);
        boolean bl = this.minecraft.player.getAbilities().instabuild;
        int k = ((EnchantmentMenu)this.menu).getGoldCount();
        int buttonHeight = sd ? 15 : 21;
        for (int l = 0; l < 3; ++l) {
            int m = ((EnchantmentMenu)this.menu).costs[l];
            Optional optional = this.minecraft.level.registryAccess().lookupOrThrow(Registries.ENCHANTMENT).get(((EnchantmentMenu)this.menu).enchantClue[l]);
            int n = ((EnchantmentMenu)this.menu).levelClue[l];
            int o = l + 1;
            double t = (double)i - ((double)this.leftPos + (sd ? 52.5 : 80.5));
            double u = (double)j - ((double)this.topPos + (sd ? 17.5 : 23.5) + (double)(buttonHeight * l));
            if (!(t >= 0.0 && u >= 0.0 && t < (double)(sd ? 70 : 120) && u < (double)buttonHeight && m > 0 && n >= 0 && !optional.isEmpty())) continue;
            ArrayList list = Lists.newArrayList();
            ((Holder.Reference)optional.get()).value();
            list.add(Component.translatable((String)"container.enchant.clue", (Object[])new Object[]{Enchantment.getFullname((Holder)((Holder)optional.get()), (int)n)}).withStyle(ChatFormatting.WHITE));
            if (!bl) {
                list.add(CommonComponents.EMPTY);
                if (this.minecraft.player.experienceLevel < m) {
                    list.add(Component.translatable((String)"container.enchant.level.requirement", (Object[])new Object[]{((EnchantmentMenu)this.menu).costs[l]}).withStyle(ChatFormatting.RED));
                } else {
                    MutableComponent mutableComponent = o == 1 ? Component.translatable((String)"container.enchant.lapis.one") : Component.translatable((String)"container.enchant.lapis.many", (Object[])new Object[]{o});
                    list.add(mutableComponent.withStyle(k >= o ? ChatFormatting.GRAY : ChatFormatting.RED));
                    MutableComponent mutableComponent2 = o == 1 ? Component.translatable((String)"container.enchant.level.one") : Component.translatable((String)"container.enchant.level.many", (Object[])new Object[]{o});
                    list.add(mutableComponent2.withStyle(ChatFormatting.GRAY));
                }
            }
            guiGraphics.setComponentTooltipForNextFrame(this.font, (List)list, i, j);
            break;
        }
    }
}

