/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.grindstone;

import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.gui.screens.inventory.GrindstoneScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.GrindstoneMenu;
import net.minecraft.world.inventory.Slot;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.inventory.LegacySlotDisplay;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;

@Mixin(value={GrindstoneScreen.class})
public abstract class GrindstoneScreenMixin
extends AbstractContainerScreen<GrindstoneMenu> {
    private static final LegacySlotDisplay SLOTS_DISPLAY = new LegacySlotDisplay(){

        @Override
        public int getWidth() {
            return 30;
        }
    };
    private static final LegacySlotDisplay SD_SLOTS_DISPLAY = new LegacySlotDisplay(){

        @Override
        public int getWidth() {
            return 20;
        }
    };

    public GrindstoneScreenMixin(GrindstoneMenu abstractContainerMenu, Inventory inventory, Component component) {
        super((AbstractContainerMenu)abstractContainerMenu, inventory, component);
    }

    protected void init() {
        boolean sd = LegacyOptions.getUIMode().isSD();
        this.imageWidth = sd ? 130 : 207;
        this.imageHeight = sd ? 145 : 215;
        this.inventoryLabelX = sd ? 7 : 10;
        this.inventoryLabelY = sd ? 71 : 105;
        this.titleLabelX = sd ? 7 : 10;
        this.titleLabelY = sd ? 5 : 11;
        final int slotsSize = sd ? 13 : 21;
        LegacySlotDisplay defaultDisplay = new LegacySlotDisplay(){

            @Override
            public int getWidth() {
                return slotsSize;
            }
        };
        super.init();
        for (int i = 0; i < ((GrindstoneMenu)this.menu).slots.size(); ++i) {
            Slot s = (Slot)((GrindstoneMenu)this.menu).slots.get(i);
            if (i == 0) {
                LegacySlotDisplay.override(s, sd ? 28 : 41, sd ? 19 : 30, sd ? SD_SLOTS_DISPLAY : SLOTS_DISPLAY);
                continue;
            }
            if (i == 1) {
                LegacySlotDisplay.override(s, sd ? 28 : 41, sd ? 44 : 65, sd ? SD_SLOTS_DISPLAY : SLOTS_DISPLAY);
                continue;
            }
            if (i == 2) {
                LegacySlotDisplay.override(s, sd ? 90 : 138, sd ? 31 : 46, sd ? SD_SLOTS_DISPLAY : SLOTS_DISPLAY);
                continue;
            }
            if (i < ((GrindstoneMenu)this.menu).slots.size() - 9) {
                LegacySlotDisplay.override(s, this.inventoryLabelX + (s.getContainerSlot() - 9) % 9 * slotsSize, (sd ? 81 : 116) + (s.getContainerSlot() - 9) / 9 * slotsSize, defaultDisplay);
                continue;
            }
            LegacySlotDisplay.override(s, this.inventoryLabelX + s.getContainerSlot() * slotsSize, sd ? 125 : 185, defaultDisplay);
        }
    }

    public void renderBackground(GuiGraphics guiGraphics, int i, int j, float f) {
        this.renderBg(guiGraphics, f, i, j);
    }

    protected void renderLabels(GuiGraphics guiGraphics, int i, int j) {
        LegacyFontUtil.applySDFont(b -> super.renderLabels(guiGraphics, i, j));
    }

    @Inject(method={"renderBg"}, at={@At(value="HEAD")}, cancellable=true)
    public void renderBg(GuiGraphics guiGraphics, float f, int i, int j, CallbackInfo ci) {
        ci.cancel();
        boolean sd = LegacyOptions.getUIMode().isSD();
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(UIAccessor.of((Screen)this).getResourceLocation("imageSprite", sd ? LegacySprites.PANEL : LegacySprites.SMALL_PANEL), this.leftPos, this.topPos, this.imageWidth, this.imageHeight);
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)(this.leftPos + (sd ? 61 : 85)), (float)(this.topPos + (sd ? 33 : 50)));
        FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(sd ? LegacySprites.SMALL_ARROW : LegacySprites.ARROW, 0, 0, sd ? 16 : 33, sd ? 14 : 24);
        if (!sd) {
            guiGraphics.pose().scale(1.5f, 1.5f);
        }
        if ((((GrindstoneMenu)this.menu).getSlot(0).hasItem() || ((GrindstoneMenu)this.menu).getSlot(1).hasItem()) && !((GrindstoneMenu)this.menu).getSlot(2).hasItem()) {
            FactoryGuiGraphics.of((GuiGraphics)guiGraphics).blitSprite(LegacySprites.ERROR_CROSS, sd ? 0 : 2, 0, 15, 15);
        }
        guiGraphics.pose().popMatrix();
    }
}

