/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin.base.client.gui;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.contextualbar.ContextualBarRenderer;
import net.minecraft.locale.Language;
import net.minecraft.network.chat.FormattedText;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import wily.factoryapi.FactoryAPIClient;
import wily.factoryapi.util.ColorUtil;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.util.client.LegacyRenderUtil;

@Mixin(value={ContextualBarRenderer.class})
public interface ExperienceBarRendererMixin {
    @Inject(method={"renderExperienceLevel"}, at={@At(value="HEAD")}, cancellable=true)
    private static void renderExperienceLevel(GuiGraphics guiGraphics, Font font, int i, CallbackInfo ci) {
        ci.cancel();
        if (!LegacyRenderUtil.canDisplayHUD()) {
            return;
        }
        guiGraphics.pose().pushMatrix();
        guiGraphics.pose().translate((float)guiGraphics.guiWidth() / 2.0f, (float)guiGraphics.guiHeight());
        String exp = String.valueOf(i);
        int hudScale = (Integer)LegacyOptions.hudScale.get();
        boolean is720p = Minecraft.getInstance().getWindow().getHeight() % 720 == 0;
        guiGraphics.pose().translate(0.0f, -36.0f);
        if (!is720p && hudScale != 1) {
            guiGraphics.pose().scale(0.875f, 0.875f);
        }
        LegacyRenderUtil.drawOutlinedString(guiGraphics, font, Language.getInstance().getVisualOrder(FormattedText.of((String)exp)), -font.width(exp) / 2, -2, ColorUtil.withAlpha((int)((Integer)CommonColor.EXPERIENCE_TEXT.get()), (float)LegacyRenderUtil.getHUDOpacity()), ColorUtil.withAlpha((int)-16777216, (float)LegacyRenderUtil.getHUDOpacity()), is720p && hudScale == 3 || !is720p && hudScale == 2 || hudScale == 1 ? 0.51f : 0.6666667f);
        FactoryAPIClient.getProfiler().pop();
        guiGraphics.pose().popMatrix();
    }
}

