/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.block;

import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.BooleanSupplier;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1826;
import net.minecraft.class_1842;
import net.minecraft.class_1844;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3468;
import net.minecraft.class_3730;
import net.minecraft.class_5328;
import net.minecraft.class_5556;
import net.minecraft.class_5620;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_9334;
import wily.factoryapi.base.config.FactoryMixinToggle;
import wily.legacy.block.ColoredWaterCauldronBlock;
import wily.legacy.block.entity.WaterCauldronBlockEntity;
import wily.legacy.config.LegacyMixinToggles;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.LegacyItemUtil;

public class LegacyBlockBehaviors {
    public static void setup() {
        class_2347 defaultDispenseItemBehavior = new class_2347(){

            public class_1799 method_10135(class_2342 blockSource, class_1799 itemStack) {
                class_2350 direction = (class_2350)blockSource.comp_1969().method_11654((class_2769)class_2315.field_10918);
                class_1299 entityType = ((class_1826)itemStack.method_7909()).method_8015(itemStack);
                try {
                    if (entityType.method_5894(blockSource.comp_1967(), itemStack, null, blockSource.comp_1968().method_10093(direction), class_3730.field_16470, direction != class_2350.field_11036, false) != null) {
                        itemStack.method_7934(1);
                        blockSource.comp_1967().method_33596(null, (class_6880)class_5712.field_28738, blockSource.comp_1968());
                    }
                }
                catch (Exception var6) {
                    field_34020.error("Error while dispensing spawn egg from dispenser at {}", (Object)blockSource.comp_1968(), (Object)var6);
                    return class_1799.field_8037;
                }
                return itemStack;
            }
        };
        for (class_1826 spawnEggItem : class_1826.method_8017()) {
            class_2315.method_10009((class_1935)spawnEggItem, (class_2357)defaultDispenseItemBehavior);
        }
        Map emptyCauldron = class_5620.field_27775.comp_1982();
        Map waterCauldron = class_5620.field_27776.comp_1982();
        Map powderSnowCauldron = class_5620.field_28011.comp_1982();
        Map lavaCauldron = class_5620.field_27777.comp_1982();
        class_5620 emptyCauldronPotion = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            class_6880 p = ((class_1844)itemStack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274)).comp_2378().orElse(null);
            if (p == null) {
                return LegacyBlockBehaviors.defaultPassInteraction();
            }
            level.method_8501(blockPos, class_2246.field_27097.method_9564());
            level.method_35230(blockPos, (class_2591)LegacyRegistries.WATER_CAULDRON_BLOCK_ENTITY.get()).ifPresent(be -> {
                be.potion = p;
                be.lastPotionItemUsed = itemStack.method_41409();
                be.method_5431();
                if (be.hasWater()) {
                    LegacyBlockBehaviors.sendCauldronBubblesParticles(level, blockPos);
                }
            });
            if (!level.method_8608()) {
                class_1792 item = itemStack.method_7909();
                player.method_6122(interactionHand, class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8469)));
                player.method_7281(class_3468.field_15373);
                player.method_7259(class_3468.field_15372.method_14956((Object)item));
                level.method_8396(null, blockPos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
                level.method_33596(null, (class_6880)class_5712.field_28166, blockPos);
                return LegacyBlockBehaviors.consumeInteraction();
            }
            return LegacyBlockBehaviors.successInteraction();
        };
        LegacyBlockBehaviors.putInteractionOrFallback(emptyCauldron, class_1802.field_8574, emptyCauldronPotion);
        LegacyBlockBehaviors.putInteractionOrFallback(emptyCauldron, class_1802.field_8436, emptyCauldronPotion);
        LegacyBlockBehaviors.putInteractionOrFallback(emptyCauldron, class_1802.field_8150, emptyCauldronPotion);
        LegacyBlockBehaviors.putInteractionOrFallback(waterCauldron, class_1802.field_8469, (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            WaterCauldronBlockEntity be;
            block5: {
                block4: {
                    class_2586 patt0$temp = level.method_8321(blockPos);
                    if (!(patt0$temp instanceof WaterCauldronBlockEntity)) break block4;
                    be = (WaterCauldronBlockEntity)patt0$temp;
                    if (be.waterColor == null) break block5;
                }
                return LegacyBlockBehaviors.defaultPassInteraction();
            }
            if (!level.method_8608()) {
                class_1792 item = itemStack.method_7909();
                player.method_6122(interactionHand, class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)LegacyItemUtil.setItemStackPotion(new class_1799(be.lastPotionItemUsed), be.potion)));
                player.method_7281(class_3468.field_15373);
                player.method_7259(class_3468.field_15372.method_14956((Object)item));
                class_5556.method_31650((class_2680)blockState, (class_1937)level, (class_2338)blockPos);
                LegacyBlockBehaviors.sendCauldronSplashParticles(level, blockPos);
                level.method_8396(null, blockPos, class_3417.field_14779, class_3419.field_15245, 1.0f, 1.0f);
                level.method_33596(null, (class_6880)class_5712.field_28167, blockPos);
                return LegacyBlockBehaviors.consumeInteraction();
            }
            return LegacyBlockBehaviors.successInteraction();
        });
        class_5620 waterCauldronPotion = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            class_6880<class_1842> p;
            WaterCauldronBlockEntity be;
            block12: {
                block11: {
                    class_2586 patt0$temp = level.method_8321(blockPos);
                    if (!(patt0$temp instanceof WaterCauldronBlockEntity)) break block11;
                    be = (WaterCauldronBlockEntity)patt0$temp;
                    p = LegacyItemUtil.getPotionContent(itemStack);
                    if (p != null && ((Integer)blockState.method_11654((class_2769)class_5556.field_27206) != 3 || !be.potion.equals(p))) break block12;
                }
                return LegacyBlockBehaviors.defaultPassInteraction();
            }
            if (!be.potion.equals(p)) {
                level.method_8501(blockPos, class_2246.field_10593.method_9564());
                if (!be.potion.equals(p) && !level.method_8608()) {
                    level.method_8396(null, blockPos, class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
                }
            } else {
                level.method_8501(blockPos, (class_2680)blockState.method_28493((class_2769)class_5556.field_27206));
                if (be.waterColor != null) {
                    be.setWaterColor(null);
                    level.method_8501(blockPos, (class_2680)blockState.method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(1)));
                    be.method_11012();
                }
                be.lastPotionItemUsed = itemStack.method_41409();
                if (!level.method_8608()) {
                    level.method_8396(null, blockPos, class_3417.field_14826, class_3419.field_15245, 1.0f, 1.0f);
                }
            }
            if (!level.method_8608()) {
                player.method_6122(interactionHand, class_5328.method_30012((class_1799)itemStack, (class_1657)player, (class_1799)new class_1799((class_1935)class_1802.field_8469)));
                player.method_7281(class_3468.field_15373);
                player.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
                level.method_33596(null, (class_6880)class_5712.field_28166, blockPos);
                if (be.hasWater() && !be.method_11015()) {
                    LegacyBlockBehaviors.sendCauldronBubblesParticles(level, blockPos);
                }
                return LegacyBlockBehaviors.consumeInteraction();
            }
            return LegacyBlockBehaviors.successInteraction();
        };
        LegacyBlockBehaviors.putInteractionOrFallback(waterCauldron, class_1802.field_8574, waterCauldronPotion);
        LegacyBlockBehaviors.putInteractionOrFallback(waterCauldron, class_1802.field_8436, waterCauldronPotion);
        LegacyBlockBehaviors.putInteractionOrFallback(waterCauldron, class_1802.field_8150, waterCauldronPotion);
        LegacyBlockBehaviors.putInteractionOrFallback(waterCauldron, class_1802.field_8107, (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            WaterCauldronBlockEntity be;
            class_2586 patt0$temp = level.method_8321(blockPos);
            if (!(patt0$temp instanceof WaterCauldronBlockEntity) || (be = (WaterCauldronBlockEntity)patt0$temp).hasWater()) {
                return LegacyBlockBehaviors.defaultPassInteraction();
            }
            if (!level.method_8608()) {
                int l = (Integer)blockState.method_11654((class_2769)class_5556.field_27206);
                int arrowCount = Math.min(itemStack.method_7947(), l < 3 ? l * 16 : 64);
                itemStack.method_57008(arrowCount, (class_1309)player);
                class_1799 tippedArrow = LegacyItemUtil.setItemStackPotion(new class_1799((class_1935)class_1802.field_8087, arrowCount), be.potion);
                player.method_31548().method_7398(tippedArrow);
                player.method_7281(class_3468.field_15373);
                player.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
                int i = (int)Math.min(3.0, Math.ceil((double)arrowCount / 16.0));
                class_2680 blockState2 = l - i == 0 ? class_2246.field_10593.method_9564() : (class_2680)blockState.method_11657((class_2769)class_5556.field_27206, (Comparable)Integer.valueOf(i));
                level.method_8501(blockPos, blockState2);
                level.method_43276((class_6880)class_5712.field_28733, blockPos, class_5712.class_7397.method_43287((class_2680)blockState2));
                return LegacyBlockBehaviors.consumeInteraction();
            }
            return LegacyBlockBehaviors.successInteraction();
        });
        BiFunction<class_5620, class_5620, class_5620> beforeInteraction = (a, b) -> (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            if (((Boolean)LegacyMixinToggles.legacyCauldrons.get()).booleanValue()) {
                b.interact(blockState, level, blockPos, player, interactionHand, itemStack);
            }
            return a.interact(blockState, level, blockPos, player, interactionHand, itemStack);
        };
        class_5620 fillWater = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            LegacyBlockBehaviors.sendCauldronBubblesParticles(level, blockPos);
            class_2586 patt0$temp = level.method_8321(blockPos);
            if (patt0$temp instanceof WaterCauldronBlockEntity) {
                WaterCauldronBlockEntity be = (WaterCauldronBlockEntity)patt0$temp;
                be.setWaterColor(null);
                if (!be.hasWater()) {
                    be.potion = be.getDefaultPotion();
                    if (!level.method_8608()) {
                        level.method_8396(null, blockPos, class_3417.field_15102, class_3419.field_15245, 1.0f, 1.0f);
                    }
                }
            }
            return LegacyBlockBehaviors.successInteraction();
        };
        waterCauldron.merge(class_1802.field_8705, fillWater, beforeInteraction);
        emptyCauldron.merge(class_1802.field_8705, fillWater, beforeInteraction);
        powderSnowCauldron.merge(class_1802.field_8705, fillWater, beforeInteraction);
        lavaCauldron.merge(class_1802.field_8705, fillWater, beforeInteraction);
        class_5620 fillLava = (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            if (level instanceof class_3218) {
                class_3218 sl = (class_3218)level;
                class_243 center = blockPos.method_46558();
                sl.method_65096((class_2394)class_2398.field_11239, center.field_1352, center.field_1351 + 0.5, center.field_1350, 2, 0.2, 0.1, 0.2, (double)0.02f);
            }
            return LegacyBlockBehaviors.successInteraction();
        };
        waterCauldron.merge(class_1802.field_8187, fillLava, beforeInteraction);
        emptyCauldron.merge(class_1802.field_8187, fillLava, beforeInteraction);
        powderSnowCauldron.merge(class_1802.field_8187, fillLava, beforeInteraction);
        lavaCauldron.merge(class_1802.field_8187, fillLava, beforeInteraction);
        LegacyBlockBehaviors.putInteractionOrFallback(waterCauldron, class_1802.field_8550, (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            if (!LegacyRegistries.isInvalidCauldron(blockState, level, blockPos)) {
                LegacyBlockBehaviors.sendCauldronSplashParticles(level, blockPos);
                return class_5620.method_32210((class_2680)blockState, (class_1937)level, (class_2338)blockPos, (class_1657)player, (class_1268)interactionHand, (class_1799)itemStack, (class_1799)new class_1799((class_1935)class_1802.field_8705), blockStatex -> (Integer)blockStatex.method_11654((class_2769)class_5556.field_27206) == 3, (class_3414)class_3417.field_15126);
            }
            return LegacyBlockBehaviors.consumeInteraction();
        });
        for (class_1767 color : class_1767.values()) {
            LegacyBlockBehaviors.putInteractionOrFallback(waterCauldron, (class_1792)class_1769.method_7803((class_1767)color), (blockState, level, blockPos, player, interactionHand, itemStack) -> {
                WaterCauldronBlockEntity be;
                block7: {
                    block6: {
                        class_2586 patt0$temp = level.method_8321(blockPos);
                        if (!(patt0$temp instanceof WaterCauldronBlockEntity)) break block6;
                        be = (WaterCauldronBlockEntity)patt0$temp;
                        if (itemStack.method_7909() instanceof class_1769 && be.hasWater()) break block7;
                    }
                    return LegacyBlockBehaviors.defaultPassInteraction();
                }
                int dyeColor = LegacyItemUtil.getDyeColor(color);
                if (be.waterColor == null) {
                    be.setWaterColor(dyeColor);
                } else {
                    be.waterColor = LegacyItemUtil.mixColors(List.of(be.waterColor, Integer.valueOf(dyeColor)).iterator());
                    be.setWaterColor(be.waterColor);
                }
                be.method_5431();
                if (!level.method_8608()) {
                    level.method_8396(null, blockPos, class_3417.field_14737, class_3419.field_15245, 0.25f, 1.0f);
                    LegacyBlockBehaviors.sendCauldronBubblesParticles(level, blockPos);
                }
                return level.method_8608() ? LegacyBlockBehaviors.successInteraction() : LegacyBlockBehaviors.consumeInteraction();
            });
        }
    }

    public static void putInteractionOrFallback(Map<class_1792, class_5620> interactionMap, class_1792 item, class_5620 cauldronInteraction) {
        LegacyBlockBehaviors.putInteractionOrFallback(interactionMap, item, cauldronInteraction, () -> ((FactoryMixinToggle)LegacyMixinToggles.legacyCauldrons).get());
    }

    public static void putInteractionOrFallback(Map<class_1792, class_5620> interactionMap, class_1792 item, class_5620 cauldronInteraction, BooleanSupplier supplier) {
        interactionMap.merge(item, cauldronInteraction, (a, b) -> (blockState, level, blockPos, player, interactionHand, itemStack) -> {
            if (supplier.getAsBoolean()) {
                return b.interact(blockState, level, blockPos, player, interactionHand, itemStack);
            }
            return a.interact(blockState, level, blockPos, player, interactionHand, itemStack);
        });
    }

    public static void registerDyedWaterCauldronInteraction(Map<class_1792, class_5620> waterCauldron) {
        if (!((Boolean)LegacyMixinToggles.legacyCauldrons.get()).booleanValue()) {
            return;
        }
        class_7923.field_41178.method_40295().forEach(i -> {
            if (!LegacyItemUtil.isDyeableItem((class_6880<class_1792>)i)) {
                return;
            }
            waterCauldron.put((class_1792)i.comp_349(), (blockState, level, blockPos, player, interactionHand, itemStack) -> {
                WaterCauldronBlockEntity be;
                class_2586 patt0$temp = level.method_8321(blockPos);
                if (!(patt0$temp instanceof WaterCauldronBlockEntity) || !(be = (WaterCauldronBlockEntity)patt0$temp).hasWater() || LegacyItemUtil.isDyedItem(itemStack) && be.waterColor == null) {
                    return LegacyBlockBehaviors.defaultPassInteraction();
                }
                if (!level.method_8608()) {
                    player.method_7281(class_3468.field_15373);
                    player.method_7259(class_3468.field_15372.method_14956((Object)itemStack.method_7909()));
                    if (be.waterColor == null) {
                        itemStack.method_57379(class_9334.field_49644, null);
                    } else {
                        LegacyItemUtil.dyeItem(itemStack, be.waterColor);
                        level.method_8396(null, blockPos, class_3417.field_14737, class_3419.field_15245, 0.25f, 1.0f);
                        LegacyBlockBehaviors.sendCauldronSplashParticles(level, blockPos);
                    }
                    ColoredWaterCauldronBlock.lowerFillLevel(be);
                }
                return LegacyBlockBehaviors.successInteraction();
            });
        });
    }

    public static void sendCauldronBubblesParticles(class_1937 level, class_2338 blockPos) {
        if (level instanceof class_3218) {
            class_3218 sl = (class_3218)level;
            class_243 center = blockPos.method_46558();
            sl.method_65096((class_2394)class_2398.field_11247, center.field_1352, center.field_1351 + 0.5, center.field_1350, 2, 0.2, 0.1, 0.2, (double)0.02f);
        }
    }

    public static void sendCauldronSplashParticles(class_1937 level, class_2338 blockPos) {
        if (level instanceof class_3218) {
            class_3218 sl = (class_3218)level;
            class_243 center = blockPos.method_46558();
            sl.method_65096((class_2394)class_2398.field_11202, center.field_1352, center.field_1351 + 0.5, center.field_1350, 2, 0.2, 0.2, 0.2, 1.0);
        }
    }

    public static class_1269 defaultPassInteraction() {
        return class_1269.field_5811;
    }

    public static class_1269 successInteraction() {
        return class_1269.field_5812;
    }

    public static class_1269 consumeInteraction() {
        return class_1269.field_21466;
    }
}

