/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_11719;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import wily.factoryapi.FactoryEvent;
import wily.factoryapi.util.DynamicUtil;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.IdValueInfo;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.OptionHolder;
import wily.legacy.client.SizeableAsset;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.util.IOUtil;

public record ControlType(class_2960 id, Optional<class_2561> name, boolean isKbm, Optional<SizeableAsset<ControlFont>> font, Optional<class_2960> minecraftLogo, Optional<SizeableAsset<class_2583>> style, Map<String, ControlTooltip.LegacyIcon> icons) implements IdValueInfo<ControlType>
{
    public static final SizeableAsset<class_2583> EMPTY_STYLE_ASSET = new SizeableAsset<class_2583>(class_2583.field_24360);
    public static final Codec<ControlType> EXTENDED_CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2960.field_25139.fieldOf("id").forGetter(ControlType::id), (App)DynamicUtil.getComponentCodec().optionalFieldOf("name").forGetter(ControlType::name), (App)Codec.BOOL.optionalFieldOf("isKbm", (Object)false).forGetter(ControlType::isKbm), (App)SizeableAsset.createWithFallback(ControlFont.CODEC).optionalFieldOf("font").forGetter(ControlType::font), (App)class_2960.field_25139.optionalFieldOf("minecraftLogo").forGetter(ControlType::minecraftLogo)).apply((Applicative)i, ControlType::new));
    public static final Codec<ControlType> CODEC = IOUtil.createFallbackCodec(EXTENDED_CODEC, class_2960.field_25139.xmap(ControlType::new, ControlType::id));
    public static final Codec<OptionHolder<ControlType>> OPTION_CODEC = OptionHolder.createCodecWithAuto(ControlType::get);
    public static final class_2960 KBM = Legacy4J.createModLocation("java");
    public static final class_2960 x360 = Legacy4J.createModLocation("xbox_360");
    public static final class_2960 xONE = Legacy4J.createModLocation("xbox_one");
    public static final class_2960 PS3 = Legacy4J.createModLocation("playstation_3");
    public static final class_2960 PS4 = Legacy4J.createModLocation("playstation_4");
    public static final class_2960 WII_U = Legacy4J.createModLocation("wii_u");
    public static final class_2960 SWITCH = Legacy4J.createModLocation("switch");
    public static final class_2960 STEAM = Legacy4J.createModLocation("steam");
    public static final class_2960 STADIA = Legacy4J.createModLocation("stadia");
    public static final class_2960 PSVITA = Legacy4J.createModLocation("playstation_vita");
    public static final class_2960 PS5 = Legacy4J.createModLocation("playstation_5");

    public ControlType(class_2960 id, Optional<class_2561> name, boolean isKbm, Optional<SizeableAsset<ControlFont>> font, Optional<class_2960> minecraftLogo) {
        this(id, name, isKbm, font, minecraftLogo, font.map(asset -> asset.map(f -> class_2583.field_24360.method_27704(f.font()))), new HashMap<String, ControlTooltip.LegacyIcon>());
    }

    public ControlType(class_2960 id) {
        this(id, Optional.of(class_2561.method_43471((String)("legacy.options.controlType." + id.method_12832()))), false, Optional.of(new SizeableAsset<ControlFont>(new ControlFont((class_11719)new class_11719.class_11721(id)))), Optional.of(id.method_45136("textures/gui/title/minecraft/%s.png".formatted(id.method_12832()))));
    }

    public static ControlType getActiveControllerType() {
        if (((OptionHolder)LegacyOptions.selectedControlType.get()).isAuto()) {
            if (Legacy4JClient.controllerManager.connectedController != null) {
                return Legacy4JClient.controllerManager.connectedController.getType();
            }
            return ControlType.get(x360);
        }
        ControlType type = (ControlType)((OptionHolder)LegacyOptions.selectedControlType.get()).get();
        return type.isKbm() ? ControlType.get(x360) : type;
    }

    public static ControlType getActiveType() {
        return (Boolean)LegacyOptions.lockControlTypeChange.get() == false && Legacy4JClient.controllerManager.isControllerTheLastInput() || (Boolean)LegacyOptions.lockControlTypeChange.get() != false && (Legacy4JClient.controllerManager.connectedController != null && ((OptionHolder)LegacyOptions.selectedControlType.get()).isAuto() || !((OptionHolder)LegacyOptions.selectedControlType.get()).orElse(ControlType.get(KBM)).isKbm()) ? ControlType.getActiveControllerType() : ControlType.getKbmActiveType();
    }

    public static ControlType getKbmActiveType() {
        if (((OptionHolder)LegacyOptions.selectedControlType.get()).isAuto()) {
            return ControlType.get(KBM);
        }
        ControlType type = (ControlType)((OptionHolder)LegacyOptions.selectedControlType.get()).get();
        return !type.isKbm() ? ControlType.get(KBM) : type;
    }

    public static ControlType get(class_2960 id) {
        return (ControlType)Legacy4JClient.controlTypesManager.map().get((Object)id);
    }

    public class_2583 styleOrEmpty() {
        return this.style.orElse(EMPTY_STYLE_ASSET).get();
    }

    public int iconHeight() {
        return this.font.isPresent() ? this.font.get().get().iconHeight() : 0;
    }

    @Override
    public ControlType copyFrom(ControlType other) {
        return new ControlType(this.id, other.name.or(this::name), this.isKbm, other.font.or(this::font), other.minecraftLogo.or(this::minecraftLogo), other.style.or(this::style), this.icons);
    }

    @Override
    public boolean isValid() {
        return this.name.isPresent() && this.font.isPresent() && this.style.isPresent();
    }

    public record ControlFont(class_11719 font, int iconHeight) {
        public static final Codec<ControlFont> CODEC = IOUtil.createFallbackCodec(RecordCodecBuilder.create(i -> i.group((App)class_11719.field_61971.fieldOf("id").forGetter(ControlFont::font), (App)Codec.INT.fieldOf("iconHeight").forGetter(ControlFont::iconHeight)).apply((Applicative)i, ControlFont::new)), class_11719.field_61971.xmap(ControlFont::new, ControlFont::font));

        public ControlFont(class_11719 font) {
            this(font, 15);
        }
    }

    public static interface UpdateEvent {
        public static final FactoryEvent<UpdateEvent> EVENT = new FactoryEvent(e -> (last, actual) -> e.invokeAll(l -> l.change(last, actual)));

        public void change(ControlType var1, ControlType var2);
    }
}

