/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1799;
import net.minecraft.class_1959;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.util.DynamicUtil;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.IdValueInfo;
import wily.legacy.util.IOUtil;

public record LegacyBiomeOverride(class_2960 id, Optional<class_2561> name, Optional<class_1799> item, Optional<Integer> waterColor, Optional<Integer> waterFogColor, Optional<Integer> fogColor, Optional<Integer> skyColor, Optional<Float> waterTransparency, Optional<Float> waterFogDistance) implements IdValueInfo<LegacyBiomeOverride>
{
    private final Optional<Integer> waterColor;
    private final Optional<Integer> waterFogColor;
    private final Optional<Integer> fogColor;
    private final Optional<Integer> skyColor;
    private final Optional<Float> waterTransparency;
    private final Optional<Float> waterFogDistance;
    public static final class_2960 DEFAULT_LOCATION = FactoryAPI.createVanillaLocation((String)"default");
    public static final Codec<LegacyBiomeOverride> CODEC = RecordCodecBuilder.create(i -> i.group((App)class_2960.field_25139.fieldOf("id").forGetter(LegacyBiomeOverride::id), (App)DynamicUtil.getComponentCodec().optionalFieldOf("name").forGetter(LegacyBiomeOverride::name), (App)DynamicUtil.ITEM_CODEC.optionalFieldOf("item").forGetter(LegacyBiomeOverride::item), (App)CommonColor.INT_COLOR_CODEC.optionalFieldOf("water_color").forGetter(LegacyBiomeOverride::waterColor), (App)CommonColor.INT_COLOR_CODEC.optionalFieldOf("water_fog_color").forGetter(LegacyBiomeOverride::waterFogColor), (App)CommonColor.INT_COLOR_CODEC.optionalFieldOf("fog_color").forGetter(LegacyBiomeOverride::fogColor), (App)CommonColor.INT_COLOR_CODEC.optionalFieldOf("sky_color").forGetter(LegacyBiomeOverride::skyColor), (App)Codec.FLOAT.optionalFieldOf("water_transparency").forGetter(LegacyBiomeOverride::waterTransparency), (App)Codec.FLOAT.optionalFieldOf("water_fog_distance").forGetter(LegacyBiomeOverride::waterFogDistance)).apply((Applicative)i, LegacyBiomeOverride::new));
    public static final Codec<List<LegacyBiomeOverride>> LIST_MAP_CODEC = IOUtil.createListIdMapCodec(CODEC, "id").fieldOf("overrides").codec();

    public LegacyBiomeOverride(class_2960 id) {
        this(id, Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static LegacyBiomeOverride getDefault() {
        return Legacy4JClient.legacyBiomeOverrides.map().computeIfAbsent((class_2960)DEFAULT_LOCATION, LegacyBiomeOverride::new);
    }

    public static LegacyBiomeOverride getOrDefault(Optional<class_5321<class_1959>> optionalKey) {
        return optionalKey.isEmpty() ? LegacyBiomeOverride.getDefault() : LegacyBiomeOverride.getOrDefault(optionalKey.get().method_29177());
    }

    public static LegacyBiomeOverride getOrDefault(class_2960 location) {
        return Legacy4JClient.legacyBiomeOverrides.map().getOrDefault(location, (LegacyBiomeOverride)LegacyBiomeOverride.getDefault());
    }

    public class_1799 icon() {
        return this.item.orElse(class_1799.field_8037);
    }

    public Optional<Float> waterTransparency() {
        return this.waterTransparency.or(() -> LegacyBiomeOverride.getDefault().waterTransparency);
    }

    public float getWaterTransparency() {
        return this.waterTransparency().orElse(Float.valueOf(1.0f)).floatValue();
    }

    public Optional<Integer> waterColor() {
        return this.waterColor.or(() -> LegacyBiomeOverride.getDefault().waterColor);
    }

    public int getWaterARGBOrDefault(int defaultColor) {
        return (int)(this.getWaterTransparency() * 255.0f) << 24 | this.waterColor().orElse(defaultColor) & 0xFFFFFF;
    }

    public Optional<Integer> waterFogColor() {
        return this.waterFogColor.or(() -> LegacyBiomeOverride.getDefault().waterFogColor);
    }

    public Optional<Integer> fogColor() {
        return this.fogColor.or(() -> LegacyBiomeOverride.getDefault().fogColor);
    }

    public Optional<Integer> skyColor() {
        return this.skyColor.or(() -> LegacyBiomeOverride.getDefault().skyColor);
    }

    public Optional<Float> waterFogDistance() {
        return this.waterFogDistance.or(() -> LegacyBiomeOverride.getDefault().waterFogDistance);
    }

    @Override
    public LegacyBiomeOverride copyFrom(LegacyBiomeOverride other) {
        return new LegacyBiomeOverride(this.id, other.name.or(this::name), other.item.or(this::item), other.waterColor.or(this::waterColor), other.waterFogColor.or(this::waterFogColor), other.fogColor.or(this::fogColor), other.skyColor.or(this::skyColor), other.waterTransparency.or(this::waterTransparency), other.waterFogDistance.or(this::waterFogDistance));
    }

    @Override
    public boolean isValid() {
        return true;
    }
}

