/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_3518;
import net.minecraft.class_4013;
import net.minecraft.class_7923;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.legacy.Legacy4J;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.CommonValue;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyIntro;
import wily.legacy.client.PlayerIdentifier;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.ControllerManager;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.KeyboardScreen;
import wily.legacy.util.IOUtil;

public class LegacyResourceManager
implements class_4013 {
    public static final class_2960 GAMEPAD_MAPPINGS = Legacy4J.createModLocation("gamepad_mappings.txt");
    public static final class_2960 INTRO_LOCATION = Legacy4J.createModLocation("intro.json");
    public static final class_2960 GAMMA_LOCATION = Legacy4J.createModLocation("gamma");
    public static final class_2960 DEFAULT_KEYBOARD_LAYOUT_LOCATION = Legacy4J.createModLocation("keyboard_layout/en_us.json");
    public static final class_2960 PLAYER_IDENTIFIERS_LOCATION = Legacy4J.createModLocation("player_identifiers.json");
    public static final String COMMON_COLORS = "common_colors.json";
    public static final String COMMON_VALUES = "common_values.json";
    public static final String DEFAULT_KBM_ICONS = "control_tooltips/icons/kbm.json";
    public static final String DEFAULT_CONTROLLER_ICONS = "control_tooltips/icons/controller.json";
    public static final List<KeyboardScreen.CharButtonBuilder> keyboardButtonBuilders = new ArrayList<KeyboardScreen.CharButtonBuilder>();
    public static LegacyIntro intro = LegacyIntro.EMPTY;
    public static ControllerBinding<?> shiftBinding;

    public static void setKeyboardLayout(class_3298 resource) {
        try {
            JsonObject obj = class_3518.method_15255((Reader)resource.method_43039());
            keyboardButtonBuilders.clear();
            shiftBinding = obj.has("shiftBinding") ? ControllerBinding.map.get(obj.get("shiftBinding").getAsString()) : ControllerBinding.LEFT_STICK_BUTTON;
            obj.getAsJsonArray("layout").forEach(e -> {
                if (e instanceof JsonObject) {
                    JsonObject o = (JsonObject)e;
                    keyboardButtonBuilders.add(new KeyboardScreen.CharButtonBuilder(class_3518.method_15282((JsonObject)o, (String)"width", (int)25), class_3518.method_15265((JsonObject)o, (String)"chars"), class_3518.method_15253((JsonObject)o, (String)"shiftChars", null), IOUtil.getJsonStringOrNull(o, "binding", ControllerBinding.map::get), IOUtil.getJsonStringOrNull(o, "icon", FactoryAPI::createLocation), IOUtil.getJsonStringOrNull(o, "soundEvent", s -> (class_3414)FactoryAPIPlatform.getRegistryValue((class_2960)FactoryAPI.createLocation((String)s), (class_2378)class_7923.field_41172))));
                } else if (e instanceof JsonPrimitive) {
                    JsonPrimitive p = (JsonPrimitive)e;
                    keyboardButtonBuilders.add(new KeyboardScreen.CharButtonBuilder(25, p.getAsString(), null, null, null, null));
                }
            });
        }
        catch (IOException e2) {
            Legacy4J.LOGGER.warn(e2.getMessage());
        }
    }

    public static <T extends ControlTooltip.CharsIcon> void addIcons(class_3300 resourceManager, class_2960 location, Codec<List<T>> codec, BiConsumer<String, ControlTooltip.LegacyIcon> addIcon) {
        resourceManager.method_14486(location).ifPresent(r -> {
            try (BufferedReader reader = r.method_43039();){
                codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)reader)).resultOrPartial(error -> Legacy4J.LOGGER.warn("Failed to parse {}: {}", (Object)location, error)).ifPresent(charsIcons -> {
                    for (ControlTooltip.CharsIcon charsIcon : charsIcons) {
                        addIcon.accept(charsIcon.name(), charsIcon);
                    }
                });
            }
            catch (IOException e) {
                Legacy4J.LOGGER.warn(e.getMessage());
            }
        });
    }

    public static void addControllerIcons(class_3300 resourceManager, class_2960 location, BiConsumer<String, ControlTooltip.LegacyIcon> addIcon) {
        LegacyResourceManager.addIcons(resourceManager, location, ControlTooltip.ControllerIcon.LIST_CODEC, addIcon);
    }

    public static void addKbmIcons(class_3300 resourceManager, class_2960 location, BiConsumer<String, ControlTooltip.LegacyIcon> addIcon) {
        LegacyResourceManager.addIcons(resourceManager, location, ControlTooltip.KeyIcon.LIST_CODEC, addIcon);
    }

    public static void loadIntroLocations(class_3300 resourceManager) {
        try {
            LegacyIntro.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)resourceManager.openAsReader(INTRO_LOCATION))).result().ifPresent(i -> {
                intro = i;
            });
        }
        catch (IOException e) {
            Legacy4J.LOGGER.error(e.getMessage());
        }
    }

    public void method_14491(class_3300 resourceManager) {
        class_310 minecraft = class_310.method_1551();
        resourceManager.method_14486(GAMEPAD_MAPPINGS).ifPresent(r -> {
            try {
                ControllerManager.getHandler().applyGamePadMappingsFromBuffer(r.method_43039());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        PlayerIdentifier.list.clear();
        resourceManager.method_14489(PLAYER_IDENTIFIERS_LOCATION).forEach(r -> {
            try {
                class_3518.method_37165((Reader)r.method_43039()).forEach(e -> PlayerIdentifier.CODEC.parse((DynamicOps)JsonOps.INSTANCE, e).result().ifPresent(p -> PlayerIdentifier.list.put(p.index(), p)));
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        });
        CommonValue.COMMON_VALUES.forEach((s, c) -> c.reset());
        CommonColor.COMMON_COLORS.forEach((s, c) -> c.reset());
        resourceManager.method_14486(DEFAULT_KEYBOARD_LAYOUT_LOCATION).ifPresent(LegacyResourceManager::setKeyboardLayout);
        IOUtil.getOrderedNamespaces(resourceManager).forEach(name -> {
            resourceManager.method_14486(FactoryAPI.createLocation((String)name, (String)COMMON_COLORS)).ifPresent(r -> {
                try {
                    JsonObject obj = class_3518.method_15255((Reader)r.method_43039());
                    obj.asMap().forEach((s, e) -> {
                        class_2960 id = FactoryAPI.createLocation((String)s);
                        if (CommonColor.COMMON_COLORS.containsKey((Object)id)) {
                            ((CommonColor)((Object)((Object)((Object)((Object)CommonColor.COMMON_COLORS.get((Object)id)))))).parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, e));
                        }
                    });
                }
                catch (IOException e2) {
                    Legacy4J.LOGGER.warn(e2.getMessage());
                }
            });
            resourceManager.method_14486(FactoryAPI.createLocation((String)name, (String)COMMON_VALUES)).ifPresent(r -> {
                try {
                    JsonObject obj = class_3518.method_15255((Reader)r.method_43039());
                    obj.asMap().forEach((s, e) -> {
                        class_2960 id = FactoryAPI.createLocation((String)s);
                        if (CommonColor.COMMON_VALUES.containsKey((Object)id)) {
                            ((CommonValue)((Object)((Object)((Object)((Object)CommonColor.COMMON_VALUES.get((Object)id)))))).parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, e));
                        }
                    });
                }
                catch (IOException e2) {
                    Legacy4J.LOGGER.warn(e2.getMessage());
                }
            });
            LegacyResourceManager.addKbmIcons(resourceManager, FactoryAPI.createLocation((String)name, (String)DEFAULT_KBM_ICONS), (s, b) -> {
                for (ControlType value : Legacy4JClient.controlTypesManager.map().values()) {
                    if (!value.isKbm()) continue;
                    value.icons().put((String)s, (ControlTooltip.LegacyIcon)b);
                }
            });
            LegacyResourceManager.addControllerIcons(resourceManager, FactoryAPI.createLocation((String)name, (String)DEFAULT_CONTROLLER_ICONS), (s, b) -> {
                for (ControlType value : Legacy4JClient.controlTypesManager.map().values()) {
                    if (value.isKbm()) continue;
                    value.icons().put((String)s, (ControlTooltip.LegacyIcon)b);
                }
            });
            for (ControlType value : Legacy4JClient.controlTypesManager.map().values()) {
                class_2960 location = FactoryAPI.createLocation((String)value.id().method_12836(), (String)"control_tooltips/icons/%s.json".formatted(value.id().method_12832()));
                if (value.isKbm()) {
                    LegacyResourceManager.addKbmIcons(resourceManager, location, value.icons()::put);
                    continue;
                }
                LegacyResourceManager.addControllerIcons(resourceManager, location, value.icons()::put);
            }
            String langKey = minecraft.method_1526().method_4668(minecraft.method_1526().method_4669()) != null ? minecraft.method_1526().method_4669() : "en_us";
            resourceManager.method_14486(FactoryAPI.createLocation((String)name, (String)"keyboard_layout/%s.json".formatted(langKey))).ifPresent(LegacyResourceManager::setKeyboardLayout);
        });
    }

    public String method_22322() {
        return "legacy:resource_manager";
    }
}

