/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.mojang.serialization.Codec;
import java.util.function.Function;
import net.minecraft.class_2960;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.RegisterListing;
import wily.legacy.client.IdValueInfo;

public class OptionHolder<T>
implements RegisterListing.Holder<T> {
    public static final OptionHolder<?> AUTO = new OptionHolder<Object>(null, r -> null){

        @Override
        public String toString() {
            return "auto";
        }
    };
    public static final OptionHolder<?> NONE = new OptionHolder<Object>(null, r -> null){

        @Override
        public String toString() {
            return "none";
        }
    };
    private final class_2960 id;
    private final Function<class_2960, T> valueGetter;

    public OptionHolder(class_2960 id, Function<class_2960, T> valueGetter) {
        this.id = id;
        this.valueGetter = valueGetter;
    }

    public static <T> Codec<OptionHolder<T>> createCodecWithAuto(Function<class_2960, T> valueGetter) {
        return Codec.STRING.xmap(value -> OptionHolder.parseWithAuto(value, valueGetter), OptionHolder::toString);
    }

    public static <T> Codec<OptionHolder<T>> createCodec(Function<class_2960, T> valueGetter) {
        return Codec.STRING.xmap(value -> OptionHolder.parse(value, valueGetter), OptionHolder::toString);
    }

    public static <T> OptionHolder<T> parseWithAuto(String stringId, Function<class_2960, T> valueGetter) {
        if (stringId.equals("auto")) {
            return OptionHolder.auto();
        }
        class_2960 id = FactoryAPI.createLocation((String)stringId);
        return id == null ? OptionHolder.auto() : new OptionHolder<T>(id, valueGetter);
    }

    public static <T> OptionHolder<T> parse(String stringId, Function<class_2960, T> valueGetter) {
        if (stringId.equals("none")) {
            return OptionHolder.none();
        }
        class_2960 id = FactoryAPI.createLocation((String)stringId);
        return id == null ? OptionHolder.none() : new OptionHolder<T>(id, valueGetter);
    }

    public static <T> OptionHolder<T> auto() {
        return AUTO;
    }

    public static <T> OptionHolder<T> none() {
        return NONE;
    }

    public static <T extends IdValueInfo<T>> OptionHolder<T> of(T value) {
        return new OptionHolder<IdValueInfo>(value.id(), r -> value);
    }

    public boolean isAuto() {
        return this.isNone();
    }

    public boolean isNone() {
        return this.get() == null;
    }

    public T orElse(T alternative) {
        T value = this.get();
        return value == null ? alternative : value;
    }

    public boolean equals(Object obj) {
        OptionHolder h;
        return obj instanceof OptionHolder && (h = (OptionHolder)obj).get() == this.get();
    }

    public class_2960 getId() {
        return this.id;
    }

    public String toString() {
        return this.id.toString();
    }

    public T get() {
        return this.valueGetter.apply(this.id);
    }
}

