/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1041;
import net.minecraft.class_1058;
import net.minecraft.class_1144;
import net.minecraft.class_11905;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_364;
import net.minecraft.class_3675;
import net.minecraft.class_4068;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_5244;
import net.minecraft.class_5348;
import net.minecraft.class_6382;
import net.minecraft.class_7764;
import net.minecraft.class_8016;
import net.minecraft.class_8021;
import net.minecraft.class_8023;
import net.minecraft.class_8028;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.Stocker;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyResourceManager;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyScrollRenderer;
import wily.legacy.client.screen.OverlayPanelScreen;
import wily.legacy.client.screen.Panel;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.init.LegacyRegistries;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

public class KeyboardScreen
extends OverlayPanelScreen {
    public static final class_2561 KEYBOARD = class_2561.method_43471((String)"legacy.menu.keyboard");
    protected final LegacyScrollRenderer scrollRenderer = new LegacyScrollRenderer();
    protected final KeyButton shiftButton;
    protected final KeyButton upButton;
    protected final KeyButton downButton;
    protected final KeyButton rightButton;
    protected final KeyButton leftButton;
    protected final KeyButton backspaceButton;
    protected final KeyButton confirmButton;
    private final Supplier<class_364> listenerSupplier;
    public boolean shift = false;
    protected RenderableVList renderableVList = new RenderableVList(this.accessor).layoutSpacing(l -> 1);
    protected RenderableVList leftKeyBar = new RenderableVList(this.accessor).layoutSpacing(l -> 0);
    protected RenderableVList rightKeyBar = new RenderableVList(this.accessor).layoutSpacing(l -> 0);
    protected boolean shiftLock = false;
    protected int lastX = 0;
    protected int lastY = 0;
    protected int xDiff = 0;
    protected int yDiff = 0;

    public KeyboardScreen(Supplier<class_364> listener, class_437 parent) {
        this(60, listener, parent);
    }

    public KeyboardScreen(int yOffset, Supplier<class_364> listener, class_437 parent) {
        this((class_437 s, Panel p) -> p.centeredLeftPos((class_437)s), (s, p) -> Math.min(p.centeredTopPos((class_437)s) + yOffset, s.field_22790 - p.height), listener, parent);
    }

    public KeyboardScreen(BiFunction<class_437, Panel, Integer> leftPosGetter, BiFunction<class_437, Panel, Integer> topPosGetter, Supplier<class_364> listener, class_437 parent) {
        this((class_437 s) -> Panel.createPanel(s, p -> p.appearance(LegacySprites.PANEL, 385, 154), p -> p.pos((Integer)leftPosGetter.apply((class_437)s, (Panel)((Object)p)), (Integer)topPosGetter.apply((class_437)s, (Panel)((Object)p)))), listener, parent);
    }

    public KeyboardScreen(Function<class_437, Panel> panelConstructor, Supplier<class_364> listener, class_437 parent) {
        super(parent, panelConstructor, class_5244.field_39003);
        this.listenerSupplier = listener;
        this.renderableVList.forceWidth = false;
        this.darkBackground = false;
        LegacyResourceManager.keyboardButtonBuilders.forEach(b -> this.renderableVList.addRenderable((class_4068)b.build(this)));
        this.leftButton = new KeyButton(263, this.listenerSupplier, ControllerBinding.LEFT_BUMPER, LegacySprites.SCROLL_LEFT);
        this.leftKeyBar.addRenderable((class_4068)this.leftButton);
        this.rightButton = new KeyButton(262, this.listenerSupplier, ControllerBinding.RIGHT_BUMPER, LegacySprites.SCROLL_RIGHT);
        this.rightKeyBar.addRenderable((class_4068)this.rightButton);
        this.upButton = new KeyButton(265, 20, this.listenerSupplier, null, LegacySprites.SCROLL_UP);
        this.leftKeyBar.addRenderable((class_4068)this.upButton);
        this.downButton = new KeyButton(264, 20, this.listenerSupplier, null, LegacySprites.SCROLL_DOWN);
        this.leftKeyBar.addRenderable((class_4068)this.downButton);
        this.shiftButton = new KeyButton(340, this.listenerSupplier, LegacyResourceManager.shiftBinding, LegacySprites.SHIFT){
            long lastRelease;

            @Override
            public boolean playSoundOnClick() {
                return this.pressTime == 0 && !KeyboardScreen.this.shiftLock;
            }

            @Override
            public void onRelease() {
                long millis = class_156.method_658();
                if (!KeyboardScreen.this.shiftLock) {
                    if (this.pressTime >= 6 || millis - this.lastRelease <= 300L) {
                        LegacySoundUtil.playSimpleUISound((class_3414)LegacyRegistries.SHIFT_LOCK.get(), 1.0f);
                        KeyboardScreen.this.shiftLock = true;
                    }
                    KeyboardScreen.this.shift = !KeyboardScreen.this.shift || KeyboardScreen.this.shiftLock;
                } else {
                    KeyboardScreen.this.shiftLock = false;
                    LegacySoundUtil.playSimpleUISound((class_3414)LegacyRegistries.SHIFT_UNLOCK.get(), 1.0f);
                }
                this.lastRelease = millis;
                super.onRelease();
            }

            @Override
            public class_2960 getSprite() {
                return KeyboardScreen.this.shiftLock ? LegacySprites.BUTTON_SLOT_SELECTED : super.getSprite();
            }
        };
        this.leftKeyBar.addRenderable((class_4068)this.shiftButton);
        this.backspaceButton = new KeyButton(this, 259, this.listenerSupplier, ControllerBinding.LEFT_BUTTON, LegacySprites.BACK){

            @Override
            public class_3414 getDownSoundEvent() {
                return (class_3414)LegacyRegistries.BACKSPACE.get();
            }
        };
        this.rightKeyBar.addRenderable((class_4068)this.backspaceButton);
        this.confirmButton = new KeyButton(257, this.listenerSupplier, ControllerBinding.START, LegacySprites.TICK){

            @Override
            public void method_25306(class_11907 input) {
                KeyboardScreen.this.method_25419();
            }
        };
        this.rightKeyBar.addRenderable((class_4068)this.confirmButton);
    }

    public static boolean isOpenKey(int i) {
        return i == 335 && !Legacy4JClient.controllerManager.isControllerTheLastInput() || i == 257 && Legacy4JClient.controllerManager.isControllerTheLastInput();
    }

    public static KeyboardScreen fromStaticListener(class_364 listener, class_437 parent) {
        KeyboardScreen keyboardScreen;
        if (listener instanceof class_8021) {
            class_8021 e = (class_8021)listener;
            keyboardScreen = new KeyboardScreen((s, p) -> Math.max(0, Math.min(e.method_46426() + (e.method_25368() - p.width) / 2, s.field_22789 - p.width)), (s, p) -> Math.max(0, Math.min(s.field_22790 - (e.method_46427() + e.method_25364()) >= p.height ? e.method_46427() + e.method_25364() + 4 : e.method_46427() - p.method_25364() - 4, s.field_22790 - p.height)), () -> listener, parent);
        } else {
            keyboardScreen = new KeyboardScreen(() -> listener, parent);
        }
        return keyboardScreen;
    }

    @Override
    public void addControlTooltips(ControlTooltip.Renderer renderer) {
        super.addControlTooltips(renderer);
        renderer.add(() -> ControlType.getActiveType().isKbm() ? ControlTooltip.getKeyIcon(0) : ControllerBinding.RIGHT_STICK.getIcon(), () -> LegacyComponents.MOVE_KEYBOARD);
    }

    @Override
    protected void method_25426() {
        class_4068 class_40682;
        this.panel.init();
        this.lastX = this.panel.method_46426();
        this.lastY = this.panel.method_46427();
        this.panel.method_48229(this.lastX + this.xDiff, this.lastY + this.yDiff);
        this.renderableVList.init(this.panel.method_46426() + (this.panel.method_25368() - 259) / 2, this.panel.method_46427() + 28, 268, 124);
        this.leftKeyBar.init(this.panel.method_46426() + 6, this.panel.method_46427() + 27, 50, 0);
        this.rightKeyBar.init(this.panel.method_46426() + this.panel.method_25368() - 56, this.panel.method_46427() + 27, 50, 0);
        if (this.method_25399() == null && !this.renderableVList.renderables.isEmpty() && (class_40682 = this.renderableVList.renderables.get(0)) instanceof class_364) {
            class_364 l = (class_364)class_40682;
            this.method_25395(l);
        }
    }

    public void method_25410(class_310 minecraft, int i, int j) {
        this.method_25419();
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        super.method_25394(guiGraphics, i, j, f);
        class_364 class_3642 = this.method_25399();
        if (class_3642 instanceof CharButton) {
            CharButton c = (CharButton)class_3642;
            c.renderTooltip(guiGraphics, i, j, f);
        }
    }

    public boolean method_25400(class_11905 characterEvent) {
        for (class_4068 renderable : this.renderableVList.renderables) {
            CharButton b;
            if (!(renderable instanceof CharButton) || !(b = (CharButton)renderable).matches(characterEvent)) continue;
            if (b.method_25370()) {
                b.onRelease();
                break;
            }
            this.method_25395((class_364)b);
            break;
        }
        return super.method_25400(characterEvent);
    }

    public boolean method_25404(class_11908 keyEvent) {
        if (keyEvent.comp_4795() == 259) {
            if (this.backspaceButton.method_25370()) {
                this.backspaceButton.method_25306((class_11907)keyEvent);
            } else {
                this.method_25395((class_364)this.backspaceButton);
            }
            return true;
        }
        if (this.renderableVList.keyPressed(keyEvent.comp_4795())) {
            return true;
        }
        return super.method_25404(keyEvent);
    }

    public boolean method_25403(class_11909 mouseButtonEvent, double d, double e) {
        if ((d != 0.0 || e != 0.0) && mouseButtonEvent.method_74245() == 0 && LegacyRenderUtil.isMouseOver(mouseButtonEvent.comp_4798(), mouseButtonEvent.comp_4799(), this.panel.method_46426(), this.panel.method_46427(), this.panel.method_25368(), this.panel.method_25364())) {
            this.xDiff = Math.max(0, Math.min(this.panel.method_46426() + Math.round((float)d), this.field_22789 - this.panel.method_25368())) - this.lastX;
            this.yDiff = Math.max(0, Math.min(this.panel.method_46427() + Math.round((float)e), this.field_22790 - this.panel.method_25364())) - this.lastY;
            this.method_48640();
        }
        return super.method_25403(mouseButtonEvent, d, e);
    }

    @Override
    public void renderDefaultBackground(class_332 guiGraphics, int i, int j, float f) {
        super.renderDefaultBackground(guiGraphics, i, j, f);
        FactoryGuiGraphics.of((class_332)guiGraphics).setBlitColor(1.0f, 1.0f, 1.0f, 0.8f);
        this.panel.method_25394(guiGraphics, i, j, f);
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)this.panel.method_46426() + 4.5f, (float)this.panel.method_46427() + 25.4f);
        FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, 0, 0, 53, 123);
        FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(LegacySprites.SQUARE_RECESSED_PANEL, this.panel.method_25368() - 62, 0, 53, 123);
        guiGraphics.method_51448().translate(-4.5f, 0.0f);
        FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(LegacySprites.PANEL_RECESS, (this.panel.method_25368() - 267) / 2, -1, 267, 125);
        guiGraphics.method_51448().popMatrix();
        FactoryGuiGraphics.of((class_332)guiGraphics).clearBlitColor();
        guiGraphics.method_51448().pushMatrix();
        guiGraphics.method_51448().translate((float)this.panel.method_46426() + ((float)this.panel.method_25368() - (float)this.field_22793.method_27525((class_5348)KEYBOARD) * 1.5f) / 2.0f, (float)(this.panel.method_46427() + 8));
        guiGraphics.method_51448().scale(1.5f, 1.5f);
        guiGraphics.method_51439(this.field_22793, KEYBOARD, 0, 0, ((Integer)CommonColor.INVENTORY_GRAY_TEXT.get()).intValue(), false);
        guiGraphics.method_51448().popMatrix();
    }

    @Override
    public void bindingStateTick(BindingState state) {
        this.method_25396().forEach(r -> {
            if (r instanceof ActionButton) {
                ActionButton a = (ActionButton)((Object)r);
                if (state.is(a.binding)) {
                    if (state.canClick()) {
                        a.method_25354(this.field_22787.method_1483());
                        a.method_25306((class_11907)new class_11908(257, 0, 0));
                    } else if (state.released) {
                        a.onRelease();
                    }
                }
            }
        });
        if (state.is(ControllerBinding.RIGHT_STICK) && state instanceof BindingState.Axis) {
            BindingState.Axis a = (BindingState.Axis)state;
            if (state.canClick(20)) {
                if (state.canClick()) {
                    LegacySoundUtil.playSimpleUISound((class_3414)LegacyRegistries.SCROLL.get(), 1.0f);
                }
                this.xDiff = Math.max(0, Math.min(this.panel.method_46426() + Math.round(a.x * 4.0f), this.field_22789 - this.panel.method_25368())) - this.lastX;
                this.yDiff = Math.max(0, Math.min(this.panel.method_46427() + Math.round(a.y * 4.0f), this.field_22790 - this.panel.method_25364())) - this.lastY;
                this.method_48640();
            }
        }
    }

    @Override
    public boolean onceClickBindings(BindingState b) {
        return false;
    }

    public static class KeyButton
    extends ActionButton {
        public final int key;
        private final Supplier<class_364> keyListener;

        public KeyButton(int key, Supplier<class_364> keyListener, ControllerBinding binding, class_2960 iconSprite) {
            this(key, 40, keyListener, binding, iconSprite);
        }

        public KeyButton(int key, int height, Supplier<class_364> keyListener, ControllerBinding binding, class_2960 iconSprite) {
            super(50, height, class_5244.field_39003, binding, iconSprite);
            this.key = key;
            this.keyListener = keyListener;
        }

        @Override
        public boolean playSoundOnClick() {
            return true;
        }

        protected void method_48579(class_332 guiGraphics, int i, int j, float f) {
            FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(this.getSprite(), this.method_46426(), this.method_46427(), this.method_25368(), this.method_25364());
            FactoryScreenUtil.enableBlend();
            this.method_48589(guiGraphics, class_310.method_1551().field_1772, LegacyRenderUtil.getDefaultTextColor(!this.method_25367()));
            FactoryScreenUtil.disableBlend();
        }

        public class_2960 getSprite() {
            return this.method_25367() ? LegacySprites.BUTTON_SLOT_HIGHLIGHTED : LegacySprites.BUTTON_SLOT;
        }

        @Override
        public void method_25306(class_11907 input) {
            super.method_25306(input);
            class_364 l = this.keyListener.get();
            if (l != null) {
                l.method_25365(true);
                l.method_25404(new class_11908(this.key, 0, 0));
            }
        }
    }

    public class CharButton
    extends ActionButton {
        private final String chars;
        private final String shiftChars;
        private final class_3414 downSound;
        private int selectedChar;

        public CharButton(int width, String chars, String shiftChars, ControllerBinding binding, class_2960 iconSprite, class_3414 downSound) {
            super(width, 20, class_5244.field_39003, binding, iconSprite);
            this.selectedChar = 0;
            this.chars = chars;
            this.shiftChars = shiftChars;
            this.downSound = downSound;
        }

        public static boolean hasShiftDown() {
            return class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)340) || class_3675.method_15987((class_1041)class_310.method_1551().method_22683(), (int)344);
        }

        public boolean matches(class_11905 characterEvent) {
            return this.chars.contains(characterEvent.method_74226()) || this.shiftChars != null && this.shiftChars.contains(characterEvent.method_74226());
        }

        public void renderTooltip(class_332 guiGraphics, int i, int j, float f) {
            if (this.pressTime >= 6 && this.getSelectedChars().length() > 1) {
                int width = 18;
                char[] chars = this.getSelectedChars().toCharArray();
                for (int i1 = 0; i1 < chars.length; ++i1) {
                    String s = String.valueOf(chars[i1]);
                    width += KeyboardScreen.this.field_22793.method_1727(s) + (i1 == 0 ? 0 : 2);
                }
                int diffX = 0;
                LegacyRenderUtil.renderPointerPanel(guiGraphics, this.method_46426() + (this.method_25368() - width) / 2, this.method_46427() - 17, width, 15);
                for (char c : chars) {
                    String s = String.valueOf(c);
                    guiGraphics.method_25303(KeyboardScreen.this.field_22793, s, this.method_46426() + (this.method_25368() - width) / 2 + diffX + 9, this.method_46427() - 14, c == this.getSelectedChar() ? -256 : -1);
                    diffX += KeyboardScreen.this.field_22793.method_1727(s) + 2;
                }
                KeyboardScreen.this.scrollRenderer.renderScroll(guiGraphics, class_8028.field_41828, this.method_46426() + (this.method_25368() - width) / 2 + 2, this.method_46427() - 15);
                KeyboardScreen.this.scrollRenderer.renderScroll(guiGraphics, class_8028.field_41829, this.method_46426() + (this.method_25368() - width) / 2 + width - 9, this.method_46427() - 15);
            }
        }

        @Override
        public class_3414 getDownSoundEvent() {
            return this.downSound == null ? super.getDownSoundEvent() : this.downSound;
        }

        public boolean method_25404(class_11908 keyEvent) {
            if ((keyEvent.method_74232() || keyEvent.method_74233()) && this.pressTime >= 6) {
                this.selectedChar = Stocker.cyclic((int)0, (int)(this.selectedChar + (keyEvent.method_74233() ? 1 : -1)), (int)this.getSelectedChars().length());
                return true;
            }
            return super.method_25404(keyEvent);
        }

        public void method_25365(boolean bl) {
            super.method_25365(bl);
            if (!bl && this.pressTime > 0) {
                this.onRelease();
            }
        }

        @Override
        public void onRelease() {
            class_364 l = KeyboardScreen.this.listenerSupplier.get();
            if (l != null) {
                KeyboardScreen.this.parent.method_25395(l);
                l.method_25400(new class_11905((int)this.getSelectedChar(), 0));
            }
            if (this.shiftChars != null && KeyboardScreen.this.shift && !KeyboardScreen.this.shiftLock) {
                KeyboardScreen.this.shift = false;
            }
            this.selectedChar = 0;
            super.onRelease();
        }

        public char getSelectedChar() {
            String characters;
            return characters.charAt((characters = this.getSelectedChars()).length() > this.selectedChar ? this.selectedChar : 0);
        }

        public String getSelectedChars() {
            return this.shiftChars != null && (CharButton.hasShiftDown() || KeyboardScreen.this.shift) ? this.shiftChars : this.chars;
        }

        public class_2561 method_25369() {
            return class_2561.method_43470((String)String.valueOf(this.getSelectedChar()));
        }
    }

    public static abstract class ActionButton
    extends class_4264 {
        public final ControllerBinding binding;
        private final class_2960 iconSprite;
        public int pressTime = 0;

        public ActionButton(int k, int l, class_2561 component, ControllerBinding binding, class_2960 iconSprite) {
            super(0, 0, k, l, component);
            this.binding = binding;
            this.iconSprite = iconSprite;
        }

        public void onRelease() {
            this.pressTime = 0;
        }

        public void method_25306(class_11907 input) {
            ++this.pressTime;
        }

        public void method_25354(class_1144 soundManager) {
            if (this.playSoundOnClick()) {
                LegacySoundUtil.playSimpleUISound(this.getDownSoundEvent(), 1.0f);
            }
        }

        public boolean playSoundOnClick() {
            return this.pressTime == 0;
        }

        public class_3414 getDownSoundEvent() {
            return (class_3414)LegacyRegistries.ACTION.get();
        }

        public void method_25357(class_11909 event) {
            if (this.pressTime > 0) {
                this.onRelease();
            }
        }

        @Nullable
        public class_8016 method_48205(class_8023 focusNavigationEvent) {
            return super.method_48205(focusNavigationEvent);
        }

        public boolean method_16803(class_11908 keyEvent) {
            if (this.field_22763 && this.field_22764 && keyEvent.method_74229() && this.pressTime > 0) {
                this.onRelease();
                return true;
            }
            return false;
        }

        protected void method_49604(class_332 guiGraphics, class_327 font, int i, int j) {
            int bindingOffset = 0;
            if (this.binding != null && Legacy4JClient.controllerManager.connectedController != null) {
                bindingOffset = this.binding.getIcon().render(guiGraphics, this.method_46426() + i, this.method_46427() + (this.method_25364() - 9) / 2 + 1, true);
            }
            if (this.iconSprite == null) {
                ActionButton.method_52718((class_332)guiGraphics, (class_327)font, (class_2561)this.method_25369(), (int)(this.method_46426() + i + bindingOffset), (int)this.method_46427(), (int)(this.method_46426() + this.method_25368() - i), (int)(this.method_46427() + this.method_25364()), (int)j);
            } else {
                class_1058 sprite = FactoryGuiGraphics.getSprites().field_5280.getOrDefault(this.iconSprite, null);
                if (sprite == null) {
                    return;
                }
                try (class_7764 contents = sprite.method_45851();){
                    FactoryScreenUtil.enableBlend();
                    FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(this.iconSprite, this.method_46426() + (this.method_25368() - contents.method_45807()) / 2 + Math.max(0, i + bindingOffset - (this.method_25368() - contents.method_45807()) / 2), this.method_46427() + (this.method_25364() - contents.method_45815()) / 2, contents.method_45807(), contents.method_45815());
                    FactoryScreenUtil.disableBlend();
                }
            }
        }

        protected void method_47399(class_6382 narrationElementOutput) {
            this.method_37021(narrationElementOutput);
        }
    }

    public record CharButtonBuilder(int width, String chars, String shiftChars, ControllerBinding binding, class_2960 iconSprite, class_3414 downSound) {
        public CharButton build(KeyboardScreen screen) {
            KeyboardScreen keyboardScreen = screen;
            Objects.requireNonNull(keyboardScreen);
            return keyboardScreen.new CharButton(this.width, this.chars, this.shiftChars, this.binding, this.iconSprite, this.downSound);
        }
    }
}

