/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BooleanSupplier;
import net.minecraft.class_11719;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_333;
import net.minecraft.class_437;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_7764;
import wily.factoryapi.base.ArbitrarySupplier;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.factoryapi.util.FactoryScreenUtil;
import wily.legacy.Legacy4JClient;
import wily.legacy.client.CommonColor;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacyTip;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.LegacyLoading;
import wily.legacy.network.TopMessage;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyFontUtil;
import wily.legacy.util.client.LegacyRenderUtil;
import wily.legacy.util.client.LegacySoundUtil;

public class LegacyLoadingScreen
extends class_437
implements LegacyLoading,
ControlTooltip.Event {
    private float progress;
    private class_2561 loadingHeader;
    private class_2561 loadingStage;
    private boolean genericLoading;
    private UIAccessor accessor = UIAccessor.of((class_437)this);

    public LegacyLoadingScreen() {
        super(class_333.field_18967);
    }

    public LegacyLoadingScreen(class_2561 loadingHeader, class_2561 loadingStage) {
        this();
        this.setLoadingHeader(loadingHeader);
        this.setLoadingStage(loadingStage);
    }

    public static LegacyLoadingScreen getDimensionChangeScreen(final BooleanSupplier levelReady, class_5321<class_1937> lastLevel, class_5321<class_1937> newLevel) {
        final long createdTime = class_156.method_658();
        boolean lastOd = LegacyLoadingScreen.isOtherDimension(lastLevel);
        boolean od = LegacyLoadingScreen.isOtherDimension(newLevel);
        LegacyLoadingScreen screen = new LegacyLoadingScreen((class_2561)(od || lastOd ? class_2561.method_43469((String)("legacy.menu." + (lastOd ? "leaving" : "entering")), (Object[])new Object[]{LegacyComponents.getDimensionName(lastOd ? lastLevel : newLevel)}) : class_2561.method_43473()), (class_2561)class_2561.method_43473()){

            public void method_25393() {
                if (levelReady.getAsBoolean() || class_156.method_658() - createdTime >= 30000L) {
                    this.field_22787.method_1507(null);
                }
            }

            public boolean method_25421() {
                return false;
            }
        };
        if (od || lastOd) {
            screen.setGenericLoading(true);
        }
        return screen;
    }

    public static boolean isOtherDimension(class_5321<class_1937> level) {
        return level != null && level != class_1937.field_25179;
    }

    public static LegacyLoadingScreen getRespawningScreen(final BooleanSupplier levelReady) {
        final long createdTime = class_156.method_658();
        LegacyLoadingScreen screen = new LegacyLoadingScreen(LegacyComponents.RESPAWNING, (class_2561)class_2561.method_43473()){

            public void method_25393() {
                if (levelReady.getAsBoolean() || class_156.method_658() - createdTime >= 30000L) {
                    this.field_22787.method_1507(null);
                }
            }

            public boolean method_25421() {
                return false;
            }
        };
        screen.setGenericLoading(true);
        return screen;
    }

    public static void startFakeAutoSave() {
        if (!((Boolean)LegacyOptions.fakeAutosaveScreen.get()).booleanValue()) {
            return;
        }
        class_310.method_1551().field_1705.field_35428 = 0.0f;
        TopMessage.setMedium(null);
        class_310.method_1551().method_1507((class_437)LegacyLoadingScreen.getFakeAutoSaveScreen());
    }

    public static LegacyLoadingScreen getFakeAutoSaveScreen() {
        return new LegacyLoadingScreen(LegacyComponents.PREPARING_AUTOSAVE, LegacyComponents.PREPARING_CHUNKS){
            int finalizingTicks = -1;

            public void method_25393() {
                this.field_22787.field_1705.field_35428 = 0.0f;
                super.method_25393();
                if (this.finalizingTicks < 0) {
                    this.setProgress(this.getProgress() + 0.02f);
                    if ((double)this.getProgress() >= 1.0) {
                        this.finalizingTicks = 80;
                        this.setProgress(0.0f);
                        this.setLoadingStage(LegacyComponents.FINALIZING);
                    }
                } else if (this.finalizingTicks > 0) {
                    --this.finalizingTicks;
                } else {
                    this.method_25419();
                    LegacySoundUtil.playBackSound();
                    this.field_22787.field_1705.field_35428 = 1.0f;
                }
            }
        };
    }

    public static LegacyLoadingScreen createWithExecutor(class_2561 header, final Runnable onClose, final ExecutorService executor) {
        return new LegacyLoadingScreen(header, (class_2561)class_2561.method_43473()){

            public void method_25419() {
                onClose.run();
                4.closeExecutor(executor);
            }

            @Override
            public boolean method_25422() {
                return true;
            }
        };
    }

    public static void closeExecutor(ExecutorService executor) {
        boolean bl;
        executor.shutdown();
        try {
            bl = executor.awaitTermination(3L, TimeUnit.SECONDS);
        }
        catch (InterruptedException var3) {
            bl = false;
        }
        if (!bl) {
            executor.shutdownNow();
        }
    }

    public void prepareRender(class_310 minecraft, int width, int height, class_2561 loadingHeader, class_2561 loadingStage, float progress, boolean genericLoading) {
        this.method_25410(minecraft, width, height);
        this.field_22787 = minecraft;
        this.accessor = UIAccessor.of((class_437)minecraft.field_1755);
        this.setLoadingHeader((class_2561)this.accessor.getElementValue("loadingHeader.component", (Object)loadingHeader, class_2561.class));
        this.setLoadingStage((class_2561)this.accessor.getElementValue("loadingStage.component", (Object)loadingStage, class_2561.class));
        this.setProgress(this.accessor.getFloat("progress", progress));
        this.setGenericLoading(this.accessor.getBoolean("genericLoading", Boolean.valueOf(genericLoading)));
    }

    public boolean method_25422() {
        return false;
    }

    public void method_25420(class_332 guiGraphics, int i, int j, float f) {
        LegacyRenderUtil.renderDefaultBackground(this.accessor, guiGraphics, true, true, false);
    }

    public void method_25394(class_332 guiGraphics, int i, int j, float f) {
        FactoryScreenUtil.disableDepthTest();
        LegacyRenderUtil.renderDefaultBackground(this.accessor, guiGraphics, true, true, false);
        super.method_25394(guiGraphics, i, j, f);
        ArbitrarySupplier fontOverride = this.accessor.getElement("fontOverride", class_2960.class);
        if (!this.isGenericLoading()) {
            if (this.getProgress() != -1.0f) {
                LegacyTip tip;
                int loadingBarX = this.accessor.getInteger("loadingBar.x", this.field_22789 / 2 - 160);
                int loadingBarY = this.accessor.getInteger("loadingBar.y", this.field_22790 / 2 + 15);
                if (this.getLoadingStage() != null) {
                    LegacyFontUtil.applySmallerFont((class_11719)fontOverride.map(class_11719.class_11721::new).orElse((Object)class_11719.field_61972), b -> guiGraphics.method_27535(this.field_22787.field_1772, this.getLoadingStage(), this.accessor.getInteger("loadingStage.x", loadingBarX + 1), this.accessor.getInteger("loadingStage.y", this.field_22790 / 2 + 5), ((Integer)CommonColor.STAGE_TEXT.get()).intValue()));
                }
                try (class_7764 contents = FactoryGuiGraphics.getSprites().method_4608(LegacySprites.LOADING_BACKGROUND).method_45851();){
                    FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(LegacySprites.LOADING_BACKGROUND, loadingBarX, loadingBarY, 320, 320 * contents.method_45815() / contents.method_45807());
                }
                if (this.getProgress() >= 0.0f) {
                    contents = FactoryGuiGraphics.getSprites().method_4608(LegacySprites.LOADING_BAR).method_45851();
                    try {
                        FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(LegacySprites.LOADING_BAR, 318, 318 * contents.method_45815() / contents.method_45807(), 0, 0, loadingBarX + 1, loadingBarY + 1, 0, (int)(318.0f * Math.max(0.0f, Math.min(this.getProgress(), 1.0f))), 318 * contents.method_45815() / contents.method_45807());
                    }
                    finally {
                        if (contents != null) {
                            contents.close();
                        }
                    }
                }
                if ((tip = Legacy4JClient.legacyTipManager.getLoadingTip()) != null) {
                    tip.method_46421(this.accessor.getInteger("loadingTip.x", (this.field_22789 - tip.width) / 2));
                    tip.method_46419(this.accessor.getInteger("loadingTip.y", loadingBarY + 10 + (this.field_22790 - (loadingBarY + 10) - tip.height) / 2));
                    tip.method_25394(guiGraphics, i, j, f);
                }
            }
        } else {
            LegacyRenderUtil.drawGenericLoading(guiGraphics, (this.field_22789 - 75) / 2, this.field_22790 / 2);
        }
        if (this.getLoadingHeader() != null) {
            LegacyFontUtil.applySmallerFont((class_11719)fontOverride.map(class_11719.class_11721::new).orElse((Object)class_11719.field_61972), b -> {
                guiGraphics.method_51448().pushMatrix();
                float scaleX = this.accessor.getFloat("loadingHeader.scaleX", 2.0f);
                guiGraphics.method_51448().translate(this.accessor.getFloat("loadingHeader.x", ((float)this.field_22789 - (float)this.field_22787.field_1772.method_27525((class_5348)this.getLoadingHeader()) * scaleX) / 2.0f), this.accessor.getFloat("loadingHeader.y", (float)(this.field_22790 / 2 - 23)));
                guiGraphics.method_51448().scale(scaleX, this.accessor.getFloat("loadingHeader.scaleY", 2.0f));
                LegacyRenderUtil.drawOutlinedString(guiGraphics, this.field_22787.field_1772, this.getLoadingHeader(), 0, 0, (int)((Integer)CommonColor.TITLE_TEXT.get()), (int)((Integer)CommonColor.TITLE_TEXT_OUTLINE.get()), this.accessor.getFloat("loadingHeader.outline", 0.5f));
                guiGraphics.method_51448().popMatrix();
            });
        }
        FactoryScreenUtil.enableDepthTest();
    }

    @Override
    public float getProgress() {
        return this.progress;
    }

    @Override
    public void setProgress(float progress) {
        this.progress = progress;
    }

    @Override
    public class_2561 getLoadingHeader() {
        return this.loadingHeader;
    }

    @Override
    public void setLoadingHeader(class_2561 loadingHeader) {
        this.loadingHeader = loadingHeader;
    }

    @Override
    public class_2561 getLoadingStage() {
        return this.loadingStage;
    }

    @Override
    public void setLoadingStage(class_2561 loadingStage) {
        this.loadingStage = loadingStage;
    }

    @Override
    public boolean isGenericLoading() {
        return this.genericLoading;
    }

    @Override
    public void setGenericLoading(boolean genericLoading) {
        this.genericLoading = genericLoading;
    }
}

