/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CancellationException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_11907;
import net.minecraft.class_11908;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_128;
import net.minecraft.class_155;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_332;
import net.minecraft.class_34;
import net.minecraft.class_364;
import net.minecraft.class_370;
import net.minecraft.class_4068;
import net.minecraft.class_4185;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_442;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_8573;
import net.minecraft.class_8579;
import net.minecraft.class_8669;
import org.apache.commons.io.FileUtils;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.Legacy4J;
import wily.legacy.client.LegacyOptions;
import wily.legacy.client.LegacySaveCache;
import wily.legacy.client.screen.ConfirmationScreen;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.CreationList;
import wily.legacy.client.screen.LoadSaveScreen;
import wily.legacy.client.screen.PlayGameScreen;
import wily.legacy.client.screen.RenderableVList;
import wily.legacy.client.screen.SaveOptionsScreen;
import wily.legacy.util.LegacyComponents;
import wily.legacy.util.client.LegacyRenderUtil;

public class SaveRenderableList
extends RenderableVList {
    static final class_2960 ERROR_HIGHLIGHTED = FactoryAPI.createVanillaLocation((String)"world_list/error_highlighted");
    static final class_2960 ERROR = FactoryAPI.createVanillaLocation((String)"world_list/error");
    static final class_2960 MARKED_JOIN_HIGHLIGHTED = FactoryAPI.createVanillaLocation((String)"world_list/marked_join_highlighted");
    static final class_2960 MARKED_JOIN = FactoryAPI.createVanillaLocation((String)"world_list/marked_join");
    static final class_2960 WARNING_HIGHLIGHTED = FactoryAPI.createVanillaLocation((String)"world_list/warning_highlighted");
    static final class_2960 WARNING = FactoryAPI.createVanillaLocation((String)"world_list/warning");
    static final class_2960 JOIN_HIGHLIGHTED = FactoryAPI.createVanillaLocation((String)"world_list/join_highlighted");
    static final class_2960 JOIN = FactoryAPI.createVanillaLocation((String)"world_list/join");
    static final Logger LOGGER = LogUtils.getLogger();
    static final class_2561 FROM_NEWER_TOOLTIP_1 = class_2561.method_43471((String)"selectWorld.tooltip.fromNewerVersion1").method_27692(class_124.field_1061);
    static final class_2561 FROM_NEWER_TOOLTIP_2 = class_2561.method_43471((String)"selectWorld.tooltip.fromNewerVersion2").method_27692(class_124.field_1061);
    static final class_2561 SNAPSHOT_TOOLTIP_1 = class_2561.method_43471((String)"selectWorld.tooltip.snapshot1").method_27692(class_124.field_1065);
    static final class_2561 SNAPSHOT_TOOLTIP_2 = class_2561.method_43471((String)"selectWorld.tooltip.snapshot2").method_27692(class_124.field_1065);
    static final class_2561 WORLD_LOCKED_TOOLTIP = class_2561.method_43471((String)"selectWorld.locked").method_27692(class_124.field_1061);
    static final class_2561 WORLD_REQUIRES_CONVERSION = class_2561.method_43471((String)"selectWorld.conversion.tooltip").method_27692(class_124.field_1061);
    static final class_2561 WORLD_EXPERIMENTAL = class_2561.method_43471((String)"selectWorld.experimental");
    static final class_2561 INCOMPATIBLE_VERSION_TOOLTIP = class_2561.method_43471((String)"selectWorld.incompatible.tooltip").method_27692(class_124.field_1061);
    public static LoadingCache<class_34, Long> sizeCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<class_34, Long>(){

        public Long load(class_34 key) {
            return FileUtils.sizeOfDirectory((File)class_310.method_1551().method_1586().method_19636().resolve(key.method_248()).toFile());
        }
    });
    public static LoadingCache<class_34, class_8573> iconCache = CacheBuilder.newBuilder().build((CacheLoader)new CacheLoader<class_34, class_8573>(){

        public class_8573 load(class_34 key) {
            boolean bl;
            Path iconFile = key.method_27020();
            try {
                BasicFileAttributes basicFileAttributes = Files.readAttributes(iconFile, BasicFileAttributes.class, LinkOption.NOFOLLOW_LINKS);
                if (basicFileAttributes.isSymbolicLink()) {
                    List list = class_310.method_1551().method_52702().method_52618(iconFile);
                    if (!list.isEmpty()) {
                        Legacy4J.LOGGER.warn("{}", (Object)class_8579.method_52241((Path)iconFile, (List)list));
                        iconFile = null;
                    } else {
                        basicFileAttributes = Files.readAttributes(iconFile, BasicFileAttributes.class, new LinkOption[0]);
                    }
                }
                if (!basicFileAttributes.isRegularFile()) {
                    iconFile = null;
                }
            }
            catch (NoSuchFileException noSuchFileException) {
                iconFile = null;
            }
            catch (IOException iOException) {
                Legacy4J.LOGGER.error("could not validate symlink", (Throwable)iOException);
                iconFile = null;
            }
            class_8573 icon = class_8573.method_52200((class_1060)class_310.method_1551().method_1531(), (String)key.method_248());
            boolean bl2 = bl = iconFile != null && Files.isRegularFile(iconFile, new LinkOption[0]);
            if (bl) {
                try (InputStream inputStream = Files.newInputStream(iconFile, new OpenOption[0]);){
                    icon.method_52199(class_1011.method_4309((InputStream)inputStream));
                }
                catch (Throwable throwable) {
                    Legacy4J.LOGGER.error("Invalid icon for world {}", (Object)key.method_248(), (Object)throwable);
                }
            } else {
                icon.method_52198();
            }
            return icon;
        }
    });
    @Nullable
    public List<class_34> currentlyDisplayedLevels;
    public boolean firstLoad = true;
    protected class_310 minecraft;
    private CompletableFuture<List<class_34>> pendingLevels;
    private String filter;

    public SaveRenderableList(UIAccessor accessor) {
        super(accessor);
        this.layoutSpacing(l -> 0);
        this.minecraft = class_310.method_1551();
        this.filter = "";
        this.reloadSaveList();
    }

    public static void resetIconCache() {
        iconCache.asMap().forEach((s, i) -> i.close());
        iconCache.invalidateAll();
    }

    public static void handleLevelLoadFailure(class_310 minecraft, class_2561 component) {
        minecraft.method_1507((class_437)new ConfirmationScreen((class_437)new class_442(), (class_2561)class_2561.method_43471((String)"selectWorld.futureworld.error.title"), component, b -> {}){

            @Override
            protected void addButtons() {
                this.okButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.ok"), b -> this.method_25419()).method_46434(this.panel.x + 15, this.panel.y + this.panel.height - 30, 200, 20).method_46431();
                this.renderableVList.addRenderable((class_4068)this.okButton);
            }
        });
    }

    @Nullable
    public List<class_34> pollLevelsIgnoreErrors() {
        try {
            return this.pendingLevels.getNow(null);
        }
        catch (CancellationException | CompletionException runtimeException) {
            return null;
        }
    }

    void reloadSaveList() {
        this.pendingLevels = this.loadLevels();
    }

    public void updateFilter(String string) {
        if (this.currentlyDisplayedLevels != null && !string.equals(this.filter)) {
            this.fillLevels(string, this.currentlyDisplayedLevels);
        }
        this.filter = string;
    }

    private CompletableFuture<List<class_34>> loadLevels() {
        class_32.class_7410 levelCandidates;
        try {
            levelCandidates = this.minecraft.method_1586().method_235();
        }
        catch (class_33 levelStorageException) {
            Legacy4J.LOGGER.error("Couldn't load level list", (Throwable)levelStorageException);
            SaveRenderableList.handleLevelLoadFailure(this.minecraft, levelStorageException.method_43416());
            return CompletableFuture.completedFuture(List.of());
        }
        if (levelCandidates.method_43421()) {
            return CompletableFuture.completedFuture(List.of());
        }
        if (this.currentlyDisplayedLevels == null || this.currentlyDisplayedLevels.isEmpty()) {
            this.getScreen(PlayGameScreen.class).isLoading = true;
        }
        CompletableFuture completableFuture = this.minecraft.method_1586().method_43417(levelCandidates);
        completableFuture.thenAcceptAsync(l -> l.forEach(s -> sizeCache.refresh(s)));
        return completableFuture.exceptionally(throwable -> {
            this.minecraft.method_1494(class_128.method_560((Throwable)throwable, (String)"Couldn't load level list"));
            return List.of();
        });
    }

    public void addCreationButtons() {
        if (!this.accessor.getBoolean("hasTabList", Boolean.valueOf(true)).booleanValue()) {
            this.getScreen(PlayGameScreen.class).creationList.renderables.forEach(this::addRenderable);
        }
    }

    public void fillLevels(String filter, List<class_34> list) {
        this.getScreen(PlayGameScreen.class).isLoading = false;
        this.renderables.clear();
        this.addCreationButtons();
        if (list != null) {
            filter = filter.toLowerCase(Locale.ROOT);
            for (class_34 summary : list) {
                if (!this.filterAccepts(filter, summary)) continue;
                this.addRenderable((class_4068)new SaveButton(0, 0, 270, 30, summary));
            }
        }
        this.currentlyDisplayedLevels = list;
        this.getScreen().method_37064(true);
    }

    @Override
    public void init(String name, int leftPos, int topPos, int listWidth, int listHeight) {
        if (this.firstLoad) {
            this.addCreationButtons();
            this.firstLoad = false;
        }
        super.init(name, leftPos, topPos, listWidth, listHeight);
    }

    private boolean filterAccepts(String string, class_34 levelSummary) {
        return levelSummary.method_252().toLowerCase(Locale.ROOT).contains(string) || levelSummary.method_248().toLowerCase(Locale.ROOT).contains(string);
    }

    public class_34 getLevelSummary(int saveButtonIndex) {
        if (this.currentlyDisplayedLevels != null && this.renderables.get(saveButtonIndex) instanceof class_4264 && saveButtonIndex < this.currentlyDisplayedLevels.size()) {
            return this.currentlyDisplayedLevels.get(saveButtonIndex);
        }
        return null;
    }

    public void joinWorld(class_34 summary) {
        if (summary.method_54552()) {
            if (summary instanceof class_34.class_8578) {
                this.minecraft.method_1507(class_8669.method_52748(() -> this.minecraft.method_1507(this.getScreen())));
            } else {
                this.loadWorld(summary);
            }
        }
    }

    public void loadWorld(class_34 summary) {
        this.reloadSaveList();
        if (((Boolean)LegacyOptions.directSaveLoad.get()).booleanValue()) {
            LegacySaveCache.copySaveBtwSources(LoadSaveScreen.getSummaryAccess(class_310.method_1551().method_1586(), summary), LegacySaveCache.getLevelStorageSource());
            LoadSaveScreen.loadWorld(this.getScreen(), this.minecraft, LegacySaveCache.getLevelStorageSource(), summary);
        } else {
            this.minecraft.method_1507((class_437)new LoadSaveScreen(this, this.getScreen(), summary, LegacySaveCache.getLevelStorageSource()){

                @Override
                public void completeLoad() {
                    if (((Boolean)LegacyOptions.saveCache.get()).booleanValue()) {
                        LegacySaveCache.copySaveBtwSources(LoadSaveScreen.getSummaryAccess(class_310.method_1551().method_1586(), this.summary), LegacySaveCache.currentWorldSource);
                    }
                    super.completeLoad();
                }
            });
        }
    }

    public void deleteSave(class_34 summary) {
        class_32 levelStorageSource = this.minecraft.method_1586();
        String string = summary.method_248();
        try (class_32.class_5143 levelStorageAccess = levelStorageSource.method_27002(string);){
            levelStorageAccess.method_27015();
        }
        catch (IOException iOException) {
            class_370.method_27025((class_310)this.minecraft, (String)string);
            LOGGER.error("Failed to delete world {}", (Object)string, (Object)iOException);
        }
        this.reloadSaveList();
        this.minecraft.method_1507(this.getScreen());
    }

    public class SaveButton
    extends CreationList.ContentButton
    implements ControlTooltip.ActionHolder {
        public final class_34 summary;

        public SaveButton(int i, int j, int k, int l, class_34 summary) {
            super(SaveRenderableList.this, i, j, k, l, (class_2561)class_2561.method_43470((String)summary.method_252()));
            this.summary = summary;
        }

        public void method_25306(class_11907 input) {
            SaveRenderableList.this.joinWorld(this.summary);
        }

        public void method_25348(class_11909 event, boolean bl) {
            if (this.summary.method_33784()) {
                return;
            }
            boolean hoverIcon = LegacyRenderUtil.isMouseOver(event.comp_4798(), event.comp_4799(), this.method_46426() + 5, this.method_46427() + 5, 20, this.field_22759);
            if (hoverIcon || this.method_25370()) {
                this.method_25306((class_11907)event);
            }
        }

        public boolean method_25404(class_11908 keyEvent) {
            if (keyEvent.comp_4795() == 79) {
                SaveRenderableList.this.minecraft.method_1507((class_437)new SaveOptionsScreen(SaveRenderableList.this.getScreen(PlayGameScreen.class), this.summary));
                SaveRenderableList.this.getScreen().method_25395((class_364)this);
                return true;
            }
            return super.method_25404(keyEvent);
        }

        protected class_5250 method_25360() {
            class_5250 component = class_2561.method_43469((String)"narrator.select.world_info", (Object[])new Object[]{this.summary.method_252(), new Date(this.summary.method_249()).toString(), this.summary.method_27429()});
            if (this.summary.method_27021()) {
                component = class_5244.method_37111((class_2561[])new class_2561[]{component, WORLD_LOCKED_TOOLTIP});
            }
            if (this.summary.method_45554()) {
                component = class_5244.method_37111((class_2561[])new class_2561[]{component, WORLD_EXPERIMENTAL});
            }
            return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{component});
        }

        @Override
        public void renderIcon(class_332 guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
            FactoryGuiGraphics.of((class_332)guiGraphics).blit(((class_8573)iconCache.getUnchecked((Object)this.summary)).method_52201(), this.method_46426() + x, this.method_46427() + y, 0.0f, 0.0f, width, height, width, height);
        }

        @Override
        public void renderIconHighlight(class_332 guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
            class_2960 resourceLocation4;
            super.renderIconHighlight(guiGraphics, mouseX, mouseY, x, y, width, height);
            boolean hoverIcon = LegacyRenderUtil.isMouseOver(mouseX, mouseY, this.method_46426() + x, this.method_46427() + y, width, height);
            class_2960 resourceLocation = hoverIcon ? JOIN_HIGHLIGHTED : JOIN;
            class_2960 resourceLocation2 = hoverIcon ? WARNING_HIGHLIGHTED : WARNING;
            class_2960 resourceLocation3 = hoverIcon ? ERROR_HIGHLIGHTED : ERROR;
            class_2960 class_29602 = resourceLocation4 = hoverIcon ? MARKED_JOIN_HIGHLIGHTED : MARKED_JOIN;
            if (this.summary instanceof class_34.class_8578 || this.summary instanceof class_34.class_8896) {
                FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(resourceLocation3, this.method_46426() + x, this.method_46427() + y, width, height);
                FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(resourceLocation4, this.method_46426() + x, this.method_46427() + y, width, height);
                return;
            }
            if (this.summary.method_27021()) {
                FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(resourceLocation3, this.method_46426() + x, this.method_46427() + y, width, height);
                if (hoverIcon) {
                    guiGraphics.method_51447(SaveRenderableList.this.minecraft.field_1772, SaveRenderableList.this.minecraft.field_1772.method_1728((class_5348)WORLD_LOCKED_TOOLTIP, 175), mouseX, mouseY);
                }
            } else if (this.summary.method_255()) {
                FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(resourceLocation3, this.method_46426() + x, this.method_46427() + y, width, height);
                if (hoverIcon) {
                    guiGraphics.method_51447(SaveRenderableList.this.minecraft.field_1772, SaveRenderableList.this.minecraft.field_1772.method_1728((class_5348)WORLD_REQUIRES_CONVERSION, 175), mouseX, mouseY);
                }
            } else if (!this.summary.method_38496()) {
                FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(resourceLocation3, this.method_46426() + x, this.method_46427() + y, width, height);
                if (hoverIcon) {
                    guiGraphics.method_51447(SaveRenderableList.this.minecraft.field_1772, SaveRenderableList.this.minecraft.field_1772.method_1728((class_5348)INCOMPATIBLE_VERSION_TOOLTIP, 175), mouseX, mouseY);
                }
            } else if (this.summary.method_54549()) {
                FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(resourceLocation4, this.method_46426() + x, this.method_46427() + y, width, height);
                if (this.summary.method_54550()) {
                    FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(resourceLocation3, this.method_46426() + x, this.method_46427() + y, width, height);
                    if (hoverIcon) {
                        guiGraphics.method_51447(SaveRenderableList.this.minecraft.field_1772, (List)ImmutableList.of((Object)FROM_NEWER_TOOLTIP_1.method_30937(), (Object)FROM_NEWER_TOOLTIP_2.method_30937()), mouseX, mouseY);
                    }
                } else if (!class_155.method_16673().comp_4031()) {
                    FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(resourceLocation2, this.method_46426() + x, this.method_46427() + y, width, height);
                    if (hoverIcon) {
                        guiGraphics.method_51447(SaveRenderableList.this.minecraft.field_1772, (List)ImmutableList.of((Object)SNAPSHOT_TOOLTIP_1.method_30937(), (Object)SNAPSHOT_TOOLTIP_2.method_30937()), mouseX, mouseY);
                    }
                }
            } else {
                FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(resourceLocation, this.method_46426() + x, this.method_46427() + y, width, height);
            }
        }

        @Override
        @Nullable
        public class_2561 getAction(ControlTooltip.ActionHolder.Context context) {
            return context.actionOfContext(ControlTooltip.ActionHolder.KeyContext.class, c -> c.key() == 79 && this.method_25370() ? LegacyComponents.SAVE_OPTIONS : ControlTooltip.getSelectAction((class_364)this, c));
        }
    }
}

