/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.screen.compat;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.minecraft.MinecraftSessionService;
import io.github.gaming32.worldhost.FriendsListUpdate;
import io.github.gaming32.worldhost.WorldHost;
import io.github.gaming32.worldhost.plugin.OnlineFriend;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1011;
import net.minecraft.class_1060;
import net.minecraft.class_11560;
import net.minecraft.class_11907;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2561;
import net.minecraft.class_2926;
import net.minecraft.class_332;
import net.minecraft.class_4068;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_642;
import net.minecraft.class_7532;
import net.minecraft.class_8573;
import net.minecraft.class_8685;
import org.jetbrains.annotations.Nullable;
import wily.factoryapi.base.client.FactoryGuiGraphics;
import wily.factoryapi.base.client.UIAccessor;
import wily.legacy.client.screen.CreationList;
import wily.legacy.client.screen.JoinGameScreen;
import wily.legacy.client.screen.ServerRenderableList;
import wily.legacy.util.LegacySprites;
import wily.legacy.util.client.LegacyRenderUtil;

public class FriendsServerRenderableList
extends ServerRenderableList {
    protected final FriendsListUpdate friendsListUpdate = friends -> this.updateServers();
    boolean ping = false;

    public FriendsServerRenderableList(UIAccessor accessor) {
        super(accessor);
    }

    @Override
    public void added() {
        WorldHost.ONLINE_FRIEND_UPDATES.add(this.friendsListUpdate);
    }

    @Override
    public void removed() {
        super.removed();
        WorldHost.ONLINE_FRIEND_UPDATES.remove(this.friendsListUpdate);
    }

    @Override
    public boolean hasOnlineFriends() {
        return !WorldHost.ONLINE_FRIENDS.isEmpty();
    }

    @Override
    public void updateLANServers() {
        if (!this.ping) {
            WorldHost.pingFriends();
            this.ping = true;
        }
        super.updateLANServers();
        class_156.method_18349().execute(() -> {
            WorldHost.ONLINE_FRIENDS.forEach((uuid, id) -> {
                final GameProfile profile = WorldHost.fetchProfile((MinecraftSessionService)this.minecraft.method_73361().comp_837(), (UUID)uuid);
                CreationList.ContentButton onlineButton = new CreationList.ContentButton(this, 0, 0, 270, 30, (class_2561)class_2561.method_43470((String)profile.name()), (OnlineFriend)id){
                    final class_642 serverData;
                    final class_8573 icon;
                    private byte @Nullable [] lastIconBytes;
                    final /* synthetic */ OnlineFriend val$id;
                    {
                        this.val$id = onlineFriend;
                        super(list, x, y, width, height, component);
                        this.serverData = new class_642("", "", class_642.class_8678.field_45611);
                        this.icon = class_8573.method_52202((class_1060)FriendsServerRenderableList.this.minecraft.method_1531(), (String)this.serverData.field_3761);
                    }

                    private boolean uploadServerIcon(@Nullable byte[] bs) {
                        if (bs == null) {
                            this.icon.method_52198();
                        } else {
                            try {
                                this.icon.method_52199(class_1011.method_49277((byte[])bs));
                            }
                            catch (Throwable throwable) {
                                LOGGER.error("Invalid icon for server {} ({})", new Object[]{this.serverData.field_3752, this.serverData.field_3761, throwable});
                                return false;
                            }
                        }
                        return true;
                    }

                    @Override
                    public void renderIcon(class_332 guiGraphics, int mouseX, int mouseY, int x, int y, int width, int height) {
                        super.renderIcon(guiGraphics, x, y, width, height, mouseX, mouseY);
                        this.updateServerInfo();
                        byte[] bs = this.serverData.method_49306();
                        if (!Arrays.equals(bs, this.lastIconBytes)) {
                            if (this.uploadServerIcon(bs)) {
                                this.lastIconBytes = bs;
                            } else {
                                this.serverData.method_49305(null);
                            }
                        }
                        if (this.serverData.method_49306() == null) {
                            class_7532.method_52722((class_332)guiGraphics, (class_8685)((class_8685)FriendsServerRenderableList.this.minecraft.method_1582().method_73544(profile, true).get()), (int)(this.method_46426() + x), (int)(this.method_46427() + y), (int)width);
                        } else {
                            ServerRenderableList.drawIcon(guiGraphics, this.method_46426() + x, this.method_46427() + y, width, height, this.icon.method_52201());
                        }
                    }

                    @Override
                    public void renderIconHighlight(class_332 guiGraphics, int x, int y, int width, int height, int mouseX, int mouseY) {
                        super.renderIconHighlight(guiGraphics, x, y, width, height, mouseX, mouseY);
                        FactoryGuiGraphics.of((class_332)guiGraphics).blitSprite(LegacyRenderUtil.isMouseOver(mouseX, mouseY, this.method_46426() + x, this.method_46427() + y, width, height) ? LegacySprites.JOIN_HIGHLIGHTED : LegacySprites.JOIN, this.method_46426(), this.method_46427(), 32, 32);
                    }

                    public void method_25306(class_11907 input) {
                        if (this.method_25370()) {
                            FriendsServerRenderableList.this.minecraft.method_1507((class_437)new JoinGameScreen(FriendsServerRenderableList.this.getScreen(), this.serverData, b -> {
                                WorldHost.LOGGER.info("Requesting to join {}", (Object)profile.id());
                                if (WorldHost.protoClient != null) {
                                    this.val$id.joinWorld(FriendsServerRenderableList.this.getScreen());
                                }
                            }));
                        }
                    }

                    private void updateServerInfo() {
                        this.serverData.field_3752 = profile.name();
                        class_2926 metadata = (class_2926)WorldHost.ONLINE_FRIEND_PINGS.get(profile.id());
                        if (metadata == null) {
                            this.serverData.field_3753 = class_2561.method_43473();
                            this.serverData.field_3757 = class_2561.method_43473();
                            return;
                        }
                        this.serverData.field_3757 = metadata.comp_1273();
                        metadata.comp_1275().ifPresentOrElse(version -> {
                            this.serverData.field_3760 = class_2561.method_43470((String)version.comp_1282());
                            this.serverData.field_3756 = version.comp_1283();
                        }, () -> {
                            this.serverData.field_3760 = class_2561.method_43471((String)"multiplayer.status.old");
                            this.serverData.field_3756 = 0;
                        });
                        metadata.comp_1274().ifPresentOrElse(players -> {
                            this.serverData.field_3753 = class_2561.method_43469((String)"multiplayer.status.player_count", (Object[])new Object[]{class_2561.method_43470((String)("" + players.comp_1280())).method_27692(class_124.field_1080), class_2561.method_43470((String)("" + players.comp_1279())).method_27692(class_124.field_1080)}).method_27692(class_124.field_1063);
                            this.serverData.field_41861 = players;
                            if (!players.comp_1281().isEmpty()) {
                                ArrayList<class_5250> playerList = new ArrayList<class_5250>(players.comp_1281().size());
                                for (class_11560 gameProfile : players.comp_1281()) {
                                    playerList.add(class_2561.method_43470((String)gameProfile.comp_4423()));
                                }
                                if (players.comp_1281().size() < players.comp_1280()) {
                                    playerList.add(class_2561.method_43469((String)"multiplayer.status.and_more", (Object[])new Object[]{players.comp_1280() - players.comp_1281().size()}));
                                }
                                this.serverData.field_3762 = playerList;
                            } else {
                                this.serverData.field_3762 = List.of();
                            }
                        }, () -> {
                            this.serverData.field_3753 = class_2561.method_43471((String)"multiplayer.status.unknown").method_27692(class_124.field_1063);
                        });
                        metadata.comp_1276().ifPresent(favicon -> {
                            if (!Arrays.equals(favicon.comp_1278(), this.serverData.method_49306())) {
                                this.serverData.method_49305(favicon.comp_1278());
                            }
                        });
                    }
                };
                this.addRenderable((class_4068)onlineButton);
                if (this.accessor.getChildren().contains((Object)onlineButton)) {
                    this.minecraft.method_44713().method_37015((class_2561)class_2561.method_43469((String)"multiplayer.lan.server_found", (Object[])new Object[]{onlineButton.method_25369()}));
                }
            });
            if (!WorldHost.ONLINE_FRIENDS.isEmpty()) {
                this.accessor.reloadUI();
            }
        });
    }
}

