/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.mixin;

import java.util.List;
import java.util.Set;
import org.objectweb.asm.tree.ClassNode;
import org.spongepowered.asm.mixin.extensibility.IMixinConfigPlugin;
import org.spongepowered.asm.mixin.extensibility.IMixinInfo;
import wily.factoryapi.FactoryAPI;
import wily.legacy.client.LegacyMixinOptions;
import wily.legacy.config.LegacyMixinToggles;

public class LegacyMixinPlugin
implements IMixinConfigPlugin {
    public void onLoad(String mixinPackage) {
        LegacyMixinToggles.COMMON_STORAGE.load();
        if (FactoryAPI.isClient()) {
            LegacyMixinOptions.CLIENT_MIXIN_STORAGE.load();
        }
    }

    public String getRefMapperConfig() {
        return null;
    }

    public boolean shouldApplyMixin(String targetClassName, String mixinClassName) {
        if (!LegacyMixinToggles.COMMON_STORAGE.getFormatted("wily.", mixinClassName)) {
            return false;
        }
        if (FactoryAPI.isClient() && !LegacyMixinOptions.CLIENT_MIXIN_STORAGE.getFormatted("wily.", mixinClassName)) {
            return false;
        }
        if (FactoryAPI.isLoadingMod((String)"nostalgic_tweaks") ? mixinClassName.endsWith("ItemInHandRendererSwayMixin") : mixinClassName.contains("compat.nostalgic.")) {
            return false;
        }
        if (!FactoryAPI.isLoadingMod((String)"sodium") && mixinClassName.contains("compat.sodium.")) {
            return false;
        }
        if (!FactoryAPI.isLoadingMod((String)"jei") && mixinClassName.contains("compat.jei.")) {
            return false;
        }
        boolean hasVivecraft = FactoryAPI.isLoadingMod((String)"vivecraft");
        return !hasVivecraft || !mixinClassName.endsWith("GuiGameRendererMixin");
    }

    public void acceptTargets(Set<String> myTargets, Set<String> otherTargets) {
    }

    public List<String> getMixins() {
        return null;
    }

    public void preApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }

    public void postApply(String targetClassName, ClassNode targetClass, String mixinClassName, IMixinInfo mixinInfo) {
    }
}

