/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3414;
import net.minecraft.class_3518;
import net.minecraft.class_3675;
import net.minecraft.class_4013;
import net.minecraft.class_7923;
import wily.factoryapi.FactoryAPI;
import wily.factoryapi.FactoryAPIPlatform;
import wily.legacy.Legacy4J;
import wily.legacy.client.CommonColor;
import wily.legacy.client.CommonValue;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyIntro;
import wily.legacy.client.PlayerIdentifier;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.ControllerManager;
import wily.legacy.client.screen.ControlTooltip;
import wily.legacy.client.screen.KeyboardScreen;
import wily.legacy.util.JsonUtil;

public class LegacyResourceManager
implements class_4013 {
    public static final class_2960 GAMEPAD_MAPPINGS = Legacy4J.createModLocation("gamepad_mappings.txt");
    public static final class_2960 INTRO_LOCATION = Legacy4J.createModLocation("intro.json");
    public static final class_2960 GAMMA_LOCATION = Legacy4J.createModLocation("gamma");
    public static final class_2960 DEFAULT_KEYBOARD_LAYOUT_LOCATION = Legacy4J.createModLocation("keyboard_layout/en_us.json");
    public static final class_2960 PLAYER_IDENTIFIERS_LOCATION = Legacy4J.createModLocation("player_identifiers.json");
    public static final String CONTROL_TYPES = "control_types.json";
    public static final String COMMON_COLORS = "common_colors.json";
    public static final String COMMON_VALUES = "common_values.json";
    public static final String DEFAULT_KBM_ICONS = "control_tooltips/icons/kbm.json";
    public static final String DEFAULT_CONTROLLER_ICONS = "control_tooltips/icons/controller.json";
    public static LegacyIntro intro = LegacyIntro.EMPTY;
    public static final List<KeyboardScreen.CharButtonBuilder> keyboardButtonBuilders = new ArrayList<KeyboardScreen.CharButtonBuilder>();
    public static ControllerBinding<?> shiftBinding;

    public void method_14491(class_3300 resourceManager) {
        class_310 minecraft = class_310.method_1551();
        resourceManager.method_14486(GAMEPAD_MAPPINGS).ifPresent(r -> {
            try {
                ControllerManager.getHandler().applyGamePadMappingsFromBuffer(r.method_43039());
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
        PlayerIdentifier.list.clear();
        resourceManager.method_14489(PLAYER_IDENTIFIERS_LOCATION).forEach(r -> {
            try {
                class_3518.method_37165((Reader)r.method_43039()).forEach(e -> PlayerIdentifier.CODEC.parse((DynamicOps)JsonOps.INSTANCE, e).result().ifPresent(p -> PlayerIdentifier.list.put(p.index(), p)));
            }
            catch (IOException e2) {
                throw new RuntimeException(e2);
            }
        });
        ControlType.types.clear();
        CommonValue.COMMON_VALUES.forEach((s, c) -> c.reset());
        CommonColor.COMMON_COLORS.forEach((s, c) -> c.reset());
        resourceManager.method_14486(DEFAULT_KEYBOARD_LAYOUT_LOCATION).ifPresent(LegacyResourceManager::setKeyboardLayout);
        JsonUtil.getOrderedNamespaces(resourceManager).forEach(name -> {
            resourceManager.method_14486(FactoryAPI.createLocation((String)name, (String)CONTROL_TYPES)).ifPresent(r -> {
                try {
                    class_3518.method_37165((Reader)r.method_43039()).forEach(e -> {
                        ControlType type;
                        class_2960 id;
                        if (e instanceof JsonPrimitive) {
                            JsonPrimitive p = (JsonPrimitive)e;
                            id = FactoryAPI.createLocation((String)p.getAsString());
                            if (ControlType.types.containsKey((Object)id.toString()) && ControlType.defaultTypes.contains(ControlType.types.get((Object)id.toString()))) {
                                return;
                            }
                            for (ControlType defaultType : ControlType.defaultTypes) {
                                if (!defaultType.getId().equals((Object)id)) continue;
                                ControlType.types.put((Object)id.toString(), (Object)defaultType);
                                return;
                            }
                            type = ControlType.create(id, null, false);
                        } else {
                            JsonObject o = e.getAsJsonObject();
                            id = FactoryAPI.createLocation((String)class_3518.method_15265((JsonObject)o, (String)"id"));
                            type = ControlType.create(id, (class_2561)JsonUtil.getJsonStringOrNull(o, "displayName", class_2561::method_43471), class_3518.method_15258((JsonObject)o, (String)"isKbm", (boolean)false));
                        }
                        ControlType.types.put((Object)id.toString(), (Object)type);
                    });
                }
                catch (IOException e2) {
                    Legacy4J.LOGGER.warn(e2.getMessage());
                }
            });
            resourceManager.method_14486(FactoryAPI.createLocation((String)name, (String)COMMON_COLORS)).ifPresent(r -> {
                try {
                    JsonObject obj = class_3518.method_15255((Reader)r.method_43039());
                    obj.asMap().forEach((s, e) -> {
                        class_2960 id = FactoryAPI.createLocation((String)s);
                        if (CommonColor.COMMON_COLORS.containsKey((Object)id)) {
                            ((CommonColor)((Object)((Object)((Object)((Object)CommonColor.COMMON_COLORS.get((Object)id)))))).parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, e));
                        }
                    });
                }
                catch (IOException e2) {
                    Legacy4J.LOGGER.warn(e2.getMessage());
                }
            });
            resourceManager.method_14486(FactoryAPI.createLocation((String)name, (String)COMMON_VALUES)).ifPresent(r -> {
                try {
                    JsonObject obj = class_3518.method_15255((Reader)r.method_43039());
                    obj.asMap().forEach((s, e) -> {
                        class_2960 id = FactoryAPI.createLocation((String)s);
                        if (CommonColor.COMMON_VALUES.containsKey((Object)id)) {
                            ((CommonValue)((Object)((Object)((Object)((Object)CommonColor.COMMON_VALUES.get((Object)id)))))).parse(new Dynamic((DynamicOps)JsonOps.INSTANCE, e));
                        }
                    });
                }
                catch (IOException e2) {
                    Legacy4J.LOGGER.warn(e2.getMessage());
                }
            });
            LegacyResourceManager.addKbmIcons(resourceManager, FactoryAPI.createLocation((String)name, (String)DEFAULT_KBM_ICONS), (s, b) -> {
                for (ControlType value : ControlType.types.values()) {
                    if (!value.isKbm()) continue;
                    value.getIcons().put((String)s, (ControlTooltip.LegacyIcon)b);
                }
            });
            LegacyResourceManager.addControllerIcons(resourceManager, FactoryAPI.createLocation((String)name, (String)DEFAULT_CONTROLLER_ICONS), (s, b) -> {
                for (ControlType value : ControlType.types.values()) {
                    if (value.isKbm()) continue;
                    value.getIcons().put((String)s, (ControlTooltip.LegacyIcon)b);
                }
            });
            for (ControlType value : ControlType.types.values()) {
                class_2960 location = FactoryAPI.createLocation((String)value.getId().method_12836(), (String)"control_tooltips/icons/%s.json".formatted(value.getId().method_12832()));
                if (value.isKbm()) {
                    LegacyResourceManager.addKbmIcons(resourceManager, location, value.getIcons()::put);
                    continue;
                }
                LegacyResourceManager.addControllerIcons(resourceManager, location, value.getIcons()::put);
            }
            String langKey = minecraft.method_1526().method_4668(minecraft.method_1526().method_4669()) != null ? minecraft.method_1526().method_4669() : "en_us";
            resourceManager.method_14486(FactoryAPI.createLocation((String)name, (String)"keyboard_layout/%s.json".formatted(langKey))).ifPresent(LegacyResourceManager::setKeyboardLayout);
        });
    }

    public static void setKeyboardLayout(class_3298 resource) {
        try {
            JsonObject obj = class_3518.method_15255((Reader)resource.method_43039());
            keyboardButtonBuilders.clear();
            shiftBinding = obj.has("shiftBinding") ? ControllerBinding.map.get(obj.get("shiftBinding").getAsString()) : ControllerBinding.LEFT_STICK_BUTTON;
            obj.getAsJsonArray("layout").forEach(e -> {
                if (e instanceof JsonObject) {
                    JsonObject o = (JsonObject)e;
                    keyboardButtonBuilders.add(new KeyboardScreen.CharButtonBuilder(class_3518.method_15282((JsonObject)o, (String)"width", (int)25), class_3518.method_15265((JsonObject)o, (String)"chars"), class_3518.method_15253((JsonObject)o, (String)"shiftChars", null), JsonUtil.getJsonStringOrNull(o, "binding", ControllerBinding.map::get), JsonUtil.getJsonStringOrNull(o, "icon", FactoryAPI::createLocation), JsonUtil.getJsonStringOrNull(o, "soundEvent", s -> (class_3414)FactoryAPIPlatform.getRegistryValue((class_2960)FactoryAPI.createLocation((String)s), (class_2378)class_7923.field_41172))));
                } else if (e instanceof JsonPrimitive) {
                    JsonPrimitive p = (JsonPrimitive)e;
                    keyboardButtonBuilders.add(new KeyboardScreen.CharButtonBuilder(25, p.getAsString(), null, null, null, null));
                }
            });
        }
        catch (IOException e2) {
            Legacy4J.LOGGER.warn(e2.getMessage());
        }
    }

    public static void addIcons(class_3300 resourceManager, class_2960 location, BiConsumer<String, JsonObject> addIcon) {
        resourceManager.method_14486(location).ifPresent(r -> {
            try {
                class_3518.method_15255((Reader)r.method_43039()).asMap().forEach((s, o) -> addIcon.accept((String)s, o.getAsJsonObject()));
            }
            catch (IOException e) {
                Legacy4J.LOGGER.warn(e.getMessage());
            }
        });
    }

    public static void addControllerIcons(class_3300 resourceManager, class_2960 location, BiConsumer<String, ControlTooltip.LegacyIcon> addIcon) {
        LegacyResourceManager.addIcons(resourceManager, location, (s, o) -> {
            ControllerBinding<?> binding = ControllerBinding.map.get(s);
            if (binding != null) {
                addIcon.accept((String)s, ControlTooltip.LegacyIcon.create(() -> ((BindingState)binding.getMapped().state()).pressed, JsonUtil.getJsonStringOrNull(o, "icon", String::toCharArray), JsonUtil.getJsonStringOrNull(o, "iconOverlay", String::toCharArray), JsonUtil.getJsonStringOrNull(o, "tipIcon", v -> Character.valueOf(v.charAt(0))), () -> !((BindingState)binding.getMapped().state()).isBlocked(), ControlType::getActiveControllerType));
            }
        });
    }

    public static void addKbmIcons(class_3300 resourceManager, class_2960 location, BiConsumer<String, ControlTooltip.LegacyIcon> addIcon) {
        LegacyResourceManager.addIcons(resourceManager, location, (s, o) -> {
            class_3675.class_306 key = class_3675.method_15981((String)s);
            ControlTooltip.LegacyIcon icon = ControlTooltip.LegacyIcon.create(key, JsonUtil.getJsonStringOrNull(o, "icon", String::toCharArray), JsonUtil.getJsonStringOrNull(o, "iconOverlay", String::toCharArray), JsonUtil.getJsonStringOrNull(o, "tipIcon", v -> Character.valueOf(v.charAt(0))));
            addIcon.accept(key.method_1441(), icon);
        });
    }

    public static void loadIntroLocations(class_3300 resourceManager) {
        try {
            LegacyIntro.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)JsonParser.parseReader((Reader)resourceManager.openAsReader(INTRO_LOCATION))).result().ifPresent(i -> {
                intro = i;
            });
        }
        catch (IOException e) {
            Legacy4J.LOGGER.error(e.getMessage());
        }
    }

    public String method_22322() {
        return "legacy:resource_manager";
    }
}

