/*
 * Decompiled with CFR 0.152.
 */
package wily.legacy.client.controller;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import net.minecraft.class_2561;
import net.minecraft.class_368;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import wily.factoryapi.FactoryAPIClient;
import wily.legacy.Legacy4J;
import wily.legacy.client.ControlType;
import wily.legacy.client.LegacyTip;
import wily.legacy.client.controller.BindingState;
import wily.legacy.client.controller.ControllerBinding;
import wily.legacy.client.controller.ControllerManager;
import wily.legacy.client.screen.LegacyMenuAccess;

public interface Controller {
    public static final Controller EMPTY = new Controller(){

        @Override
        public String getName() {
            return "Empty";
        }

        @Override
        public ControlType getType() {
            return ControlType.x360;
        }

        @Override
        public boolean buttonPressed(int i) {
            return false;
        }

        @Override
        public float axisValue(int i) {
            return 0.0f;
        }

        @Override
        public boolean hasButton(ControllerBinding.Button button) {
            return false;
        }

        @Override
        public boolean hasAxis(ControllerBinding.Axis axis) {
            return false;
        }

        @Override
        public Handler getHandler() {
            return Handler.EMPTY;
        }

        @Override
        public void manageBindings(Runnable run) {
        }
    };

    public String getName();

    public ControlType getType();

    public boolean buttonPressed(int var1);

    public float axisValue(int var1);

    default public boolean hasLED() {
        return false;
    }

    default public void setLED(byte r, byte g, byte b) {
    }

    default public void connect(ControllerManager manager) {
        manager.setControllerTheLastInput(true);
        if (!manager.isCursorDisabled && manager.minecraft.field_1755 != null) {
            manager.minecraft.execute(() -> manager.minecraft.field_1755.method_48640());
        }
        this.addOrSetControllerToast(ControllerManager.CONTROLLER_DETECTED);
    }

    default public void rumble(char low_frequency_rumble, char high_frequency_rumble, int duration_ms) {
    }

    default public void rumbleTriggers(char left_rumble, char right_rumble, int duration_ms) {
    }

    default public int getTouchpadsCount() {
        return 0;
    }

    default public int getTouchpadFingersCount(int touchpad) {
        return 0;
    }

    default public boolean hasFingerInTouchpad(int touchpad, int finger, Byte state, Float x, Float y, Float pressure) {
        return false;
    }

    public boolean hasButton(ControllerBinding.Button var1);

    public boolean hasAxis(ControllerBinding.Axis var1);

    default public void disconnect(ControllerManager manager) {
        manager.setControllerTheLastInput(false);
        if (manager.isCursorDisabled && !manager.getCursorMode().isNever()) {
            manager.enableCursor();
        }
        manager.updateBindings(EMPTY);
        manager.connectedController = null;
        this.addOrSetControllerToast(ControllerManager.CONTROLLER_DISCONNECTED);
    }

    default public void addOrSetControllerToast(class_2561 component) {
        LegacyTip oldToast = (LegacyTip)FactoryAPIClient.getToasts().method_1997(LegacyTip.class, class_368.field_2208);
        class_5250 tip = class_2561.method_43470((String)this.getName());
        if (oldToast == null || oldToast.title != ControllerManager.CONTROLLER_DETECTED && oldToast.title != ControllerManager.CONTROLLER_DISCONNECTED || oldToast.visibility == class_368.class_369.field_2209) {
            FactoryAPIClient.getToasts().method_1999((class_368)new LegacyTip(component, (class_2561)tip).centered().disappearTime(4500L));
        } else {
            oldToast.tip((class_2561)tip).title(component).disappearTime(4500L);
        }
    }

    public Handler getHandler();

    default public void manageBindings(Runnable run) {
        run.run();
    }

    public static interface Event {
        public static final Event EMPTY = new Event(){};

        public static Event of(Object o) {
            Event e;
            return o instanceof Event ? (e = (Event)o) : EMPTY;
        }

        default public void controllerTick(Controller controller) {
        }

        default public void bindingStateTick(BindingState state) {
        }

        default public boolean onceClickBindings() {
            return true;
        }

        default public boolean disableCursorOnInit() {
            return !(this instanceof LegacyMenuAccess);
        }
    }

    public static interface Handler {
        public static final class_2561 DOWNLOAD_MESSAGE = class_2561.method_43471((String)"legacy.menu.download_natives_message");
        public static final class_2561 DOWNLOADING_NATIVES = class_2561.method_43471((String)"legacy.menu.downloading_natives");
        public static final class_2561 LOADING_NATIVES = class_2561.method_43471((String)"legacy.menu.loading_natives");
        public static final Handler EMPTY = new Handler(){

            @Override
            public class_2561 getName() {
                return class_5244.field_24333;
            }

            @Override
            public void init() {
            }

            @Override
            public boolean update() {
                return false;
            }

            @Override
            public void setup(ControllerManager manager) {
            }

            @Override
            public Controller getController(int jid) {
                return null;
            }

            @Override
            public boolean isValidController(int jid) {
                return false;
            }

            @Override
            public int getButtonIndex(ControllerBinding.Button button) {
                return -1;
            }

            @Override
            public int getAxisIndex(ControllerBinding.Axis axis) {
                return -1;
            }

            @Override
            public void applyGamePadMappingsFromBuffer(BufferedReader reader) {
            }
        };

        public class_2561 getName();

        public void init();

        public boolean update();

        default public void setup(ControllerManager manager) {
            manager.connectedController.manageBindings(manager::updateBindings);
        }

        public Controller getController(int var1);

        public boolean isValidController(int var1);

        public int getButtonIndex(ControllerBinding.Button var1);

        public int getAxisIndex(ControllerBinding.Axis var1);

        public void applyGamePadMappingsFromBuffer(BufferedReader var1) throws IOException;

        default public void tryDownloadAndApplyNewMappings() {
            try {
                this.applyGamePadMappingsFromBuffer(new BufferedReader(new InputStreamReader(URI.create("https://raw.githubusercontent.com/mdqinc/SDL_GameControllerDB/master/gamecontrollerdb.txt").toURL().openStream())));
            }
            catch (IOException e) {
                Legacy4J.LOGGER.warn(e.getMessage());
            }
        }
    }
}

